/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

#ifndef RESULT_H
#define RESULT_H

// WorKflow includes
#include "slot.h"

// forward declarations
namespace WorKflow
{
  class Parameter;
  class ResultDescription;
}

namespace WorKflow
{
  /**
   * @short Represents a Command's result slot.
   *
   * This class represents a result slot for a command instance. A command has
   * one or more of these.
   *
   * Use the connect() method to connect the result to another command's
   * parameter instance, such that data flows automatically between commands. The
   * setValue() method forwards the data along the connection.
   */
  class Result : public Slot
  {
  public:
    /**
     * Constructor.
     * @param command The command to which the result is associated.
     * @param desc The result's description;
     */
    Result(Command* command, ResultDescription* desc);

    /**
     * Destructor.
     */
    ~Result();

    /**
     * Forwards the result's value along the connection to a parameter instance.
     * If no connection exists, this method has no effect.
     * @param value The result's value.
     */
    void setValue(const Value& value);

    /**
     * This is for debugging purposes.
     * @return The most recently assigned value.
     */
    Value value();

    QString linkedParameter() const;

  private:
    Value m_value;
    QString m_linkedParameter;
  };
}

#endif
