/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

#ifndef PARAMETERINSPECTOR_H
#define PARAMETERINSPECTOR_H

// debugger includes
#include "parameterinspectorbase.h"

// forward declarations
namespace WorKflow
{
  class Command;
  class Parameter;
}

class ParameterInspector : public ParameterInspectorBase
{
  Q_OBJECT

public:
  static ParameterInspector* self();

  void setCommand(WorKflow::Command* command);

public slots:
  void commitChanges();

signals:
  void changed();
  void visibilityChanged();

protected slots:
  virtual void slotClosePressed();
  virtual void slotParameterTypeChanged(int);
  virtual void slotValueItemSelected();
  virtual void slotParameterSelected();
  virtual void showDatatypeInfo();
  virtual void moveDown();
  virtual void moveUp();
  virtual void deleteValue();
  virtual void editValue();
  virtual void addValue();
  virtual void updateInspector();
  virtual void updateWidget();
  virtual void slotAutoUpdateChecked(bool);

protected:
  virtual void showEvent(QShowEvent*);
  virtual void hideEvent(QHideEvent*);

  ParameterInspector();
  ~ParameterInspector();

private:
  void enableButtons();
  QString getValue(const QString& oldvalue = "");

  static ParameterInspector* s_self;

  WorKflow::Command* m_command;
  WorKflow::Parameter* m_parameter;
};

#endif
