/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

#ifndef EDITWIDGET_H
#define EDITWIDGET_H

#include <qwidget.h>

class QGridLayout;

namespace WorKflow
{
  class CommandDescription;
  class Command;
  class CommandWidget;
  class Document;
}

/**
 * @author Thomas Kadauke
 */
class EditWidget : public QWidget
{
  Q_OBJECT

public:
  EditWidget(QWidget *parent = 0, const char *name = 0);
  ~EditWidget();

public slots:
  void setCommandDescription(WorKflow::CommandDescription* desc);

private:
  WorKflow::CommandDescription* m_description;
  WorKflow::Document* m_document;
  WorKflow::Command* m_command;
  WorKflow::CommandWidget* m_widget;
  QGridLayout* m_layout;
};

#endif
