/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

#ifndef IOWIDGET_H
#define IOWIDGET_H

// Qt includes
#include <qvaluelist.h>

#include "iowidgetbase.h"

// forward declarations
namespace WorKflow
{
  class CommandDescription;
  class ParameterDescription;
  class ResultDescription;
}

class IoWidget : public IoWidgetBase
{
  Q_OBJECT

public:
  typedef QValueList<WorKflow::ParameterDescription*> ParamList;
  typedef QValueList<WorKflow::ResultDescription*> ResultList;

  IoWidget(QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
  ~IoWidget();

public slots:
  void setCommandDescription(WorKflow::CommandDescription* desc);

protected slots:
  virtual void slotResultSelectionChanged();
  virtual void resultDown();
  virtual void resultUp();
  virtual void removeResult();
  virtual void editResult();
  virtual void addResult();
  virtual void slotParameterSelectionChanged();
  virtual void parameterDown();
  virtual void parameterUp();
  virtual void removeParameter();
  virtual void editParameter();
  virtual void addParameter();

private:
  WorKflow::CommandDescription* m_description;
};

#endif

