/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// KDE includes
#include <klocale.h>

// designer includes
#include "requirementlistitem.h"

RequirementListItem::RequirementListItem(QListView* parent)
  : QListViewItem(parent, parent->lastItem()), m_kind(ApplicationRunning)
{
  update();
}

RequirementListItem::~RequirementListItem()
{
}

RequirementListItem::Kind RequirementListItem::kind() const
{
  return m_kind;
}

void RequirementListItem::setKind(Kind kind)
{
  m_kind = kind;
  update();
}

QString RequirementListItem::application() const
{
  return m_application;
}

void RequirementListItem::setApplication(const QString& app)
{
  m_application = app;
  update();
}

void RequirementListItem::update()
{
  switch (m_kind) {
    case ApplicationRunning:
      setText(0, i18n("Application \"%1\" needs to be running").arg(m_application));
      break;
    case ProgramInstalled:
      setText(0, i18n("Program \"%1\" needs to be installed").arg(m_application));
      break;
  }
}
