/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// KDE includes
#include <klocale.h>
#include <kpushbutton.h>

// Qt includes
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qradiobutton.h>

// WorKflow includes
#include "resultdescription.h"
#include "commanddescription.h"
#include "parameterdescription.h"
#include "result.h"
#include "datatype.h"
#include "typemanager.h"

// designer includes
#include "resultdialog.h"
#include "dialoghelper.h"
#include "selecttypedialog.h"
#include "typelistitem.h"

using namespace WorKflow;

bool ResultDialog::editResult(QWidget* parent, CommandDescription* cmd, ResultDescription* desc)
{
  ResultDialog dialog(parent, cmd, desc);
  return dialog.exec();
}

ResultDescription* ResultDialog::newResult(QWidget* parent, CommandDescription* cmd)
{
  ResultDialog dialog(parent, cmd, new ResultDescription(cmd));
  if (dialog.exec())
    return dialog.m_description;
  else
    return 0;
}

void ResultDialog::init()
{
  m_idEdit->setText(m_description->id());
  m_nameEdit->setText(m_description->name());
  m_descriptionEdit->setText(m_description->description());

  typedef QValueList<ParameterDescription*> ParamList;
  ParamList params = m_command->parameters();

  if (params.isEmpty()) {
    m_sameTypeRadio->setEnabled(false);
    m_otherTypeRadio->setChecked(true);
  } else {
    for (ParamList::ConstIterator i = params.begin(); i != params.end(); ++i) {
      m_sameTypeCombo->insertItem(i18n("%1").arg((*i)->id()));
    }
  }

  if (m_description->parameter().isEmpty()) {
    m_otherTypeRadio->setChecked(true);

    QStringList types = m_description->typeIds();
    for (QStringList::ConstIterator i = types.begin(); i != types.end(); ++i) {
      Datatype* type = TypeManager::self()->find(*i);
      if (type) {
        new TypeListItem(m_typesListView, type);
      }
    }
  } else {
    DialogHelper::setComboBoxText(m_sameTypeCombo, m_description->parameter());
    m_copyResultCheckBox->setChecked(m_description->copyValue());
  }
}

void ResultDialog::accept()
{
  m_description->setId(m_idEdit->text());
  m_description->setName(m_nameEdit->text());
  m_description->setDescription(m_descriptionEdit->text());

  m_description->clearTypeIds();
  if (m_sameTypeRadio->isChecked()) {
    m_description->setParameter(m_sameTypeCombo->currentText());
    m_description->setCopyValue(m_copyResultCheckBox->isChecked());
  } else {
    m_description->setCopyValue(false);

    QListViewItemIterator it(m_typesListView);
    while (it.current()) {
      TypeListItem* item = static_cast<TypeListItem*>(it.current());
      m_description->addTypeId(item->type()->id());
      ++it;
    }
  }

  QDialog::accept();
}

ResultDialog::ResultDialog(QWidget* parent, CommandDescription* cmd, ResultDescription* desc)
  : ResultDialogBase(parent), m_command(cmd), m_description(desc)
{
  init();
}

ResultDialog::~ResultDialog()
{
}

void ResultDialog::addType()
{
  Datatype* type = SelectTypeDialog::select(this);
  if (type) {
    TypeListItem* item = new TypeListItem(m_typesListView, type);
    m_typesListView->setSelected(item, true);
  }
}

void ResultDialog::removeType()
{
  DialogHelper::removeItem(m_typesListView);
}

void ResultDialog::slotTypeSelectionChanged()
{
  QListViewItem* item = m_typesListView->selectedItem();
  m_removeTypeButton->setEnabled(item != 0);
  m_typeUpButton->setEnabled(item != 0 && item->itemAbove() != 0);
  m_typeDownButton->setEnabled(item != 0 && item->itemBelow() != 0);
}

void ResultDialog::typeUp()
{
  DialogHelper::itemUp(m_typesListView);
}

void ResultDialog::typeDown()
{
  DialogHelper::itemDown(m_typesListView);
}

#include "resultdialog.moc"
