/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// KDE includes
#include <klocale.h>

// WorKflow includes
#include "categorylistview.h"
#include "categorylistviewitem.h"
#include "commandmanager.h"
#include "librarymanager.h"
#include "category.h"

using namespace WorKflow;

CategoryListView::CategoryListView(QWidget* parent, const char* name)
  : KListView(parent, name)
{
  addColumn(i18n("Category"));
  connect(LibraryManager::self(), SIGNAL(allLibrariesLoaded()), this, SLOT(populate()));
  connect(this, SIGNAL(selectionChanged(QListViewItem*)), this, SLOT(slotSelectionChanged(QListViewItem*)));
}

CategoryListView::~CategoryListView()
{
}

void CategoryListView::populate()
{
  clear();
  // "All commands" category
  QListViewItem* allCommands = new CategoryListViewItem(this, 0);
  insertItem(allCommands);

  if (m_filter.isEmpty()) {
    // other categories
    typedef CommandManager::CategoryList CatList;
    CatList categories = CommandManager::self()->categories();
    for (CatList::ConstIterator i = categories.begin(); i != categories.end(); ++i) {
      insertItem(new CategoryListViewItem(this, *i));
    }
  } else {
    allCommands->setText(0, i18n("Search"));
  }

  // select "All commands" category such that an associated
  // command view is populated with items
  setSelected(allCommands, true);
}

void CategoryListView::slotSelectionChanged(QListViewItem* item)
{
  CategoryListViewItem* catItem = static_cast<CategoryListViewItem*>(item);
  Category* cat = catItem->category();
  QString catName = "";

  // if cat is zero, this means "All" was selected, so catName is empty.
  if (cat) {
    catName = cat->id();
  }

  emit categorySelected(catName);
}

void CategoryListView::setFilter(const QString& string)
{
  m_filter = string;
  populate();
}

#include "categorylistview.moc"
