/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// KDE includes
#include <kdebug.h>

// WorKflow includes
#include "combobox.h"
#include "datatype.h"
#include "typemanager.h"
#include "parameter.h"

using namespace WorKflow;

class ComboBox::Private
{
public:
  Private();

  Datatype* type;
};

ComboBox::Private::Private()
  : type(0)
{
}

ComboBox::ComboBox(bool rw, QWidget* parent, const char* name)
  : QComboBox(rw, parent, name)
{
  d = new Private;
}

ComboBox::ComboBox(QWidget* parent, const char* name)
  : QComboBox(parent, name)
{
  d = new Private;

  connect(this, SIGNAL(activated(int)), this, SLOT(slotChanged()));
}

ComboBox::~ComboBox()
{
  delete d;
}

QString ComboBox::parameterId() const
{
  return WidgetInterface::parameterId();
}

Value ComboBox::value()
{
  const QStringList& keys = d->type->enumKeys();
  QString key = *(keys.at(currentItem()));
  return Value::singleString(parameter()->typeId(), key);
}

void ComboBox::setValue(const Value& value)
{
  const QStringList& keys = d->type->enumKeys();
  int index = keys.findIndex(value.asStringList().first());
  if (index != currentItem()) {
    setCurrentItem(index);
  }
}

void ComboBox::setParameterId(const QString& paramId)
{
  WidgetInterface::setParameterId(paramId);
}

void ComboBox::slotChanged()
{
  if (!parameter())
    return;

  emit changed(value());
}

void ComboBox::setCommand(Command* cmd)
{
  WidgetInterface::setCommand(cmd);
  if (parameter()) {
    clear();
    d->type = parameter()->type();
    if (!d->type->isEnum()) {
      kdWarning() << "combobox parameter type not an enum" << endl;
      return;
    }

    const QStringList& names = d->type->enumNames();
    insertStringList(names);
  }
}

#include "combobox.moc"
