/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// KDE includes
#include <klistview.h>
#include <klocale.h>
#include <kpushbutton.h>

// Qt includes
#include <qlineedit.h>
#include <qgroupbox.h>

// dialog includes
#include "editfilenamefilterdialog.h"

bool EditFilenameFilterDialog::edit(QWidget* parent, QStringList& filters)
{
  EditFilenameFilterDialog dialog(parent, filters);
  if (dialog.exec()) {
    filters = dialog.filters();
    return true;
  }

  return false;
}

EditFilenameFilterDialog::EditFilenameFilterDialog(QWidget* parent, const QStringList& filters)
  : EditFilenameFilterDialogBase(parent), m_dontUpdate(false)
{
  for (QStringList::ConstIterator i = filters.begin(); i != filters.end(); ++i) {
    int split = (*i).find('|');
    QString pattern = (*i).left(split);
    QString description = (*i).mid(split + 1);

    new KListViewItem(m_listView, pattern, description);
  }
}

EditFilenameFilterDialog::~EditFilenameFilterDialog()
{
}

void EditFilenameFilterDialog::addFilter()
{
  QListViewItem* item = new KListViewItem(m_listView, "*.", i18n("<description>"));
  m_listView->setSelected(item, true);

  m_patternEdit->selectAll();
  m_patternEdit->setFocus();
}

void EditFilenameFilterDialog::removeFilter()
{
  QListViewItem* item = m_listView->selectedItem();
  if (item != 0) {
    delete item;
  }
}

void EditFilenameFilterDialog::updateFilter()
{
  if (m_dontUpdate)
    return;

  QListViewItem* item = m_listView->selectedItem();
  if (item != 0) {
    item->setText(0, m_patternEdit->text());
    item->setText(1, m_descriptionEdit->text());
  }
}

void EditFilenameFilterDialog::slotSelectionChanged()
{
  QListViewItem* item = m_listView->selectedItem();
  m_removeButton->setEnabled(item != 0);
  m_groupBox->setEnabled(item != 0);

  if (item != 0) {
    m_dontUpdate = true;

    m_patternEdit->setText(item->text(0));
    m_descriptionEdit->setText(item->text(1));

    m_dontUpdate = false;
  }
}

QStringList EditFilenameFilterDialog::filters()
{
  QStringList result;

  for (QListViewItemIterator it(m_listView); it.current(); ++it) {
    result << QString("%1|%2").arg(it.current()->text(0)).arg(it.current()->text(1));
  }

  return result;
}

#include "editfilenamefilterdialog.moc"
