/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// WorKflow includes
#include "listbox.h"
#include "command.h"
#include "parameter.h"

using namespace WorKflow;

ListBox::ListBox(QWidget* parent, const char* name, WFlags f)
  : QListBox(parent, name, f)
{
//   d = new ListBox::Private;
}

ListBox::~ListBox()
{
//   delete d;
}

Value ListBox::value()
{
  QStringList result;
  for (int i = 0; i != count(); ++i)
    result << text(i);
  return Value::stringList(parameter()->typeId(), result);
}

void ListBox::setValue(const Value& value)
{
  clear();
  insertStringList(value.asStringList());
}

void ListBox::setParameterId(const QString& paramId)
{
  WidgetInterface::setParameterId(paramId);
}

QString ListBox::parameterId() const
{
  return WidgetInterface::parameterId();
}

#include "listbox.moc"
