/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// WorKflow includes
#include "slider.h"
#include "parameter.h"
#include "datatype.h"

using namespace WorKflow;

Slider::Slider(int minValue, int maxValue, int pageStep, int value, Orientation o, QWidget* parent, const char* name)
  : QSlider(minValue, maxValue, pageStep, value, o, parent, name)
{
  connect(this, SIGNAL(valueChanged(int)), this, SLOT(slotChanged()));
}

Slider::Slider(Orientation o, QWidget* parent, const char* name)
  : QSlider(o, parent, name)
{
  connect(this, SIGNAL(valueChanged(int)), this, SLOT(slotChanged()));
}

Slider::Slider(QWidget* parent, const char* name)
  : QSlider(parent, name)
{
  connect(this, SIGNAL(valueChanged(int)), this, SLOT(slotChanged()));
}

Slider::~Slider()
{
}

QString Slider::parameterId() const
{
  return WidgetInterface::parameterId();
}

Value Slider::value()
{
  Datatype* type = parameter()->type();
  if (type->isEnum()) {
    return Value::enumValue(type->id(), QSlider::value());
  } else
    return Value::singleNumber(parameter()->typeId(), QSlider::value());
}

void Slider::setParameterId(const QString& paramId)
{
  WidgetInterface::setParameterId(paramId);
}

void Slider::setValue(const Value& value)
{
  Datatype* type = parameter()->type();
  int val;
  if (type->isEnum()) {
    val = value.enumIndex();
  } else {
    val = value.asStringList().first().toInt();
  }

  if (QSlider::value() != val)
    QSlider::setValue(val);
}

void Slider::slotChanged()
{
  if (!parameter())
    return;

  Value val = value();
  emit changed(val);

  if (parameter()) {
    if (parameter()->type()->isEnum()) {
      emit enumNameChanged(val.enumName());
    }
  }
}

void Slider::setCommand(Command* cmd)
{
  WidgetInterface::setCommand(cmd);
  if (parameter()) {
    Datatype* type = parameter()->type();
    if (type->isEnum()) {
      setMinValue(0);
      setMaxValue(type->enumKeys().count() - 1);
      setSteps(1, 1);
    }
  }
}

#include "slider.moc"
