/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

#ifndef STRINGLISTEDITOR_H
#define STRINGLISTEDITOR_H

// Qt includes
#include <qwidget.h>

// WorKflow includes
#include "widgetinterface.h"

namespace WorKflow
{
  class StringListEditor : public QWidget, public WorKflow::WidgetInterface
  {
    Q_OBJECT
    Q_PROPERTY(QString parameterId READ parameterId WRITE setParameterId)

  public:
    StringListEditor(QWidget* parent = 0, const char* name = 0, WFlags fl = 0);
    ~StringListEditor();

    virtual Value value();

    virtual void setParameterId(const QString& paramId);
    virtual QString parameterId() const;

  public slots:
    virtual void setValue(const Value& val);

  signals:
    void changed(const Value& val);

  protected slots:
    virtual void add();
    virtual void remove();
    virtual void down();
    virtual void up();
    virtual void slotSelectionChanged();

  protected:
    void emitChanged();

  private:
    class Private;
    Private* d;
  };
}

#endif

