/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// KDE includes
#include <kapplication.h>
#include <dcopclient.h>

// library includes
#include "kateapplication.h"
#include "katedocument.h"

using namespace WorKflow;

KateApplication::KateApplication(ApplicationDescription* app, const QString& dcopid)
  : WorKflow::Application(app, dcopid)
{
}

KateApplication::~KateApplication()
{
}

DCOPRef KateApplication::activeDocument()
{
  DCOPRef result = DCOPRef(dcopName().utf8(), "KateDocumentManager").call("activeDocument()");
  return result;
}

DCOPRef KateApplication::mainWindow()
{
  DCOPRef result = DCOPRef(dcopName().utf8(), "KateApplication").call("activeMainWindow()");
  return result;
}

QStringList KateApplication::actions()
{
  
}

QString KateApplication::actionName(const QString& actionId)
{
}

void KateApplication::executeAction(const QString& actionId)
{
}

QString KateApplication::currentText()
{
  KateDocument doc(activeDocument());

  QString text = doc.editor().call("text()");
  return text;
}

QString KateApplication::selectedText()
{
  KateDocument doc(activeDocument());

  DCOPRef selRef = doc.selection();

  bool hasSelection = selRef.call("hasSelection()");
  if (!hasSelection)
    return QString::null;

  QString text = selRef.call("selection()");
  return text;
}

void KateApplication::setCurrentText(const QString& text)
{
  KateDocument doc(activeDocument());

  doc.editor().call("setText(QString)", text);
}

bool KateApplication::setSelectedText(const QString& text)
{
  KateDocument doc(activeDocument());

  if (!doc.selection().call("hasSelection()"))
    return false;

  if (!doc.selection().call("removeSelectedText()"))
    return false;

  uint line = doc.view().call("cursorLine()");
  uint column = doc.view().call("cursorColumn()");

  if (!doc.editor().call("insertText(uint,uint,QString)", line, column, text))
    return false;

  return true;
}

QValueList<DCOPRef> KateApplication::allDocuments()
{
  QValueList<DCOPRef> result;

  DCOPRef docManager(dcopName().utf8(), "KateDocumentManager");
  uint num = docManager.call("documents()");
  for (uint i = 0; i != num; ++i) {
    result.append(docManager.call("document(uint)", i));
  }

  return result;
}

DCOPRef KateApplication::open(const KURL& url)
{
  DCOPRef manager(dcopName().utf8(), "KateDocumentManager");
  return manager.call("openURL(KURL,QString)", url, QString());
}

void KateApplication::insertText(const QString& text, InsertPosition pos)
{
  KateDocument doc(activeDocument());
  uint line = 0;
  uint col = 0;

  switch (pos) {
    case CursorPosition:
      line = doc.view().call("cursorLine()");
      col = doc.view().call("cursorColumn()");
      break;
    case StartOfDocument:
      break;
    case EndOfDocument: {
      int numLines = doc.editor().call("numLines()");
      line = numLines - 1;
      break;
    }
  }

  doc.editor().call("insertText(uint,uint,QString)", line, col, text);
}
