/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// KDE includes
#include <klocale.h>

// WorKflow includes
#include <workflow/document.h>
#include <workflow/applicationmanager.h>

// command includes
#include "openfilesinkatecommand.h"
#include "kateapplication.h"

using namespace WorKflow;

OpenFilesInKateCommand::OpenFilesInKateCommand(Document* parent, CommandDescription* description)
  : Command(parent, description)
{
}

OpenFilesInKateCommand::~OpenFilesInKateCommand()
{
}

void OpenFilesInKateCommand::execute()
{
  QStringList files = value("input").asStringList();

  Application* app = document()->appManager()->findRunning("org.kde.kate");
  if (app) {
    KateApplication* kate = static_cast<KateApplication*>(app);

    QValueList<DCOPRef> result;
    int num = 0;
    int count = files.count();
    for (QStringList::ConstIterator i = files.begin(); i != files.end(); ++i, ++num) {
      emit progress(double(num) / double(count), i18n("Opening file %1 in Kate").arg(*i));
      result.append(kate->open(*i));
    }

    setResult("output", Value::dcopRefList("org.kde.private.katedocument", result));
  } else {
    // error
  }
}

#include "openfilesinkatecommand.moc"
