/*
    This file is part of KOrganizer.
    Copyright (c) 2001 Cornelius Schumacher <schumacher@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#ifndef KOPROJECTVIEW_H
#define KOPROJECTVIEW_H
/* $Id: koprojectview.h,v 1.5 2002/06/11 10:14:46 schwann Exp $ */

#include <qptrlist.h>
#include <qfontmetrics.h>

#include <qmap.h>

#include <libkcal/calendar.h>
#include <libkcal/event.h>

#include "korganizer/baseview.h"
#include "KGanttItem.h"

class KGantt;
class QLineEdit;
class QFont;
class QLabel;
class QPopupMenu;
class QListBox;
class QStrList;
class QListView;

/**
  This class provides an item of the project view. It is a xQTask with
  an additional Event attribute.
*/
class KOProjectViewItem : public KGanttItem {
  public:
    KOProjectViewItem(Todo *,KGanttItem* parentTask, const QString& text, 
	              const QDateTime& start, const QDateTime& end);
    ~KOProjectViewItem();
    
    Todo *event();
    
  private:
    Todo *mEvent;
};


/**
 * This class provides a Gantt-like project view on todo items 
 *
 * @short project view on todo items.
 * @author Cornelius Schumacher <schumacher@kde.org>
 */
class KOProjectView : public KOrg::BaseView
{
    Q_OBJECT
  public:
    KOProjectView(Calendar *, QWidget* parent=0, const char* name=0 );
    ~KOProjectView() {}

    QPtrList<Incidence> selectedIncidences();
    DateList selectedDates();

    /** Return number of shown dates. */
    int currentDateCount() { return 0; }

    void readSettings();
    void writeSettings(KConfig *);

  public slots:
    void updateView();
    void updateConfig();

    void changeEventDisplay(Event *, int);
  
    void showDates(const QDate &start, const QDate &end);
    void showEvents(QPtrList<Event> eventList);

/*
    void editItem(QListViewItem *item);
    void showItem(QListViewItem *item);
    void popupMenu(QListViewItem *item,const QPoint &,int);
    void newTodo();
    void newSubTodo();
    void showTodo();
    void editTodo();
    void deleteTodo();
    void purgeCompleted();
    void itemClicked(QListViewItem *);
*/
    
  protected slots:
    void showModeMenu();  
    void zoomIn();
    void zoomOut();
    void taskChanged(KGanttItem *task,KGanttItem::Change change);
  
  signals:
    void newTodoSignal();
    void newSubTodoSignal(Todo *);
    void showTodoSignal(Todo *);
    void editTodoSignal(Todo *);
    void deleteTodoSignal(Todo *);

  private:
    void createMainTask();
    KGanttItem *createTask(KGanttItem *,Todo *);
  
    KGantt *mGantt;
    KGanttItem *mMainTask;

    QMap<Todo *,KGanttItem *>::ConstIterator insertTodoItem(Todo *todo);

    QMap<Todo *,KGanttItem *> mTodoMap;
};

#endif
