<?php
/**
 * $Horde: moment/list.php,v 1.9 2003/08/07 01:33:59 chuck Exp $
 *
 * Copyright 2003 Mike Cochrane <mike@graftonhall.co.nz>
 *
 * See the enclosed file LICENSE for license information.
 */

@define('MOMENT_BASE', dirname(__FILE__));
require_once MOMENT_BASE . '/lib/base.php';

/* Get the current action ID. */
$actionID = Horde::getFormData('actionID');

/* Sort out the sorting values and meeting filtering. */
if (($sortby = Horde::getFormData('sortby')) !== null) {
    $prefs->setValue('sortby', $sortby);
}
if (($sortdir = Horde::getFormData('sortdir')) !== null) {
    $prefs->setValue('sortdir', $sortdir);
}
if (($show_completed = Horde::getFormData('show_completed')) !== null) {
    $prefs->setValue('show_completed', $show_completed);
}

/* Get the full, sorted meeting list. */
$meetings = Moment::listMeetings($prefs->getValue('sortby'),
                                 $prefs->getValue('sortdir'));

/* Page variables. */
$i = 0;
$title = _("Meetings");
$js_onLoad = null;

$list = Horde::applicationUrl('list.php');
$all_link = Horde::link(Horde::addParameter($list, 'show_completed=1'), _("All meetings"), 'menuitem') . _("All meetings") . '</a>';
$complete_link = Horde::link(Horde::addParameter($list, 'show_completed=2'), _("Complete meetings"), 'menuitem') . _("Past meetings") . '</a>';
$incomplete_link = Horde::link(Horde::addParameter($list, 'show_completed=0'), _("Incomplete meetings"), 'menuitem') . _("Upcoming meetings") . '</a>';
switch ($prefs->getValue('show_completed')) {
 case 1: // All meetings
     $all_link = _("All meetings");
     break;

 case 0: // Incomplete meetings
     $incomplete_link = _("Upcoming meetings");
     break;

 case 2: // Complete meetings
     $complete_link = _("Past meetings");
     break;
}

require MOMENT_TEMPLATES . '/common-header.inc';
Moment::menu();
require MOMENT_TEMPLATES . '/list/javascript.inc';
require MOMENT_TEMPLATES . '/list/header.inc';

if (count($meetings) > 0) {
    require MOMENT_TEMPLATES . '/list/meeting_headers.inc';

    $i = 0;
    foreach ($meetings as $meeting_id => $meeting) {
        $class = 'item' . ($i++ % 2);
        $style = 'white-space:nowrap;';

        if ($meeting['status'] == 'cancelled') {
            $style .= "text-decoration:line-through;";
        }
        $meetingurl = Horde::applicationUrl(Horde::addParameter('viewMeeting.php', 'meetingID', $meeting_id));
        $delurl = Horde::applicationUrl(Horde::addParameter('meeting.php', 'meetingID', $meeting_id));
        $delurl = Horde::addParameter($delurl, 'actionID', MOMENT_DELETE_MEETING);

        require MOMENT_TEMPLATES . '/list/meeting_summaries.inc';
    }

    require MOMENT_TEMPLATES . '/list/meeting_footers.inc';
} else {
    require MOMENT_TEMPLATES . '/list/empty.inc';
}

require MOMENT_TEMPLATES . '/list/footer.inc';
require MOMENT_TEMPLATES . '/common-footer.inc';
