<?php
/**
 * Nag base inclusion file.
 *
 * $Horde: nag/lib/base.php,v 1.51 2003/04/23 13:52:12 jan Exp $
 *
 * This file brings in all of the dependencies that every Nag
 * script will need and sets up objects that all scripts use.
 */

// Find the base file path of Horde
@define('HORDE_BASE', dirname(__FILE__) . '/../..');

// Find the base file path of Nag
@define('NAG_BASE', dirname(__FILE__) . '/..');

// Registry
require_once HORDE_BASE . '/lib/Registry.php';
$registry = &Registry::singleton();
$registry->pushApp('nag');
$conf = &$GLOBALS['conf'];
@define('NAG_TEMPLATES', $registry->getParam('templates'));

// Horde base libraries
require_once HORDE_BASE . '/lib/Horde.php';
require_once HORDE_BASE . '/lib/Auth.php';
require_once HORDE_BASE . '/lib/Text.php';
require_once HORDE_BASE . '/lib/Help.php';

// Don't allow access unless there is a Horde login or guests are
// allowed.
if (!Auth::isAuthenticated() && !$registry->allowGuests()) {
    Horde::authenticationFailureRedirect();
}

// Nag base libraries
require_once NAG_BASE . '/lib/Nag.php';
require_once NAG_BASE . '/lib/Driver.php';

// Browser detection library
require_once HORDE_BASE . '/lib/Browser.php';
$browser = &Browser::singleton();

// Notification system.
require_once HORDE_BASE . '/lib/Notification.php';
require_once NAG_BASE . '/lib/Notification/Listener/status.php';
$notification = &Notification::singleton();
$notification->attach('status', null, 'Notification_Listener_status_nag');

// Set the timezone variable, if available.
NLS::setTimeZone();

// Create a share instance.
require_once HORDE_BASE . '/lib/Share.php';
$GLOBALS['nag_shares'] = &Horde_Share::singleton($registry->getApp());

// Update the preference for what task lists to display. If the user doesn't
// have any selected task lists for view then fall back to some available
// list.
$GLOBALS['display_tasklists'] = unserialize($GLOBALS['prefs']->getValue('display_tasklists'));
if (($d_task = Horde::getFormData('display_tasklist')) !== null) {
    if (in_array($d_task, $GLOBALS['display_tasklists'])) {
        $key = array_search($d_task, $GLOBALS['display_tasklists']);
        unset($GLOBALS['display_tasklists'][$key]);
    } else {
        $GLOBALS['display_tasklists'][] = $d_task;
    }
}

// Make sure all task lists exist now, to save on checking later.
$_temp = $GLOBALS['display_tasklists'];
$_all = Nag::listTasklists();
$GLOBALS['display_tasklists'] = array();
foreach ($_temp as $id) {
    if (isset($_all[$id])) {
        $GLOBALS['display_tasklists'][] = $id;
    }
}
$GLOBALS['prefs']->setValue('display_tasklists', serialize($GLOBALS['display_tasklists']));

// Make sure we have at least one task list to work with.
if (count($GLOBALS['display_tasklists']) == 0) {
    // Find a task list to fall back on.
    $lists = Nag::listTasklists(true);
    if (count($lists) > 0) {
        if (array_key_exists(Auth::getAuth(), $lists)) {
            // User's personal task list.
            $GLOBALS['display_tasklists'] = array(Auth::getAuth());
        } else {
            // Some other task list they own.
            $GLOBALS['display_tasklists'] = array(array_pop(array_keys($lists)));
        }
    } elseif (Auth::getAuth()) {
        // Create a personal task list.
        $GLOBALS['display_tasklists'] = array(Auth::getAuth());

        // If this share doesn't exist then create it.
        if (!$GLOBALS['nag_shares']->exists(Auth::getAuth())) {
            require_once HORDE_BASE . '/lib/Identity.php';
            $identity = &new Identity();
            $name = $identity->getValue('fullname');
            if (trim($name) == '') {
                $name = Auth::removeHook(Auth::getAuth());
            }
            $share = $GLOBALS['nag_shares']->newShare(Auth::getAuth());
            $share->setOwner(Auth::getAuth(), false);
            $share->setShareName(sprintf(_("%s's Task List"), $name), false);
            $GLOBALS['nag_shares']->addShare($share);
        }
    }
    $GLOBALS['prefs']->setValue('display_tasklists', serialize($GLOBALS['display_tasklists']));
}
