<?php
/**
 * $Horde: nag/task.php,v 1.51 2003/08/07 22:27:32 slusarz Exp $
 *
 * Copyright 2001-2003 Jon Parise <jon@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

define('NAG_BASE', dirname(__FILE__));
require_once NAG_BASE . '/lib/base.php';

/* Redirect to the task list if no action has been requested. */
$actionID = Horde::getFormData('actionID');
if (is_null($actionID)) {
    header('Location: ' . Horde::applicationUrl('list.php', true));
    exit;
}

$url = Horde::getFormData('url');

/* Run through the action handlers. */
switch ($actionID) {
case NAG_ADD_TASK:
    /* Set up the task attributes. */
    $tasklist_id = $prefs->getValue('default_tasklist');
    $task_id = null;
    $task_name = '';
    $task_due = 0;
    $task_desc = '';
    $task_priority = 3;
    $task_completed = 0;

    if (($task_category = $prefs->getValue('default_task_category')) == null) {
        $task_category = 0;
    }

    $task_alarm = 0;
    $alarm_value = 15;
    $alarm_unit = 'min';  
    $alarm_set = false;

    include_once HORDE_BASE . '/lib/Widgets.php';

    /* Set the initial due date to one week from now. */
    $initial_date = getdate(time() + 604800);
    $javascript = 'onchange="document.task.due_type[1].checked = true;"';
    $day_widget = Horde_Widgets::buildDayWidget('due[day]', $initial_date['mday'], $javascript);
    $month_widget = Horde_Widgets::buildMonthWidget('due[month]', $initial_date['mon'], $javascript);
    $year_widget = Horde_Widgets::buildYearWidget('due[year]', 3, $initial_date['year'], $javascript);
    $hour_widget = Horde_Widgets::buildHourWidget('due_hour', $initial_date['hours'], $javascript);
    $minute_widget = Horde_Widgets::buildMinuteWidget('due_minute', 15, null, $javascript);

    /* Set up the radio buttons. */
    $none_checked = ($task_due == 0) ? 'checked="checked" ' : '';
    $specified_checked = ($task_due != 0) ? 'checked="checked" ' : '';

    $title = _("Adding A New Task");
    break;

case NAG_MODIFY_TASK:
    $task_id = Horde::getFormData('task');
    $tasklist_id = Horde::getFormData('tasklist');
    $task = Nag::getTask($tasklist_id, $task_id);
    $alarm_value = 15;
    $alarm_unit = 'min';  
    $alarm_set = false;  

    if ($task) {
        /* Set up the task attributes. */
        $task_name = $task['name'];
        $task_due = $task['due'];
        $task_desc = $task['desc'];
        $task_priority = $task['priority'];
        $task_completed = $task['completed'];
        $task_category = $task['category'];
        $task_alarm = $task['alarm'];

        /* If the due date isn't set, set the widgets to the
         * default. */
        $due_date = getdate(($task_due > 0) ? $task_due : (time() + 604800));
        $javascript = 'onchange="document.task.due_type[1].checked = true;"';

        /* Set up alarm widget data. */
        if ($task_due && $task_alarm) {
            $alarm_set = true;
            if ($task_alarm % 10080 == 0) {
                $alarm_value = $task_alarm / 10080;
                $alarm_unit = 'week';
            } elseif ($task_alarm % 1440 == 0) {
                $alarm_value = $task_alarm / 1440;
                $alarm_unit = 'day';
            } elseif ($task_alarm % 60 == 0) {
                $alarm_value = $task_alarm / 60;
                $alarm_unit = 'hour';
            } else {
                $alarm_value = $task_alarm;
                $alarm_unit = 'min';
            }
        }

        /* Set up the due date selection widgets. */
        include_once HORDE_BASE . '/lib/Widgets.php';
        $day_widget = Horde_Widgets::buildDayWidget('due[day]', $due_date['mday'], $javascript);
        $month_widget = Horde_Widgets::buildMonthWidget('due[month]', $due_date['mon'], $javascript);
        $year_widget = Horde_Widgets::buildYearWidget('due[year]', 3, $due_date['year'], $javascript);
        $hour_widget = Horde_Widgets::buildHourWidget('due_hour', $due_date['hours'], $javascript);
        $minute_widget = Horde_Widgets::buildMinuteWidget('due_minute', 15, $due_date['minutes'], $javascript);

        /* Set up the radio buttons. */
        $none_checked = ($task_due == 0) ? 'checked="checked" ' : '';
        $specified_checked = ($task_due > 0) ? 'checked="checked" ' : '';

        $title = _("Modifying:") . ' ' . $task_name;
    } else {
        $title = _("Unknown task");
    }
    break;

case NAG_SAVE_TASK:
    /* Get the form values. */
    $task_id = Horde::getFormData('task');
    $tasklist_original = Horde::getFormData('tasklist_original');
    $tasklist_target = Horde::getFormData('tasklist_target');

    $share = $GLOBALS['nag_shares']->getShare($tasklist_target);
    if (is_a($share, 'PEAR_Error') || !$share->hasPermission(Auth::getAuth(), _PERMS_EDIT)) {
        $notification->push(sprintf(_("Access denied saving task to %s."), $share->getShareName()), 'horde.error');
    } else {
        $task_name = Horde::getFormData('task_name');
        $task_desc = Horde::getFormData('task_desc');
        $task_priority = Horde::getFormData('task_priority');
        $task_completed = Horde::getFormData('task_completed');
        $task_category = Horde::getFormData('task_category');
        $due_type = Horde::getFormData('due_type');
        $due = Horde::getFormData('due');
        $due_day = !empty($due['day']) ? $due['day'] : null;
        $due_month = !empty($due['month']) ? $due['month'] : null;
        $due_year = !empty($due['year']) ? $due['year'] : null;
        $due_hour = Horde::getFormData('due_hour');
        $due_minute = Horde::getFormData('due_minute');
        $alarm_set = Horde::getFormData('alarm');
        $alarm_unit = Horde::getFormData('alarm_unit');
        $alarm_value = Horde::getFormData('alarm_value');
        if ($alarm_set) {
            $task_alarm = $alarm_value * $alarm_unit ;
        } else {
            $task_alarm = 0;
        }

        if ($task_category == '*new*') {
            $new_category = Horde::getFormData('new_category');
            $task_category = Nag::addCategory($new_category);
            if ($task_category == 0) {
                $notification->push(sprintf(_('Unable to create new category: %s'), $new_category), 'horde.warning');
            }
        }

        /* Convert the due date to Unix time. */
        $due_str = "$due_month/$due_day/$due_year $due_hour:$due_minute";

        /* Set the due date according to the $due_type toggle. */
        $task_due = (strcasecmp($due_type, 'none')) ? strtotime($due_str) : 0;

        /* If $task_id is set, we're modifying an existing
         * task. Otherwise, we're adding a new task with the provided
         * attributes. */
        if ($task_id != null && !empty($tasklist_original)) {
            if ($tasklist_original != $tasklist_target) {
                /* Saving to a different task list */
                $share = $GLOBALS['nag_shares']->getShare($tasklist_original);
                if (!is_a($share, 'PEAR_Error') && $share->hasPermission(Auth::getAuth(), _PERMS_DELETE)) {
                    $storage = &Nag_Driver::singleton($conf['storage']['driver'], $tasklist_original,
                                                      $conf['storage']['params']);
                    $storage->retrieve();

                    $storage->deleteTask($task_id);

                    if (is_a($storage->store(), 'PEAR_Error')) {
                        $notification->push(sprintf(_("There was a problem removing the task from %s."), $share->getShareName()), 'horde.error');
                    }
                } else {
                    $notification->push(sprintf(_("Access denied removing task from %s."), $share->getShareName()), 'horde.error');
                }

                $storage = &Nag_Driver::singleton($conf['storage']['driver'], $tasklist_target,
                                                  $conf['storage']['params']);
                $storage->retrieve();

                $task_id = $storage->addTask($task_name, $task_desc, $task_due,
                                             $task_priority, $task_completed,
                                             $task_category, $task_alarm);
            } else {
                /* Saving to the same task list. */
                $storage = &Nag_Driver::singleton($conf['storage']['driver'], $tasklist_target,
                                                  $conf['storage']['params']);
                $storage->retrieve();

                $storage->modifyTask($task_id, 'name', $task_name);
                $storage->modifyTask($task_id, 'desc', $task_desc);
                $storage->modifyTask($task_id, 'due', $task_due);
                $storage->modifyTask($task_id, 'priority', $task_priority);
                $storage->modifyTask($task_id, 'completed', $task_completed);
                $storage->modifyTask($task_id, 'alarm', $task_alarm);
                $storage->modifyTask($task_id, 'category', $task_category);
            }
        } else {
            $storage = &Nag_Driver::singleton($conf['storage']['driver'], $tasklist_target,
                                              $conf['storage']['params']);
            $storage->retrieve();

            $task_id = $storage->addTask($task_name, $task_desc, $task_due,
                                         $task_priority, $task_completed,
                                         $task_category, $task_alarm);
        }

        /* Store the changes. */
        $result = $storage->store();
        if (!is_a($result, 'PEAR_Error')) {
            $notification->push(_("The task was saved."), 'horde.success');
        } else {
            $notification->push(sprintf(_("There was a problem saving the task: %s."), $result->getMessage()), 'horde.error');
        }
    }

    /* Return to the task list. */
    $taskurl = Horde::addParameter('view.php', 'task=' . $task_id);
    $taskurl = Horde::addParameter($taskurl, 'tasklist=' . $tasklist_target);
    header('Location: ' . Horde::applicationUrl($taskurl, true));
    exit;
    break;

case NAG_DELETE_TASKS:
    /* Delete the task if we're provided with a valid task ID. */
    $task_id = Horde::getFormData('task');
    $tasklist_id = Horde::getFormData('tasklist');
    if (isset($task_id)) {
        $share = $GLOBALS['nag_shares']->getShare($tasklist_id);
        if (is_a($share, 'PEAR_Error') || !$share->hasPermission(Auth::getAuth(), _PERMS_DELETE)) {
            $task = Nag::getTask($tasklist_id, $task_id);
            $notification->push(sprintf(_("Access denied deleting task %s."), $task['name']), 'horde.error');
        } else {
            $storage = &Nag_Driver::singleton($conf['storage']['driver'], $tasklist_id,
                                              $conf['storage']['params']);
            $storage->retrieve();

            $storage->deleteTask($task_id);
            if (!is_a($storage->store(), 'PEAR_Error')) {
                $notification->push(_("Deleted 1 task."), 'horde.success');
            } else {
                $notification->push(_("There was a problem deleting tasks."), 'horde.error');
            }
        }
    }

    /* Return to the task list. */
    header('Location: ' . Horde::applicationUrl('list.php', true));
    exit;
    break;

case NAG_COMPLETE_TASKS:
    /* Complete the task if we're provided with a valid task ID. */
    $task_id = Horde::getFormData('task');
    $tasklist_id = Horde::getFormData('tasklist');
    if (isset($task_id)) {
        $share = $GLOBALS['nag_shares']->getShare($tasklist_id);
        if (is_a($share, 'PEAR_Error') || !$share->hasPermission(Auth::getAuth(), _PERMS_EDIT)) {
            $task = Nag::getTask($tasklist_id, $task_id);
            $notification->push(sprintf(_("Access denied completing task %s."), $task['name']), 'horde.error');
        } else {
            $storage = &Nag_Driver::singleton($conf['storage']['driver'], $tasklist_id,
                                              $conf['storage']['params']);
            $storage->retrieve();

            $storage->modifyTask($task_id, 'completed', 1);
            if (!is_a($storage->store(), 'PEAR_Error')) {
                $notification->push(_("Marked task as completed."), 'horde.success');
            } else {
                $notification->push(_("There was a problem setting task completion status."), 'horde.error');
            }
        }
    }

    if (isset($url)) {
        header('Location: ' . $url);
    } else {
        header('Location: ' . Horde::applicationUrl('list.php', true));
    }
    exit;
    break;

default:
    header('Location: ' . Horde::applicationUrl('list.php', true));
    exit;
}

$js_onLoad = 'document.task.task_name.focus()';
require NAG_TEMPLATES . '/common-header.inc';
Nag::menu();
require NAG_TEMPLATES . '/task/task.inc';
require NAG_TEMPLATES . '/common-footer.inc';
