<?php
/**
 * $Horde: horde/rpc.php,v 1.15 2003/08/05 01:21:42 chuck Exp $
 *
 * Copyright 2002-2003 Jan Schneider <jan@horde.org>
 *
 * See the enclosed file COPYING for license information (LGPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 */

define('HORDE_BASE', dirname(__FILE__));
require_once HORDE_BASE . '/lib/base.php';
require_once HORDE_BASE . '/lib/RPC.php';

$auth = &Auth::singleton($conf['auth']['driver']);

if (isset($_SERVER['PHP_AUTH_USER'])) {
    $user = $_SERVER['PHP_AUTH_USER'];
    $pass = $_SERVER['PHP_AUTH_PW'];
}

if (!isset($user)
    || !$auth->authenticate($user, array('password' => $pass))) {
    header('WWW-Authenticate: Basic realm="Horde RPC"');
    header('HTTP/1.0 401 Unauthorized');
    echo '401 Unauthorized';
    exit;
}

if (isset($HTTP_RAW_POST_DATA)) {
    $input = $HTTP_RAW_POST_DATA;
} else {
    $input = implode("\r\n", file('php://input'));
}

$serverType = 'xmlrpc';
if (!empty($_SERVER['CONTENT_TYPE'])) {
    switch ($_SERVER['CONTENT_TYPE']) {
    case 'application/vnd.syncml+xml':
        $serverType = 'syncml';
        break;

    default:
        $serverType = 'xmlrpc';
    }
}

$server = &RPC::singleton($serverType);
$out = $server->getResponse($input);

header('Content-Type: ' . $server->getResponseContentType());
header('Content-length: ' . strlen($out));
header('Accept-Charset: UTF-8');
echo $out;
