/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is a test script.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgtestmacro.h"
#include "skgimportexportmanager.h"
#include "skgbankincludes.h"

/**
 * The main function of the unit test
 * @param argc the number of arguments
 * @param argv the list of arguments
 */
int main(int argc, char** argv)
{
    Q_UNUSED(argc);
    Q_UNUSED(argv);

    // Init test
    SKGINITTEST(true);

    {
        // Test import MT940
        SKGDocumentBank document1;
        SKGTESTERROR("document1.initialize()", document1.initialize(), true);
        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, "IMPORT_MT940", err);
            SKGImportExportManager impmissing(&document1, QUrl("missingfile.mt940"));
            SKGTESTERROR("imp1.importFile", impmissing.importFile(), false);

            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath("IN") % "/skgtestimportmt940/test1.mt940"));
            SKGTESTERROR("MT940.importFile", imp1.importFile(), true);
        }

        {
            SKGAccountObject account(&document1);
            SKGTESTERROR("MT940.setName", account.setName("NUMERO DE COMPTE IBAN 2"), true);
            SKGTESTERROR("MT940.load", account.load(), true);
            SKGTEST("MT940:getCurrentAmount", SKGServices::doubleToString(account.getCurrentAmount()), "11.4");
        }
    }

    {
        // Test import MT940
        SKGDocumentBank document1;
        SKGTESTERROR("document1.initialize()", document1.initialize(), true);
        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, "IMPORT_MT940", err);

            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath("IN") % "/skgtestimportmt940/583501.mt940"));
            SKGTESTERROR("MT940.importFile", imp1.importFile(), true);
        }

        {
            SKGAccountObject account(&document1);
            SKGTESTERROR("MT940.setName", account.setName("12345.12"), true);
            SKGTESTERROR("MT940.load", account.load(), true);
            SKGTEST("MT940:getCurrentAmount", SKGServices::doubleToString(account.getCurrentAmount()), "12145.12");
        }
    }

    {
        // Test import MT940
        SKGDocumentBank document1;
        SKGTESTERROR("document1.initialize()", document1.initialize(), true);
        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, "IMPORT_MT940", err);

            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath("IN") % "/skgtestimportmt940/341076.mt940"));
            SKGTESTERROR("MT940.importFile", imp1.importFile(), true);
        }

        {
            SKGAccountObject account(&document1);
            SKGTESTERROR("MT940.setName", account.setName("2602272001"), true);
            SKGTESTERROR("MT940.load", account.load(), true);
            SKGTEST("MT940:getCurrentAmount", SKGServices::doubleToString(account.getCurrentAmount()), "-12.56");
        }
    }

    {
        // Test import MT940
        SKGDocumentBank document1;
        SKGTESTERROR("document1.initialize()", document1.initialize(), true);
        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, "IMPORT_MT940", err);

            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath("IN") % "/skgtestimportmt940/267442_1.mt940"));
            SKGTESTERROR("MT940.importFile", imp1.importFile(), true);
        }

        {
            SKGAccountObject account(&document1);
            SKGTESTERROR("MT940.setName", account.setName("55555.55"), true);
            SKGTESTERROR("MT940.load", account.load(), true);
            SKGTEST("MT940:getCurrentAmount", SKGServices::doubleToString(account.getCurrentAmount()), "1972.1");
        }
    }

    {
        // Test import MT940
        SKGDocumentBank document1;
        SKGTESTERROR("document1.initialize()", document1.initialize(), true);
        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, "IMPORT_MT940", err);

            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath("IN") % "/skgtestimportmt940/267442_2.mt940"));
            SKGTESTERROR("MT940.importFile", imp1.importFile(), true);
        }

        {
            SKGAccountObject account(&document1);
            SKGTESTERROR("MT940.setName", account.setName("54842.79"), true);
            SKGTESTERROR("MT940.load", account.load(), true);
            SKGTEST("MT940:getCurrentAmount", SKGServices::doubleToString(account.getCurrentAmount()), "1030.5");
        }
    }

    {
        // 280897
        SKGDocumentBank document1;
        SKGTESTERROR("document1.initialize()", document1.initialize(), true);
        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, "IMPORT_MT940", err);

            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath("IN") % "/skgtestimportmt940/test1.mt940"));
            SKGTESTERROR("MT940.importFile", imp1.importFile(), true);
        }
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, "IMPORT_MT940", err);

            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath("IN") % "/skgtestimportmt940/test1.mt940"));
            SKGTESTERROR("MT940.importFile", imp1.importFile(), true);
        }

        {
            bool oExist = false;
            SKGTESTERROR("document1.existObjects", document1.existObjects("operation", "rc_unit_id=0", oExist), true);
            SKGTESTBOOL("document1.existObjects", oExist, false);
        }
    }
    // End test
    SKGENDTEST();
}
