/********************************************************
*  mgaXaction.c
*
*  Source file for Matrox video parameters tuning utility.
*  Interface-independant functions.  Commands for driver.
*
*  Copyright (C) 2001, Matrox Graphics Inc.
*
*  Author : Stephane Duguay
*  Last modified : April 2001.
*********************************************************/

#include "mgaXaction.h"

extern int CurrentScreen;

BOOL SendMGACmd(char *mgaCMD, char* sResult, XF86VidModeModeLine* pModeLine, Display* pDisp)
{
    FILE* fdIn;
	FILE* fdOut;
    BOOL bRet = FALSE;

    fdIn = fopen("/tmp/mgaDriverIn", "wt");

    if(fdIn)
    {
        /* Set flag to 1 */
        pModeLine->flags |= 0x80000000;

        /* Write command */
        fputs(mgaCMD, fdIn);
        fclose(fdIn);
		
		bRet = XF86VidModeModModeLine(pDisp, CurrentScreen, pModeLine);

		XSync(pDisp, FALSE);

		fdOut = fopen("/tmp/mgaDriverOut", "rt");

		if(fdOut)
		{
			fgets(sResult, 255, fdOut);
			fclose(fdOut);
			remove("/tmp/mgaDriverOut");
			return bRet;
		}
		else
			return FALSE;
    }
    else
		return FALSE;
}

void moveScreenLeft(XF86VidModeModeLine* pModeLine, Display* pDisp)
{
	char sResult[255];
	
	if(pModeLine->hsyncend + 8 < pModeLine->htotal)
	{
		if(!SendMGACmd("left 1", sResult, pModeLine, pDisp))
			XBell(pDisp, 80); /* Command not sended correctly  */
	}
	else
		XBell(pDisp, 80); /* Invalid parameters */
}

void moveScreenRight(XF86VidModeModeLine* pModeLine, Display* pDisp)
{
	char sResult[255];
	
	if(pModeLine->hsyncstart - 8 > pModeLine->hdisplay)
	{
	   if(!SendMGACmd("right 1", sResult, pModeLine, pDisp))
    	   XBell(pDisp, 80); /* Command not sended correctly  */
	}
	else
		XBell(pDisp, 80); /* Invalid parameters */
}

void moveScreenUp(XF86VidModeModeLine* pModeLine, Display* pDisp)
{
	char sResult[255];
	
	if(pModeLine->vsyncend + 8 < pModeLine->vtotal)
	{
		if(!SendMGACmd("up 1", sResult, pModeLine, pDisp))
			XBell(pDisp, 80); /* Command not sended correctly  */
	}
	else
		XBell(pDisp, 80); /* Invalid parameters */
}

void moveScreenDown(XF86VidModeModeLine* pModeLine, Display* pDisp)
{
	char sResult[255];
	
	if(pModeLine->vsyncstart + 8 > pModeLine->vdisplay)
	{
		if(!SendMGACmd("down 1", sResult, pModeLine, pDisp))
			XBell(pDisp, 80); /* Command not sended correctly  */
	}
	else
		XBell(pDisp, 80); /* Invalid parameters */
}

void resizeScreenWider(XF86VidModeModeLine* pModeLine, Display* pDisp)
{
	char sResult[255];
	
	if(pModeLine->htotal - 8 > pModeLine->hsyncend)
	{
		if(!SendMGACmd("h+ 1",sResult, pModeLine, pDisp))
			XBell(pDisp, 80); /* Command not sended correctly  */
	}
	else
		XBell(pDisp, 80); /* Invalid parameters */
}

void resizeScreenNarrower(XF86VidModeModeLine* pModeLine, Display* pDisp)
{
	char sResult[255];
	
   if(!SendMGACmd("h- 1", sResult, pModeLine, pDisp))
       XBell(pDisp, 80); /* Command not sended correctly  */
}

void resizeScreenShorter(XF86VidModeModeLine* pModeLine, Display* pDisp)
{
	char sResult[255];
	
   if(!SendMGACmd("v- 1", sResult, pModeLine, pDisp))
       XBell(pDisp, 80); /* Command not sended correctly  */
}

void resizeScreenTaller(XF86VidModeModeLine* pModeLine, Display* pDisp)
{
	char sResult[255];
	
	if(pModeLine->vtotal - 8 > pModeLine->vsyncend)
	{
		if(!SendMGACmd("v+ 1", sResult, pModeLine, pDisp))
			XBell(pDisp, 80); /* Command not sended correctly  */
	}
	else
		XBell(pDisp, 80); /* Invalid parameters */
}

void applyNewRefresh(XF86VidModeModeLine* pModeLine, Display* pDisp, int refresh)
{
   char sRefresh[255];
   char sResult[255];

   sprintf(sRefresh, "refresh %d", refresh);

   if(!SendMGACmd(sRefresh, sResult, pModeLine, pDisp))
       XBell(pDisp, 80); /* Command not sended correctly  */

}

void UndoLastChange(XF86VidModeModeLine* pModeLine, Display* pDisp)
{
	char sResult[255];
	
	if(!SendMGACmd("undo",sResult, pModeLine, pDisp))
		XBell(pDisp, 80); /* Command not sended correctly  */
}

BOOL isHalLoaded(XF86VidModeModeLine* pModeLine, Display* pDisp)
{
	char sResult[255];
	
	if(!SendMGACmd("hal", sResult, pModeLine, pDisp))
		XBell(pDisp, 80); /* Command not sended correctly  */

	if(!strcmp(sResult, "YES"))
		return TRUE;
	else
		return FALSE;

}

BOOL isDriverModed(XF86VidModeModeLine* pModeLine, Display* pDisp)
{
	char sResult[255];
	
	if(!SendMGACmd("test", sResult, pModeLine, pDisp))
		XBell(pDisp, 80); /* Command not sended correctly  */

	if(!strcmp(sResult, "YES"))
		return TRUE;
	else
		return FALSE;

}


