/********************************************************
*  mgaXconfig.h
*
*  Header file for Matrox video parameters tuning utility.
*  Functions accessing/modifying XF86ConfigRec struct.
*
*  Copyright (C) 2001, Matrox Graphics Inc.
*
*  Author : Luugi Marsan
*  Last modified : April 2001.
*********************************************************/

#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/StringDefs.h>

#include <X11/extensions/xf86vmode.h>

#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <signal.h>

#include <unistd.h>
#include <sys/types.h>
#include <xf86Parser.h>

#include <stdarg.h>

/* Fill struct and write struct to filename. */
XF86ConfigPtr getConfigPtr();
BOOL confWriteConfigFile( char* filename, XF86ConfigPtr conf); 

/* Invert screens */
XF86ConfigPtr confSetLayout ( XF86ConfigPtr conf, int where);

/* Dual-Head */
XF86ConfigPtr confEnableDualHead ( XF86ConfigPtr conf , int where);
XF86ConfigPtr confDisableDualHead ( XF86ConfigPtr conf);
BOOL confDualHeadIsActive(XF86ConfigPtr conf);

/* Clone */
XF86ConfigPtr confEnableClone ( XF86ConfigPtr conf);
XF86ConfigPtr confDisableClone ( XF86ConfigPtr conf);
BOOL confCloneIsActive(XF86ConfigPtr conf);

/* Module Section */
BOOL confIsModuleActive(XF86ConfigPtr conf, char* load_name);
XF86ConfigPtr confUnloadModule (XF86ConfigPtr conf, char* load_name);
XF86ConfigPtr confLoadModule (XF86ConfigPtr conf, char* load_name);

/* Misc */
XF86ConfigPtr confSetDefaultDepth(XF86ConfigPtr conf, int screen, int depth);
XF86ConfigPtr confSetResolutions(XF86ConfigPtr conf, int screenIndex, int nbRes, char** Resolutions, int colorDepth);
int confGetDefaultDepth(XF86ConfigPtr conf, int screen);
int confGetResolutions(XF86ConfigPtr conf, int screenIndex, int colorDepth, char** Resolutions, int maxnbRes);

/* Xinerama */
XF86ConfigPtr confEnableXinerama(XF86ConfigPtr conf);
XF86ConfigPtr confDisableXinerama(XF86ConfigPtr conf);
BOOL confXineramaIsActive(XF86ConfigPtr conf);

/* add a Modeline */
XF86ConfigPtr confAddModeline(XF86ConfigPtr conf, int screenIndex, XF86VidModeModeLine* pModeLine, int dotClock);

/* retrieve user-defined Modelines */
XF86ConfModeLinePtr confGetUserModeLines(XF86ConfigPtr conf, int screenIndex);

/* Hw Cursor */
XF86ConfigPtr confEnableHWCursor (XF86ConfigPtr conf);
XF86ConfigPtr confDisableHWCursor (XF86ConfigPtr conf);
BOOL confHWCursorIsActive(XF86ConfigPtr conf);

/* TV */
XF86ConfigPtr confEnableTVout( XF86ConfigPtr conf, int screenIndex, char* tvstandard , char* cabletype);
XF86ConfigPtr confDisableTVout (XF86ConfigPtr conf, int screenIndex);
BOOL confTVIsActive(XF86ConfigPtr conf, int screenIndex);
char* confGetTVStandard(XF86ConfigPtr conf, int screenIndex);
char* confGetCableType(XF86ConfigPtr conf, int screenIndex);

/* DigitalScreen */
XF86ConfigPtr confEnableDigitalScreen( XF86ConfigPtr conf, int screenIndex);
XF86ConfigPtr confDisableDigitalScreen(XF86ConfigPtr conf, int screenIndex);
BOOL confDigitalScreenIsActive(XF86ConfigPtr conf, int screenIndex);

BOOL confValidateLayout (XF86ConfigPtr p);
XF86ConfigPtr confGetServerLayout(XF86ConfigPtr conf, int* scrn1, int* where, int* scrn2 );
BOOL confRenameScreen(XF86ConfigPtr conf, XF86ConfScreenPtr pScrn, char *name);
BOOL confRenameDevice(XF86ConfigPtr conf, XF86ConfDevicePtr pDevice, char *name);

