#!/bin/bash

font="arial"
fontfile="${font}.ttf"
encoding="windows-1251"

if [ ! -x ./subfont ]
then
	echo "subfont executable must be in the current directory."
	exit
fi

function doit() {
	rm -rf ${font}-${fontsize} 2>/dev/null
	mkdir ${font}-${fontsize} 2>/dev/null
	./subfont --outdir "${font}-${fontsize}" --blur $blur --outline $outline "$encoding" $fontsize "$fontfile" || exit
	./subfont --outdir ${font}-${fontsize} --append encodings/osd-mplayer $symbolssize osd/osd.pfb || exit
}

fontsize="14"
symbolssize="22"
blur="1.5"
outline="1"
doit

fontsize="18"
symbolssize="28"
blur="1.5"
outline="1.5"
doit

fontsize="24"
symbolssize="35"
blur="2"
outline="1.5"
doit

fontsize="28"
symbolssize="40"
blur="2"
outline="2"
doit
