/*
** FAAD2 - Freeware Advanced Audio (AAC) Decoder including SBR decoding
** Copyright (C) 2003 M. Bakker, Ahead Software AG, http://www.nero.com
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
** Any non-GPL usage of this software or parts of this software is strictly
** forbidden.
**
** Commercial non-GPL licensing of this software is possible.
** For more info contact Ahead Software through Mpeg4AAClicense@nero.com.
**
** $Id: iq_table.h,v 1.2 2003/10/03 22:22:27 alex Exp $
**/

#ifndef IQ_TABLE_H__
#define IQ_TABLE_H__

#ifdef __cplusplus
extern "C" {
#endif


#ifndef FIXED_POINT

#ifdef _MSC_VER
#pragma warning(disable:4305)
#pragma warning(disable:4244)
#endif

/* !!!DON'T CHANGE IQ_TABLE_SIZE!!! */
#define IQ_TABLE_SIZE  1026

static real_t iq_table[] =
{
    0.0000000000,
    1.0000000000,
    2.5198420998,
    4.3267487109,
    6.3496042079,
    8.5498797334,
    10.9027235570,
    13.3905182794,
    16.0000000000,
    18.7207544075,
    21.5443469003,
    24.4637809963,
    27.4731418213,
    30.5673509404,
    33.7419916985,
    36.9931811150,
    40.3174735966,
    43.7117870412,
    47.1733450958,
    50.6996313257,
    54.2883523319,
    57.9374077040,
    61.6448652744,
    65.4089405366,
    69.2279793748,
    73.1004434553,
    77.0248977786,
    81.0000000000,
    85.0244912125,
    89.0971879449,
    93.2169751786,
    97.3828002241,
    101.5936673260,
    105.8486328899,
    110.1468012434,
    114.4873208566,
    118.8693809602,
    123.2922085109,
    127.7550654584,
    132.2572462776,
    136.7980757341,
    141.3769068557,
    145.9931190852,
    150.6461165966,
    155.3353267543,
    160.0601987021,
    164.8202020667,
    169.6148257665,
    174.4435769119,
    179.3059797911,
    184.2015749320,
    189.1299182326,
    194.0905801545,
    199.0831449737,
    204.1072100830,
    209.1623853419,
    214.2482924705,
    219.3645644828,
    224.5108451564,
    229.6867885365,
    234.8920584701,
    240.1263281692,
    245.3892798002,
    250.6806040975,
    256.0000000000,
    261.3471743083,
    266.7218413611,
    272.1237227299,
    277.5525469304,
    283.0080491495,
    288.4899709866,
    293.9980602090,
    299.5320705195,
    305.0917613358,
    310.6768975818,
    316.2872494882,
    321.9225924034,
    327.5827066139,
    333.2673771724,
    338.9763937351,
    344.7095504051,
    350.4666455847,
    356.2474818330,
    362.0518657308,
    367.8796077506,
    373.7305221334,
    379.6044267700,
    385.5011430873,
    391.4204959402,
    397.3623135070,
    403.3264271901,
    409.3126715201,
    415.3208840636,
    421.3509053358,
    427.4025787150,
    433.4757503618,
    439.5702691405,
    445.6859865441,
    451.8227566217,
    457.9804359091,
    464.1588833613,
    470.3579602882,
    476.5775302922,
    482.8174592083,
    489.0776150459,
    495.3578679332,
    501.6580900633,
    507.9781556420,
    514.3179408377,
    520.6773237328,
    527.0561842769,
    533.4544042413,
    539.8718671753,
    546.3084583636,
    552.7640647857,
    559.2385750758,
    565.7318794845,
    572.2438698415,
    578.7744395198,
    585.3234834006,
    591.8908978393,
    598.4765806331,
    605.0804309888,
    611.7023494920,
    618.3422380776,
    625.0000000000,
    631.6755398055,
    638.3687633048,
    645.0795775462,
    651.8078907899,
    658.5536124831,
    665.3166532354,
    672.0969247951,
    678.8943400262,
    685.7088128862,
    692.5402584041,
    699.3885926590,
    706.2537327602,
    713.1355968262,
    720.0341039659,
    726.9491742592,
    733.8807287386,
    740.8286893712,
    747.7929790411,
    754.7735215322,
    761.7702415115,
    768.7830645130,
    775.8119169219,
    782.8567259587,
    789.9174196648,
    796.9939268870,
    804.0861772639,
    811.1941012115,
    818.3176299096,
    825.4566952887,
    832.6112300164,
    839.7811674856,
    846.9664418012,
    854.1669877685,
    861.3827408814,
    868.6136373104,
    875.8596138918,
    883.1206081164,
    890.3965581189,
    897.6874026669,
    904.9930811514,
    912.3135335758,
    919.6487005467,
    926.9985232641,
    934.3629435117,
    941.7419036483,
    949.1353465979,
    956.5432158417,
    963.9654554089,
    971.4020098686,
    978.8528243212,
    986.3178443907,
    993.7970162163,
    1001.2902864449,
    1008.7976022234,
    1016.3189111915,
    1023.8541614739,
    1031.4033016737,
    1038.9662808647,
    1046.5430485854,
    1054.1335548314,
    1061.7377500496,
    1069.3555851309,
    1076.9870114047,
    1084.6319806319,
    1092.2904449995,
    1099.9623571140,
    1107.6476699961,
    1115.3463370744,
    1123.0583121801,
    1130.7835495416,
    1138.5220037785,
    1146.2736298969,
    1154.0383832838,
    1161.8162197020,
    1169.6070952851,
    1177.4109665328,
    1185.2277903054,
    1193.0575238198,
    1200.9001246442,
    1208.7555506939,
    1216.6237602266,
    1224.5047118380,
    1232.3983644575,
    1240.3046773436,
    1248.2236100803,
    1256.1551225723,
    1264.0991750417,
    1272.0557280230,
    1280.0247423603,
    1288.0061792024,
    1296.0000000000,
    1304.0061665011,
    1312.0246407478,
    1320.0553850728,
    1328.0983620955,
    1336.1535347188,
    1344.2208661255,
    1352.3003197751,
    1360.3918594003,
    1368.4954490040,
    1376.6110528559,
    1384.7386354892,
    1392.8781616980,
    1401.0295965338,
    1409.1929053025,
    1417.3680535619,
    1425.5550071182,
    1433.7537320236,
    1441.9641945733,
    1450.1863613025,
    1458.4201989843,
    1466.6656746263,
    1474.9227554684,
    1483.1914089801,
    1491.4716028579,
    1499.7633050227,
    1508.0664836175,
    1516.3811070048,
    1524.7071437644,
    1533.0445626906,
    1541.3933327903,
    1549.7534232806,
    1558.1248035861,
    1566.5074433375,
    1574.9013123686,
    1583.3063807145,
    1591.7226186094,
    1600.1499964846,
    1608.5884849662,
    1617.0380548732,
    1625.4986772154,
    1633.9703231917,
    1642.4529641876,
    1650.9465717736,
    1659.4511177036,
    1667.9665739122,
    1676.4929125137,
    1685.0301057998,
    1693.5781262378,
    1702.1369464690,
    1710.7065393070,
    1719.2868777356,
    1727.8779349075,
    1736.4796841426,
    1745.0920989258,
    1753.7151529063,
    1762.3488198950,
    1770.9930738636,
    1779.6478889428,
    1788.3132394207,
    1796.9890997413,
    1805.6754445031,
    1814.3722484576,
    1823.0794865074,
    1831.7971337056,
    1840.5251652535,
    1849.2635564999,
    1858.0122829390,
    1866.7713202096,
    1875.5406440938,
    1884.3202305150,
    1893.1100555371,
    1901.9100953633,
    1910.7203263343,
    1919.5407249276,
    1928.3712677557,
    1937.2119315653,
    1946.0626932359,
    1954.9235297784,
    1963.7944183344,
    1972.6753361744,
    1981.5662606973,
    1990.4671694285,
    1999.3780400196,
    2008.2988502465,
    2017.2295780088,
    2026.1702013285,
    2035.1206983489,
    2044.0810473338,
    2053.0512266659,
    2062.0312148464,
    2071.0209904936,
    2080.0205323417,
    2089.0298192403,
    2098.0488301532,
    2107.0775441570,
    2116.1159404408,
    2125.1639983049,
    2134.2216971598,
    2143.2890165253,
    2152.3659360297,
    2161.4524354089,
    2170.5484945052,
    2179.6540932666,
    2188.7692117462,
    2197.8938301007,
    2207.0279285901,
    2216.1714875766,
    2225.3244875237,
    2234.4869089955,
    2243.6587326558,
    2252.8399392674,
    2262.0305096911,
    2271.2304248850,
    2280.4396659037,
    2289.6582138977,
    2298.8860501122,
    2308.1231558868,
    2317.3695126545,
    2326.6251019409,
    2335.8899053637,
    2345.1639046317,
    2354.4470815443,
    2363.7394179907,
    2373.0408959490,
    2382.3514974860,
    2391.6712047559,
    2401.0000000000,
    2410.3378655461,
    2419.6847838074,
    2429.0407372823,
    2438.4057085534,
    2447.7796802872,
    2457.1626352330,
    2466.5545562227,
    2475.9554261700,
    2485.3652280695,
    2494.7839449968,
    2504.2115601072,
    2513.6480566352,
    2523.0934178943,
    2532.5476272760,
    2542.0106682495,
    2551.4825243609,
    2560.9631792328,
    2570.4526165636,
    2579.9508201270,
    2589.4577737714,
    2598.9734614194,
    2608.4978670675,
    2618.0309747849,
    2627.5727687136,
    2637.1232330677,
    2646.6823521328,
    2656.2501102653,
    2665.8264918923,
    2675.4114815110,
    2685.0050636878,
    2694.6072230582,
    2704.2179443264,
    2713.8372122643,
    2723.4650117115,
    2733.1013275747,
    2742.7461448270,
    2752.3994485079,
    2762.0612237221,
    2771.7314556399,
    2781.4101294962,
    2791.0972305902,
    2800.7927442847,
    2810.4966560063,
    2820.2089512442,
    2829.9296155502,
    2839.6586345385,
    2849.3959938845,
    2859.1416793251,
    2868.8956766580,
    2878.6579717413,
    2888.4285504930,
    2898.2073988909,
    2907.9945029718,
    2917.7898488313,
    2927.5934226236,
    2937.4052105607,
    2947.2251989123,
    2957.0533740053,
    2966.8897222234,
    2976.7342300070,
    2986.5868838523,
    2996.4476703115,
    3006.3165759920,
    3016.1935875562,
    3026.0786917212,
    3035.9718752584,
    3045.8731249931,
    3055.7824278041,
    3065.6997706236,
    3075.6251404365,
    3085.5585242804,
    3095.4999092450,
    3105.4492824719,
    3115.4066311543,
    3125.3719425365,
    3135.3452039137,
    3145.3264026318,
    3155.3155260867,
    3165.3125617243,
    3175.3174970403,
    3185.3303195795,
    3195.3510169356,
    3205.3795767511,
    3215.4159867169,
    3225.4602345719,
    3235.5123081028,
    3245.5721951437,
    3255.6398835758,
    3265.7153613275,
    3275.7986163735,
    3285.8896367348,
    3295.9884104787,
    3306.0949257178,
    3316.2091706107,
    3326.3311333606,
    3336.4608022160,
    3346.5981654700,
    3356.7432114599,
    3366.8959285672,
    3377.0563052172,
    3387.2243298788,
    3397.3999910641,
    3407.5832773283,
    3417.7741772695,
    3427.9726795281,
    3438.1787727870,
    3448.3924457710,
    3458.6136872466,
    3468.8424860221,
    3479.0788309468,
    3489.3227109112,
    3499.5741148464,
    3509.8330317244,
    3520.0994505573,
    3530.3733603973,
    3540.6547503364,
    3550.9436095064,
    3561.2399270783,
    3571.5436922624,
    3581.8548943078,
    3592.1735225026,
    3602.4995661730,
    3612.8330146838,
    3623.1738574377,
    3633.5220838752,
    3643.8776834744,
    3654.2406457510,
    3664.6109602577,
    3674.9886165844,
    3685.3736043574,
    3695.7659132398,
    3706.1655329312,
    3716.5724531671,
    3726.9866637191,
    3737.4081543945,
    3747.8369150361,
    3758.2729355221,
    3768.7162057659,
    3779.1667157159,
    3789.6244553551,
    3800.0894147012,
    3810.5615838063,
    3821.0409527566,
    3831.5275116724,
    3842.0212507077,
    3852.5221600504,
    3863.0302299216,
    3873.5454505757,
    3884.0678123003,
    3894.5973054159,
    3905.1339202756,
    3915.6776472653,
    3926.2284768030,
    3936.7863993390,
    3947.3514053559,
    3957.9234853677,
    3968.5026299205,
    3979.0888295917,
    3989.6820749901,
    4000.2823567557,
    4010.8896655596,
    4021.5039921036,
    4032.1253271203,
    4042.7536613729,
    4053.3889856548,
    4064.0312907898,
    4074.6805676315,
    4085.3368070638,
    4096.0000000000,
    4106.6701373831,
    4117.3472101855,
    4128.0312094089,
    4138.7221260843,
    4149.4199512713,
    4160.1246760588,
    4170.8362915639,
    4181.5547889326,
    4192.2801593392,
    4203.0123939861,
    4213.7514841039,
    4224.4974209512,
    4235.2501958144,
    4246.0098000075,
    4256.7762248721,
    4267.5494617770,
    4278.3295021186,
    4289.1163373202,
    4299.9099588321,
    4310.7103581313,
    4321.5175267219,
    4332.3314561342,
    4343.1521379251,
    4353.9795636778,
    4364.8137250016,
    4375.6546135320,
    4386.5022209304,
    4397.3565388837,
    4408.2175591050,
    4419.0852733324,
    4429.9596733298,
    4440.8407508861,
    4451.7284978156,
    4462.6229059575,
    4473.5239671759,
    4484.4316733599,
    4495.3460164231,
    4506.2669883035,
    4517.1945809640,
    4528.1287863914,
    4539.0695965968,
    4550.0170036156,
    4560.9709995068,
    4571.9315763535,
    4582.8987262626,
    4593.8724413645,
    4604.8527138130,
    4615.8395357856,
    4626.8328994828,
    4637.8327971284,
    4648.8392209693,
    4659.8521632753,
    4670.8716163390,
    4681.8975724760,
    4692.9300240243,
    4703.9689633444,
    4715.0143828193,
    4726.0662748543,
    4737.1246318771,
    4748.1894463371,
    4759.2607107062,
    4770.3384174777,
    4781.4225591672,
    4792.5131283116,
    4803.6101174696,
    4814.7135192213,
    4825.8233261683,
    4836.9395309335,
    4848.0621261609,
    4859.1911045158,
    4870.3264586842,
    4881.4681813733,
    4892.6162653110,
    4903.7707032459,
    4914.9314879474,
    4926.0986122052,
    4937.2720688295,
    4948.4518506510,
    4959.6379505206,
    4970.8303613092,
    4982.0290759079,
    4993.2340872279,
    5004.4453882001,
    5015.6629717753,
    5026.8868309241,
    5038.1169586365,
    5049.3533479223,
    5060.5959918105,
    5071.8448833497,
    5083.1000156077,
    5094.3613816714,
    5105.6289746470,
    5116.9027876595,
    5128.1828138531,
    5139.4690463907,
    5150.7614784539,
    5162.0601032433,
    5173.3649139777,
    5184.6759038949,
    5195.9930662506,
    5207.3163943194,
    5218.6458813939,
    5229.9815207850,
    5241.3233058217,
    5252.6712298510,
    5264.0252862380,
    5275.3854683656,
    5286.7517696346,
    5298.1241834635,
    5309.5027032884,
    5320.8873225631,
    5332.2780347590,
    5343.6748333647,
    5355.0777118863,
    5366.4866638472,
    5377.9016827880,
    5389.3227622665,
    5400.7498958574,
    5412.1830771527,
    5423.6222997611,
    5435.0675573082,
    5446.5188434364,
    5457.9761518049,
    5469.4394760894,
    5480.9088099822,
    5492.3841471923,
    5503.8654814448,
    5515.3528064816,
    5526.8461160606,
    5538.3454039558,
    5549.8506639579,
    5561.3618898731,
    5572.8790755240,
    5584.4022147491,
    5595.9313014028,
    5607.4663293552,
    5619.0072924923,
    5630.5541847159,
    5642.1069999431,
    5653.6657321070,
    5665.2303751559,
    5676.8009230538,
    5688.3773697797,
    5699.9597093284,
    5711.5479357096,
    5723.1420429485,
    5734.7420250850,
    5746.3478761746,
    5757.9595902874,
    5769.5771615087,
    5781.2005839386,
    5792.8298516920,
    5804.4649588987,
    5816.1058997031,
    5827.7526682643,
    5839.4052587560,
    5851.0636653664,
    5862.7278822983,
    5874.3979037688,
    5886.0737240093,
    5897.7553372658,
    5909.4427377983,
    5921.1359198811,
    5932.8348778025,
    5944.5396058651,
    5956.2500983854,
    5967.9663496940,
    5979.6883541351,
    5991.4161060672,
    6003.1495998623,
    6014.8888299063,
    6026.6337905987,
    6038.3844763527,
    6050.1408815952,
    6061.9030007664,
    6073.6708283203,
    6085.4443587241,
    6097.2235864585,
    6109.0085060174,
    6120.7991119082,
    6132.5953986513,
    6144.3973607806,
    6156.2049928426,
    6168.0182893975,
    6179.8372450182,
    6191.6618542904,
    6203.4921118132,
    6215.3280121982,
    6227.1695500700,
    6239.0167200659,
    6250.8695168361,
    6262.7279350432,
    6274.5919693627,
    6286.4616144826,
    6298.3368651034,
    6310.2177159382,
    6322.1041617124,
    6333.9961971640,
    6345.8938170431,
    6357.7970161124,
    6369.7057891466,
    6381.6201309327,
    6393.5400362700,
    6405.4654999698,
    6417.3965168555,
    6429.3330817625,
    6441.2751895383,
    6453.2228350423,
    6465.1760131457,
    6477.1347187317,
    6489.0989466952,
    6501.0686919430,
    6513.0439493936,
    6525.0247139769,
    6537.0109806350,
    6549.0027443210,
    6561.0000000000,
    6573.0027426484,
    6585.0109672541,
    6597.0246688165,
    6609.0438423464,
    6621.0684828657,
    6633.0985854079,
    6645.1341450177,
    6657.1751567510,
    6669.2216156747,
    6681.2735168671,
    6693.3308554176,
    6705.3936264265,
    6717.4618250051,
    6729.5354462759,
    6741.6144853722,
    6753.6989374383,
    6765.7887976291,
    6777.8840611107,
    6789.9847230597,
    6802.0907786636,
    6814.2022231205,
    6826.3190516394,
    6838.4412594396,
    6850.5688417513,
    6862.7017938151,
    6874.8401108821,
    6886.9837882140,
    6899.1328210829,
    6911.2872047712,
    6923.4469345719,
    6935.6120057882,
    6947.7824137335,
    6959.9581537318,
    6972.1392211169,
    6984.3256112330,
    6996.5173194347,
    7008.7143410863,
    7020.9166715624,
    7033.1243062477,
    7045.3372405367,
    7057.5554698343,
    7069.7789895548,
    7082.0077951229,
    7094.2418819728,
    7106.4812455489,
    7118.7258813051,
    7130.9757847053,
    7143.2309512230,
    7155.4913763416,
    7167.7570555538,
    7180.0279843624,
    7192.3041582795,
    7204.5855728270,
    7216.8722235361,
    7229.1641059476,
    7241.4612156120,
    7253.7635480891,
    7266.0710989478,
    7278.3838637670,
    7290.7018381344,
    7303.0250176474,
    7315.3533979125,
    7327.6869745455,
    7340.0257431713,
    7352.3696994244,
    7364.7188389480,
    7377.0731573946,
    7389.4326504259,
    7401.7973137127,
    7414.1671429346,
    7426.5421337804,
    7438.9222819480,
    7451.3075831438,
    7463.6980330837,
    7476.0936274921,
    7488.4943621024,
    7500.9002326569,
    7513.3112349065,
    7525.7273646110,
    7538.1486175390,
    7550.5749894679,
    7563.0064761834,
    7575.4430734804,
    7587.8847771619,
    7600.3315830400,
    7612.7834869349,
    7625.2404846758,
    7637.7025721001,
    7650.1697450538,
    7662.6419993914,
    7675.1193309757,
    7687.6017356782,
    7700.0892093785,
    7712.5817479647,
    7725.0793473331,
    7737.5820033885,
    7750.0897120437,
    7762.6024692201,
    7775.1202708469,
    7787.6431128620,
    7800.1709912110,
    7812.7039018478,
    7825.2418407347,
    7837.7848038416,
    7850.3327871468,
    7862.8857866366,
    7875.4437983052,
    7888.0068181548,
    7900.5748421957,
    7913.1478664460,
    7925.7258869318,
    7938.3088996870,
    7950.8969007534,
    7963.4898861807,
    7976.0878520263,
    7988.6907943555,
    8001.2987092412,
    8013.9115927643,
    8026.5294410131,
    8039.1522500838,
    8051.7800160802,
    8064.4127351138,
    8077.0504033037,
    8089.6930167764,
    8102.3405716663,
    8114.9930641151,
    8127.6504902721,
    8140.3128462940,
    8152.9801283453,
    8165.6523325976,
    8178.3294552300,
    8191.0114924292,
    8203.6984403890,
    8216.3902953107,
    8229.0870534031,
    8241.7887108821,
    8254.4952639709,
    8267.2067089000,
    8279.9230419073,
    8292.6442592376,
    8305.3703571432,
    8318.1013318835,
    8330.8371797251,
    8343.5778969415,
    8356.3234798136,
    8369.0739246292,
    8381.8292276834,
    8394.5893852780,
    8407.3543937222,
    8420.1242493321,
    8432.8989484305,
    8445.6784873475,
    8458.4628624202,
    8471.2520699922,
    8484.0461064144,
    8496.8449680444,
    8509.6486512468,
    8522.4571523928,
    8535.2704678607,
    8548.0885940353,
    8560.9115273086,
    8573.7392640788,
    8586.5718007514,
    8599.4091337382,
    8612.2512594579,
    8625.0981743359,
    8637.9498748040,
    8650.8063573010,
    8663.6676182722,
    8676.5336541692,
    8689.4044614507,
    8702.2800365815,
    8715.1603760331,
    8728.0454762838,
    8740.9353338178,
    8753.8299451264,
    8766.7293067070,
    8779.6334150636,
    8792.5422667064,
    8805.4558581523,
    8818.3741859245,
    8831.2972465524,
    8844.2250365719,
    8857.1575525253,
    8870.0947909611,
    8883.0367484340,
    8895.9834215053,
    8908.9348067421,
    8921.8909007182,
    8934.8517000133,
    8947.8172012135,
    8960.7874009109,
    8973.7622957040,
    8986.7418821972,
    8999.7261570012,
    9012.7151167328,
    9025.7087580148,
    9038.7070774762,
    9051.7100717521,
    9064.7177374833,
    9077.7300713171,
    9090.7470699065,
    9103.7687299106,
    9116.7950479945,
    9129.8260208291,
    9142.8616450914,
    9155.9019174644,
    9168.9468346367,
    9181.9963933031,
    9195.0505901642,
    9208.1094219263,
    9221.1728853017,
    9234.2409770084,
    9247.3136937704,
    9260.3910323173,
    9273.4729893846,
    9286.5595617135,
    9299.6507460510,
    9312.7465391496,
    9325.8469377679,
    9338.9519386698,
    9352.0615386252,
    9365.1757344094,
    9378.2945228036,
    9391.4179005944,
    9404.5458645741,
    9417.6784115407,
    9430.8155382977,
    9443.9572416540,
    9457.1035184244,
    9470.2543654290,
    9483.4097794934,
    9496.5697574489,
    9509.7342961321,
    9522.9033923851,
    9536.0770430556,
    9549.2552449966,
    9562.4379950666,
    9575.6252901295,
    9588.8171270546,
    9602.0135027165,
    9615.2144139955,
    9628.4198577767,
    9641.6298309511,
    9654.8443304146,
    9668.0633530688,
    9681.2868958202,
    9694.5149555808,
    9707.7475292679,
    9720.9846138040,
    9734.2262061168,
    9747.4723031393,
    9760.7229018097,
    9773.9779990712,
    9787.2375918726,
    9800.5016771674,
    9813.7702519147,
    9827.0433130783,
    9840.3208576275,
    9853.6028825365,
    9866.8893847847,
    9880.1803613565,
    9893.4758092415,
    9906.7757254342,
    9920.0801069342,
    9933.3889507462,
    9946.7022538799,
    9960.0200133500,
    9973.3422261761,
    9986.6688893829,
    10000.0000000000,
    10013.3355550619,
    10026.6755516082,
    10040.0199866833,
    10053.3688573365,
    10066.7221606221,
    10080.0798935991,
    10093.4420533317,
    10106.8086368886,
    10120.1796413436,
    10133.5550637751,
    10146.9349012666,
    10160.3191509062,
    10173.7078097869,
    10187.1008750065,
    10200.4983436674,
    10213.9002128770,
    10227.3064797472,
    10240.7171413949,
    10254.1321949415,
    10267.5516375131,
    10280.9754662408,
    10294.4036782600,
    10307.8362707111,
    10321.2732407388,
    10334.7145854928
};

#else

/* !!!DON'T CHANGE IQ_TABLE_SIZE!!! */
#define IQ_TABLE_SIZE  8192

static real_t iq_table[] =
{
    REAL_CONST(0.000000/8.0),
    REAL_CONST(1.000000/8.0),
    REAL_CONST(2.519842/8.0),
    REAL_CONST(4.326749/8.0),
    REAL_CONST(6.349604/8.0),
    REAL_CONST(8.549880/8.0),
    REAL_CONST(10.902724/8.0),
    REAL_CONST(13.390518/8.0),
    REAL_CONST(16.000000/8.0),
    REAL_CONST(18.720754/8.0),
    REAL_CONST(21.544347/8.0),
    REAL_CONST(24.463781/8.0),
    REAL_CONST(27.473142/8.0),
    REAL_CONST(30.567351/8.0),
    REAL_CONST(33.741992/8.0),
    REAL_CONST(36.993181/8.0),
    REAL_CONST(40.317474/8.0),
    REAL_CONST(43.711787/8.0),
    REAL_CONST(47.173345/8.0),
    REAL_CONST(50.699631/8.0),
    REAL_CONST(54.288352/8.0),
    REAL_CONST(57.937408/8.0),
    REAL_CONST(61.644865/8.0),
    REAL_CONST(65.408941/8.0),
    REAL_CONST(69.227979/8.0),
    REAL_CONST(73.100443/8.0),
    REAL_CONST(77.024898/8.0),
    REAL_CONST(81.000000/8.0),
    REAL_CONST(85.024491/8.0),
    REAL_CONST(89.097188/8.0),
    REAL_CONST(93.216975/8.0),
    REAL_CONST(97.382800/8.0),
    REAL_CONST(101.593667/8.0),
    REAL_CONST(105.848633/8.0),
    REAL_CONST(110.146801/8.0),
    REAL_CONST(114.487321/8.0),
    REAL_CONST(118.869381/8.0),
    REAL_CONST(123.292209/8.0),
    REAL_CONST(127.755065/8.0),
    REAL_CONST(132.257246/8.0),
    REAL_CONST(136.798076/8.0),
    REAL_CONST(141.376907/8.0),
    REAL_CONST(145.993119/8.0),
    REAL_CONST(150.646117/8.0),
    REAL_CONST(155.335327/8.0),
    REAL_CONST(160.060199/8.0),
    REAL_CONST(164.820202/8.0),
    REAL_CONST(169.614826/8.0),
    REAL_CONST(174.443577/8.0),
    REAL_CONST(179.305980/8.0),
    REAL_CONST(184.201575/8.0),
    REAL_CONST(189.129918/8.0),
    REAL_CONST(194.090580/8.0),
    REAL_CONST(199.083145/8.0),
    REAL_CONST(204.107210/8.0),
    REAL_CONST(209.162385/8.0),
    REAL_CONST(214.248292/8.0),
    REAL_CONST(219.364564/8.0),
    REAL_CONST(224.510845/8.0),
    REAL_CONST(229.686789/8.0),
    REAL_CONST(234.892058/8.0),
    REAL_CONST(240.126328/8.0),
    REAL_CONST(245.389280/8.0),
    REAL_CONST(250.680604/8.0),
    REAL_CONST(256.000000/8.0),
    REAL_CONST(261.347174/8.0),
    REAL_CONST(266.721841/8.0),
    REAL_CONST(272.123723/8.0),
    REAL_CONST(277.552547/8.0),
    REAL_CONST(283.008049/8.0),
    REAL_CONST(288.489971/8.0),
    REAL_CONST(293.998060/8.0),
    REAL_CONST(299.532071/8.0),
    REAL_CONST(305.091761/8.0),
    REAL_CONST(310.676898/8.0),
    REAL_CONST(316.287249/8.0),
    REAL_CONST(321.922592/8.0),
    REAL_CONST(327.582707/8.0),
    REAL_CONST(333.267377/8.0),
    REAL_CONST(338.976394/8.0),
    REAL_CONST(344.709550/8.0),
    REAL_CONST(350.466646/8.0),
    REAL_CONST(356.247482/8.0),
    REAL_CONST(362.051866/8.0),
    REAL_CONST(367.879608/8.0),
    REAL_CONST(373.730522/8.0),
    REAL_CONST(379.604427/8.0),
    REAL_CONST(385.501143/8.0),
    REAL_CONST(391.420496/8.0),
    REAL_CONST(397.362314/8.0),
    REAL_CONST(403.326427/8.0),
    REAL_CONST(409.312672/8.0),
    REAL_CONST(415.320884/8.0),
    REAL_CONST(421.350905/8.0),
    REAL_CONST(427.402579/8.0),
    REAL_CONST(433.475750/8.0),
    REAL_CONST(439.570269/8.0),
    REAL_CONST(445.685987/8.0),
    REAL_CONST(451.822757/8.0),
    REAL_CONST(457.980436/8.0),
    REAL_CONST(464.158883/8.0),
    REAL_CONST(470.357960/8.0),
    REAL_CONST(476.577530/8.0),
    REAL_CONST(482.817459/8.0),
    REAL_CONST(489.077615/8.0),
    REAL_CONST(495.357868/8.0),
    REAL_CONST(501.658090/8.0),
    REAL_CONST(507.978156/8.0),
    REAL_CONST(514.317941/8.0),
    REAL_CONST(520.677324/8.0),
    REAL_CONST(527.056184/8.0),
    REAL_CONST(533.454404/8.0),
    REAL_CONST(539.871867/8.0),
    REAL_CONST(546.308458/8.0),
    REAL_CONST(552.764065/8.0),
    REAL_CONST(559.238575/8.0),
    REAL_CONST(565.731879/8.0),
    REAL_CONST(572.243870/8.0),
    REAL_CONST(578.774440/8.0),
    REAL_CONST(585.323483/8.0),
    REAL_CONST(591.890898/8.0),
    REAL_CONST(598.476581/8.0),
    REAL_CONST(605.080431/8.0),
    REAL_CONST(611.702349/8.0),
    REAL_CONST(618.342238/8.0),
    REAL_CONST(625.000000/8.0),
    REAL_CONST(631.675540/8.0),
    REAL_CONST(638.368763/8.0),
    REAL_CONST(645.079578/8.0),
    REAL_CONST(651.807891/8.0),
    REAL_CONST(658.553612/8.0),
    REAL_CONST(665.316653/8.0),
    REAL_CONST(672.096925/8.0),
    REAL_CONST(678.894340/8.0),
    REAL_CONST(685.708813/8.0),
    REAL_CONST(692.540258/8.0),
    REAL_CONST(699.388593/8.0),
    REAL_CONST(706.253733/8.0),
    REAL_CONST(713.135597/8.0),
    REAL_CONST(720.034104/8.0),
    REAL_CONST(726.949174/8.0),
    REAL_CONST(733.880729/8.0),
    REAL_CONST(740.828689/8.0),
    REAL_CONST(747.792979/8.0),
    REAL_CONST(754.773522/8.0),
    REAL_CONST(761.770242/8.0),
    REAL_CONST(768.783065/8.0),
    REAL_CONST(775.811917/8.0),
    REAL_CONST(782.856726/8.0),
    REAL_CONST(789.917420/8.0),
    REAL_CONST(796.993927/8.0),
    REAL_CONST(804.086177/8.0),
    REAL_CONST(811.194101/8.0),
    REAL_CONST(818.317630/8.0),
    REAL_CONST(825.456695/8.0),
    REAL_CONST(832.611230/8.0),
    REAL_CONST(839.781167/8.0),
    REAL_CONST(846.966442/8.0),
    REAL_CONST(854.166988/8.0),
    REAL_CONST(861.382741/8.0),
    REAL_CONST(868.613637/8.0),
    REAL_CONST(875.859614/8.0),
    REAL_CONST(883.120608/8.0),
    REAL_CONST(890.396558/8.0),
    REAL_CONST(897.687403/8.0),
    REAL_CONST(904.993081/8.0),
    REAL_CONST(912.313534/8.0),
    REAL_CONST(919.648701/8.0),
    REAL_CONST(926.998523/8.0),
    REAL_CONST(934.362944/8.0),
    REAL_CONST(941.741904/8.0),
    REAL_CONST(949.135347/8.0),
    REAL_CONST(956.543216/8.0),
    REAL_CONST(963.965455/8.0),
    REAL_CONST(971.402010/8.0),
    REAL_CONST(978.852824/8.0),
    REAL_CONST(986.317844/8.0),
    REAL_CONST(993.797016/8.0),
    REAL_CONST(1001.290286/8.0),
    REAL_CONST(1008.797602/8.0),
    REAL_CONST(1016.318911/8.0),
    REAL_CONST(1023.854161/8.0),
    REAL_CONST(1031.403302/8.0),
    REAL_CONST(1038.966281/8.0),
    REAL_CONST(1046.543049/8.0),
    REAL_CONST(1054.133555/8.0),
    REAL_CONST(1061.737750/8.0),
    REAL_CONST(1069.355585/8.0),
    REAL_CONST(1076.987011/8.0),
    REAL_CONST(1084.631981/8.0),
    REAL_CONST(1092.290445/8.0),
    REAL_CONST(1099.962357/8.0),
    REAL_CONST(1107.647670/8.0),
    REAL_CONST(1115.346337/8.0),
    REAL_CONST(1123.058312/8.0),
    REAL_CONST(1130.783550/8.0),
    REAL_CONST(1138.522004/8.0),
    REAL_CONST(1146.273630/8.0),
    REAL_CONST(1154.038383/8.0),
    REAL_CONST(1161.816220/8.0),
    REAL_CONST(1169.607095/8.0),
    REAL_CONST(1177.410967/8.0),
    REAL_CONST(1185.227790/8.0),
    REAL_CONST(1193.057524/8.0),
    REAL_CONST(1200.900125/8.0),
    REAL_CONST(1208.755551/8.0),
    REAL_CONST(1216.623760/8.0),
    REAL_CONST(1224.504712/8.0),
    REAL_CONST(1232.398364/8.0),
    REAL_CONST(1240.304677/8.0),
    REAL_CONST(1248.223610/8.0),
    REAL_CONST(1256.155123/8.0),
    REAL_CONST(1264.099175/8.0),
    REAL_CONST(1272.055728/8.0),
    REAL_CONST(1280.024742/8.0),
    REAL_CONST(1288.006179/8.0),
    REAL_CONST(1296.000000/8.0),
    REAL_CONST(1304.006167/8.0),
    REAL_CONST(1312.024641/8.0),
    REAL_CONST(1320.055385/8.0),
    REAL_CONST(1328.098362/8.0),
    REAL_CONST(1336.153535/8.0),
    REAL_CONST(1344.220866/8.0),
    REAL_CONST(1352.300320/8.0),
    REAL_CONST(1360.391859/8.0),
    REAL_CONST(1368.495449/8.0),
    REAL_CONST(1376.611053/8.0),
    REAL_CONST(1384.738635/8.0),
    REAL_CONST(1392.878162/8.0),
    REAL_CONST(1401.029597/8.0),
    REAL_CONST(1409.192905/8.0),
    REAL_CONST(1417.368054/8.0),
    REAL_CONST(1425.555007/8.0),
    REAL_CONST(1433.753732/8.0),
    REAL_CONST(1441.964195/8.0),
    REAL_CONST(1450.186361/8.0),
    REAL_CONST(1458.420199/8.0),
    REAL_CONST(1466.665675/8.0),
    REAL_CONST(1474.922755/8.0),
    REAL_CONST(1483.191409/8.0),
    REAL_CONST(1491.471603/8.0),
    REAL_CONST(1499.763305/8.0),
    REAL_CONST(1508.066484/8.0),
    REAL_CONST(1516.381107/8.0),
    REAL_CONST(1524.707144/8.0),
    REAL_CONST(1533.044563/8.0),
    REAL_CONST(1541.393333/8.0),
    REAL_CONST(1549.753423/8.0),
    REAL_CONST(1558.124804/8.0),
    REAL_CONST(1566.507443/8.0),
    REAL_CONST(1574.901312/8.0),
    REAL_CONST(1583.306381/8.0),
    REAL_CONST(1591.722619/8.0),
    REAL_CONST(1600.149996/8.0),
    REAL_CONST(1608.588485/8.0),
    REAL_CONST(1617.038055/8.0),
    REAL_CONST(1625.498677/8.0),
    REAL_CONST(1633.970323/8.0),
    REAL_CONST(1642.452964/8.0),
    REAL_CONST(1650.946572/8.0),
    REAL_CONST(1659.451118/8.0),
    REAL_CONST(1667.966574/8.0),
    REAL_CONST(1676.492913/8.0),
    REAL_CONST(1685.030106/8.0),
    REAL_CONST(1693.578126/8.0),
    REAL_CONST(1702.136946/8.0),
    REAL_CONST(1710.706539/8.0),
    REAL_CONST(1719.286878/8.0),
    REAL_CONST(1727.877935/8.0),
    REAL_CONST(1736.479684/8.0),
    REAL_CONST(1745.092099/8.0),
    REAL_CONST(1753.715153/8.0),
    REAL_CONST(1762.348820/8.0),
    REAL_CONST(1770.993074/8.0),
    REAL_CONST(1779.647889/8.0),
    REAL_CONST(1788.313239/8.0),
    REAL_CONST(1796.989100/8.0),
    REAL_CONST(1805.675445/8.0),
    REAL_CONST(1814.372248/8.0),
    REAL_CONST(1823.079487/8.0),
    REAL_CONST(1831.797134/8.0),
    REAL_CONST(1840.525165/8.0),
    REAL_CONST(1849.263556/8.0),
    REAL_CONST(1858.012283/8.0),
    REAL_CONST(1866.771320/8.0),
    REAL_CONST(1875.540644/8.0),
    REAL_CONST(1884.320231/8.0),
    REAL_CONST(1893.110056/8.0),
    REAL_CONST(1901.910095/8.0),
    REAL_CONST(1910.720326/8.0),
    REAL_CONST(1919.540725/8.0),
    REAL_CONST(1928.371268/8.0),
    REAL_CONST(1937.211932/8.0),
    REAL_CONST(1946.062693/8.0),
    REAL_CONST(1954.923530/8.0),
    REAL_CONST(1963.794418/8.0),
    REAL_CONST(1972.675336/8.0),
    REAL_CONST(1981.566261/8.0),
    REAL_CONST(1990.467169/8.0),
    REAL_CONST(1999.378040/8.0),
    REAL_CONST(2008.298850/8.0),
    REAL_CONST(2017.229578/8.0),
    REAL_CONST(2026.170201/8.0),
    REAL_CONST(2035.120698/8.0),
    REAL_CONST(2044.081047/8.0),
    REAL_CONST(2053.051227/8.0),
    REAL_CONST(2062.031215/8.0),
    REAL_CONST(2071.020990/8.0),
    REAL_CONST(2080.020532/8.0),
    REAL_CONST(2089.029819/8.0),
    REAL_CONST(2098.048830/8.0),
    REAL_CONST(2107.077544/8.0),
    REAL_CONST(2116.115940/8.0),
    REAL_CONST(2125.163998/8.0),
    REAL_CONST(2134.221697/8.0),
    REAL_CONST(2143.289017/8.0),
    REAL_CONST(2152.365936/8.0),
    REAL_CONST(2161.452435/8.0),
    REAL_CONST(2170.548495/8.0),
    REAL_CONST(2179.654093/8.0),
    REAL_CONST(2188.769212/8.0),
    REAL_CONST(2197.893830/8.0),
    REAL_CONST(2207.027929/8.0),
    REAL_CONST(2216.171488/8.0),
    REAL_CONST(2225.324488/8.0),
    REAL_CONST(2234.486909/8.0),
    REAL_CONST(2243.658733/8.0),
    REAL_CONST(2252.839939/8.0),
    REAL_CONST(2262.030510/8.0),
    REAL_CONST(2271.230425/8.0),
    REAL_CONST(2280.439666/8.0),
    REAL_CONST(2289.658214/8.0),
    REAL_CONST(2298.886050/8.0),
    REAL_CONST(2308.123156/8.0),
    REAL_CONST(2317.369513/8.0),
    REAL_CONST(2326.625102/8.0),
    REAL_CONST(2335.889905/8.0),
    REAL_CONST(2345.163905/8.0),
    REAL_CONST(2354.447082/8.0),
    REAL_CONST(2363.739418/8.0),
    REAL_CONST(2373.040896/8.0),
    REAL_CONST(2382.351497/8.0),
    REAL_CONST(2391.671205/8.0),
    REAL_CONST(2401.000000/8.0),
    REAL_CONST(2410.337866/8.0),
    REAL_CONST(2419.684784/8.0),
    REAL_CONST(2429.040737/8.0),
    REAL_CONST(2438.405709/8.0),
    REAL_CONST(2447.779680/8.0),
    REAL_CONST(2457.162635/8.0),
    REAL_CONST(2466.554556/8.0),
    REAL_CONST(2475.955426/8.0),
    REAL_CONST(2485.365228/8.0),
    REAL_CONST(2494.783945/8.0),
    REAL_CONST(2504.211560/8.0),
    REAL_CONST(2513.648057/8.0),
    REAL_CONST(2523.093418/8.0),
    REAL_CONST(2532.547627/8.0),
    REAL_CONST(2542.010668/8.0),
    REAL_CONST(2551.482524/8.0),
    REAL_CONST(2560.963179/8.0),
    REAL_CONST(2570.452617/8.0),
    REAL_CONST(2579.950820/8.0),
    REAL_CONST(2589.457774/8.0),
    REAL_CONST(2598.973461/8.0),
    REAL_CONST(2608.497867/8.0),
    REAL_CONST(2618.030975/8.0),
    REAL_CONST(2627.572769/8.0),
    REAL_CONST(2637.123233/8.0),
    REAL_CONST(2646.682352/8.0),
    REAL_CONST(2656.250110/8.0),
    REAL_CONST(2665.826492/8.0),
    REAL_CONST(2675.411482/8.0),
    REAL_CONST(2685.005064/8.0),
    REAL_CONST(2694.607223/8.0),
    REAL_CONST(2704.217944/8.0),
    REAL_CONST(2713.837212/8.0),
    REAL_CONST(2723.465012/8.0),
    REAL_CONST(2733.101328/8.0),
    REAL_CONST(2742.746145/8.0),
    REAL_CONST(2752.399449/8.0),
    REAL_CONST(2762.061224/8.0),
    REAL_CONST(2771.731456/8.0),
    REAL_CONST(2781.410129/8.0),
    REAL_CONST(2791.097231/8.0),
    REAL_CONST(2800.792744/8.0),
    REAL_CONST(2810.496656/8.0),
    REAL_CONST(2820.208951/8.0),
    REAL_CONST(2829.929616/8.0),
    REAL_CONST(2839.658635/8.0),
    REAL_CONST(2849.395994/8.0),
    REAL_CONST(2859.141679/8.0),
    REAL_CONST(2868.895677/8.0),
    REAL_CONST(2878.657972/8.0),
    REAL_CONST(2888.428550/8.0),
    REAL_CONST(2898.207399/8.0),
    REAL_CONST(2907.994503/8.0),
    REAL_CONST(2917.789849/8.0),
    REAL_CONST(2927.593423/8.0),
    REAL_CONST(2937.405211/8.0),
    REAL_CONST(2947.225199/8.0),
    REAL_CONST(2957.053374/8.0),
    REAL_CONST(2966.889722/8.0),
    REAL_CONST(2976.734230/8.0),
    REAL_CONST(2986.586884/8.0),
    REAL_CONST(2996.447670/8.0),
    REAL_CONST(3006.316576/8.0),
    REAL_CONST(3016.193588/8.0),
    REAL_CONST(3026.078692/8.0),
    REAL_CONST(3035.971875/8.0),
    REAL_CONST(3045.873125/8.0),
    REAL_CONST(3055.782428/8.0),
    REAL_CONST(3065.699771/8.0),
    REAL_CONST(3075.625140/8.0),
    REAL_CONST(3085.558524/8.0),
    REAL_CONST(3095.499909/8.0),
    REAL_CONST(3105.449282/8.0),
    REAL_CONST(3115.406631/8.0),
    REAL_CONST(3125.371943/8.0),
    REAL_CONST(3135.345204/8.0),
    REAL_CONST(3145.326403/8.0),
    REAL_CONST(3155.315526/8.0),
    REAL_CONST(3165.312562/8.0),
    REAL_CONST(3175.317497/8.0),
    REAL_CONST(3185.330320/8.0),
    REAL_CONST(3195.351017/8.0),
    REAL_CONST(3205.379577/8.0),
    REAL_CONST(3215.415987/8.0),
    REAL_CONST(3225.460235/8.0),
    REAL_CONST(3235.512308/8.0),
    REAL_CONST(3245.572195/8.0),
    REAL_CONST(3255.639884/8.0),
    REAL_CONST(3265.715361/8.0),
    REAL_CONST(3275.798616/8.0),
    REAL_CONST(3285.889637/8.0),
    REAL_CONST(3295.988410/8.0),
    REAL_CONST(3306.094926/8.0),
    REAL_CONST(3316.209171/8.0),
    REAL_CONST(3326.331133/8.0),
    REAL_CONST(3336.460802/8.0),
    REAL_CONST(3346.598165/8.0),
    REAL_CONST(3356.743211/8.0),
    REAL_CONST(3366.895929/8.0),
    REAL_CONST(3377.056305/8.0),
    REAL_CONST(3387.224330/8.0),
    REAL_CONST(3397.399991/8.0),
    REAL_CONST(3407.583277/8.0),
    REAL_CONST(3417.774177/8.0),
    REAL_CONST(3427.972680/8.0),
    REAL_CONST(3438.178773/8.0),
    REAL_CONST(3448.392446/8.0),
    REAL_CONST(3458.613687/8.0),
    REAL_CONST(3468.842486/8.0),
    REAL_CONST(3479.078831/8.0),
    REAL_CONST(3489.322711/8.0),
    REAL_CONST(3499.574115/8.0),
    REAL_CONST(3509.833032/8.0),
    REAL_CONST(3520.099451/8.0),
    REAL_CONST(3530.373360/8.0),
    REAL_CONST(3540.654750/8.0),
    REAL_CONST(3550.943610/8.0),
    REAL_CONST(3561.239927/8.0),
    REAL_CONST(3571.543692/8.0),
    REAL_CONST(3581.854894/8.0),
    REAL_CONST(3592.173523/8.0),
    REAL_CONST(3602.499566/8.0),
    REAL_CONST(3612.833015/8.0),
    REAL_CONST(3623.173857/8.0),
    REAL_CONST(3633.522084/8.0),
    REAL_CONST(3643.877683/8.0),
    REAL_CONST(3654.240646/8.0),
    REAL_CONST(3664.610960/8.0),
    REAL_CONST(3674.988617/8.0),
    REAL_CONST(3685.373604/8.0),
    REAL_CONST(3695.765913/8.0),
    REAL_CONST(3706.165533/8.0),
    REAL_CONST(3716.572453/8.0),
    REAL_CONST(3726.986664/8.0),
    REAL_CONST(3737.408154/8.0),
    REAL_CONST(3747.836915/8.0),
    REAL_CONST(3758.272936/8.0),
    REAL_CONST(3768.716206/8.0),
    REAL_CONST(3779.166716/8.0),
    REAL_CONST(3789.624455/8.0),
    REAL_CONST(3800.089415/8.0),
    REAL_CONST(3810.561584/8.0),
    REAL_CONST(3821.040953/8.0),
    REAL_CONST(3831.527512/8.0),
    REAL_CONST(3842.021251/8.0),
    REAL_CONST(3852.522160/8.0),
    REAL_CONST(3863.030230/8.0),
    REAL_CONST(3873.545451/8.0),
    REAL_CONST(3884.067812/8.0),
    REAL_CONST(3894.597305/8.0),
    REAL_CONST(3905.133920/8.0),
    REAL_CONST(3915.677647/8.0),
    REAL_CONST(3926.228477/8.0),
    REAL_CONST(3936.786399/8.0),
    REAL_CONST(3947.351405/8.0),
    REAL_CONST(3957.923485/8.0),
    REAL_CONST(3968.502630/8.0),
    REAL_CONST(3979.088830/8.0),
    REAL_CONST(3989.682075/8.0),
    REAL_CONST(4000.282357/8.0),
    REAL_CONST(4010.889666/8.0),
    REAL_CONST(4021.503992/8.0),
    REAL_CONST(4032.125327/8.0),
    REAL_CONST(4042.753661/8.0),
    REAL_CONST(4053.388986/8.0),
    REAL_CONST(4064.031291/8.0),
    REAL_CONST(4074.680568/8.0),
    REAL_CONST(4085.336807/8.0),
    REAL_CONST(4096.000000/8.0),
    REAL_CONST(4106.670137/8.0),
    REAL_CONST(4117.347210/8.0),
    REAL_CONST(4128.031209/8.0),
    REAL_CONST(4138.722126/8.0),
    REAL_CONST(4149.419951/8.0),
    REAL_CONST(4160.124676/8.0),
    REAL_CONST(4170.836292/8.0),
    REAL_CONST(4181.554789/8.0),
    REAL_CONST(4192.280159/8.0),
    REAL_CONST(4203.012394/8.0),
    REAL_CONST(4213.751484/8.0),
    REAL_CONST(4224.497421/8.0),
    REAL_CONST(4235.250196/8.0),
    REAL_CONST(4246.009800/8.0),
    REAL_CONST(4256.776225/8.0),
    REAL_CONST(4267.549462/8.0),
    REAL_CONST(4278.329502/8.0),
    REAL_CONST(4289.116337/8.0),
    REAL_CONST(4299.909959/8.0),
    REAL_CONST(4310.710358/8.0),
    REAL_CONST(4321.517527/8.0),
    REAL_CONST(4332.331456/8.0),
    REAL_CONST(4343.152138/8.0),
    REAL_CONST(4353.979564/8.0),
    REAL_CONST(4364.813725/8.0),
    REAL_CONST(4375.654614/8.0),
    REAL_CONST(4386.502221/8.0),
    REAL_CONST(4397.356539/8.0),
    REAL_CONST(4408.217559/8.0),
    REAL_CONST(4419.085273/8.0),
    REAL_CONST(4429.959673/8.0),
    REAL_CONST(4440.840751/8.0),
    REAL_CONST(4451.728498/8.0),
    REAL_CONST(4462.622906/8.0),
    REAL_CONST(4473.523967/8.0),
    REAL_CONST(4484.431673/8.0),
    REAL_CONST(4495.346016/8.0),
    REAL_CONST(4506.266988/8.0),
    REAL_CONST(4517.194581/8.0),
    REAL_CONST(4528.128786/8.0),
    REAL_CONST(4539.069597/8.0),
    REAL_CONST(4550.017004/8.0),
    REAL_CONST(4560.971000/8.0),
    REAL_CONST(4571.931576/8.0),
    REAL_CONST(4582.898726/8.0),
    REAL_CONST(4593.872441/8.0),
    REAL_CONST(4604.852714/8.0),
    REAL_CONST(4615.839536/8.0),
    REAL_CONST(4626.832899/8.0),
    REAL_CONST(4637.832797/8.0),
    REAL_CONST(4648.839221/8.0),
    REAL_CONST(4659.852163/8.0),
    REAL_CONST(4670.871616/8.0),
    REAL_CONST(4681.897572/8.0),
    REAL_CONST(4692.930024/8.0),
    REAL_CONST(4703.968963/8.0),
    REAL_CONST(4715.014383/8.0),
    REAL_CONST(4726.066275/8.0),
    REAL_CONST(4737.124632/8.0),
    REAL_CONST(4748.189446/8.0),
    REAL_CONST(4759.260711/8.0),
    REAL_CONST(4770.338417/8.0),
    REAL_CONST(4781.422559/8.0),
    REAL_CONST(4792.513128/8.0),
    REAL_CONST(4803.610117/8.0),
    REAL_CONST(4814.713519/8.0),
    REAL_CONST(4825.823326/8.0),
    REAL_CONST(4836.939531/8.0),
    REAL_CONST(4848.062126/8.0),
    REAL_CONST(4859.191105/8.0),
    REAL_CONST(4870.326459/8.0),
    REAL_CONST(4881.468181/8.0),
    REAL_CONST(4892.616265/8.0),
    REAL_CONST(4903.770703/8.0),
    REAL_CONST(4914.931488/8.0),
    REAL_CONST(4926.098612/8.0),
    REAL_CONST(4937.272069/8.0),
    REAL_CONST(4948.451851/8.0),
    REAL_CONST(4959.637951/8.0),
    REAL_CONST(4970.830361/8.0),
    REAL_CONST(4982.029076/8.0),
    REAL_CONST(4993.234087/8.0),
    REAL_CONST(5004.445388/8.0),
    REAL_CONST(5015.662972/8.0),
    REAL_CONST(5026.886831/8.0),
    REAL_CONST(5038.116959/8.0),
    REAL_CONST(5049.353348/8.0),
    REAL_CONST(5060.595992/8.0),
    REAL_CONST(5071.844883/8.0),
    REAL_CONST(5083.100016/8.0),
    REAL_CONST(5094.361382/8.0),
    REAL_CONST(5105.628975/8.0),
    REAL_CONST(5116.902788/8.0),
    REAL_CONST(5128.182814/8.0),
    REAL_CONST(5139.469046/8.0),
    REAL_CONST(5150.761478/8.0),
    REAL_CONST(5162.060103/8.0),
    REAL_CONST(5173.364914/8.0),
    REAL_CONST(5184.675904/8.0),
    REAL_CONST(5195.993066/8.0),
    REAL_CONST(5207.316394/8.0),
    REAL_CONST(5218.645881/8.0),
    REAL_CONST(5229.981521/8.0),
    REAL_CONST(5241.323306/8.0),
    REAL_CONST(5252.671230/8.0),
    REAL_CONST(5264.025286/8.0),
    REAL_CONST(5275.385468/8.0),
    REAL_CONST(5286.751770/8.0),
    REAL_CONST(5298.124183/8.0),
    REAL_CONST(5309.502703/8.0),
    REAL_CONST(5320.887323/8.0),
    REAL_CONST(5332.278035/8.0),
    REAL_CONST(5343.674833/8.0),
    REAL_CONST(5355.077712/8.0),
    REAL_CONST(5366.486664/8.0),
    REAL_CONST(5377.901683/8.0),
    REAL_CONST(5389.322762/8.0),
    REAL_CONST(5400.749896/8.0),
    REAL_CONST(5412.183077/8.0),
    REAL_CONST(5423.622300/8.0),
    REAL_CONST(5435.067557/8.0),
    REAL_CONST(5446.518843/8.0),
    REAL_CONST(5457.976152/8.0),
    REAL_CONST(5469.439476/8.0),
    REAL_CONST(5480.908810/8.0),
    REAL_CONST(5492.384147/8.0),
    REAL_CONST(5503.865481/8.0),
    REAL_CONST(5515.352806/8.0),
    REAL_CONST(5526.846116/8.0),
    REAL_CONST(5538.345404/8.0),
    REAL_CONST(5549.850664/8.0),
    REAL_CONST(5561.361890/8.0),
    REAL_CONST(5572.879076/8.0),
    REAL_CONST(5584.402215/8.0),
    REAL_CONST(5595.931301/8.0),
    REAL_CONST(5607.466329/8.0),
    REAL_CONST(5619.007292/8.0),
    REAL_CONST(5630.554185/8.0),
    REAL_CONST(5642.107000/8.0),
    REAL_CONST(5653.665732/8.0),
    REAL_CONST(5665.230375/8.0),
    REAL_CONST(5676.800923/8.0),
    REAL_CONST(5688.377370/8.0),
    REAL_CONST(5699.959709/8.0),
    REAL_CONST(5711.547936/8.0),
    REAL_CONST(5723.142043/8.0),
    REAL_CONST(5734.742025/8.0),
    REAL_CONST(5746.347876/8.0),
    REAL_CONST(5757.959590/8.0),
    REAL_CONST(5769.577162/8.0),
    REAL_CONST(5781.200584/8.0),
    REAL_CONST(5792.829852/8.0),
    REAL_CONST(5804.464959/8.0),
    REAL_CONST(5816.105900/8.0),
    REAL_CONST(5827.752668/8.0),
    REAL_CONST(5839.405259/8.0),
    REAL_CONST(5851.063665/8.0),
    REAL_CONST(5862.727882/8.0),
    REAL_CONST(5874.397904/8.0),
    REAL_CONST(5886.073724/8.0),
    REAL_CONST(5897.755337/8.0),
    REAL_CONST(5909.442738/8.0),
    REAL_CONST(5921.135920/8.0),
    REAL_CONST(5932.834878/8.0),
    REAL_CONST(5944.539606/8.0),
    REAL_CONST(5956.250098/8.0),
    REAL_CONST(5967.966350/8.0),
    REAL_CONST(5979.688354/8.0),
    REAL_CONST(5991.416106/8.0),
    REAL_CONST(6003.149600/8.0),
    REAL_CONST(6014.888830/8.0),
    REAL_CONST(6026.633791/8.0),
    REAL_CONST(6038.384476/8.0),
    REAL_CONST(6050.140882/8.0),
    REAL_CONST(6061.903001/8.0),
    REAL_CONST(6073.670828/8.0),
    REAL_CONST(6085.444359/8.0),
    REAL_CONST(6097.223586/8.0),
    REAL_CONST(6109.008506/8.0),
    REAL_CONST(6120.799112/8.0),
    REAL_CONST(6132.595399/8.0),
    REAL_CONST(6144.397361/8.0),
    REAL_CONST(6156.204993/8.0),
    REAL_CONST(6168.018289/8.0),
    REAL_CONST(6179.837245/8.0),
    REAL_CONST(6191.661854/8.0),
    REAL_CONST(6203.492112/8.0),
    REAL_CONST(6215.328012/8.0),
    REAL_CONST(6227.169550/8.0),
    REAL_CONST(6239.016720/8.0),
    REAL_CONST(6250.869517/8.0),
    REAL_CONST(6262.727935/8.0),
    REAL_CONST(6274.591969/8.0),
    REAL_CONST(6286.461614/8.0),
    REAL_CONST(6298.336865/8.0),
    REAL_CONST(6310.217716/8.0),
    REAL_CONST(6322.104162/8.0),
    REAL_CONST(6333.996197/8.0),
    REAL_CONST(6345.893817/8.0),
    REAL_CONST(6357.797016/8.0),
    REAL_CONST(6369.705789/8.0),
    REAL_CONST(6381.620131/8.0),
    REAL_CONST(6393.540036/8.0),
    REAL_CONST(6405.465500/8.0),
    REAL_CONST(6417.396517/8.0),
    REAL_CONST(6429.333082/8.0),
    REAL_CONST(6441.275190/8.0),
    REAL_CONST(6453.222835/8.0),
    REAL_CONST(6465.176013/8.0),
    REAL_CONST(6477.134719/8.0),
    REAL_CONST(6489.098947/8.0),
    REAL_CONST(6501.068692/8.0),
    REAL_CONST(6513.043949/8.0),
    REAL_CONST(6525.024714/8.0),
    REAL_CONST(6537.010981/8.0),
    REAL_CONST(6549.002744/8.0),
    REAL_CONST(6561.000000/8.0),
    REAL_CONST(6573.002743/8.0),
    REAL_CONST(6585.010967/8.0),
    REAL_CONST(6597.024669/8.0),
    REAL_CONST(6609.043842/8.0),
    REAL_CONST(6621.068483/8.0),
    REAL_CONST(6633.098585/8.0),
    REAL_CONST(6645.134145/8.0),
    REAL_CONST(6657.175157/8.0),
    REAL_CONST(6669.221616/8.0),
    REAL_CONST(6681.273517/8.0),
    REAL_CONST(6693.330855/8.0),
    REAL_CONST(6705.393626/8.0),
    REAL_CONST(6717.461825/8.0),
    REAL_CONST(6729.535446/8.0),
    REAL_CONST(6741.614485/8.0),
    REAL_CONST(6753.698937/8.0),
    REAL_CONST(6765.788798/8.0),
    REAL_CONST(6777.884061/8.0),
    REAL_CONST(6789.984723/8.0),
    REAL_CONST(6802.090779/8.0),
    REAL_CONST(6814.202223/8.0),
    REAL_CONST(6826.319052/8.0),
    REAL_CONST(6838.441259/8.0),
    REAL_CONST(6850.568842/8.0),
    REAL_CONST(6862.701794/8.0),
    REAL_CONST(6874.840111/8.0),
    REAL_CONST(6886.983788/8.0),
    REAL_CONST(6899.132821/8.0),
    REAL_CONST(6911.287205/8.0),
    REAL_CONST(6923.446935/8.0),
    REAL_CONST(6935.612006/8.0),
    REAL_CONST(6947.782414/8.0),
    REAL_CONST(6959.958154/8.0),
    REAL_CONST(6972.139221/8.0),
    REAL_CONST(6984.325611/8.0),
    REAL_CONST(6996.517319/8.0),
    REAL_CONST(7008.714341/8.0),
    REAL_CONST(7020.916672/8.0),
    REAL_CONST(7033.124306/8.0),
    REAL_CONST(7045.337241/8.0),
    REAL_CONST(7057.555470/8.0),
    REAL_CONST(7069.778990/8.0),
    REAL_CONST(7082.007795/8.0),
    REAL_CONST(7094.241882/8.0),
    REAL_CONST(7106.481246/8.0),
    REAL_CONST(7118.725881/8.0),
    REAL_CONST(7130.975785/8.0),
    REAL_CONST(7143.230951/8.0),
    REAL_CONST(7155.491376/8.0),
    REAL_CONST(7167.757056/8.0),
    REAL_CONST(7180.027984/8.0),
    REAL_CONST(7192.304158/8.0),
    REAL_CONST(7204.585573/8.0),
    REAL_CONST(7216.872224/8.0),
    REAL_CONST(7229.164106/8.0),
    REAL_CONST(7241.461216/8.0),
    REAL_CONST(7253.763548/8.0),
    REAL_CONST(7266.071099/8.0),
    REAL_CONST(7278.383864/8.0),
    REAL_CONST(7290.701838/8.0),
    REAL_CONST(7303.025018/8.0),
    REAL_CONST(7315.353398/8.0),
    REAL_CONST(7327.686975/8.0),
    REAL_CONST(7340.025743/8.0),
    REAL_CONST(7352.369699/8.0),
    REAL_CONST(7364.718839/8.0),
    REAL_CONST(7377.073157/8.0),
    REAL_CONST(7389.432650/8.0),
    REAL_CONST(7401.797314/8.0),
    REAL_CONST(7414.167143/8.0),
    REAL_CONST(7426.542134/8.0),
    REAL_CONST(7438.922282/8.0),
    REAL_CONST(7451.307583/8.0),
    REAL_CONST(7463.698033/8.0),
    REAL_CONST(7476.093627/8.0),
    REAL_CONST(7488.494362/8.0),
    REAL_CONST(7500.900233/8.0),
    REAL_CONST(7513.311235/8.0),
    REAL_CONST(7525.727365/8.0),
    REAL_CONST(7538.148618/8.0),
    REAL_CONST(7550.574989/8.0),
    REAL_CONST(7563.006476/8.0),
    REAL_CONST(7575.443073/8.0),
    REAL_CONST(7587.884777/8.0),
    REAL_CONST(7600.331583/8.0),
    REAL_CONST(7612.783487/8.0),
    REAL_CONST(7625.240485/8.0),
    REAL_CONST(7637.702572/8.0),
    REAL_CONST(7650.169745/8.0),
    REAL_CONST(7662.641999/8.0),
    REAL_CONST(7675.119331/8.0),
    REAL_CONST(7687.601736/8.0),
    REAL_CONST(7700.089209/8.0),
    REAL_CONST(7712.581748/8.0),
    REAL_CONST(7725.079347/8.0),
    REAL_CONST(7737.582003/8.0),
    REAL_CONST(7750.089712/8.0),
    REAL_CONST(7762.602469/8.0),
    REAL_CONST(7775.120271/8.0),
    REAL_CONST(7787.643113/8.0),
    REAL_CONST(7800.170991/8.0),
    REAL_CONST(7812.703902/8.0),
    REAL_CONST(7825.241841/8.0),
    REAL_CONST(7837.784804/8.0),
    REAL_CONST(7850.332787/8.0),
    REAL_CONST(7862.885787/8.0),
    REAL_CONST(7875.443798/8.0),
    REAL_CONST(7888.006818/8.0),
    REAL_CONST(7900.574842/8.0),
    REAL_CONST(7913.147866/8.0),
    REAL_CONST(7925.725887/8.0),
    REAL_CONST(7938.308900/8.0),
    REAL_CONST(7950.896901/8.0),
    REAL_CONST(7963.489886/8.0),
    REAL_CONST(7976.087852/8.0),
    REAL_CONST(7988.690794/8.0),
    REAL_CONST(8001.298709/8.0),
    REAL_CONST(8013.911593/8.0),
    REAL_CONST(8026.529441/8.0),
    REAL_CONST(8039.152250/8.0),
    REAL_CONST(8051.780016/8.0),
    REAL_CONST(8064.412735/8.0),
    REAL_CONST(8077.050403/8.0),
    REAL_CONST(8089.693017/8.0),
    REAL_CONST(8102.340572/8.0),
    REAL_CONST(8114.993064/8.0),
    REAL_CONST(8127.650490/8.0),
    REAL_CONST(8140.312846/8.0),
    REAL_CONST(8152.980128/8.0),
    REAL_CONST(8165.652333/8.0),
    REAL_CONST(8178.329455/8.0),
    REAL_CONST(8191.011492/8.0),
    REAL_CONST(8203.698440/8.0),
    REAL_CONST(8216.390295/8.0),
    REAL_CONST(8229.087053/8.0),
    REAL_CONST(8241.788711/8.0),
    REAL_CONST(8254.495264/8.0),
    REAL_CONST(8267.206709/8.0),
    REAL_CONST(8279.923042/8.0),
    REAL_CONST(8292.644259/8.0),
    REAL_CONST(8305.370357/8.0),
    REAL_CONST(8318.101332/8.0),
    REAL_CONST(8330.837180/8.0),
    REAL_CONST(8343.577897/8.0),
    REAL_CONST(8356.323480/8.0),
    REAL_CONST(8369.073925/8.0),
    REAL_CONST(8381.829228/8.0),
    REAL_CONST(8394.589385/8.0),
    REAL_CONST(8407.354394/8.0),
    REAL_CONST(8420.124249/8.0),
    REAL_CONST(8432.898948/8.0),
    REAL_CONST(8445.678487/8.0),
    REAL_CONST(8458.462862/8.0),
    REAL_CONST(8471.252070/8.0),
    REAL_CONST(8484.046106/8.0),
    REAL_CONST(8496.844968/8.0),
    REAL_CONST(8509.648651/8.0),
    REAL_CONST(8522.457152/8.0),
    REAL_CONST(8535.270468/8.0),
    REAL_CONST(8548.088594/8.0),
    REAL_CONST(8560.911527/8.0),
    REAL_CONST(8573.739264/8.0),
    REAL_CONST(8586.571801/8.0),
    REAL_CONST(8599.409134/8.0),
    REAL_CONST(8612.251259/8.0),
    REAL_CONST(8625.098174/8.0),
    REAL_CONST(8637.949875/8.0),
    REAL_CONST(8650.806357/8.0),
    REAL_CONST(8663.667618/8.0),
    REAL_CONST(8676.533654/8.0),
    REAL_CONST(8689.404461/8.0),
    REAL_CONST(8702.280037/8.0),
    REAL_CONST(8715.160376/8.0),
    REAL_CONST(8728.045476/8.0),
    REAL_CONST(8740.935334/8.0),
    REAL_CONST(8753.829945/8.0),
    REAL_CONST(8766.729307/8.0),
    REAL_CONST(8779.633415/8.0),
    REAL_CONST(8792.542267/8.0),
    REAL_CONST(8805.455858/8.0),
    REAL_CONST(8818.374186/8.0),
    REAL_CONST(8831.297247/8.0),
    REAL_CONST(8844.225037/8.0),
    REAL_CONST(8857.157553/8.0),
    REAL_CONST(8870.094791/8.0),
    REAL_CONST(8883.036748/8.0),
    REAL_CONST(8895.983422/8.0),
    REAL_CONST(8908.934807/8.0),
    REAL_CONST(8921.890901/8.0),
    REAL_CONST(8934.851700/8.0),
    REAL_CONST(8947.817201/8.0),
    REAL_CONST(8960.787401/8.0),
    REAL_CONST(8973.762296/8.0),
    REAL_CONST(8986.741882/8.0),
    REAL_CONST(8999.726157/8.0),
    REAL_CONST(9012.715117/8.0),
    REAL_CONST(9025.708758/8.0),
    REAL_CONST(9038.707077/8.0),
    REAL_CONST(9051.710072/8.0),
    REAL_CONST(9064.717737/8.0),
    REAL_CONST(9077.730071/8.0),
    REAL_CONST(9090.747070/8.0),
    REAL_CONST(9103.768730/8.0),
    REAL_CONST(9116.795048/8.0),
    REAL_CONST(9129.826021/8.0),
    REAL_CONST(9142.861645/8.0),
    REAL_CONST(9155.901917/8.0),
    REAL_CONST(9168.946835/8.0),
    REAL_CONST(9181.996393/8.0),
    REAL_CONST(9195.050590/8.0),
    REAL_CONST(9208.109422/8.0),
    REAL_CONST(9221.172885/8.0),
    REAL_CONST(9234.240977/8.0),
    REAL_CONST(9247.313694/8.0),
    REAL_CONST(9260.391032/8.0),
    REAL_CONST(9273.472989/8.0),
    REAL_CONST(9286.559562/8.0),
    REAL_CONST(9299.650746/8.0),
    REAL_CONST(9312.746539/8.0),
    REAL_CONST(9325.846938/8.0),
    REAL_CONST(9338.951939/8.0),
    REAL_CONST(9352.061539/8.0),
    REAL_CONST(9365.175734/8.0),
    REAL_CONST(9378.294523/8.0),
    REAL_CONST(9391.417901/8.0),
    REAL_CONST(9404.545865/8.0),
    REAL_CONST(9417.678412/8.0),
    REAL_CONST(9430.815538/8.0),
    REAL_CONST(9443.957242/8.0),
    REAL_CONST(9457.103518/8.0),
    REAL_CONST(9470.254365/8.0),
    REAL_CONST(9483.409779/8.0),
    REAL_CONST(9496.569757/8.0),
    REAL_CONST(9509.734296/8.0),
    REAL_CONST(9522.903392/8.0),
    REAL_CONST(9536.077043/8.0),
    REAL_CONST(9549.255245/8.0),
    REAL_CONST(9562.437995/8.0),
    REAL_CONST(9575.625290/8.0),
    REAL_CONST(9588.817127/8.0),
    REAL_CONST(9602.013503/8.0),
    REAL_CONST(9615.214414/8.0),
    REAL_CONST(9628.419858/8.0),
    REAL_CONST(9641.629831/8.0),
    REAL_CONST(9654.844330/8.0),
    REAL_CONST(9668.063353/8.0),
    REAL_CONST(9681.286896/8.0),
    REAL_CONST(9694.514956/8.0),
    REAL_CONST(9707.747529/8.0),
    REAL_CONST(9720.984614/8.0),
    REAL_CONST(9734.226206/8.0),
    REAL_CONST(9747.472303/8.0),
    REAL_CONST(9760.722902/8.0),
    REAL_CONST(9773.977999/8.0),
    REAL_CONST(9787.237592/8.0),
    REAL_CONST(9800.501677/8.0),
    REAL_CONST(9813.770252/8.0),
    REAL_CONST(9827.043313/8.0),
    REAL_CONST(9840.320858/8.0),
    REAL_CONST(9853.602883/8.0),
    REAL_CONST(9866.889385/8.0),
    REAL_CONST(9880.180361/8.0),
    REAL_CONST(9893.475809/8.0),
    REAL_CONST(9906.775725/8.0),
    REAL_CONST(9920.080107/8.0),
    REAL_CONST(9933.388951/8.0),
    REAL_CONST(9946.702254/8.0),
    REAL_CONST(9960.020013/8.0),
    REAL_CONST(9973.342226/8.0),
    REAL_CONST(9986.668889/8.0),
    REAL_CONST(10000.000000/8.0),
    REAL_CONST(10013.335555/8.0),
    REAL_CONST(10026.675552/8.0),
    REAL_CONST(10040.019987/8.0),
    REAL_CONST(10053.368857/8.0),
    REAL_CONST(10066.722161/8.0),
    REAL_CONST(10080.079894/8.0),
    REAL_CONST(10093.442053/8.0),
    REAL_CONST(10106.808637/8.0),
    REAL_CONST(10120.179641/8.0),
    REAL_CONST(10133.555064/8.0),
    REAL_CONST(10146.934901/8.0),
    REAL_CONST(10160.319151/8.0),
    REAL_CONST(10173.707810/8.0),
    REAL_CONST(10187.100875/8.0),
    REAL_CONST(10200.498344/8.0),
    REAL_CONST(10213.900213/8.0),
    REAL_CONST(10227.306480/8.0),
    REAL_CONST(10240.717141/8.0),
    REAL_CONST(10254.132195/8.0),
    REAL_CONST(10267.551638/8.0),
    REAL_CONST(10280.975466/8.0),
    REAL_CONST(10294.403678/8.0),
    REAL_CONST(10307.836271/8.0),
    REAL_CONST(10321.273241/8.0),
    REAL_CONST(10334.714585/8.0),
    REAL_CONST(10348.160302/8.0),
    REAL_CONST(10361.610388/8.0),
    REAL_CONST(10375.064840/8.0),
    REAL_CONST(10388.523655/8.0),
    REAL_CONST(10401.986831/8.0),
    REAL_CONST(10415.454364/8.0),
    REAL_CONST(10428.926253/8.0),
    REAL_CONST(10442.402493/8.0),
    REAL_CONST(10455.883083/8.0),
    REAL_CONST(10469.368019/8.0),
    REAL_CONST(10482.857299/8.0),
    REAL_CONST(10496.350920/8.0),
    REAL_CONST(10509.848879/8.0),
    REAL_CONST(10523.351173/8.0),
    REAL_CONST(10536.857800/8.0),
    REAL_CONST(10550.368756/8.0),
    REAL_CONST(10563.884040/8.0),
    REAL_CONST(10577.403647/8.0),
    REAL_CONST(10590.927576/8.0),
    REAL_CONST(10604.455824/8.0),
    REAL_CONST(10617.988388/8.0),
    REAL_CONST(10631.525265/8.0),
    REAL_CONST(10645.066452/8.0),
    REAL_CONST(10658.611947/8.0),
    REAL_CONST(10672.161747/8.0),
    REAL_CONST(10685.715849/8.0),
    REAL_CONST(10699.274250/8.0),
    REAL_CONST(10712.836948/8.0),
    REAL_CONST(10726.403941/8.0),
    REAL_CONST(10739.975224/8.0),
    REAL_CONST(10753.550797/8.0),
    REAL_CONST(10767.130655/8.0),
    REAL_CONST(10780.714796/8.0),
    REAL_CONST(10794.303218/8.0),
    REAL_CONST(10807.895918/8.0),
    REAL_CONST(10821.492892/8.0),
    REAL_CONST(10835.094140/8.0),
    REAL_CONST(10848.699656/8.0),
    REAL_CONST(10862.309440/8.0),
    REAL_CONST(10875.923489/8.0),
    REAL_CONST(10889.541799/8.0),
    REAL_CONST(10903.164368/8.0),
    REAL_CONST(10916.791193/8.0),
    REAL_CONST(10930.422273/8.0),
    REAL_CONST(10944.057603/8.0),
    REAL_CONST(10957.697182/8.0),
    REAL_CONST(10971.341006/8.0),
    REAL_CONST(10984.989074/8.0),
    REAL_CONST(10998.641382/8.0),
    REAL_CONST(11012.297928/8.0),
    REAL_CONST(11025.958709/8.0),
    REAL_CONST(11039.623723/8.0),
    REAL_CONST(11053.292967/8.0),
    REAL_CONST(11066.966438/8.0),
    REAL_CONST(11080.644134/8.0),
    REAL_CONST(11094.326053/8.0),
    REAL_CONST(11108.012190/8.0),
    REAL_CONST(11121.702545/8.0),
    REAL_CONST(11135.397114/8.0),
    REAL_CONST(11149.095895/8.0),
    REAL_CONST(11162.798885/8.0),
    REAL_CONST(11176.506082/8.0),
    REAL_CONST(11190.217483/8.0),
    REAL_CONST(11203.933085/8.0),
    REAL_CONST(11217.652886/8.0),
    REAL_CONST(11231.376883/8.0),
    REAL_CONST(11245.105074/8.0),
    REAL_CONST(11258.837456/8.0),
    REAL_CONST(11272.574027/8.0),
    REAL_CONST(11286.314784/8.0),
    REAL_CONST(11300.059724/8.0),
    REAL_CONST(11313.808846/8.0),
    REAL_CONST(11327.562145/8.0),
    REAL_CONST(11341.319621/8.0),
    REAL_CONST(11355.081270/8.0),
    REAL_CONST(11368.847090/8.0),
    REAL_CONST(11382.617078/8.0),
    REAL_CONST(11396.391232/8.0),
    REAL_CONST(11410.169549/8.0),
    REAL_CONST(11423.952027/8.0),
    REAL_CONST(11437.738663/8.0),
    REAL_CONST(11451.529455/8.0),
    REAL_CONST(11465.324400/8.0),
    REAL_CONST(11479.123496/8.0),
    REAL_CONST(11492.926740/8.0),
    REAL_CONST(11506.734130/8.0),
    REAL_CONST(11520.545663/8.0),
    REAL_CONST(11534.361337/8.0),
    REAL_CONST(11548.181150/8.0),
    REAL_CONST(11562.005097/8.0),
    REAL_CONST(11575.833179/8.0),
    REAL_CONST(11589.665391/8.0),
    REAL_CONST(11603.501732/8.0),
    REAL_CONST(11617.342198/8.0),
    REAL_CONST(11631.186788/8.0),
    REAL_CONST(11645.035499/8.0),
    REAL_CONST(11658.888329/8.0),
    REAL_CONST(11672.745275/8.0),
    REAL_CONST(11686.606334/8.0),
    REAL_CONST(11700.471505/8.0),
    REAL_CONST(11714.340784/8.0),
    REAL_CONST(11728.214170/8.0),
    REAL_CONST(11742.091660/8.0),
    REAL_CONST(11755.973251/8.0),
    REAL_CONST(11769.858942/8.0),
    REAL_CONST(11783.748729/8.0),
    REAL_CONST(11797.642610/8.0),
    REAL_CONST(11811.540583/8.0),
    REAL_CONST(11825.442646/8.0),
    REAL_CONST(11839.348796/8.0),
    REAL_CONST(11853.259030/8.0),
    REAL_CONST(11867.173347/8.0),
    REAL_CONST(11881.091743/8.0),
    REAL_CONST(11895.014217/8.0),
    REAL_CONST(11908.940766/8.0),
    REAL_CONST(11922.871387/8.0),
    REAL_CONST(11936.806079/8.0),
    REAL_CONST(11950.744839/8.0),
    REAL_CONST(11964.687665/8.0),
    REAL_CONST(11978.634553/8.0),
    REAL_CONST(11992.585503/8.0),
    REAL_CONST(12006.540511/8.0),
    REAL_CONST(12020.499575/8.0),
    REAL_CONST(12034.462692/8.0),
    REAL_CONST(12048.429861/8.0),
    REAL_CONST(12062.401080/8.0),
    REAL_CONST(12076.376345/8.0),
    REAL_CONST(12090.355654/8.0),
    REAL_CONST(12104.339005/8.0),
    REAL_CONST(12118.326396/8.0),
    REAL_CONST(12132.317824/8.0),
    REAL_CONST(12146.313287/8.0),
    REAL_CONST(12160.312783/8.0),
    REAL_CONST(12174.316310/8.0),
    REAL_CONST(12188.323864/8.0),
    REAL_CONST(12202.335444/8.0),
    REAL_CONST(12216.351048/8.0),
    REAL_CONST(12230.370673/8.0),
    REAL_CONST(12244.394316/8.0),
    REAL_CONST(12258.421976/8.0),
    REAL_CONST(12272.453650/8.0),
    REAL_CONST(12286.489336/8.0),
    REAL_CONST(12300.529032/8.0),
    REAL_CONST(12314.572735/8.0),
    REAL_CONST(12328.620443/8.0),
    REAL_CONST(12342.672154/8.0),
    REAL_CONST(12356.727866/8.0),
    REAL_CONST(12370.787575/8.0),
    REAL_CONST(12384.851281/8.0),
    REAL_CONST(12398.918980/8.0),
    REAL_CONST(12412.990671/8.0),
    REAL_CONST(12427.066351/8.0),
    REAL_CONST(12441.146017/8.0),
    REAL_CONST(12455.229668/8.0),
    REAL_CONST(12469.317302/8.0),
    REAL_CONST(12483.408916/8.0),
    REAL_CONST(12497.504507/8.0),
    REAL_CONST(12511.604075/8.0),
    REAL_CONST(12525.707615/8.0),
    REAL_CONST(12539.815127/8.0),
    REAL_CONST(12553.926608/8.0),
    REAL_CONST(12568.042055/8.0),
    REAL_CONST(12582.161467/8.0),
    REAL_CONST(12596.284841/8.0),
    REAL_CONST(12610.412175/8.0),
    REAL_CONST(12624.543467/8.0),
    REAL_CONST(12638.678715/8.0),
    REAL_CONST(12652.817915/8.0),
    REAL_CONST(12666.961067/8.0),
    REAL_CONST(12681.108168/8.0),
    REAL_CONST(12695.259216/8.0),
    REAL_CONST(12709.414208/8.0),
    REAL_CONST(12723.573143/8.0),
    REAL_CONST(12737.736018/8.0),
    REAL_CONST(12751.902830/8.0),
    REAL_CONST(12766.073579/8.0),
    REAL_CONST(12780.248261/8.0),
    REAL_CONST(12794.426874/8.0),
    REAL_CONST(12808.609417/8.0),
    REAL_CONST(12822.795886/8.0),
    REAL_CONST(12836.986281/8.0),
    REAL_CONST(12851.180598/8.0),
    REAL_CONST(12865.378836/8.0),
    REAL_CONST(12879.580992/8.0),
    REAL_CONST(12893.787065/8.0),
    REAL_CONST(12907.997051/8.0),
    REAL_CONST(12922.210950/8.0),
    REAL_CONST(12936.428758/8.0),
    REAL_CONST(12950.650474/8.0),
    REAL_CONST(12964.876095/8.0),
    REAL_CONST(12979.105619/8.0),
    REAL_CONST(12993.339045/8.0),
    REAL_CONST(13007.576370/8.0),
    REAL_CONST(13021.817591/8.0),
    REAL_CONST(13036.062708/8.0),
    REAL_CONST(13050.311717/8.0),
    REAL_CONST(13064.564616/8.0),
    REAL_CONST(13078.821404/8.0),
    REAL_CONST(13093.082079/8.0),
    REAL_CONST(13107.346637/8.0),
    REAL_CONST(13121.615077/8.0),
    REAL_CONST(13135.887398/8.0),
    REAL_CONST(13150.163596/8.0),
    REAL_CONST(13164.443670/8.0),
    REAL_CONST(13178.727617/8.0),
    REAL_CONST(13193.015436/8.0),
    REAL_CONST(13207.307125/8.0),
    REAL_CONST(13221.602680/8.0),
    REAL_CONST(13235.902101/8.0),
    REAL_CONST(13250.205385/8.0),
    REAL_CONST(13264.512531/8.0),
    REAL_CONST(13278.823535/8.0),
    REAL_CONST(13293.138396/8.0),
    REAL_CONST(13307.457112/8.0),
    REAL_CONST(13321.779680/8.0),
    REAL_CONST(13336.106100/8.0),
    REAL_CONST(13350.436367/8.0),
    REAL_CONST(13364.770482/8.0),
    REAL_CONST(13379.108441/8.0),
    REAL_CONST(13393.450242/8.0),
    REAL_CONST(13407.795884/8.0),
    REAL_CONST(13422.145364/8.0),
    REAL_CONST(13436.498680/8.0),
    REAL_CONST(13450.855830/8.0),
    REAL_CONST(13465.216813/8.0),
    REAL_CONST(13479.581625/8.0),
    REAL_CONST(13493.950266/8.0),
    REAL_CONST(13508.322733/8.0),
    REAL_CONST(13522.699024/8.0),
    REAL_CONST(13537.079136/8.0),
    REAL_CONST(13551.463069/8.0),
    REAL_CONST(13565.850819/8.0),
    REAL_CONST(13580.242386/8.0),
    REAL_CONST(13594.637766/8.0),
    REAL_CONST(13609.036958/8.0),
    REAL_CONST(13623.439960/8.0),
    REAL_CONST(13637.846770/8.0),
    REAL_CONST(13652.257385/8.0),
    REAL_CONST(13666.671804/8.0),
    REAL_CONST(13681.090025/8.0),
    REAL_CONST(13695.512046/8.0),
    REAL_CONST(13709.937865/8.0),
    REAL_CONST(13724.367479/8.0),
    REAL_CONST(13738.800887/8.0),
    REAL_CONST(13753.238087/8.0),
    REAL_CONST(13767.679077/8.0),
    REAL_CONST(13782.123854/8.0),
    REAL_CONST(13796.572417/8.0),
    REAL_CONST(13811.024765/8.0),
    REAL_CONST(13825.480893/8.0),
    REAL_CONST(13839.940802/8.0),
    REAL_CONST(13854.404489/8.0),
    REAL_CONST(13868.871952/8.0),
    REAL_CONST(13883.343188/8.0),
    REAL_CONST(13897.818197/8.0),
    REAL_CONST(13912.296976/8.0),
    REAL_CONST(13926.779522/8.0),
    REAL_CONST(13941.265835/8.0),
    REAL_CONST(13955.755912/8.0),
    REAL_CONST(13970.249751/8.0),
    REAL_CONST(13984.747351/8.0),
    REAL_CONST(13999.248708/8.0),
    REAL_CONST(14013.753822/8.0),
    REAL_CONST(14028.262691/8.0),
    REAL_CONST(14042.775312/8.0),
    REAL_CONST(14057.291683/8.0),
    REAL_CONST(14071.811803/8.0),
    REAL_CONST(14086.335669/8.0),
    REAL_CONST(14100.863281/8.0),
    REAL_CONST(14115.394635/8.0),
    REAL_CONST(14129.929730/8.0),
    REAL_CONST(14144.468564/8.0),
    REAL_CONST(14159.011135/8.0),
    REAL_CONST(14173.557441/8.0),
    REAL_CONST(14188.107480/8.0),
    REAL_CONST(14202.661250/8.0),
    REAL_CONST(14217.218750/8.0),
    REAL_CONST(14231.779977/8.0),
    REAL_CONST(14246.344930/8.0),
    REAL_CONST(14260.913606/8.0),
    REAL_CONST(14275.486004/8.0),
    REAL_CONST(14290.062122/8.0),
    REAL_CONST(14304.641958/8.0),
    REAL_CONST(14319.225510/8.0),
    REAL_CONST(14333.812776/8.0),
    REAL_CONST(14348.403754/8.0),
    REAL_CONST(14362.998443/8.0),
    REAL_CONST(14377.596840/8.0),
    REAL_CONST(14392.198943/8.0),
    REAL_CONST(14406.804752/8.0),
    REAL_CONST(14421.414263/8.0),
    REAL_CONST(14436.027475/8.0),
    REAL_CONST(14450.644386/8.0),
    REAL_CONST(14465.264995/8.0),
    REAL_CONST(14479.889298/8.0),
    REAL_CONST(14494.517296/8.0),
    REAL_CONST(14509.148984/8.0),
    REAL_CONST(14523.784363/8.0),
    REAL_CONST(14538.423430/8.0),
    REAL_CONST(14553.066182/8.0),
    REAL_CONST(14567.712619/8.0),
    REAL_CONST(14582.362738/8.0),
    REAL_CONST(14597.016537/8.0),
    REAL_CONST(14611.674015/8.0),
    REAL_CONST(14626.335170/8.0),
    REAL_CONST(14641.000000/8.0),
    REAL_CONST(14655.668503/8.0),
    REAL_CONST(14670.340677/8.0),
    REAL_CONST(14685.016521/8.0),
    REAL_CONST(14699.696032/8.0),
    REAL_CONST(14714.379209/8.0),
    REAL_CONST(14729.066050/8.0),
    REAL_CONST(14743.756553/8.0),
    REAL_CONST(14758.450716/8.0),
    REAL_CONST(14773.148537/8.0),
    REAL_CONST(14787.850016/8.0),
    REAL_CONST(14802.555149/8.0),
    REAL_CONST(14817.263935/8.0),
    REAL_CONST(14831.976372/8.0),
    REAL_CONST(14846.692459/8.0),
    REAL_CONST(14861.412193/8.0),
    REAL_CONST(14876.135573/8.0),
    REAL_CONST(14890.862597/8.0),
    REAL_CONST(14905.593263/8.0),
    REAL_CONST(14920.327569/8.0),
    REAL_CONST(14935.065514/8.0),
    REAL_CONST(14949.807096/8.0),
    REAL_CONST(14964.552313/8.0),
    REAL_CONST(14979.301163/8.0),
    REAL_CONST(14994.053644/8.0),
    REAL_CONST(15008.809755/8.0),
    REAL_CONST(15023.569493/8.0),
    REAL_CONST(15038.332858/8.0),
    REAL_CONST(15053.099847/8.0),
    REAL_CONST(15067.870458/8.0),
    REAL_CONST(15082.644690/8.0),
    REAL_CONST(15097.422541/8.0),
    REAL_CONST(15112.204010/8.0),
    REAL_CONST(15126.989093/8.0),
    REAL_CONST(15141.777790/8.0),
    REAL_CONST(15156.570099/8.0),
    REAL_CONST(15171.366018/8.0),
    REAL_CONST(15186.165546/8.0),
    REAL_CONST(15200.968679/8.0),
    REAL_CONST(15215.775418/8.0),
    REAL_CONST(15230.585760/8.0),
    REAL_CONST(15245.399703/8.0),
    REAL_CONST(15260.217246/8.0),
    REAL_CONST(15275.038386/8.0),
    REAL_CONST(15289.863123/8.0),
    REAL_CONST(15304.691453/8.0),
    REAL_CONST(15319.523377/8.0),
    REAL_CONST(15334.358891/8.0),
    REAL_CONST(15349.197994/8.0),
    REAL_CONST(15364.040685/8.0),
    REAL_CONST(15378.886961/8.0),
    REAL_CONST(15393.736821/8.0),
    REAL_CONST(15408.590264/8.0),
    REAL_CONST(15423.447287/8.0),
    REAL_CONST(15438.307888/8.0),
    REAL_CONST(15453.172066/8.0),
    REAL_CONST(15468.039820/8.0),
    REAL_CONST(15482.911148/8.0),
    REAL_CONST(15497.786047/8.0),
    REAL_CONST(15512.664516/8.0),
    REAL_CONST(15527.546554/8.0),
    REAL_CONST(15542.432158/8.0),
    REAL_CONST(15557.321327/8.0),
    REAL_CONST(15572.214060/8.0),
    REAL_CONST(15587.110354/8.0),
    REAL_CONST(15602.010208/8.0),
    REAL_CONST(15616.913620/8.0),
    REAL_CONST(15631.820589/8.0),
    REAL_CONST(15646.731113/8.0),
    REAL_CONST(15661.645189/8.0),
    REAL_CONST(15676.562817/8.0),
    REAL_CONST(15691.483995/8.0),
    REAL_CONST(15706.408720/8.0),
    REAL_CONST(15721.336993/8.0),
    REAL_CONST(15736.268809/8.0),
    REAL_CONST(15751.204169/8.0),
    REAL_CONST(15766.143070/8.0),
    REAL_CONST(15781.085510/8.0),
    REAL_CONST(15796.031489/8.0),
    REAL_CONST(15810.981003/8.0),
    REAL_CONST(15825.934053/8.0),
    REAL_CONST(15840.890635/8.0),
    REAL_CONST(15855.850748/8.0),
    REAL_CONST(15870.814391/8.0),
    REAL_CONST(15885.781562/8.0),
    REAL_CONST(15900.752259/8.0),
    REAL_CONST(15915.726481/8.0),
    REAL_CONST(15930.704226/8.0),
    REAL_CONST(15945.685492/8.0),
    REAL_CONST(15960.670278/8.0),
    REAL_CONST(15975.658581/8.0),
    REAL_CONST(15990.650401/8.0),
    REAL_CONST(16005.645736/8.0),
    REAL_CONST(16020.644583/8.0),
    REAL_CONST(16035.646942/8.0),
    REAL_CONST(16050.652811/8.0),
    REAL_CONST(16065.662188/8.0),
    REAL_CONST(16080.675071/8.0),
    REAL_CONST(16095.691459/8.0),
    REAL_CONST(16110.711350/8.0),
    REAL_CONST(16125.734743/8.0),
    REAL_CONST(16140.761636/8.0),
    REAL_CONST(16155.792027/8.0),
    REAL_CONST(16170.825914/8.0),
    REAL_CONST(16185.863297/8.0),
    REAL_CONST(16200.904173/8.0),
    REAL_CONST(16215.948541/8.0),
    REAL_CONST(16230.996399/8.0),
    REAL_CONST(16246.047746/8.0),
    REAL_CONST(16261.102579/8.0),
    REAL_CONST(16276.160898/8.0),
    REAL_CONST(16291.222700/8.0),
    REAL_CONST(16306.287985/8.0),
    REAL_CONST(16321.356750/8.0),
    REAL_CONST(16336.428994/8.0),
    REAL_CONST(16351.504716/8.0),
    REAL_CONST(16366.583913/8.0),
    REAL_CONST(16381.666584/8.0),
    REAL_CONST(16396.752727/8.0),
    REAL_CONST(16411.842341/8.0),
    REAL_CONST(16426.935425/8.0),
    REAL_CONST(16442.031976/8.0),
    REAL_CONST(16457.131994/8.0),
    REAL_CONST(16472.235476/8.0),
    REAL_CONST(16487.342421/8.0),
    REAL_CONST(16502.452827/8.0),
    REAL_CONST(16517.566693/8.0),
    REAL_CONST(16532.684017/8.0),
    REAL_CONST(16547.804797/8.0),
    REAL_CONST(16562.929033/8.0),
    REAL_CONST(16578.056722/8.0),
    REAL_CONST(16593.187863/8.0),
    REAL_CONST(16608.322454/8.0),
    REAL_CONST(16623.460494/8.0),
    REAL_CONST(16638.601981/8.0),
    REAL_CONST(16653.746913/8.0),
    REAL_CONST(16668.895290/8.0),
    REAL_CONST(16684.047109/8.0),
    REAL_CONST(16699.202368/8.0),
    REAL_CONST(16714.361068/8.0),
    REAL_CONST(16729.523204/8.0),
    REAL_CONST(16744.688777/8.0),
    REAL_CONST(16759.857785/8.0),
    REAL_CONST(16775.030226/8.0),
    REAL_CONST(16790.206098/8.0),
    REAL_CONST(16805.385400/8.0),
    REAL_CONST(16820.568131/8.0),
    REAL_CONST(16835.754288/8.0),
    REAL_CONST(16850.943871/8.0),
    REAL_CONST(16866.136877/8.0),
    REAL_CONST(16881.333306/8.0),
    REAL_CONST(16896.533156/8.0),
    REAL_CONST(16911.736424/8.0),
    REAL_CONST(16926.943110/8.0),
    REAL_CONST(16942.153213/8.0),
    REAL_CONST(16957.366730/8.0),
    REAL_CONST(16972.583659/8.0),
    REAL_CONST(16987.804001/8.0),
    REAL_CONST(17003.027752/8.0),
    REAL_CONST(17018.254912/8.0),
    REAL_CONST(17033.485479/8.0),
    REAL_CONST(17048.719451/8.0),
    REAL_CONST(17063.956826/8.0),
    REAL_CONST(17079.197605/8.0),
    REAL_CONST(17094.441784/8.0),
    REAL_CONST(17109.689362/8.0),
    REAL_CONST(17124.940338/8.0),
    REAL_CONST(17140.194711/8.0),
    REAL_CONST(17155.452478/8.0),
    REAL_CONST(17170.713638/8.0),
    REAL_CONST(17185.978190/8.0),
    REAL_CONST(17201.246133/8.0),
    REAL_CONST(17216.517464/8.0),
    REAL_CONST(17231.792182/8.0),
    REAL_CONST(17247.070287/8.0),
    REAL_CONST(17262.351775/8.0),
    REAL_CONST(17277.636646/8.0),
    REAL_CONST(17292.924898/8.0),
    REAL_CONST(17308.216530/8.0),
    REAL_CONST(17323.511541/8.0),
    REAL_CONST(17338.809928/8.0),
    REAL_CONST(17354.111690/8.0),
    REAL_CONST(17369.416826/8.0),
    REAL_CONST(17384.725335/8.0),
    REAL_CONST(17400.037214/8.0),
    REAL_CONST(17415.352462/8.0),
    REAL_CONST(17430.671079/8.0),
    REAL_CONST(17445.993061/8.0),
    REAL_CONST(17461.318409/8.0),
    REAL_CONST(17476.647120/8.0),
    REAL_CONST(17491.979193/8.0),
    REAL_CONST(17507.314626/8.0),
    REAL_CONST(17522.653419/8.0),
    REAL_CONST(17537.995569/8.0),
    REAL_CONST(17553.341074/8.0),
    REAL_CONST(17568.689935/8.0),
    REAL_CONST(17584.042149/8.0),
    REAL_CONST(17599.397714/8.0),
    REAL_CONST(17614.756629/8.0),
    REAL_CONST(17630.118893/8.0),
    REAL_CONST(17645.484505/8.0),
    REAL_CONST(17660.853462/8.0),
    REAL_CONST(17676.225764/8.0),
    REAL_CONST(17691.601408/8.0),
    REAL_CONST(17706.980394/8.0),
    REAL_CONST(17722.362720/8.0),
    REAL_CONST(17737.748384/8.0),
    REAL_CONST(17753.137386/8.0),
    REAL_CONST(17768.529723/8.0),
    REAL_CONST(17783.925394/8.0),
    REAL_CONST(17799.324399/8.0),
    REAL_CONST(17814.726734/8.0),
    REAL_CONST(17830.132399/8.0),
    REAL_CONST(17845.541393/8.0),
    REAL_CONST(17860.953714/8.0),
    REAL_CONST(17876.369360/8.0),
    REAL_CONST(17891.788331/8.0),
    REAL_CONST(17907.210624/8.0),
    REAL_CONST(17922.636238/8.0),
    REAL_CONST(17938.065173/8.0),
    REAL_CONST(17953.497425/8.0),
    REAL_CONST(17968.932995/8.0),
    REAL_CONST(17984.371880/8.0),
    REAL_CONST(17999.814079/8.0),
    REAL_CONST(18015.259591/8.0),
    REAL_CONST(18030.708415/8.0),
    REAL_CONST(18046.160548/8.0),
    REAL_CONST(18061.615990/8.0),
    REAL_CONST(18077.074738/8.0),
    REAL_CONST(18092.536793/8.0),
    REAL_CONST(18108.002151/8.0),
    REAL_CONST(18123.470813/8.0),
    REAL_CONST(18138.942775/8.0),
    REAL_CONST(18154.418038/8.0),
    REAL_CONST(18169.896599/8.0),
    REAL_CONST(18185.378458/8.0),
    REAL_CONST(18200.863612/8.0),
    REAL_CONST(18216.352060/8.0),
    REAL_CONST(18231.843802/8.0),
    REAL_CONST(18247.338835/8.0),
    REAL_CONST(18262.837158/8.0),
    REAL_CONST(18278.338770/8.0),
    REAL_CONST(18293.843670/8.0),
    REAL_CONST(18309.351855/8.0),
    REAL_CONST(18324.863325/8.0),
    REAL_CONST(18340.378078/8.0),
    REAL_CONST(18355.896113/8.0),
    REAL_CONST(18371.417429/8.0),
    REAL_CONST(18386.942023/8.0),
    REAL_CONST(18402.469895/8.0),
    REAL_CONST(18418.001044/8.0),
    REAL_CONST(18433.535467/8.0),
    REAL_CONST(18449.073164/8.0),
    REAL_CONST(18464.614133/8.0),
    REAL_CONST(18480.158372/8.0),
    REAL_CONST(18495.705881/8.0),
    REAL_CONST(18511.256658/8.0),
    REAL_CONST(18526.810702/8.0),
    REAL_CONST(18542.368011/8.0),
    REAL_CONST(18557.928583/8.0),
    REAL_CONST(18573.492419/8.0),
    REAL_CONST(18589.059515/8.0),
    REAL_CONST(18604.629871/8.0),
    REAL_CONST(18620.203486/8.0),
    REAL_CONST(18635.780358/8.0),
    REAL_CONST(18651.360485/8.0),
    REAL_CONST(18666.943867/8.0),
    REAL_CONST(18682.530502/8.0),
    REAL_CONST(18698.120388/8.0),
    REAL_CONST(18713.713525/8.0),
    REAL_CONST(18729.309910/8.0),
    REAL_CONST(18744.909543/8.0),
    REAL_CONST(18760.512422/8.0),
    REAL_CONST(18776.118546/8.0),
    REAL_CONST(18791.727914/8.0),
    REAL_CONST(18807.340524/8.0),
    REAL_CONST(18822.956374/8.0),
    REAL_CONST(18838.575465/8.0),
    REAL_CONST(18854.197793/8.0),
    REAL_CONST(18869.823358/8.0),
    REAL_CONST(18885.452158/8.0),
    REAL_CONST(18901.084193/8.0),
    REAL_CONST(18916.719460/8.0),
    REAL_CONST(18932.357959/8.0),
    REAL_CONST(18947.999687/8.0),
    REAL_CONST(18963.644645/8.0),
    REAL_CONST(18979.292830/8.0),
    REAL_CONST(18994.944241/8.0),
    REAL_CONST(19010.598877/8.0),
    REAL_CONST(19026.256736/8.0),
    REAL_CONST(19041.917817/8.0),
    REAL_CONST(19057.582120/8.0),
    REAL_CONST(19073.249641/8.0),
    REAL_CONST(19088.920381/8.0),
    REAL_CONST(19104.594338/8.0),
    REAL_CONST(19120.271510/8.0),
    REAL_CONST(19135.951896/8.0),
    REAL_CONST(19151.635495/8.0),
    REAL_CONST(19167.322306/8.0),
    REAL_CONST(19183.012327/8.0),
    REAL_CONST(19198.705557/8.0),
    REAL_CONST(19214.401994/8.0),
    REAL_CONST(19230.101638/8.0),
    REAL_CONST(19245.804487/8.0),
    REAL_CONST(19261.510539/8.0),
    REAL_CONST(19277.219794/8.0),
    REAL_CONST(19292.932250/8.0),
    REAL_CONST(19308.647906/8.0),
    REAL_CONST(19324.366760/8.0),
    REAL_CONST(19340.088811/8.0),
    REAL_CONST(19355.814058/8.0),
    REAL_CONST(19371.542500/8.0),
    REAL_CONST(19387.274135/8.0),
    REAL_CONST(19403.008962/8.0),
    REAL_CONST(19418.746980/8.0),
    REAL_CONST(19434.488187/8.0),
    REAL_CONST(19450.232582/8.0),
    REAL_CONST(19465.980164/8.0),
    REAL_CONST(19481.730931/8.0),
    REAL_CONST(19497.484883/8.0),
    REAL_CONST(19513.242017/8.0),
    REAL_CONST(19529.002334/8.0),
    REAL_CONST(19544.765830/8.0),
    REAL_CONST(19560.532506/8.0),
    REAL_CONST(19576.302359/8.0),
    REAL_CONST(19592.075389/8.0),
    REAL_CONST(19607.851595/8.0),
    REAL_CONST(19623.630974/8.0),
    REAL_CONST(19639.413526/8.0),
    REAL_CONST(19655.199249/8.0),
    REAL_CONST(19670.988143/8.0),
    REAL_CONST(19686.780205/8.0),
    REAL_CONST(19702.575435/8.0),
    REAL_CONST(19718.373831/8.0),
    REAL_CONST(19734.175393/8.0),
    REAL_CONST(19749.980118/8.0),
    REAL_CONST(19765.788005/8.0),
    REAL_CONST(19781.599054/8.0),
    REAL_CONST(19797.413263/8.0),
    REAL_CONST(19813.230631/8.0),
    REAL_CONST(19829.051156/8.0),
    REAL_CONST(19844.874837/8.0),
    REAL_CONST(19860.701674/8.0),
    REAL_CONST(19876.531664/8.0),
    REAL_CONST(19892.364806/8.0),
    REAL_CONST(19908.201100/8.0),
    REAL_CONST(19924.040543/8.0),
    REAL_CONST(19939.883136/8.0),
    REAL_CONST(19955.728875/8.0),
    REAL_CONST(19971.577761/8.0),
    REAL_CONST(19987.429792/8.0),
    REAL_CONST(20003.284967/8.0),
    REAL_CONST(20019.143283/8.0),
    REAL_CONST(20035.004742/8.0),
    REAL_CONST(20050.869340/8.0),
    REAL_CONST(20066.737076/8.0),
    REAL_CONST(20082.607951/8.0),
    REAL_CONST(20098.481961/8.0),
    REAL_CONST(20114.359107/8.0),
    REAL_CONST(20130.239386/8.0),
    REAL_CONST(20146.122798/8.0),
    REAL_CONST(20162.009341/8.0),
    REAL_CONST(20177.899014/8.0),
    REAL_CONST(20193.791815/8.0),
    REAL_CONST(20209.687745/8.0),
    REAL_CONST(20225.586801/8.0),
    REAL_CONST(20241.488982/8.0),
    REAL_CONST(20257.394286/8.0),
    REAL_CONST(20273.302714/8.0),
    REAL_CONST(20289.214263/8.0),
    REAL_CONST(20305.128932/8.0),
    REAL_CONST(20321.046720/8.0),
    REAL_CONST(20336.967626/8.0),
    REAL_CONST(20352.891648/8.0),
    REAL_CONST(20368.818786/8.0),
    REAL_CONST(20384.749038/8.0),
    REAL_CONST(20400.682403/8.0),
    REAL_CONST(20416.618879/8.0),
    REAL_CONST(20432.558466/8.0),
    REAL_CONST(20448.501162/8.0),
    REAL_CONST(20464.446967/8.0),
    REAL_CONST(20480.395878/8.0),
    REAL_CONST(20496.347894/8.0),
    REAL_CONST(20512.303016/8.0),
    REAL_CONST(20528.261240/8.0),
    REAL_CONST(20544.222566/8.0),
    REAL_CONST(20560.186993/8.0),
    REAL_CONST(20576.154520/8.0),
    REAL_CONST(20592.125145/8.0),
    REAL_CONST(20608.098867/8.0),
    REAL_CONST(20624.075685/8.0),
    REAL_CONST(20640.055598/8.0),
    REAL_CONST(20656.038605/8.0),
    REAL_CONST(20672.024704/8.0),
    REAL_CONST(20688.013894/8.0),
    REAL_CONST(20704.006174/8.0),
    REAL_CONST(20720.001543/8.0),
    REAL_CONST(20736.000000/8.0),
    REAL_CONST(20752.001543/8.0),
    REAL_CONST(20768.006171/8.0),
    REAL_CONST(20784.013884/8.0),
    REAL_CONST(20800.024679/8.0),
    REAL_CONST(20816.038555/8.0),
    REAL_CONST(20832.055513/8.0),
    REAL_CONST(20848.075549/8.0),
    REAL_CONST(20864.098664/8.0),
    REAL_CONST(20880.124856/8.0),
    REAL_CONST(20896.154123/8.0),
    REAL_CONST(20912.186465/8.0),
    REAL_CONST(20928.221880/8.0),
    REAL_CONST(20944.260368/8.0),
    REAL_CONST(20960.301926/8.0),
    REAL_CONST(20976.346555/8.0),
    REAL_CONST(20992.394252/8.0),
    REAL_CONST(21008.445017/8.0),
    REAL_CONST(21024.498848/8.0),
    REAL_CONST(21040.555744/8.0),
    REAL_CONST(21056.615704/8.0),
    REAL_CONST(21072.678727/8.0),
    REAL_CONST(21088.744812/8.0),
    REAL_CONST(21104.813957/8.0),
    REAL_CONST(21120.886161/8.0),
    REAL_CONST(21136.961424/8.0),
    REAL_CONST(21153.039743/8.0),
    REAL_CONST(21169.121119/8.0),
    REAL_CONST(21185.205549/8.0),
    REAL_CONST(21201.293033/8.0),
    REAL_CONST(21217.383569/8.0),
    REAL_CONST(21233.477156/8.0),
    REAL_CONST(21249.573794/8.0),
    REAL_CONST(21265.673480/8.0),
    REAL_CONST(21281.776214/8.0),
    REAL_CONST(21297.881994/8.0),
    REAL_CONST(21313.990820/8.0),
    REAL_CONST(21330.102690/8.0),
    REAL_CONST(21346.217604/8.0),
    REAL_CONST(21362.335559/8.0),
    REAL_CONST(21378.456556/8.0),
    REAL_CONST(21394.580591/8.0),
    REAL_CONST(21410.707666/8.0),
    REAL_CONST(21426.837778/8.0),
    REAL_CONST(21442.970926/8.0),
    REAL_CONST(21459.107109/8.0),
    REAL_CONST(21475.246326/8.0),
    REAL_CONST(21491.388576/8.0),
    REAL_CONST(21507.533858/8.0),
    REAL_CONST(21523.682170/8.0),
    REAL_CONST(21539.833512/8.0),
    REAL_CONST(21555.987882/8.0),
    REAL_CONST(21572.145279/8.0),
    REAL_CONST(21588.305702/8.0),
    REAL_CONST(21604.469150/8.0),
    REAL_CONST(21620.635622/8.0),
    REAL_CONST(21636.805116/8.0),
    REAL_CONST(21652.977632/8.0),
    REAL_CONST(21669.153169/8.0),
    REAL_CONST(21685.331724/8.0),
    REAL_CONST(21701.513298/8.0),
    REAL_CONST(21717.697888/8.0),
    REAL_CONST(21733.885495/8.0),
    REAL_CONST(21750.076116/8.0),
    REAL_CONST(21766.269750/8.0),
    REAL_CONST(21782.466398/8.0),
    REAL_CONST(21798.666056/8.0),
    REAL_CONST(21814.868725/8.0),
    REAL_CONST(21831.074403/8.0),
    REAL_CONST(21847.283089/8.0),
    REAL_CONST(21863.494782/8.0),
    REAL_CONST(21879.709481/8.0),
    REAL_CONST(21895.927184/8.0),
    REAL_CONST(21912.147891/8.0),
    REAL_CONST(21928.371600/8.0),
    REAL_CONST(21944.598311/8.0),
    REAL_CONST(21960.828022/8.0),
    REAL_CONST(21977.060732/8.0),
    REAL_CONST(21993.296440/8.0),
    REAL_CONST(22009.535145/8.0),
    REAL_CONST(22025.776846/8.0),
    REAL_CONST(22042.021541/8.0),
    REAL_CONST(22058.269230/8.0),
    REAL_CONST(22074.519912/8.0),
    REAL_CONST(22090.773585/8.0),
    REAL_CONST(22107.030248/8.0),
    REAL_CONST(22123.289900/8.0),
    REAL_CONST(22139.552540/8.0),
    REAL_CONST(22155.818168/8.0),
    REAL_CONST(22172.086781/8.0),
    REAL_CONST(22188.358379/8.0),
    REAL_CONST(22204.632961/8.0),
    REAL_CONST(22220.910525/8.0),
    REAL_CONST(22237.191071/8.0),
    REAL_CONST(22253.474598/8.0),
    REAL_CONST(22269.761103/8.0),
    REAL_CONST(22286.050587/8.0),
    REAL_CONST(22302.343048/8.0),
    REAL_CONST(22318.638485/8.0),
    REAL_CONST(22334.936897/8.0),
    REAL_CONST(22351.238283/8.0),
    REAL_CONST(22367.542642/8.0),
    REAL_CONST(22383.849973/8.0),
    REAL_CONST(22400.160274/8.0),
    REAL_CONST(22416.473545/8.0),
    REAL_CONST(22432.789784/8.0),
    REAL_CONST(22449.108990/8.0),
    REAL_CONST(22465.431163/8.0),
    REAL_CONST(22481.756301/8.0),
    REAL_CONST(22498.084404/8.0),
    REAL_CONST(22514.415469/8.0),
    REAL_CONST(22530.749496/8.0),
    REAL_CONST(22547.086485/8.0),
    REAL_CONST(22563.426433/8.0),
    REAL_CONST(22579.769340/8.0),
    REAL_CONST(22596.115205/8.0),
    REAL_CONST(22612.464026/8.0),
    REAL_CONST(22628.815803/8.0),
    REAL_CONST(22645.170535/8.0),
    REAL_CONST(22661.528220/8.0),
    REAL_CONST(22677.888857/8.0),
    REAL_CONST(22694.252446/8.0),
    REAL_CONST(22710.618985/8.0),
    REAL_CONST(22726.988473/8.0),
    REAL_CONST(22743.360909/8.0),
    REAL_CONST(22759.736292/8.0),
    REAL_CONST(22776.114621/8.0),
    REAL_CONST(22792.495896/8.0),
    REAL_CONST(22808.880114/8.0),
    REAL_CONST(22825.267275/8.0),
    REAL_CONST(22841.657378/8.0),
    REAL_CONST(22858.050421/8.0),
    REAL_CONST(22874.446404/8.0),
    REAL_CONST(22890.845326/8.0),
    REAL_CONST(22907.247185/8.0),
    REAL_CONST(22923.651981/8.0),
    REAL_CONST(22940.059712/8.0),
    REAL_CONST(22956.470378/8.0),
    REAL_CONST(22972.883977/8.0),
    REAL_CONST(22989.300508/8.0),
    REAL_CONST(23005.719971/8.0),
    REAL_CONST(23022.142364/8.0),
    REAL_CONST(23038.567686/8.0),
    REAL_CONST(23054.995936/8.0),
    REAL_CONST(23071.427113/8.0),
    REAL_CONST(23087.861216/8.0),
    REAL_CONST(23104.298245/8.0),
    REAL_CONST(23120.738197/8.0),
    REAL_CONST(23137.181072/8.0),
    REAL_CONST(23153.626869/8.0),
    REAL_CONST(23170.075587/8.0),
    REAL_CONST(23186.527224/8.0),
    REAL_CONST(23202.981781/8.0),
    REAL_CONST(23219.439255/8.0),
    REAL_CONST(23235.899646/8.0),
    REAL_CONST(23252.362952/8.0),
    REAL_CONST(23268.829173/8.0),
    REAL_CONST(23285.298308/8.0),
    REAL_CONST(23301.770356/8.0),
    REAL_CONST(23318.245314/8.0),
    REAL_CONST(23334.723184/8.0),
    REAL_CONST(23351.203963/8.0),
    REAL_CONST(23367.687650/8.0),
    REAL_CONST(23384.174245/8.0),
    REAL_CONST(23400.663746/8.0),
    REAL_CONST(23417.156152/8.0),
    REAL_CONST(23433.651463/8.0),
    REAL_CONST(23450.149677/8.0),
    REAL_CONST(23466.650794/8.0),
    REAL_CONST(23483.154812/8.0),
    REAL_CONST(23499.661730/8.0),
    REAL_CONST(23516.171547/8.0),
    REAL_CONST(23532.684263/8.0),
    REAL_CONST(23549.199876/8.0),
    REAL_CONST(23565.718385/8.0),
    REAL_CONST(23582.239789/8.0),
    REAL_CONST(23598.764087/8.0),
    REAL_CONST(23615.291279/8.0),
    REAL_CONST(23631.821363/8.0),
    REAL_CONST(23648.354338/8.0),
    REAL_CONST(23664.890203/8.0),
    REAL_CONST(23681.428957/8.0),
    REAL_CONST(23697.970599/8.0),
    REAL_CONST(23714.515128/8.0),
    REAL_CONST(23731.062544/8.0),
    REAL_CONST(23747.612844/8.0),
    REAL_CONST(23764.166029/8.0),
    REAL_CONST(23780.722096/8.0),
    REAL_CONST(23797.281046/8.0),
    REAL_CONST(23813.842877/8.0),
    REAL_CONST(23830.407588/8.0),
    REAL_CONST(23846.975178/8.0),
    REAL_CONST(23863.545646/8.0),
    REAL_CONST(23880.118991/8.0),
    REAL_CONST(23896.695212/8.0),
    REAL_CONST(23913.274308/8.0),
    REAL_CONST(23929.856278/8.0),
    REAL_CONST(23946.441122/8.0),
    REAL_CONST(23963.028837/8.0),
    REAL_CONST(23979.619424/8.0),
    REAL_CONST(23996.212880/8.0),
    REAL_CONST(24012.809206/8.0),
    REAL_CONST(24029.408400/8.0),
    REAL_CONST(24046.010461/8.0),
    REAL_CONST(24062.615388/8.0),
    REAL_CONST(24079.223180/8.0),
    REAL_CONST(24095.833837/8.0),
    REAL_CONST(24112.447356/8.0),
    REAL_CONST(24129.063738/8.0),
    REAL_CONST(24145.682981/8.0),
    REAL_CONST(24162.305084/8.0),
    REAL_CONST(24178.930046/8.0),
    REAL_CONST(24195.557867/8.0),
    REAL_CONST(24212.188545/8.0),
    REAL_CONST(24228.822079/8.0),
    REAL_CONST(24245.458468/8.0),
    REAL_CONST(24262.097712/8.0),
    REAL_CONST(24278.739809/8.0),
    REAL_CONST(24295.384759/8.0),
    REAL_CONST(24312.032559/8.0),
    REAL_CONST(24328.683211/8.0),
    REAL_CONST(24345.336711/8.0),
    REAL_CONST(24361.993060/8.0),
    REAL_CONST(24378.652257/8.0),
    REAL_CONST(24395.314300/8.0),
    REAL_CONST(24411.979189/8.0),
    REAL_CONST(24428.646922/8.0),
    REAL_CONST(24445.317499/8.0),
    REAL_CONST(24461.990918/8.0),
    REAL_CONST(24478.667179/8.0),
    REAL_CONST(24495.346281/8.0),
    REAL_CONST(24512.028223/8.0),
    REAL_CONST(24528.713003/8.0),
    REAL_CONST(24545.400621/8.0),
    REAL_CONST(24562.091076/8.0),
    REAL_CONST(24578.784367/8.0),
    REAL_CONST(24595.480492/8.0),
    REAL_CONST(24612.179452/8.0),
    REAL_CONST(24628.881244/8.0),
    REAL_CONST(24645.585869/8.0),
    REAL_CONST(24662.293325/8.0),
    REAL_CONST(24679.003610/8.0),
    REAL_CONST(24695.716725/8.0),
    REAL_CONST(24712.432668/8.0),
    REAL_CONST(24729.151438/8.0),
    REAL_CONST(24745.873035/8.0),
    REAL_CONST(24762.597457/8.0),
    REAL_CONST(24779.324703/8.0),
    REAL_CONST(24796.054772/8.0),
    REAL_CONST(24812.787665/8.0),
    REAL_CONST(24829.523378/8.0),
    REAL_CONST(24846.261912/8.0),
    REAL_CONST(24863.003266/8.0),
    REAL_CONST(24879.747438/8.0),
    REAL_CONST(24896.494428/8.0),
    REAL_CONST(24913.244235/8.0),
    REAL_CONST(24929.996857/8.0),
    REAL_CONST(24946.752295/8.0),
    REAL_CONST(24963.510546/8.0),
    REAL_CONST(24980.271610/8.0),
    REAL_CONST(24997.035487/8.0),
    REAL_CONST(25013.802174/8.0),
    REAL_CONST(25030.571672/8.0),
    REAL_CONST(25047.343978/8.0),
    REAL_CONST(25064.119093/8.0),
    REAL_CONST(25080.897016/8.0),
    REAL_CONST(25097.677744/8.0),
    REAL_CONST(25114.461279/8.0),
    REAL_CONST(25131.247617/8.0),
    REAL_CONST(25148.036759/8.0),
    REAL_CONST(25164.828704/8.0),
    REAL_CONST(25181.623451/8.0),
    REAL_CONST(25198.420998/8.0),
    REAL_CONST(25215.221345/8.0),
    REAL_CONST(25232.024491/8.0),
    REAL_CONST(25248.830435/8.0),
    REAL_CONST(25265.639176/8.0),
    REAL_CONST(25282.450713/8.0),
    REAL_CONST(25299.265045/8.0),
    REAL_CONST(25316.082172/8.0),
    REAL_CONST(25332.902091/8.0),
    REAL_CONST(25349.724804/8.0),
    REAL_CONST(25366.550307/8.0),
    REAL_CONST(25383.378601/8.0),
    REAL_CONST(25400.209685/8.0),
    REAL_CONST(25417.043558/8.0),
    REAL_CONST(25433.880218/8.0),
    REAL_CONST(25450.719665/8.0),
    REAL_CONST(25467.561898/8.0),
    REAL_CONST(25484.406916/8.0),
    REAL_CONST(25501.254718/8.0),
    REAL_CONST(25518.105303/8.0),
    REAL_CONST(25534.958670/8.0),
    REAL_CONST(25551.814819/8.0),
    REAL_CONST(25568.673748/8.0),
    REAL_CONST(25585.535457/8.0),
    REAL_CONST(25602.399944/8.0),
    REAL_CONST(25619.267209/8.0),
    REAL_CONST(25636.137250/8.0),
    REAL_CONST(25653.010067/8.0),
    REAL_CONST(25669.885660/8.0),
    REAL_CONST(25686.764026/8.0),
    REAL_CONST(25703.645165/8.0),
    REAL_CONST(25720.529077/8.0),
    REAL_CONST(25737.415759/8.0),
    REAL_CONST(25754.305213/8.0),
    REAL_CONST(25771.197435/8.0),
    REAL_CONST(25788.092426/8.0),
    REAL_CONST(25804.990185/8.0),
    REAL_CONST(25821.890710/8.0),
    REAL_CONST(25838.794002/8.0),
    REAL_CONST(25855.700058/8.0),
    REAL_CONST(25872.608878/8.0),
    REAL_CONST(25889.520461/8.0),
    REAL_CONST(25906.434807/8.0),
    REAL_CONST(25923.351914/8.0),
    REAL_CONST(25940.271781/8.0),
    REAL_CONST(25957.194407/8.0),
    REAL_CONST(25974.119793/8.0),
    REAL_CONST(25991.047936/8.0),
    REAL_CONST(26007.978835/8.0),
    REAL_CONST(26024.912491/8.0),
    REAL_CONST(26041.848902/8.0),
    REAL_CONST(26058.788067/8.0),
    REAL_CONST(26075.729985/8.0),
    REAL_CONST(26092.674655/8.0),
    REAL_CONST(26109.622077/8.0),
    REAL_CONST(26126.572249/8.0),
    REAL_CONST(26143.525171/8.0),
    REAL_CONST(26160.480842/8.0),
    REAL_CONST(26177.439260/8.0),
    REAL_CONST(26194.400426/8.0),
    REAL_CONST(26211.364337/8.0),
    REAL_CONST(26228.330994/8.0),
    REAL_CONST(26245.300395/8.0),
    REAL_CONST(26262.272540/8.0),
    REAL_CONST(26279.247427/8.0),
    REAL_CONST(26296.225056/8.0),
    REAL_CONST(26313.205425/8.0),
    REAL_CONST(26330.188534/8.0),
    REAL_CONST(26347.174383/8.0),
    REAL_CONST(26364.162969/8.0),
    REAL_CONST(26381.154293/8.0),
    REAL_CONST(26398.148353/8.0),
    REAL_CONST(26415.145148/8.0),
    REAL_CONST(26432.144678/8.0),
    REAL_CONST(26449.146942/8.0),
    REAL_CONST(26466.151939/8.0),
    REAL_CONST(26483.159667/8.0),
    REAL_CONST(26500.170127/8.0),
    REAL_CONST(26517.183317/8.0),
    REAL_CONST(26534.199236/8.0),
    REAL_CONST(26551.217883/8.0),
    REAL_CONST(26568.239258/8.0),
    REAL_CONST(26585.263360/8.0),
    REAL_CONST(26602.290188/8.0),
    REAL_CONST(26619.319740/8.0),
    REAL_CONST(26636.352017/8.0),
    REAL_CONST(26653.387017/8.0),
    REAL_CONST(26670.424739/8.0),
    REAL_CONST(26687.465183/8.0),
    REAL_CONST(26704.508347/8.0),
    REAL_CONST(26721.554231/8.0),
    REAL_CONST(26738.602834/8.0),
    REAL_CONST(26755.654154/8.0),
    REAL_CONST(26772.708192/8.0),
    REAL_CONST(26789.764947/8.0),
    REAL_CONST(26806.824416/8.0),
    REAL_CONST(26823.886600/8.0),
    REAL_CONST(26840.951498/8.0),
    REAL_CONST(26858.019109/8.0),
    REAL_CONST(26875.089431/8.0),
    REAL_CONST(26892.162465/8.0),
    REAL_CONST(26909.238209/8.0),
    REAL_CONST(26926.316662/8.0),
    REAL_CONST(26943.397823/8.0),
    REAL_CONST(26960.481693/8.0),
    REAL_CONST(26977.568269/8.0),
    REAL_CONST(26994.657551/8.0),
    REAL_CONST(27011.749538/8.0),
    REAL_CONST(27028.844229/8.0),
    REAL_CONST(27045.941624/8.0),
    REAL_CONST(27063.041721/8.0),
    REAL_CONST(27080.144520/8.0),
    REAL_CONST(27097.250020/8.0),
    REAL_CONST(27114.358219/8.0),
    REAL_CONST(27131.469118/8.0),
    REAL_CONST(27148.582715/8.0),
    REAL_CONST(27165.699009/8.0),
    REAL_CONST(27182.818000/8.0),
    REAL_CONST(27199.939687/8.0),
    REAL_CONST(27217.064068/8.0),
    REAL_CONST(27234.191144/8.0),
    REAL_CONST(27251.320912/8.0),
    REAL_CONST(27268.453373/8.0),
    REAL_CONST(27285.588525/8.0),
    REAL_CONST(27302.726368/8.0),
    REAL_CONST(27319.866901/8.0),
    REAL_CONST(27337.010122/8.0),
    REAL_CONST(27354.156032/8.0),
    REAL_CONST(27371.304629/8.0),
    REAL_CONST(27388.455912/8.0),
    REAL_CONST(27405.609881/8.0),
    REAL_CONST(27422.766535/8.0),
    REAL_CONST(27439.925872/8.0),
    REAL_CONST(27457.087893/8.0),
    REAL_CONST(27474.252595/8.0),
    REAL_CONST(27491.419979/8.0),
    REAL_CONST(27508.590044/8.0),
    REAL_CONST(27525.762788/8.0),
    REAL_CONST(27542.938211/8.0),
    REAL_CONST(27560.116312/8.0),
    REAL_CONST(27577.297090/8.0),
    REAL_CONST(27594.480545/8.0),
    REAL_CONST(27611.666675/8.0),
    REAL_CONST(27628.855480/8.0),
    REAL_CONST(27646.046959/8.0),
    REAL_CONST(27663.241110/8.0),
    REAL_CONST(27680.437934/8.0),
    REAL_CONST(27697.637429/8.0),
    REAL_CONST(27714.839595/8.0),
    REAL_CONST(27732.044430/8.0),
    REAL_CONST(27749.251934/8.0),
    REAL_CONST(27766.462107/8.0),
    REAL_CONST(27783.674946/8.0),
    REAL_CONST(27800.890452/8.0),
    REAL_CONST(27818.108624/8.0),
    REAL_CONST(27835.329460/8.0),
    REAL_CONST(27852.552960/8.0),
    REAL_CONST(27869.779123/8.0),
    REAL_CONST(27887.007948/8.0),
    REAL_CONST(27904.239435/8.0),
    REAL_CONST(27921.473583/8.0),
    REAL_CONST(27938.710390/8.0),
    REAL_CONST(27955.949856/8.0),
    REAL_CONST(27973.191981/8.0),
    REAL_CONST(27990.436763/8.0),
    REAL_CONST(28007.684201/8.0),
    REAL_CONST(28024.934295/8.0),
    REAL_CONST(28042.187044/8.0),
    REAL_CONST(28059.442447/8.0),
    REAL_CONST(28076.700503/8.0),
    REAL_CONST(28093.961211/8.0),
    REAL_CONST(28111.224571/8.0),
    REAL_CONST(28128.490582/8.0),
    REAL_CONST(28145.759243/8.0),
    REAL_CONST(28163.030554/8.0),
    REAL_CONST(28180.304512/8.0),
    REAL_CONST(28197.581118/8.0),
    REAL_CONST(28214.860371/8.0),
    REAL_CONST(28232.142270/8.0),
    REAL_CONST(28249.426814/8.0),
    REAL_CONST(28266.714002/8.0),
    REAL_CONST(28284.003834/8.0),
    REAL_CONST(28301.296308/8.0),
    REAL_CONST(28318.591424/8.0),
    REAL_CONST(28335.889182/8.0),
    REAL_CONST(28353.189579/8.0),
    REAL_CONST(28370.492617/8.0),
    REAL_CONST(28387.798292/8.0),
    REAL_CONST(28405.106606/8.0),
    REAL_CONST(28422.417557/8.0),
    REAL_CONST(28439.731144/8.0),
    REAL_CONST(28457.047366/8.0),
    REAL_CONST(28474.366223/8.0),
    REAL_CONST(28491.687714/8.0),
    REAL_CONST(28509.011838/8.0),
    REAL_CONST(28526.338594/8.0),
    REAL_CONST(28543.667982/8.0),
    REAL_CONST(28561.000000/8.0),
    REAL_CONST(28578.334648/8.0),
    REAL_CONST(28595.671925/8.0),
    REAL_CONST(28613.011831/8.0),
    REAL_CONST(28630.354364/8.0),
    REAL_CONST(28647.699523/8.0),
    REAL_CONST(28665.047309/8.0),
    REAL_CONST(28682.397719/8.0),
    REAL_CONST(28699.750754/8.0),
    REAL_CONST(28717.106412/8.0),
    REAL_CONST(28734.464693/8.0),
    REAL_CONST(28751.825596/8.0),
    REAL_CONST(28769.189120/8.0),
    REAL_CONST(28786.555264/8.0),
    REAL_CONST(28803.924028/8.0),
    REAL_CONST(28821.295410/8.0),
    REAL_CONST(28838.669411/8.0),
    REAL_CONST(28856.046028/8.0),
    REAL_CONST(28873.425262/8.0),
    REAL_CONST(28890.807112/8.0),
    REAL_CONST(28908.191576/8.0),
    REAL_CONST(28925.578655/8.0),
    REAL_CONST(28942.968346/8.0),
    REAL_CONST(28960.360650/8.0),
    REAL_CONST(28977.755566/8.0),
    REAL_CONST(28995.153093/8.0),
    REAL_CONST(29012.553229/8.0),
    REAL_CONST(29029.955975/8.0),
    REAL_CONST(29047.361330/8.0),
    REAL_CONST(29064.769292/8.0),
    REAL_CONST(29082.179861/8.0),
    REAL_CONST(29099.593037/8.0),
    REAL_CONST(29117.008817/8.0),
    REAL_CONST(29134.427203/8.0),
    REAL_CONST(29151.848192/8.0),
    REAL_CONST(29169.271784/8.0),
    REAL_CONST(29186.697979/8.0),
    REAL_CONST(29204.126775/8.0),
    REAL_CONST(29221.558172/8.0),
    REAL_CONST(29238.992168/8.0),
    REAL_CONST(29256.428764/8.0),
    REAL_CONST(29273.867959/8.0),
    REAL_CONST(29291.309750/8.0),
    REAL_CONST(29308.754139/8.0),
    REAL_CONST(29326.201124/8.0),
    REAL_CONST(29343.650704/8.0),
    REAL_CONST(29361.102879/8.0),
    REAL_CONST(29378.557648/8.0),
    REAL_CONST(29396.015009/8.0),
    REAL_CONST(29413.474963/8.0),
    REAL_CONST(29430.937508/8.0),
    REAL_CONST(29448.402644/8.0),
    REAL_CONST(29465.870370/8.0),
    REAL_CONST(29483.340685/8.0),
    REAL_CONST(29500.813588/8.0),
    REAL_CONST(29518.289079/8.0),
    REAL_CONST(29535.767157/8.0),
    REAL_CONST(29553.247821/8.0),
    REAL_CONST(29570.731070/8.0),
    REAL_CONST(29588.216904/8.0),
    REAL_CONST(29605.705322/8.0),
    REAL_CONST(29623.196322/8.0),
    REAL_CONST(29640.689905/8.0),
    REAL_CONST(29658.186070/8.0),
    REAL_CONST(29675.684815/8.0),
    REAL_CONST(29693.186140/8.0),
    REAL_CONST(29710.690044/8.0),
    REAL_CONST(29728.196527/8.0),
    REAL_CONST(29745.705588/8.0),
    REAL_CONST(29763.217225/8.0),
    REAL_CONST(29780.731439/8.0),
    REAL_CONST(29798.248228/8.0),
    REAL_CONST(29815.767592/8.0),
    REAL_CONST(29833.289529/8.0),
    REAL_CONST(29850.814040/8.0),
    REAL_CONST(29868.341123/8.0),
    REAL_CONST(29885.870778/8.0),
    REAL_CONST(29903.403004/8.0),
    REAL_CONST(29920.937800/8.0),
    REAL_CONST(29938.475165/8.0),
    REAL_CONST(29956.015099/8.0),
    REAL_CONST(29973.557601/8.0),
    REAL_CONST(29991.102670/8.0),
    REAL_CONST(30008.650306/8.0),
    REAL_CONST(30026.200506/8.0),
    REAL_CONST(30043.753272/8.0),
    REAL_CONST(30061.308602/8.0),
    REAL_CONST(30078.866496/8.0),
    REAL_CONST(30096.426952/8.0),
    REAL_CONST(30113.989970/8.0),
    REAL_CONST(30131.555549/8.0),
    REAL_CONST(30149.123688/8.0),
    REAL_CONST(30166.694387/8.0),
    REAL_CONST(30184.267645/8.0),
    REAL_CONST(30201.843461/8.0),
    REAL_CONST(30219.421835/8.0),
    REAL_CONST(30237.002765/8.0),
    REAL_CONST(30254.586251/8.0),
    REAL_CONST(30272.172293/8.0),
    REAL_CONST(30289.760889/8.0),
    REAL_CONST(30307.352038/8.0),
    REAL_CONST(30324.945741/8.0),
    REAL_CONST(30342.541995/8.0),
    REAL_CONST(30360.140801/8.0),
    REAL_CONST(30377.742158/8.0),
    REAL_CONST(30395.346065/8.0),
    REAL_CONST(30412.952521/8.0),
    REAL_CONST(30430.561526/8.0),
    REAL_CONST(30448.173078/8.0),
    REAL_CONST(30465.787178/8.0),
    REAL_CONST(30483.403824/8.0),
    REAL_CONST(30501.023015/8.0),
    REAL_CONST(30518.644751/8.0),
    REAL_CONST(30536.269031/8.0),
    REAL_CONST(30553.895855/8.0),
    REAL_CONST(30571.525221/8.0),
    REAL_CONST(30589.157130/8.0),
    REAL_CONST(30606.791579/8.0),
    REAL_CONST(30624.428569/8.0),
    REAL_CONST(30642.068098/8.0),
    REAL_CONST(30659.710167/8.0),
    REAL_CONST(30677.354774/8.0),
    REAL_CONST(30695.001918/8.0),
    REAL_CONST(30712.651599/8.0),
    REAL_CONST(30730.303816/8.0),
    REAL_CONST(30747.958568/8.0),
    REAL_CONST(30765.615855/8.0),
    REAL_CONST(30783.275676/8.0),
    REAL_CONST(30800.938030/8.0),
    REAL_CONST(30818.602917/8.0),
    REAL_CONST(30836.270335/8.0),
    REAL_CONST(30853.940284/8.0),
    REAL_CONST(30871.612763/8.0),
    REAL_CONST(30889.287772/8.0),
    REAL_CONST(30906.965310/8.0),
    REAL_CONST(30924.645376/8.0),
    REAL_CONST(30942.327969/8.0),
    REAL_CONST(30960.013089/8.0),
    REAL_CONST(30977.700734/8.0),
    REAL_CONST(30995.390905/8.0),
    REAL_CONST(31013.083600/8.0),
    REAL_CONST(31030.778819/8.0),
    REAL_CONST(31048.476561/8.0),
    REAL_CONST(31066.176826/8.0),
    REAL_CONST(31083.879612/8.0),
    REAL_CONST(31101.584918/8.0),
    REAL_CONST(31119.292745/8.0),
    REAL_CONST(31137.003092/8.0),
    REAL_CONST(31154.715957/8.0),
    REAL_CONST(31172.431340/8.0),
    REAL_CONST(31190.149240/8.0),
    REAL_CONST(31207.869657/8.0),
    REAL_CONST(31225.592590/8.0),
    REAL_CONST(31243.318038/8.0),
    REAL_CONST(31261.046000/8.0),
    REAL_CONST(31278.776476/8.0),
    REAL_CONST(31296.509466/8.0),
    REAL_CONST(31314.244967/8.0),
    REAL_CONST(31331.982980/8.0),
    REAL_CONST(31349.723504/8.0),
    REAL_CONST(31367.466538/8.0),
    REAL_CONST(31385.212081/8.0),
    REAL_CONST(31402.960133/8.0),
    REAL_CONST(31420.710693/8.0),
    REAL_CONST(31438.463761/8.0),
    REAL_CONST(31456.219335/8.0),
    REAL_CONST(31473.977415/8.0),
    REAL_CONST(31491.738000/8.0),
    REAL_CONST(31509.501090/8.0),
    REAL_CONST(31527.266683/8.0),
    REAL_CONST(31545.034780/8.0),
    REAL_CONST(31562.805379/8.0),
    REAL_CONST(31580.578479/8.0),
    REAL_CONST(31598.354081/8.0),
    REAL_CONST(31616.132183/8.0),
    REAL_CONST(31633.912784/8.0),
    REAL_CONST(31651.695884/8.0),
    REAL_CONST(31669.481483/8.0),
    REAL_CONST(31687.269579/8.0),
    REAL_CONST(31705.060171/8.0),
    REAL_CONST(31722.853260/8.0),
    REAL_CONST(31740.648844/8.0),
    REAL_CONST(31758.446922/8.0),
    REAL_CONST(31776.247495/8.0),
    REAL_CONST(31794.050561/8.0),
    REAL_CONST(31811.856119/8.0),
    REAL_CONST(31829.664169/8.0),
    REAL_CONST(31847.474711/8.0),
    REAL_CONST(31865.287743/8.0),
    REAL_CONST(31883.103264/8.0),
    REAL_CONST(31900.921275/8.0),
    REAL_CONST(31918.741774/8.0),
    REAL_CONST(31936.564761/8.0),
    REAL_CONST(31954.390235/8.0),
    REAL_CONST(31972.218195/8.0),
    REAL_CONST(31990.048640/8.0),
    REAL_CONST(32007.881571/8.0),
    REAL_CONST(32025.716986/8.0),
    REAL_CONST(32043.554884/8.0),
    REAL_CONST(32061.395265/8.0),
    REAL_CONST(32079.238128/8.0),
    REAL_CONST(32097.083473/8.0),
    REAL_CONST(32114.931298/8.0),
    REAL_CONST(32132.781604/8.0),
    REAL_CONST(32150.634389/8.0),
    REAL_CONST(32168.489652/8.0),
    REAL_CONST(32186.347394/8.0),
    REAL_CONST(32204.207613/8.0),
    REAL_CONST(32222.070309/8.0),
    REAL_CONST(32239.935480/8.0),
    REAL_CONST(32257.803127/8.0),
    REAL_CONST(32275.673248/8.0),
    REAL_CONST(32293.545843/8.0),
    REAL_CONST(32311.420912/8.0),
    REAL_CONST(32329.298453/8.0),
    REAL_CONST(32347.178465/8.0),
    REAL_CONST(32365.060949/8.0),
    REAL_CONST(32382.945904/8.0),
    REAL_CONST(32400.833328/8.0),
    REAL_CONST(32418.723221/8.0),
    REAL_CONST(32436.615583/8.0),
    REAL_CONST(32454.510412/8.0),
    REAL_CONST(32472.407709/8.0),
    REAL_CONST(32490.307472/8.0),
    REAL_CONST(32508.209700/8.0),
    REAL_CONST(32526.114394/8.0),
    REAL_CONST(32544.021552/8.0),
    REAL_CONST(32561.931174/8.0),
    REAL_CONST(32579.843258/8.0),
    REAL_CONST(32597.757805/8.0),
    REAL_CONST(32615.674814/8.0),
    REAL_CONST(32633.594283/8.0),
    REAL_CONST(32651.516213/8.0),
    REAL_CONST(32669.440602/8.0),
    REAL_CONST(32687.367451/8.0),
    REAL_CONST(32705.296757/8.0),
    REAL_CONST(32723.228522/8.0),
    REAL_CONST(32741.162743/8.0),
    REAL_CONST(32759.099420/8.0),
    REAL_CONST(32777.038553/8.0),
    REAL_CONST(32794.980141/8.0),
    REAL_CONST(32812.924183/8.0),
    REAL_CONST(32830.870678/8.0),
    REAL_CONST(32848.819627/8.0),
    REAL_CONST(32866.771027/8.0),
    REAL_CONST(32884.724879/8.0),
    REAL_CONST(32902.681183/8.0),
    REAL_CONST(32920.639936/8.0),
    REAL_CONST(32938.601139/8.0),
    REAL_CONST(32956.564790/8.0),
    REAL_CONST(32974.530890/8.0),
    REAL_CONST(32992.499438/8.0),
    REAL_CONST(33010.470432/8.0),
    REAL_CONST(33028.443872/8.0),
    REAL_CONST(33046.419758/8.0),
    REAL_CONST(33064.398089/8.0),
    REAL_CONST(33082.378864/8.0),
    REAL_CONST(33100.362083/8.0),
    REAL_CONST(33118.347744/8.0),
    REAL_CONST(33136.335848/8.0),
    REAL_CONST(33154.326393/8.0),
    REAL_CONST(33172.319379/8.0),
    REAL_CONST(33190.314806/8.0),
    REAL_CONST(33208.312671/8.0),
    REAL_CONST(33226.312976/8.0),
    REAL_CONST(33244.315719/8.0),
    REAL_CONST(33262.320900/8.0),
    REAL_CONST(33280.328517/8.0),
    REAL_CONST(33298.338571/8.0),
    REAL_CONST(33316.351061/8.0),
    REAL_CONST(33334.365985/8.0),
    REAL_CONST(33352.383344/8.0),
    REAL_CONST(33370.403136/8.0),
    REAL_CONST(33388.425361/8.0),
    REAL_CONST(33406.450019/8.0),
    REAL_CONST(33424.477108/8.0),
    REAL_CONST(33442.506628/8.0),
    REAL_CONST(33460.538579/8.0),
    REAL_CONST(33478.572959/8.0),
    REAL_CONST(33496.609768/8.0),
    REAL_CONST(33514.649006/8.0),
    REAL_CONST(33532.690671/8.0),
    REAL_CONST(33550.734764/8.0),
    REAL_CONST(33568.781282/8.0),
    REAL_CONST(33586.830227/8.0),
    REAL_CONST(33604.881597/8.0),
    REAL_CONST(33622.935391/8.0),
    REAL_CONST(33640.991609/8.0),
    REAL_CONST(33659.050250/8.0),
    REAL_CONST(33677.111314/8.0),
    REAL_CONST(33695.174800/8.0),
    REAL_CONST(33713.240707/8.0),
    REAL_CONST(33731.309034/8.0),
    REAL_CONST(33749.379781/8.0),
    REAL_CONST(33767.452948/8.0),
    REAL_CONST(33785.528533/8.0),
    REAL_CONST(33803.606536/8.0),
    REAL_CONST(33821.686957/8.0),
    REAL_CONST(33839.769794/8.0),
    REAL_CONST(33857.855047/8.0),
    REAL_CONST(33875.942716/8.0),
    REAL_CONST(33894.032799/8.0),
    REAL_CONST(33912.125297/8.0),
    REAL_CONST(33930.220207/8.0),
    REAL_CONST(33948.317531/8.0),
    REAL_CONST(33966.417267/8.0),
    REAL_CONST(33984.519415/8.0),
    REAL_CONST(34002.623973/8.0),
    REAL_CONST(34020.730941/8.0),
    REAL_CONST(34038.840320/8.0),
    REAL_CONST(34056.952107/8.0),
    REAL_CONST(34075.066302/8.0),
    REAL_CONST(34093.182905/8.0),
    REAL_CONST(34111.301916/8.0),
    REAL_CONST(34129.423332/8.0),
    REAL_CONST(34147.547155/8.0),
    REAL_CONST(34165.673382/8.0),
    REAL_CONST(34183.802014/8.0),
    REAL_CONST(34201.933050/8.0),
    REAL_CONST(34220.066489/8.0),
    REAL_CONST(34238.202330/8.0),
    REAL_CONST(34256.340574/8.0),
    REAL_CONST(34274.481219/8.0),
    REAL_CONST(34292.624264/8.0),
    REAL_CONST(34310.769710/8.0),
    REAL_CONST(34328.917555/8.0),
    REAL_CONST(34347.067799/8.0),
    REAL_CONST(34365.220440/8.0),
    REAL_CONST(34383.375480/8.0),
    REAL_CONST(34401.532916/8.0),
    REAL_CONST(34419.692748/8.0),
    REAL_CONST(34437.854976/8.0),
    REAL_CONST(34456.019599/8.0),
    REAL_CONST(34474.186617/8.0),
    REAL_CONST(34492.356028/8.0),
    REAL_CONST(34510.527832/8.0),
    REAL_CONST(34528.702029/8.0),
    REAL_CONST(34546.878617/8.0),
    REAL_CONST(34565.057596/8.0),
    REAL_CONST(34583.238967/8.0),
    REAL_CONST(34601.422727/8.0),
    REAL_CONST(34619.608876/8.0),
    REAL_CONST(34637.797414/8.0),
    REAL_CONST(34655.988340/8.0),
    REAL_CONST(34674.181653/8.0),
    REAL_CONST(34692.377354/8.0),
    REAL_CONST(34710.575440/8.0),
    REAL_CONST(34728.775912/8.0),
    REAL_CONST(34746.978769/8.0),
    REAL_CONST(34765.184010/8.0),
    REAL_CONST(34783.391635/8.0),
    REAL_CONST(34801.601643/8.0),
    REAL_CONST(34819.814033/8.0),
    REAL_CONST(34838.028805/8.0),
    REAL_CONST(34856.245958/8.0),
    REAL_CONST(34874.465492/8.0),
    REAL_CONST(34892.687406/8.0),
    REAL_CONST(34910.911699/8.0),
    REAL_CONST(34929.138371/8.0),
    REAL_CONST(34947.367421/8.0),
    REAL_CONST(34965.598848/8.0),
    REAL_CONST(34983.832652/8.0),
    REAL_CONST(35002.068832/8.0),
    REAL_CONST(35020.307388/8.0),
    REAL_CONST(35038.548319/8.0),
    REAL_CONST(35056.791624/8.0),
    REAL_CONST(35075.037303/8.0),
    REAL_CONST(35093.285355/8.0),
    REAL_CONST(35111.535779/8.0),
    REAL_CONST(35129.788576/8.0),
    REAL_CONST(35148.043743/8.0),
    REAL_CONST(35166.301282/8.0),
    REAL_CONST(35184.561190/8.0),
    REAL_CONST(35202.823468/8.0),
    REAL_CONST(35221.088114/8.0),
    REAL_CONST(35239.355129/8.0),
    REAL_CONST(35257.624511/8.0),
    REAL_CONST(35275.896260/8.0),
    REAL_CONST(35294.170376/8.0),
    REAL_CONST(35312.446857/8.0),
    REAL_CONST(35330.725704/8.0),
    REAL_CONST(35349.006915/8.0),
    REAL_CONST(35367.290490/8.0),
    REAL_CONST(35385.576428/8.0),
    REAL_CONST(35403.864729/8.0),
    REAL_CONST(35422.155392/8.0),
    REAL_CONST(35440.448416/8.0),
    REAL_CONST(35458.743801/8.0),
    REAL_CONST(35477.041547/8.0),
    REAL_CONST(35495.341652/8.0),
    REAL_CONST(35513.644116/8.0),
    REAL_CONST(35531.948938/8.0),
    REAL_CONST(35550.256119/8.0),
    REAL_CONST(35568.565656/8.0),
    REAL_CONST(35586.877550/8.0),
    REAL_CONST(35605.191800/8.0),
    REAL_CONST(35623.508406/8.0),
    REAL_CONST(35641.827366/8.0),
    REAL_CONST(35660.148681/8.0),
    REAL_CONST(35678.472348/8.0),
    REAL_CONST(35696.798369/8.0),
    REAL_CONST(35715.126743/8.0),
    REAL_CONST(35733.457468/8.0),
    REAL_CONST(35751.790544/8.0),
    REAL_CONST(35770.125971/8.0),
    REAL_CONST(35788.463747/8.0),
    REAL_CONST(35806.803873/8.0),
    REAL_CONST(35825.146348/8.0),
    REAL_CONST(35843.491171/8.0),
    REAL_CONST(35861.838341/8.0),
    REAL_CONST(35880.187859/8.0),
    REAL_CONST(35898.539722/8.0),
    REAL_CONST(35916.893932/8.0),
    REAL_CONST(35935.250487/8.0),
    REAL_CONST(35953.609386/8.0),
    REAL_CONST(35971.970629/8.0),
    REAL_CONST(35990.334215/8.0),
    REAL_CONST(36008.700144/8.0),
    REAL_CONST(36027.068415/8.0),
    REAL_CONST(36045.439028/8.0),
    REAL_CONST(36063.811982/8.0),
    REAL_CONST(36082.187276/8.0),
    REAL_CONST(36100.564910/8.0),
    REAL_CONST(36118.944883/8.0),
    REAL_CONST(36137.327195/8.0),
    REAL_CONST(36155.711844/8.0),
    REAL_CONST(36174.098831/8.0),
    REAL_CONST(36192.488155/8.0),
    REAL_CONST(36210.879815/8.0),
    REAL_CONST(36229.273811/8.0),
    REAL_CONST(36247.670141/8.0),
    REAL_CONST(36266.068806/8.0),
    REAL_CONST(36284.469805/8.0),
    REAL_CONST(36302.873137/8.0),
    REAL_CONST(36321.278801/8.0),
    REAL_CONST(36339.686798/8.0),
    REAL_CONST(36358.097126/8.0),
    REAL_CONST(36376.509785/8.0),
    REAL_CONST(36394.924775/8.0),
    REAL_CONST(36413.342094/8.0),
    REAL_CONST(36431.761742/8.0),
    REAL_CONST(36450.183718/8.0),
    REAL_CONST(36468.608023/8.0),
    REAL_CONST(36487.034654/8.0),
    REAL_CONST(36505.463613/8.0),
    REAL_CONST(36523.894898/8.0),
    REAL_CONST(36542.328508/8.0),
    REAL_CONST(36560.764443/8.0),
    REAL_CONST(36579.202703/8.0),
    REAL_CONST(36597.643286/8.0),
    REAL_CONST(36616.086193/8.0),
    REAL_CONST(36634.531422/8.0),
    REAL_CONST(36652.978974/8.0),
    REAL_CONST(36671.428847/8.0),
    REAL_CONST(36689.881040/8.0),
    REAL_CONST(36708.335554/8.0),
    REAL_CONST(36726.792388/8.0),
    REAL_CONST(36745.251541/8.0),
    REAL_CONST(36763.713012/8.0),
    REAL_CONST(36782.176802/8.0),
    REAL_CONST(36800.642909/8.0),
    REAL_CONST(36819.111332/8.0),
    REAL_CONST(36837.582072/8.0),
    REAL_CONST(36856.055127/8.0),
    REAL_CONST(36874.530498/8.0),
    REAL_CONST(36893.008183/8.0),
    REAL_CONST(36911.488182/8.0),
    REAL_CONST(36929.970494/8.0),
    REAL_CONST(36948.455119/8.0),
    REAL_CONST(36966.942056/8.0),
    REAL_CONST(36985.431305/8.0),
    REAL_CONST(37003.922865/8.0),
    REAL_CONST(37022.416735/8.0),
    REAL_CONST(37040.912915/8.0),
    REAL_CONST(37059.411404/8.0),
    REAL_CONST(37077.912202/8.0),
    REAL_CONST(37096.415309/8.0),
    REAL_CONST(37114.920722/8.0),
    REAL_CONST(37133.428443/8.0),
    REAL_CONST(37151.938470/8.0),
    REAL_CONST(37170.450803/8.0),
    REAL_CONST(37188.965441/8.0),
    REAL_CONST(37207.482384/8.0),
    REAL_CONST(37226.001631/8.0),
    REAL_CONST(37244.523182/8.0),
    REAL_CONST(37263.047035/8.0),
    REAL_CONST(37281.573191/8.0),
    REAL_CONST(37300.101648/8.0),
    REAL_CONST(37318.632407/8.0),
    REAL_CONST(37337.165467/8.0),
    REAL_CONST(37355.700827/8.0),
    REAL_CONST(37374.238486/8.0),
    REAL_CONST(37392.778444/8.0),
    REAL_CONST(37411.320701/8.0),
    REAL_CONST(37429.865255/8.0),
    REAL_CONST(37448.412107/8.0),
    REAL_CONST(37466.961255/8.0),
    REAL_CONST(37485.512699/8.0),
    REAL_CONST(37504.066439/8.0),
    REAL_CONST(37522.622474/8.0),
    REAL_CONST(37541.180803/8.0),
    REAL_CONST(37559.741427/8.0),
    REAL_CONST(37578.304343/8.0),
    REAL_CONST(37596.869552/8.0),
    REAL_CONST(37615.437054/8.0),
    REAL_CONST(37634.006846/8.0),
    REAL_CONST(37652.578930/8.0),
    REAL_CONST(37671.153305/8.0),
    REAL_CONST(37689.729969/8.0),
    REAL_CONST(37708.308922/8.0),
    REAL_CONST(37726.890165/8.0),
    REAL_CONST(37745.473695/8.0),
    REAL_CONST(37764.059513/8.0),
    REAL_CONST(37782.647619/8.0),
    REAL_CONST(37801.238010/8.0),
    REAL_CONST(37819.830688/8.0),
    REAL_CONST(37838.425651/8.0),
    REAL_CONST(37857.022899/8.0),
    REAL_CONST(37875.622431/8.0),
    REAL_CONST(37894.224246/8.0),
    REAL_CONST(37912.828345/8.0),
    REAL_CONST(37931.434727/8.0),
    REAL_CONST(37950.043390/8.0),
    REAL_CONST(37968.654335/8.0),
    REAL_CONST(37987.267561/8.0),
    REAL_CONST(38005.883067/8.0),
    REAL_CONST(38024.500853/8.0),
    REAL_CONST(38043.120918/8.0),
    REAL_CONST(38061.743262/8.0),
    REAL_CONST(38080.367884/8.0),
    REAL_CONST(38098.994783/8.0),
    REAL_CONST(38117.623960/8.0),
    REAL_CONST(38136.255413/8.0),
    REAL_CONST(38154.889141/8.0),
    REAL_CONST(38173.525145/8.0),
    REAL_CONST(38192.163424/8.0),
    REAL_CONST(38210.803977/8.0),
    REAL_CONST(38229.446804/8.0),
    REAL_CONST(38248.091904/8.0),
    REAL_CONST(38266.739276/8.0),
    REAL_CONST(38285.388920/8.0),
    REAL_CONST(38304.040836/8.0),
    REAL_CONST(38322.695023/8.0),
    REAL_CONST(38341.351480/8.0),
    REAL_CONST(38360.010207/8.0),
    REAL_CONST(38378.671203/8.0),
    REAL_CONST(38397.334467/8.0),
    REAL_CONST(38416.000000/8.0),
    REAL_CONST(38434.667800/8.0),
    REAL_CONST(38453.337868/8.0),
    REAL_CONST(38472.010202/8.0),
    REAL_CONST(38490.684801/8.0),
    REAL_CONST(38509.361667/8.0),
    REAL_CONST(38528.040797/8.0),
    REAL_CONST(38546.722191/8.0),
    REAL_CONST(38565.405849/8.0),
    REAL_CONST(38584.091770/8.0),
    REAL_CONST(38602.779954/8.0),
    REAL_CONST(38621.470400/8.0),
    REAL_CONST(38640.163107/8.0),
    REAL_CONST(38658.858075/8.0),
    REAL_CONST(38677.555304/8.0),
    REAL_CONST(38696.254793/8.0),
    REAL_CONST(38714.956541/8.0),
    REAL_CONST(38733.660548/8.0),
    REAL_CONST(38752.366813/8.0),
    REAL_CONST(38771.075336/8.0),
    REAL_CONST(38789.786116/8.0),
    REAL_CONST(38808.499152/8.0),
    REAL_CONST(38827.214445/8.0),
    REAL_CONST(38845.931993/8.0),
    REAL_CONST(38864.651797/8.0),
    REAL_CONST(38883.373854/8.0),
    REAL_CONST(38902.098166/8.0),
    REAL_CONST(38920.824731/8.0),
    REAL_CONST(38939.553548/8.0),
    REAL_CONST(38958.284618/8.0),
    REAL_CONST(38977.017940/8.0),
    REAL_CONST(38995.753513/8.0),
    REAL_CONST(39014.491337/8.0),
    REAL_CONST(39033.231411/8.0),
    REAL_CONST(39051.973734/8.0),
    REAL_CONST(39070.718306/8.0),
    REAL_CONST(39089.465127/8.0),
    REAL_CONST(39108.214196/8.0),
    REAL_CONST(39126.965512/8.0),
    REAL_CONST(39145.719075/8.0),
    REAL_CONST(39164.474885/8.0),
    REAL_CONST(39183.232940/8.0),
    REAL_CONST(39201.993240/8.0),
    REAL_CONST(39220.755786/8.0),
    REAL_CONST(39239.520575/8.0),
    REAL_CONST(39258.287608/8.0),
    REAL_CONST(39277.056884/8.0),
    REAL_CONST(39295.828403/8.0),
    REAL_CONST(39314.602164/8.0),
    REAL_CONST(39333.378166/8.0),
    REAL_CONST(39352.156409/8.0),
    REAL_CONST(39370.936893/8.0),
    REAL_CONST(39389.719617/8.0),
    REAL_CONST(39408.504580/8.0),
    REAL_CONST(39427.291782/8.0),
    REAL_CONST(39446.081222/8.0),
    REAL_CONST(39464.872900/8.0),
    REAL_CONST(39483.666815/8.0),
    REAL_CONST(39502.462967/8.0),
    REAL_CONST(39521.261355/8.0),
    REAL_CONST(39540.061978/8.0),
    REAL_CONST(39558.864837/8.0),
    REAL_CONST(39577.669930/8.0),
    REAL_CONST(39596.477258/8.0),
    REAL_CONST(39615.286819/8.0),
    REAL_CONST(39634.098613/8.0),
    REAL_CONST(39652.912639/8.0),
    REAL_CONST(39671.728897/8.0),
    REAL_CONST(39690.547387/8.0),
    REAL_CONST(39709.368108/8.0),
    REAL_CONST(39728.191058/8.0),
    REAL_CONST(39747.016239/8.0),
    REAL_CONST(39765.843649/8.0),
    REAL_CONST(39784.673288/8.0),
    REAL_CONST(39803.505155/8.0),
    REAL_CONST(39822.339250/8.0),
    REAL_CONST(39841.175571/8.0),
    REAL_CONST(39860.014120/8.0),
    REAL_CONST(39878.854894/8.0),
    REAL_CONST(39897.697895/8.0),
    REAL_CONST(39916.543120/8.0),
    REAL_CONST(39935.390570/8.0),
    REAL_CONST(39954.240244/8.0),
    REAL_CONST(39973.092141/8.0),
    REAL_CONST(39991.946261/8.0),
    REAL_CONST(40010.802604/8.0),
    REAL_CONST(40029.661169/8.0),
    REAL_CONST(40048.521955/8.0),
    REAL_CONST(40067.384962/8.0),
    REAL_CONST(40086.250189/8.0),
    REAL_CONST(40105.117636/8.0),
    REAL_CONST(40123.987303/8.0),
    REAL_CONST(40142.859188/8.0),
    REAL_CONST(40161.733291/8.0),
    REAL_CONST(40180.609613/8.0),
    REAL_CONST(40199.488151/8.0),
    REAL_CONST(40218.368906/8.0),
    REAL_CONST(40237.251878/8.0),
    REAL_CONST(40256.137065/8.0),
    REAL_CONST(40275.024467/8.0),
    REAL_CONST(40293.914083/8.0),
    REAL_CONST(40312.805914/8.0),
    REAL_CONST(40331.699959/8.0),
    REAL_CONST(40350.596216/8.0),
    REAL_CONST(40369.494686/8.0),
    REAL_CONST(40388.395368/8.0),
    REAL_CONST(40407.298262/8.0),
    REAL_CONST(40426.203367/8.0),
    REAL_CONST(40445.110682/8.0),
    REAL_CONST(40464.020207/8.0),
    REAL_CONST(40482.931941/8.0),
    REAL_CONST(40501.845885/8.0),
    REAL_CONST(40520.762036/8.0),
    REAL_CONST(40539.680396/8.0),
    REAL_CONST(40558.600963/8.0),
    REAL_CONST(40577.523737/8.0),
    REAL_CONST(40596.448718/8.0),
    REAL_CONST(40615.375904/8.0),
    REAL_CONST(40634.305295/8.0),
    REAL_CONST(40653.236891/8.0),
    REAL_CONST(40672.170692/8.0),
    REAL_CONST(40691.106696/8.0),
    REAL_CONST(40710.044904/8.0),
    REAL_CONST(40728.985314/8.0),
    REAL_CONST(40747.927927/8.0),
    REAL_CONST(40766.872741/8.0),
    REAL_CONST(40785.819757/8.0),
    REAL_CONST(40804.768973/8.0),
    REAL_CONST(40823.720390/8.0),
    REAL_CONST(40842.674006/8.0),
    REAL_CONST(40861.629821/8.0),
    REAL_CONST(40880.587835/8.0),
    REAL_CONST(40899.548048/8.0),
    REAL_CONST(40918.510457/8.0),
    REAL_CONST(40937.475064/8.0),
    REAL_CONST(40956.441868/8.0),
    REAL_CONST(40975.410868/8.0),
    REAL_CONST(40994.382063/8.0),
    REAL_CONST(41013.355454/8.0),
    REAL_CONST(41032.331039/8.0),
    REAL_CONST(41051.308818/8.0),
    REAL_CONST(41070.288790/8.0),
    REAL_CONST(41089.270956/8.0),
    REAL_CONST(41108.255315/8.0),
    REAL_CONST(41127.241865/8.0),
    REAL_CONST(41146.230607/8.0),
    REAL_CONST(41165.221540/8.0),
    REAL_CONST(41184.214664/8.0),
    REAL_CONST(41203.209977/8.0),
    REAL_CONST(41222.207480/8.0),
    REAL_CONST(41241.207173/8.0),
    REAL_CONST(41260.209053/8.0),
    REAL_CONST(41279.213122/8.0),
    REAL_CONST(41298.219378/8.0),
    REAL_CONST(41317.227822/8.0),
    REAL_CONST(41336.238451/8.0),
    REAL_CONST(41355.251267/8.0),
    REAL_CONST(41374.266268/8.0),
    REAL_CONST(41393.283455/8.0),
    REAL_CONST(41412.302826/8.0),
    REAL_CONST(41431.324380/8.0),
    REAL_CONST(41450.348119/8.0),
    REAL_CONST(41469.374040/8.0),
    REAL_CONST(41488.402144/8.0),
    REAL_CONST(41507.432430/8.0),
    REAL_CONST(41526.464897/8.0),
    REAL_CONST(41545.499545/8.0),
    REAL_CONST(41564.536374/8.0),
    REAL_CONST(41583.575383/8.0),
    REAL_CONST(41602.616571/8.0),
    REAL_CONST(41621.659938/8.0),
    REAL_CONST(41640.705484/8.0),
    REAL_CONST(41659.753208/8.0),
    REAL_CONST(41678.803109/8.0),
    REAL_CONST(41697.855187/8.0),
    REAL_CONST(41716.909442/8.0),
    REAL_CONST(41735.965873/8.0),
    REAL_CONST(41755.024479/8.0),
    REAL_CONST(41774.085261/8.0),
    REAL_CONST(41793.148217/8.0),
    REAL_CONST(41812.213347/8.0),
    REAL_CONST(41831.280650/8.0),
    REAL_CONST(41850.350126/8.0),
    REAL_CONST(41869.421775/8.0),
    REAL_CONST(41888.495597/8.0),
    REAL_CONST(41907.571589/8.0),
    REAL_CONST(41926.649753/8.0),
    REAL_CONST(41945.730087/8.0),
    REAL_CONST(41964.812591/8.0),
    REAL_CONST(41983.897265/8.0),
    REAL_CONST(42002.984108/8.0),
    REAL_CONST(42022.073120/8.0),
    REAL_CONST(42041.164299/8.0),
    REAL_CONST(42060.257647/8.0),
    REAL_CONST(42079.353161/8.0),
    REAL_CONST(42098.450842/8.0),
    REAL_CONST(42117.550689/8.0),
    REAL_CONST(42136.652702/8.0),
    REAL_CONST(42155.756880/8.0),
    REAL_CONST(42174.863222/8.0),
    REAL_CONST(42193.971729/8.0),
    REAL_CONST(42213.082399/8.0),
    REAL_CONST(42232.195233/8.0),
    REAL_CONST(42251.310229/8.0),
    REAL_CONST(42270.427388/8.0),
    REAL_CONST(42289.546708/8.0),
    REAL_CONST(42308.668190/8.0),
    REAL_CONST(42327.791832/8.0),
    REAL_CONST(42346.917634/8.0),
    REAL_CONST(42366.045596/8.0),
    REAL_CONST(42385.175718/8.0),
    REAL_CONST(42404.307998/8.0),
    REAL_CONST(42423.442437/8.0),
    REAL_CONST(42442.579033/8.0),
    REAL_CONST(42461.717787/8.0),
    REAL_CONST(42480.858697/8.0),
    REAL_CONST(42500.001764/8.0),
    REAL_CONST(42519.146987/8.0),
    REAL_CONST(42538.294365/8.0),
    REAL_CONST(42557.443898/8.0),
    REAL_CONST(42576.595586/8.0),
    REAL_CONST(42595.749427/8.0),
    REAL_CONST(42614.905422/8.0),
    REAL_CONST(42634.063570/8.0),
    REAL_CONST(42653.223870/8.0),
    REAL_CONST(42672.386323/8.0),
    REAL_CONST(42691.550926/8.0),
    REAL_CONST(42710.717681/8.0),
    REAL_CONST(42729.886587/8.0),
    REAL_CONST(42749.057642/8.0),
    REAL_CONST(42768.230847/8.0),
    REAL_CONST(42787.406201/8.0),
    REAL_CONST(42806.583704/8.0),
    REAL_CONST(42825.763355/8.0),
    REAL_CONST(42844.945154/8.0),
    REAL_CONST(42864.129099/8.0),
    REAL_CONST(42883.315192/8.0),
    REAL_CONST(42902.503431/8.0),
    REAL_CONST(42921.693815/8.0),
    REAL_CONST(42940.886345/8.0),
    REAL_CONST(42960.081019/8.0),
    REAL_CONST(42979.277838/8.0),
    REAL_CONST(42998.476800/8.0),
    REAL_CONST(43017.677906/8.0),
    REAL_CONST(43036.881155/8.0),
    REAL_CONST(43056.086546/8.0),
    REAL_CONST(43075.294079/8.0),
    REAL_CONST(43094.503754/8.0),
    REAL_CONST(43113.715569/8.0),
    REAL_CONST(43132.929525/8.0),
    REAL_CONST(43152.145621/8.0),
    REAL_CONST(43171.363856/8.0),
    REAL_CONST(43190.584231/8.0),
    REAL_CONST(43209.806744/8.0),
    REAL_CONST(43229.031395/8.0),
    REAL_CONST(43248.258183/8.0),
    REAL_CONST(43267.487109/8.0),
    REAL_CONST(43286.718172/8.0),
    REAL_CONST(43305.951370/8.0),
    REAL_CONST(43325.186705/8.0),
    REAL_CONST(43344.424175/8.0),
    REAL_CONST(43363.663779/8.0),
    REAL_CONST(43382.905518/8.0),
    REAL_CONST(43402.149390/8.0),
    REAL_CONST(43421.395396/8.0),
    REAL_CONST(43440.643535/8.0),
    REAL_CONST(43459.893806/8.0),
    REAL_CONST(43479.146209/8.0),
    REAL_CONST(43498.400744/8.0),
    REAL_CONST(43517.657409/8.0),
    REAL_CONST(43536.916206/8.0),
    REAL_CONST(43556.177132/8.0),
    REAL_CONST(43575.440187/8.0),
    REAL_CONST(43594.705372/8.0),
    REAL_CONST(43613.972686/8.0),
    REAL_CONST(43633.242127/8.0),
    REAL_CONST(43652.513697/8.0),
    REAL_CONST(43671.787393/8.0),
    REAL_CONST(43691.063216/8.0),
    REAL_CONST(43710.341166/8.0),
    REAL_CONST(43729.621241/8.0),
    REAL_CONST(43748.903442/8.0),
    REAL_CONST(43768.187767/8.0),
    REAL_CONST(43787.474217/8.0),
    REAL_CONST(43806.762791/8.0),
    REAL_CONST(43826.053489/8.0),
    REAL_CONST(43845.346309/8.0),
    REAL_CONST(43864.641252/8.0),
    REAL_CONST(43883.938317/8.0),
    REAL_CONST(43903.237504/8.0),
    REAL_CONST(43922.538812/8.0),
    REAL_CONST(43941.842240/8.0),
    REAL_CONST(43961.147789/8.0),
    REAL_CONST(43980.455457/8.0),
    REAL_CONST(43999.765245/8.0),
    REAL_CONST(44019.077151/8.0),
    REAL_CONST(44038.391176/8.0),
    REAL_CONST(44057.707319/8.0),
    REAL_CONST(44077.025579/8.0),
    REAL_CONST(44096.345956/8.0),
    REAL_CONST(44115.668450/8.0),
    REAL_CONST(44134.993059/8.0),
    REAL_CONST(44154.319784/8.0),
    REAL_CONST(44173.648625/8.0),
    REAL_CONST(44192.979580/8.0),
    REAL_CONST(44212.312649/8.0),
    REAL_CONST(44231.647831/8.0),
    REAL_CONST(44250.985127/8.0),
    REAL_CONST(44270.324536/8.0),
    REAL_CONST(44289.666057/8.0),
    REAL_CONST(44309.009690/8.0),
    REAL_CONST(44328.355435/8.0),
    REAL_CONST(44347.703290/8.0),
    REAL_CONST(44367.053256/8.0),
    REAL_CONST(44386.405332/8.0),
    REAL_CONST(44405.759517/8.0),
    REAL_CONST(44425.115812/8.0),
    REAL_CONST(44444.474215/8.0),
    REAL_CONST(44463.834726/8.0),
    REAL_CONST(44483.197346/8.0),
    REAL_CONST(44502.562072/8.0),
    REAL_CONST(44521.928905/8.0),
    REAL_CONST(44541.297845/8.0),
    REAL_CONST(44560.668890/8.0),
    REAL_CONST(44580.042041/8.0),
    REAL_CONST(44599.417297/8.0),
    REAL_CONST(44618.794657/8.0),
    REAL_CONST(44638.174121/8.0),
    REAL_CONST(44657.555689/8.0),
    REAL_CONST(44676.939361/8.0),
    REAL_CONST(44696.325134/8.0),
    REAL_CONST(44715.713011/8.0),
    REAL_CONST(44735.102988/8.0),
    REAL_CONST(44754.495068/8.0),
    REAL_CONST(44773.889248/8.0),
    REAL_CONST(44793.285528/8.0),
    REAL_CONST(44812.683909/8.0),
    REAL_CONST(44832.084388/8.0),
    REAL_CONST(44851.486967/8.0),
    REAL_CONST(44870.891645/8.0),
    REAL_CONST(44890.298421/8.0),
    REAL_CONST(44909.707294/8.0),
    REAL_CONST(44929.118265/8.0),
    REAL_CONST(44948.531332/8.0),
    REAL_CONST(44967.946496/8.0),
    REAL_CONST(44987.363756/8.0),
    REAL_CONST(45006.783111/8.0),
    REAL_CONST(45026.204561/8.0),
    REAL_CONST(45045.628105/8.0),
    REAL_CONST(45065.053744/8.0),
    REAL_CONST(45084.481476/8.0),
    REAL_CONST(45103.911302/8.0),
    REAL_CONST(45123.343220/8.0),
    REAL_CONST(45142.777230/8.0),
    REAL_CONST(45162.213333/8.0),
    REAL_CONST(45181.651526/8.0),
    REAL_CONST(45201.091811/8.0),
    REAL_CONST(45220.534186/8.0),
    REAL_CONST(45239.978651/8.0),
    REAL_CONST(45259.425205/8.0),
    REAL_CONST(45278.873849/8.0),
    REAL_CONST(45298.324581/8.0),
    REAL_CONST(45317.777402/8.0),
    REAL_CONST(45337.232310/8.0),
    REAL_CONST(45356.689306/8.0),
    REAL_CONST(45376.148388/8.0),
    REAL_CONST(45395.609557/8.0),
    REAL_CONST(45415.072812/8.0),
    REAL_CONST(45434.538153/8.0),
    REAL_CONST(45454.005578/8.0),
    REAL_CONST(45473.475088/8.0),
    REAL_CONST(45492.946683/8.0),
    REAL_CONST(45512.420361/8.0),
    REAL_CONST(45531.896122/8.0),
    REAL_CONST(45551.373967/8.0),
    REAL_CONST(45570.853893/8.0),
    REAL_CONST(45590.335902/8.0),
    REAL_CONST(45609.819992/8.0),
    REAL_CONST(45629.306164/8.0),
    REAL_CONST(45648.794416/8.0),
    REAL_CONST(45668.284748/8.0),
    REAL_CONST(45687.777160/8.0),
    REAL_CONST(45707.271651/8.0),
    REAL_CONST(45726.768221/8.0),
    REAL_CONST(45746.266869/8.0),
    REAL_CONST(45765.767596/8.0),
    REAL_CONST(45785.270400/8.0),
    REAL_CONST(45804.775281/8.0),
    REAL_CONST(45824.282238/8.0),
    REAL_CONST(45843.791272/8.0),
    REAL_CONST(45863.302382/8.0),
    REAL_CONST(45882.815567/8.0),
    REAL_CONST(45902.330827/8.0),
    REAL_CONST(45921.848161/8.0),
    REAL_CONST(45941.367569/8.0),
    REAL_CONST(45960.889051/8.0),
    REAL_CONST(45980.412606/8.0),
    REAL_CONST(45999.938233/8.0),
    REAL_CONST(46019.465933/8.0),
    REAL_CONST(46038.995705/8.0),
    REAL_CONST(46058.527548/8.0),
    REAL_CONST(46078.061462/8.0),
    REAL_CONST(46097.597446/8.0),
    REAL_CONST(46117.135501/8.0),
    REAL_CONST(46136.675625/8.0),
    REAL_CONST(46156.217818/8.0),
    REAL_CONST(46175.762080/8.0),
    REAL_CONST(46195.308410/8.0),
    REAL_CONST(46214.856808/8.0),
    REAL_CONST(46234.407273/8.0),
    REAL_CONST(46253.959806/8.0),
    REAL_CONST(46273.514405/8.0),
    REAL_CONST(46293.071070/8.0),
    REAL_CONST(46312.629800/8.0),
    REAL_CONST(46332.190596/8.0),
    REAL_CONST(46351.753457/8.0),
    REAL_CONST(46371.318382/8.0),
    REAL_CONST(46390.885371/8.0),
    REAL_CONST(46410.454424/8.0),
    REAL_CONST(46430.025539/8.0),
    REAL_CONST(46449.598717/8.0),
    REAL_CONST(46469.173958/8.0),
    REAL_CONST(46488.751260/8.0),
    REAL_CONST(46508.330623/8.0),
    REAL_CONST(46527.912048/8.0),
    REAL_CONST(46547.495532/8.0),
    REAL_CONST(46567.081077/8.0),
    REAL_CONST(46586.668681/8.0),
    REAL_CONST(46606.258345/8.0),
    REAL_CONST(46625.850067/8.0),
    REAL_CONST(46645.443847/8.0),
    REAL_CONST(46665.039686/8.0),
    REAL_CONST(46684.637581/8.0),
    REAL_CONST(46704.237534/8.0),
    REAL_CONST(46723.839543/8.0),
    REAL_CONST(46743.443609/8.0),
    REAL_CONST(46763.049730/8.0),
    REAL_CONST(46782.657906/8.0),
    REAL_CONST(46802.268137/8.0),
    REAL_CONST(46821.880423/8.0),
    REAL_CONST(46841.494762/8.0),
    REAL_CONST(46861.111155/8.0),
    REAL_CONST(46880.729601/8.0),
    REAL_CONST(46900.350100/8.0),
    REAL_CONST(46919.972651/8.0),
    REAL_CONST(46939.597254/8.0),
    REAL_CONST(46959.223908/8.0),
    REAL_CONST(46978.852613/8.0),
    REAL_CONST(46998.483369/8.0),
    REAL_CONST(47018.116175/8.0),
    REAL_CONST(47037.751030/8.0),
    REAL_CONST(47057.387935/8.0),
    REAL_CONST(47077.026889/8.0),
    REAL_CONST(47096.667891/8.0),
    REAL_CONST(47116.310941/8.0),
    REAL_CONST(47135.956038/8.0),
    REAL_CONST(47155.603183/8.0),
    REAL_CONST(47175.252374/8.0),
    REAL_CONST(47194.903611/8.0),
    REAL_CONST(47214.556895/8.0),
    REAL_CONST(47234.212223/8.0),
    REAL_CONST(47253.869597/8.0),
    REAL_CONST(47273.529016/8.0),
    REAL_CONST(47293.190478/8.0),
    REAL_CONST(47312.853984/8.0),
    REAL_CONST(47332.519533/8.0),
    REAL_CONST(47352.187126/8.0),
    REAL_CONST(47371.856760/8.0),
    REAL_CONST(47391.528437/8.0),
    REAL_CONST(47411.202155/8.0),
    REAL_CONST(47430.877915/8.0),
    REAL_CONST(47450.555715/8.0),
    REAL_CONST(47470.235556/8.0),
    REAL_CONST(47489.917436/8.0),
    REAL_CONST(47509.601356/8.0),
    REAL_CONST(47529.287315/8.0),
    REAL_CONST(47548.975312/8.0),
    REAL_CONST(47568.665348/8.0),
    REAL_CONST(47588.357421/8.0),
    REAL_CONST(47608.051532/8.0),
    REAL_CONST(47627.747680/8.0),
    REAL_CONST(47647.445864/8.0),
    REAL_CONST(47667.146085/8.0),
    REAL_CONST(47686.848341/8.0),
    REAL_CONST(47706.552632/8.0),
    REAL_CONST(47726.258958/8.0),
    REAL_CONST(47745.967319/8.0),
    REAL_CONST(47765.677714/8.0),
    REAL_CONST(47785.390142/8.0),
    REAL_CONST(47805.104603/8.0),
    REAL_CONST(47824.821097/8.0),
    REAL_CONST(47844.539623/8.0),
    REAL_CONST(47864.260181/8.0),
    REAL_CONST(47883.982771/8.0),
    REAL_CONST(47903.707392/8.0),
    REAL_CONST(47923.434043/8.0),
    REAL_CONST(47943.162725/8.0),
    REAL_CONST(47962.893436/8.0),
    REAL_CONST(47982.626177/8.0),
    REAL_CONST(48002.360947/8.0),
    REAL_CONST(48022.097745/8.0),
    REAL_CONST(48041.836572/8.0),
    REAL_CONST(48061.577426/8.0),
    REAL_CONST(48081.320307/8.0),
    REAL_CONST(48101.065216/8.0),
    REAL_CONST(48120.812151/8.0),
    REAL_CONST(48140.561112/8.0),
    REAL_CONST(48160.312098/8.0),
    REAL_CONST(48180.065110/8.0),
    REAL_CONST(48199.820146/8.0),
    REAL_CONST(48219.577207/8.0),
    REAL_CONST(48239.336292/8.0),
    REAL_CONST(48259.097401/8.0),
    REAL_CONST(48278.860533/8.0),
    REAL_CONST(48298.625687/8.0),
    REAL_CONST(48318.392864/8.0),
    REAL_CONST(48338.162062/8.0),
    REAL_CONST(48357.933282/8.0),
    REAL_CONST(48377.706524/8.0),
    REAL_CONST(48397.481785/8.0),
    REAL_CONST(48417.259068/8.0),
    REAL_CONST(48437.038369/8.0),
    REAL_CONST(48456.819691/8.0),
    REAL_CONST(48476.603031/8.0),
    REAL_CONST(48496.388390/8.0),
    REAL_CONST(48516.175767/8.0),
    REAL_CONST(48535.965162/8.0),
    REAL_CONST(48555.756575/8.0),
    REAL_CONST(48575.550004/8.0),
    REAL_CONST(48595.345450/8.0),
    REAL_CONST(48615.142912/8.0),
    REAL_CONST(48634.942390/8.0),
    REAL_CONST(48654.743883/8.0),
    REAL_CONST(48674.547391/8.0),
    REAL_CONST(48694.352913/8.0),
    REAL_CONST(48714.160450/8.0),
    REAL_CONST(48733.970000/8.0),
    REAL_CONST(48753.781563/8.0),
    REAL_CONST(48773.595140/8.0),
    REAL_CONST(48793.410728/8.0),
    REAL_CONST(48813.228329/8.0),
    REAL_CONST(48833.047942/8.0),
    REAL_CONST(48852.869565/8.0),
    REAL_CONST(48872.693200/8.0),
    REAL_CONST(48892.518845/8.0),
    REAL_CONST(48912.346500/8.0),
    REAL_CONST(48932.176164/8.0),
    REAL_CONST(48952.007838/8.0),
    REAL_CONST(48971.841520/8.0),
    REAL_CONST(48991.677211/8.0),
    REAL_CONST(49011.514910/8.0),
    REAL_CONST(49031.354616/8.0),
    REAL_CONST(49051.196330/8.0),
    REAL_CONST(49071.040050/8.0),
    REAL_CONST(49090.885777/8.0),
    REAL_CONST(49110.733509/8.0),
    REAL_CONST(49130.583247/8.0),
    REAL_CONST(49150.434991/8.0),
    REAL_CONST(49170.288739/8.0),
    REAL_CONST(49190.144491/8.0),
    REAL_CONST(49210.002247/8.0),
    REAL_CONST(49229.862007/8.0),
    REAL_CONST(49249.723769/8.0),
    REAL_CONST(49269.587535/8.0),
    REAL_CONST(49289.453303/8.0),
    REAL_CONST(49309.321072/8.0),
    REAL_CONST(49329.190843/8.0),
    REAL_CONST(49349.062616/8.0),
    REAL_CONST(49368.936388/8.0),
    REAL_CONST(49388.812162/8.0),
    REAL_CONST(49408.689935/8.0),
    REAL_CONST(49428.569707/8.0),
    REAL_CONST(49448.451479/8.0),
    REAL_CONST(49468.335249/8.0),
    REAL_CONST(49488.221018/8.0),
    REAL_CONST(49508.108784/8.0),
    REAL_CONST(49527.998548/8.0),
    REAL_CONST(49547.890309/8.0),
    REAL_CONST(49567.784066/8.0),
    REAL_CONST(49587.679820/8.0),
    REAL_CONST(49607.577570/8.0),
    REAL_CONST(49627.477315/8.0),
    REAL_CONST(49647.379055/8.0),
    REAL_CONST(49667.282790/8.0),
    REAL_CONST(49687.188520/8.0),
    REAL_CONST(49707.096243/8.0),
    REAL_CONST(49727.005959/8.0),
    REAL_CONST(49746.917669/8.0),
    REAL_CONST(49766.831371/8.0),
    REAL_CONST(49786.747065/8.0),
    REAL_CONST(49806.664752/8.0),
    REAL_CONST(49826.584430/8.0),
    REAL_CONST(49846.506098/8.0),
    REAL_CONST(49866.429758/8.0),
    REAL_CONST(49886.355408/8.0),
    REAL_CONST(49906.283048/8.0),
    REAL_CONST(49926.212677/8.0),
    REAL_CONST(49946.144295/8.0),
    REAL_CONST(49966.077902/8.0),
    REAL_CONST(49986.013497/8.0),
    REAL_CONST(50005.951081/8.0),
    REAL_CONST(50025.890651/8.0),
    REAL_CONST(50045.832209/8.0),
    REAL_CONST(50065.775753/8.0),
    REAL_CONST(50085.721284/8.0),
    REAL_CONST(50105.668801/8.0),
    REAL_CONST(50125.618303/8.0),
    REAL_CONST(50145.569791/8.0),
    REAL_CONST(50165.523263/8.0),
    REAL_CONST(50185.478719/8.0),
    REAL_CONST(50205.436159/8.0),
    REAL_CONST(50225.395583/8.0),
    REAL_CONST(50245.356990/8.0),
    REAL_CONST(50265.320380/8.0),
    REAL_CONST(50285.285752/8.0),
    REAL_CONST(50305.253106/8.0),
    REAL_CONST(50325.222442/8.0),
    REAL_CONST(50345.193759/8.0),
    REAL_CONST(50365.167057/8.0),
    REAL_CONST(50385.142335/8.0),
    REAL_CONST(50405.119593/8.0),
    REAL_CONST(50425.098831/8.0),
    REAL_CONST(50445.080047/8.0),
    REAL_CONST(50465.063243/8.0),
    REAL_CONST(50485.048417/8.0),
    REAL_CONST(50505.035570/8.0),
    REAL_CONST(50525.024699/8.0),
    REAL_CONST(50545.015807/8.0),
    REAL_CONST(50565.008891/8.0),
    REAL_CONST(50585.003951/8.0),
    REAL_CONST(50605.000988/8.0),
    REAL_CONST(50625.000000/8.0),
    REAL_CONST(50645.000988/8.0),
    REAL_CONST(50665.003950/8.0),
    REAL_CONST(50685.008887/8.0),
    REAL_CONST(50705.015798/8.0),
    REAL_CONST(50725.024683/8.0),
    REAL_CONST(50745.035542/8.0),
    REAL_CONST(50765.048373/8.0),
    REAL_CONST(50785.063177/8.0),
    REAL_CONST(50805.079953/8.0),
    REAL_CONST(50825.098700/8.0),
    REAL_CONST(50845.119420/8.0),
    REAL_CONST(50865.142110/8.0),
    REAL_CONST(50885.166771/8.0),
    REAL_CONST(50905.193402/8.0),
    REAL_CONST(50925.222003/8.0),
    REAL_CONST(50945.252574/8.0),
    REAL_CONST(50965.285113/8.0),
    REAL_CONST(50985.319622/8.0),
    REAL_CONST(51005.356098/8.0),
    REAL_CONST(51025.394543/8.0),
    REAL_CONST(51045.434955/8.0),
    REAL_CONST(51065.477334/8.0),
    REAL_CONST(51085.521680/8.0),
    REAL_CONST(51105.567993/8.0),
    REAL_CONST(51125.616271/8.0),
    REAL_CONST(51145.666515/8.0),
    REAL_CONST(51165.718724/8.0),
    REAL_CONST(51185.772898/8.0),
    REAL_CONST(51205.829037/8.0),
    REAL_CONST(51225.887140/8.0),
    REAL_CONST(51245.947206/8.0),
    REAL_CONST(51266.009235/8.0),
    REAL_CONST(51286.073228/8.0),
    REAL_CONST(51306.139183/8.0),
    REAL_CONST(51326.207100/8.0),
    REAL_CONST(51346.276979/8.0),
    REAL_CONST(51366.348820/8.0),
    REAL_CONST(51386.422621/8.0),
    REAL_CONST(51406.498383/8.0),
    REAL_CONST(51426.576105/8.0),
    REAL_CONST(51446.655787/8.0),
    REAL_CONST(51466.737429/8.0),
    REAL_CONST(51486.821030/8.0),
    REAL_CONST(51506.906589/8.0),
    REAL_CONST(51526.994107/8.0),
    REAL_CONST(51547.083582/8.0),
    REAL_CONST(51567.175016/8.0),
    REAL_CONST(51587.268406/8.0),
    REAL_CONST(51607.363753/8.0),
    REAL_CONST(51627.461057/8.0),
    REAL_CONST(51647.560316/8.0),
    REAL_CONST(51667.661532/8.0),
    REAL_CONST(51687.764702/8.0),
    REAL_CONST(51707.869828/8.0),
    REAL_CONST(51727.976908/8.0),
    REAL_CONST(51748.085942/8.0),
    REAL_CONST(51768.196930/8.0),
    REAL_CONST(51788.309871/8.0),
    REAL_CONST(51808.424765/8.0),
    REAL_CONST(51828.541612/8.0),
    REAL_CONST(51848.660411/8.0),
    REAL_CONST(51868.781162/8.0),
    REAL_CONST(51888.903864/8.0),
    REAL_CONST(51909.028518/8.0),
    REAL_CONST(51929.155122/8.0),
    REAL_CONST(51949.283677/8.0),
    REAL_CONST(51969.414181/8.0),
    REAL_CONST(51989.546636/8.0),
    REAL_CONST(52009.681039/8.0),
    REAL_CONST(52029.817391/8.0),
    REAL_CONST(52049.955692/8.0),
    REAL_CONST(52070.095941/8.0),
    REAL_CONST(52090.238137/8.0),
    REAL_CONST(52110.382281/8.0),
    REAL_CONST(52130.528372/8.0),
    REAL_CONST(52150.676409/8.0),
    REAL_CONST(52170.826393/8.0),
    REAL_CONST(52190.978322/8.0),
    REAL_CONST(52211.132197/8.0),
    REAL_CONST(52231.288017/8.0),
    REAL_CONST(52251.445781/8.0),
    REAL_CONST(52271.605490/8.0),
    REAL_CONST(52291.767143/8.0),
    REAL_CONST(52311.930739/8.0),
    REAL_CONST(52332.096279/8.0),
    REAL_CONST(52352.263761/8.0),
    REAL_CONST(52372.433186/8.0),
    REAL_CONST(52392.604553/8.0),
    REAL_CONST(52412.777862/8.0),
    REAL_CONST(52432.953112/8.0),
    REAL_CONST(52453.130303/8.0),
    REAL_CONST(52473.309434/8.0),
    REAL_CONST(52493.490506/8.0),
    REAL_CONST(52513.673518/8.0),
    REAL_CONST(52533.858469/8.0),
    REAL_CONST(52554.045359/8.0),
    REAL_CONST(52574.234188/8.0),
    REAL_CONST(52594.424955/8.0),
    REAL_CONST(52614.617660/8.0),
    REAL_CONST(52634.812303/8.0),
    REAL_CONST(52655.008883/8.0),
    REAL_CONST(52675.207400/8.0),
    REAL_CONST(52695.407853/8.0),
    REAL_CONST(52715.610242/8.0),
    REAL_CONST(52735.814568/8.0),
    REAL_CONST(52756.020828/8.0),
    REAL_CONST(52776.229024/8.0),
    REAL_CONST(52796.439154/8.0),
    REAL_CONST(52816.651218/8.0),
    REAL_CONST(52836.865217/8.0),
    REAL_CONST(52857.081149/8.0),
    REAL_CONST(52877.299014/8.0),
    REAL_CONST(52897.518811/8.0),
    REAL_CONST(52917.740542/8.0),
    REAL_CONST(52937.964204/8.0),
    REAL_CONST(52958.189798/8.0),
    REAL_CONST(52978.417323/8.0),
    REAL_CONST(52998.646779/8.0),
    REAL_CONST(53018.878166/8.0),
    REAL_CONST(53039.111483/8.0),
    REAL_CONST(53059.346730/8.0),
    REAL_CONST(53079.583906/8.0),
    REAL_CONST(53099.823011/8.0),
    REAL_CONST(53120.064045/8.0),
    REAL_CONST(53140.307008/8.0),
    REAL_CONST(53160.551898/8.0),
    REAL_CONST(53180.798716/8.0),
    REAL_CONST(53201.047462/8.0),
    REAL_CONST(53221.298134/8.0),
    REAL_CONST(53241.550732/8.0),
    REAL_CONST(53261.805257/8.0),
    REAL_CONST(53282.061708/8.0),
    REAL_CONST(53302.320084/8.0),
    REAL_CONST(53322.580385/8.0),
    REAL_CONST(53342.842611/8.0),
    REAL_CONST(53363.106761/8.0),
    REAL_CONST(53383.372835/8.0),
    REAL_CONST(53403.640833/8.0),
    REAL_CONST(53423.910754/8.0),
    REAL_CONST(53444.182598/8.0),
    REAL_CONST(53464.456364/8.0),
    REAL_CONST(53484.732053/8.0),
    REAL_CONST(53505.009663/8.0),
    REAL_CONST(53525.289195/8.0),
    REAL_CONST(53545.570648/8.0),
    REAL_CONST(53565.854021/8.0),
    REAL_CONST(53586.139315/8.0),
    REAL_CONST(53606.426528/8.0),
    REAL_CONST(53626.715662/8.0),
    REAL_CONST(53647.006714/8.0),
    REAL_CONST(53667.299685/8.0),
    REAL_CONST(53687.594575/8.0),
    REAL_CONST(53707.891383/8.0),
    REAL_CONST(53728.190109/8.0),
    REAL_CONST(53748.490752/8.0),
    REAL_CONST(53768.793313/8.0),
    REAL_CONST(53789.097790/8.0),
    REAL_CONST(53809.404183/8.0),
    REAL_CONST(53829.712492/8.0),
    REAL_CONST(53850.022717/8.0),
    REAL_CONST(53870.334857/8.0),
    REAL_CONST(53890.648912/8.0),
    REAL_CONST(53910.964882/8.0),
    REAL_CONST(53931.282765/8.0),
    REAL_CONST(53951.602563/8.0),
    REAL_CONST(53971.924274/8.0),
    REAL_CONST(53992.247898/8.0),
    REAL_CONST(54012.573434/8.0),
    REAL_CONST(54032.900883/8.0),
    REAL_CONST(54053.230245/8.0),
    REAL_CONST(54073.561517/8.0),
    REAL_CONST(54093.894701/8.0),
    REAL_CONST(54114.229796/8.0),
    REAL_CONST(54134.566802/8.0),
    REAL_CONST(54154.905717/8.0),
    REAL_CONST(54175.246543/8.0),
    REAL_CONST(54195.589278/8.0),
    REAL_CONST(54215.933922/8.0),
    REAL_CONST(54236.280475/8.0),
    REAL_CONST(54256.628937/8.0),
    REAL_CONST(54276.979306/8.0),
    REAL_CONST(54297.331583/8.0),
    REAL_CONST(54317.685768/8.0),
    REAL_CONST(54338.041859/8.0),
    REAL_CONST(54358.399857/8.0),
    REAL_CONST(54378.759761/8.0),
    REAL_CONST(54399.121572/8.0),
    REAL_CONST(54419.485287/8.0),
    REAL_CONST(54439.850908/8.0),
    REAL_CONST(54460.218434/8.0),
    REAL_CONST(54480.587865/8.0),
    REAL_CONST(54500.959199/8.0),
    REAL_CONST(54521.332437/8.0),
    REAL_CONST(54541.707579/8.0),
    REAL_CONST(54562.084624/8.0),
    REAL_CONST(54582.463571/8.0),
    REAL_CONST(54602.844421/8.0),
    REAL_CONST(54623.227173/8.0),
    REAL_CONST(54643.611826/8.0),
    REAL_CONST(54663.998381/8.0),
    REAL_CONST(54684.386836/8.0),
    REAL_CONST(54704.777193/8.0),
    REAL_CONST(54725.169449/8.0),
    REAL_CONST(54745.563605/8.0),
    REAL_CONST(54765.959661/8.0),
    REAL_CONST(54786.357616/8.0),
    REAL_CONST(54806.757470/8.0),
    REAL_CONST(54827.159222/8.0),
    REAL_CONST(54847.562872/8.0),
    REAL_CONST(54867.968421/8.0),
    REAL_CONST(54888.375866/8.0),
    REAL_CONST(54908.785209/8.0),
    REAL_CONST(54929.196448/8.0),
    REAL_CONST(54949.609583/8.0),
    REAL_CONST(54970.024615/8.0),
    REAL_CONST(54990.441542/8.0),
    REAL_CONST(55010.860365/8.0),
    REAL_CONST(55031.281082/8.0),
    REAL_CONST(55051.703694/8.0),
    REAL_CONST(55072.128200/8.0),
    REAL_CONST(55092.554600/8.0),
    REAL_CONST(55112.982894/8.0),
    REAL_CONST(55133.413081/8.0),
    REAL_CONST(55153.845160/8.0),
    REAL_CONST(55174.279132/8.0),
    REAL_CONST(55194.714997/8.0),
    REAL_CONST(55215.152753/8.0),
    REAL_CONST(55235.592400/8.0),
    REAL_CONST(55256.033938/8.0),
    REAL_CONST(55276.477368/8.0),
    REAL_CONST(55296.922687/8.0),
    REAL_CONST(55317.369897/8.0),
    REAL_CONST(55337.818996/8.0),
    REAL_CONST(55358.269985/8.0),
    REAL_CONST(55378.722862/8.0),
    REAL_CONST(55399.177628/8.0),
    REAL_CONST(55419.634283/8.0),
    REAL_CONST(55440.092825/8.0),
    REAL_CONST(55460.553255/8.0),
    REAL_CONST(55481.015572/8.0),
    REAL_CONST(55501.479776/8.0),
    REAL_CONST(55521.945867/8.0),
    REAL_CONST(55542.413844/8.0),
    REAL_CONST(55562.883706/8.0),
    REAL_CONST(55583.355455/8.0),
    REAL_CONST(55603.829088/8.0),
    REAL_CONST(55624.304606/8.0),
    REAL_CONST(55644.782009/8.0),
    REAL_CONST(55665.261295/8.0),
    REAL_CONST(55685.742466/8.0),
    REAL_CONST(55706.225519/8.0),
    REAL_CONST(55726.710456/8.0),
    REAL_CONST(55747.197276/8.0),
    REAL_CONST(55767.685978/8.0),
    REAL_CONST(55788.176562/8.0),
    REAL_CONST(55808.669028/8.0),
    REAL_CONST(55829.163375/8.0),
    REAL_CONST(55849.659603/8.0),
    REAL_CONST(55870.157711/8.0),
    REAL_CONST(55890.657700/8.0),
    REAL_CONST(55911.159569/8.0),
    REAL_CONST(55931.663318/8.0),
    REAL_CONST(55952.168946/8.0),
    REAL_CONST(55972.676452/8.0),
    REAL_CONST(55993.185838/8.0),
    REAL_CONST(56013.697101/8.0),
    REAL_CONST(56034.210243/8.0),
    REAL_CONST(56054.725262/8.0),
    REAL_CONST(56075.242158/8.0),
    REAL_CONST(56095.760931/8.0),
    REAL_CONST(56116.281580/8.0),
    REAL_CONST(56136.804106/8.0),
    REAL_CONST(56157.328508/8.0),
    REAL_CONST(56177.854785/8.0),
    REAL_CONST(56198.382937/8.0),
    REAL_CONST(56218.912964/8.0),
    REAL_CONST(56239.444865/8.0),
    REAL_CONST(56259.978641/8.0),
    REAL_CONST(56280.514290/8.0),
    REAL_CONST(56301.051813/8.0),
    REAL_CONST(56321.591209/8.0),
    REAL_CONST(56342.132478/8.0),
    REAL_CONST(56362.675619/8.0),
    REAL_CONST(56383.220632/8.0),
    REAL_CONST(56403.767517/8.0),
    REAL_CONST(56424.316273/8.0),
    REAL_CONST(56444.866900/8.0),
    REAL_CONST(56465.419398/8.0),
    REAL_CONST(56485.973766/8.0),
    REAL_CONST(56506.530005/8.0),
    REAL_CONST(56527.088113/8.0),
    REAL_CONST(56547.648090/8.0),
    REAL_CONST(56568.209937/8.0),
    REAL_CONST(56588.773652/8.0),
    REAL_CONST(56609.339235/8.0),
    REAL_CONST(56629.906686/8.0),
    REAL_CONST(56650.476005/8.0),
    REAL_CONST(56671.047192/8.0),
    REAL_CONST(56691.620245/8.0),
    REAL_CONST(56712.195165/8.0),
    REAL_CONST(56732.771951/8.0),
    REAL_CONST(56753.350603/8.0),
    REAL_CONST(56773.931121/8.0),
    REAL_CONST(56794.513504/8.0),
    REAL_CONST(56815.097752/8.0),
    REAL_CONST(56835.683865/8.0),
    REAL_CONST(56856.271842/8.0),
    REAL_CONST(56876.861682/8.0),
    REAL_CONST(56897.453387/8.0),
    REAL_CONST(56918.046954/8.0),
    REAL_CONST(56938.642385/8.0),
    REAL_CONST(56959.239678/8.0),
    REAL_CONST(56979.838833/8.0),
    REAL_CONST(57000.439850/8.0),
    REAL_CONST(57021.042729/8.0),
    REAL_CONST(57041.647469/8.0),
    REAL_CONST(57062.254070/8.0),
    REAL_CONST(57082.862532/8.0),
    REAL_CONST(57103.472853/8.0),
    REAL_CONST(57124.085035/8.0),
    REAL_CONST(57144.699076/8.0),
    REAL_CONST(57165.314977/8.0),
    REAL_CONST(57185.932736/8.0),
    REAL_CONST(57206.552354/8.0),
    REAL_CONST(57227.173830/8.0),
    REAL_CONST(57247.797163/8.0),
    REAL_CONST(57268.422355/8.0),
    REAL_CONST(57289.049403/8.0),
    REAL_CONST(57309.678309/8.0),
    REAL_CONST(57330.309071/8.0),
    REAL_CONST(57350.941689/8.0),
    REAL_CONST(57371.576163/8.0),
    REAL_CONST(57392.212493/8.0),
    REAL_CONST(57412.850678/8.0),
    REAL_CONST(57433.490717/8.0),
    REAL_CONST(57454.132612/8.0),
    REAL_CONST(57474.776360/8.0),
    REAL_CONST(57495.421962/8.0),
    REAL_CONST(57516.069418/8.0),
    REAL_CONST(57536.718727/8.0),
    REAL_CONST(57557.369889/8.0),
    REAL_CONST(57578.022904/8.0),
    REAL_CONST(57598.677770/8.0),
    REAL_CONST(57619.334489/8.0),
    REAL_CONST(57639.993059/8.0),
    REAL_CONST(57660.653480/8.0),
    REAL_CONST(57681.315752/8.0),
    REAL_CONST(57701.979875/8.0),
    REAL_CONST(57722.645848/8.0),
    REAL_CONST(57743.313671/8.0),
    REAL_CONST(57763.983343/8.0),
    REAL_CONST(57784.654864/8.0),
    REAL_CONST(57805.328235/8.0),
    REAL_CONST(57826.003454/8.0),
    REAL_CONST(57846.680521/8.0),
    REAL_CONST(57867.359436/8.0),
    REAL_CONST(57888.040199/8.0),
    REAL_CONST(57908.722809/8.0),
    REAL_CONST(57929.407266/8.0),
    REAL_CONST(57950.093569/8.0),
    REAL_CONST(57970.781719/8.0),
    REAL_CONST(57991.471715/8.0),
    REAL_CONST(58012.163556/8.0),
    REAL_CONST(58032.857242/8.0),
    REAL_CONST(58053.552774/8.0),
    REAL_CONST(58074.250150/8.0),
    REAL_CONST(58094.949370/8.0),
    REAL_CONST(58115.650434/8.0),
    REAL_CONST(58136.353342/8.0),
    REAL_CONST(58157.058093/8.0),
    REAL_CONST(58177.764687/8.0),
    REAL_CONST(58198.473124/8.0),
    REAL_CONST(58219.183403/8.0),
    REAL_CONST(58239.895524/8.0),
    REAL_CONST(58260.609487/8.0),
    REAL_CONST(58281.325291/8.0),
    REAL_CONST(58302.042936/8.0),
    REAL_CONST(58322.762421/8.0),
    REAL_CONST(58343.483747/8.0),
    REAL_CONST(58364.206913/8.0),
    REAL_CONST(58384.931919/8.0),
    REAL_CONST(58405.658764/8.0),
    REAL_CONST(58426.387448/8.0),
    REAL_CONST(58447.117971/8.0),
    REAL_CONST(58467.850332/8.0),
    REAL_CONST(58488.584531/8.0),
    REAL_CONST(58509.320568/8.0),
    REAL_CONST(58530.058443/8.0),
    REAL_CONST(58550.798154/8.0),
    REAL_CONST(58571.539702/8.0),
    REAL_CONST(58592.283087/8.0),
    REAL_CONST(58613.028308/8.0),
    REAL_CONST(58633.775364/8.0),
    REAL_CONST(58654.524256/8.0),
    REAL_CONST(58675.274983/8.0),
    REAL_CONST(58696.027545/8.0),
    REAL_CONST(58716.781941/8.0),
    REAL_CONST(58737.538172/8.0),
    REAL_CONST(58758.296236/8.0),
    REAL_CONST(58779.056134/8.0),
    REAL_CONST(58799.817865/8.0),
    REAL_CONST(58820.581429/8.0),
    REAL_CONST(58841.346826/8.0),
    REAL_CONST(58862.114054/8.0),
    REAL_CONST(58882.883115/8.0),
    REAL_CONST(58903.654007/8.0),
    REAL_CONST(58924.426731/8.0),
    REAL_CONST(58945.201285/8.0),
    REAL_CONST(58965.977670/8.0),
    REAL_CONST(58986.755885/8.0),
    REAL_CONST(59007.535930/8.0),
    REAL_CONST(59028.317805/8.0),
    REAL_CONST(59049.101509/8.0),
    REAL_CONST(59069.887042/8.0),
    REAL_CONST(59090.674404/8.0),
    REAL_CONST(59111.463594/8.0),
    REAL_CONST(59132.254612/8.0),
    REAL_CONST(59153.047458/8.0),
    REAL_CONST(59173.842131/8.0),
    REAL_CONST(59194.638631/8.0),
    REAL_CONST(59215.436958/8.0),
    REAL_CONST(59236.237111/8.0),
    REAL_CONST(59257.039091/8.0),
    REAL_CONST(59277.842896/8.0),
    REAL_CONST(59298.648527/8.0),
    REAL_CONST(59319.455983/8.0),
    REAL_CONST(59340.265263/8.0),
    REAL_CONST(59361.076369/8.0),
    REAL_CONST(59381.889298/8.0),
    REAL_CONST(59402.704051/8.0),
    REAL_CONST(59423.520628/8.0),
    REAL_CONST(59444.339028/8.0),
    REAL_CONST(59465.159251/8.0),
    REAL_CONST(59485.981296/8.0),
    REAL_CONST(59506.805164/8.0),
    REAL_CONST(59527.630853/8.0),
    REAL_CONST(59548.458365/8.0),
    REAL_CONST(59569.287697/8.0),
    REAL_CONST(59590.118851/8.0),
    REAL_CONST(59610.951825/8.0),
    REAL_CONST(59631.786620/8.0),
    REAL_CONST(59652.623234/8.0),
    REAL_CONST(59673.461668/8.0),
    REAL_CONST(59694.301922/8.0),
    REAL_CONST(59715.143995/8.0),
    REAL_CONST(59735.987886/8.0),
    REAL_CONST(59756.833596/8.0),
    REAL_CONST(59777.681124/8.0),
    REAL_CONST(59798.530470/8.0),
    REAL_CONST(59819.381634/8.0),
    REAL_CONST(59840.234614/8.0),
    REAL_CONST(59861.089412/8.0),
    REAL_CONST(59881.946026/8.0),
    REAL_CONST(59902.804456/8.0),
    REAL_CONST(59923.664702/8.0),
    REAL_CONST(59944.526764/8.0),
    REAL_CONST(59965.390641/8.0),
    REAL_CONST(59986.256333/8.0),
    REAL_CONST(60007.123839/8.0),
    REAL_CONST(60027.993160/8.0),
    REAL_CONST(60048.864295/8.0),
    REAL_CONST(60069.737243/8.0),
    REAL_CONST(60090.612005/8.0),
    REAL_CONST(60111.488581/8.0),
    REAL_CONST(60132.366968/8.0),
    REAL_CONST(60153.247169/8.0),
    REAL_CONST(60174.129181/8.0),
    REAL_CONST(60195.013005/8.0),
    REAL_CONST(60215.898641/8.0),
    REAL_CONST(60236.786088/8.0),
    REAL_CONST(60257.675345/8.0),
    REAL_CONST(60278.566414/8.0),
    REAL_CONST(60299.459292/8.0),
    REAL_CONST(60320.353981/8.0),
    REAL_CONST(60341.250479/8.0),
    REAL_CONST(60362.148786/8.0),
    REAL_CONST(60383.048902/8.0),
    REAL_CONST(60403.950827/8.0),
    REAL_CONST(60424.854561/8.0),
    REAL_CONST(60445.760102/8.0),
    REAL_CONST(60466.667451/8.0),
    REAL_CONST(60487.576608/8.0),
    REAL_CONST(60508.487572/8.0),
    REAL_CONST(60529.400342/8.0),
    REAL_CONST(60550.314919/8.0),
    REAL_CONST(60571.231302/8.0),
    REAL_CONST(60592.149491/8.0),
    REAL_CONST(60613.069486/8.0),
    REAL_CONST(60633.991286/8.0),
    REAL_CONST(60654.914890/8.0),
    REAL_CONST(60675.840300/8.0),
    REAL_CONST(60696.767513/8.0),
    REAL_CONST(60717.696531/8.0),
    REAL_CONST(60738.627352/8.0),
    REAL_CONST(60759.559977/8.0),
    REAL_CONST(60780.494405/8.0),
    REAL_CONST(60801.430635/8.0),
    REAL_CONST(60822.368668/8.0),
    REAL_CONST(60843.308503/8.0),
    REAL_CONST(60864.250140/8.0),
    REAL_CONST(60885.193578/8.0),
    REAL_CONST(60906.138818/8.0),
    REAL_CONST(60927.085859/8.0),
    REAL_CONST(60948.034700/8.0),
    REAL_CONST(60968.985341/8.0),
    REAL_CONST(60989.937782/8.0),
    REAL_CONST(61010.892023/8.0),
    REAL_CONST(61031.848063/8.0),
    REAL_CONST(61052.805903/8.0),
    REAL_CONST(61073.765541/8.0),
    REAL_CONST(61094.726977/8.0),
    REAL_CONST(61115.690212/8.0),
    REAL_CONST(61136.655244/8.0),
    REAL_CONST(61157.622074/8.0),
    REAL_CONST(61178.590701/8.0),
    REAL_CONST(61199.561125/8.0),
    REAL_CONST(61220.533345/8.0),
    REAL_CONST(61241.507362/8.0),
    REAL_CONST(61262.483175/8.0),
    REAL_CONST(61283.460783/8.0),
    REAL_CONST(61304.440187/8.0),
    REAL_CONST(61325.421385/8.0),
    REAL_CONST(61346.404379/8.0),
    REAL_CONST(61367.389167/8.0),
    REAL_CONST(61388.375749/8.0),
    REAL_CONST(61409.364124/8.0),
    REAL_CONST(61430.354294/8.0),
    REAL_CONST(61451.346256/8.0),
    REAL_CONST(61472.340011/8.0),
    REAL_CONST(61493.335559/8.0),
    REAL_CONST(61514.332899/8.0),
    REAL_CONST(61535.332031/8.0),
    REAL_CONST(61556.332955/8.0),
    REAL_CONST(61577.335670/8.0),
    REAL_CONST(61598.340177/8.0),
    REAL_CONST(61619.346473/8.0),
    REAL_CONST(61640.354561/8.0),
    REAL_CONST(61661.364438/8.0),
    REAL_CONST(61682.376106/8.0),
    REAL_CONST(61703.389562/8.0),
    REAL_CONST(61724.404808/8.0),
    REAL_CONST(61745.421843/8.0),
    REAL_CONST(61766.440667/8.0),
    REAL_CONST(61787.461279/8.0),
    REAL_CONST(61808.483679/8.0),
    REAL_CONST(61829.507866/8.0),
    REAL_CONST(61850.533841/8.0),
    REAL_CONST(61871.561603/8.0),
    REAL_CONST(61892.591152/8.0),
    REAL_CONST(61913.622487/8.0),
    REAL_CONST(61934.655609/8.0),
    REAL_CONST(61955.690516/8.0),
    REAL_CONST(61976.727209/8.0),
    REAL_CONST(61997.765687/8.0),
    REAL_CONST(62018.805951/8.0),
    REAL_CONST(62039.847998/8.0),
    REAL_CONST(62060.891831/8.0),
    REAL_CONST(62081.937447/8.0),
    REAL_CONST(62102.984847/8.0),
    REAL_CONST(62124.034030/8.0),
    REAL_CONST(62145.084997/8.0),
    REAL_CONST(62166.137746/8.0),
    REAL_CONST(62187.192278/8.0),
    REAL_CONST(62208.248592/8.0),
    REAL_CONST(62229.306689/8.0),
    REAL_CONST(62250.366566/8.0),
    REAL_CONST(62271.428226/8.0),
    REAL_CONST(62292.491666/8.0),
    REAL_CONST(62313.556887/8.0),
    REAL_CONST(62334.623888/8.0),
    REAL_CONST(62355.692669/8.0),
    REAL_CONST(62376.763231/8.0),
    REAL_CONST(62397.835572/8.0),
    REAL_CONST(62418.909692/8.0),
    REAL_CONST(62439.985591/8.0),
    REAL_CONST(62461.063268/8.0),
    REAL_CONST(62482.142724/8.0),
    REAL_CONST(62503.223958/8.0),
    REAL_CONST(62524.306970/8.0),
    REAL_CONST(62545.391759/8.0),
    REAL_CONST(62566.478326/8.0),
    REAL_CONST(62587.566669/8.0),
    REAL_CONST(62608.656788/8.0),
    REAL_CONST(62629.748684/8.0),
    REAL_CONST(62650.842356/8.0),
    REAL_CONST(62671.937804/8.0),
    REAL_CONST(62693.035027/8.0),
    REAL_CONST(62714.134024/8.0),
    REAL_CONST(62735.234797/8.0),
    REAL_CONST(62756.337344/8.0),
    REAL_CONST(62777.441665/8.0),
    REAL_CONST(62798.547760/8.0),
    REAL_CONST(62819.655629/8.0),
    REAL_CONST(62840.765271/8.0),
    REAL_CONST(62861.876685/8.0),
    REAL_CONST(62882.989873/8.0),
    REAL_CONST(62904.104833/8.0),
    REAL_CONST(62925.221565/8.0),
    REAL_CONST(62946.340068/8.0),
    REAL_CONST(62967.460343/8.0),
    REAL_CONST(62988.582389/8.0),
    REAL_CONST(63009.706207/8.0),
    REAL_CONST(63030.831794/8.0),
    REAL_CONST(63051.959152/8.0),
    REAL_CONST(63073.088280/8.0),
    REAL_CONST(63094.219178/8.0),
    REAL_CONST(63115.351845/8.0),
    REAL_CONST(63136.486281/8.0),
    REAL_CONST(63157.622486/8.0),
    REAL_CONST(63178.760459/8.0),
    REAL_CONST(63199.900201/8.0),
    REAL_CONST(63221.041710/8.0),
    REAL_CONST(63242.184987/8.0),
    REAL_CONST(63263.330032/8.0),
    REAL_CONST(63284.476843/8.0),
    REAL_CONST(63305.625421/8.0),
    REAL_CONST(63326.775766/8.0),
    REAL_CONST(63347.927877/8.0),
    REAL_CONST(63369.081753/8.0),
    REAL_CONST(63390.237395/8.0),
    REAL_CONST(63411.394803/8.0),
    REAL_CONST(63432.553975/8.0),
    REAL_CONST(63453.714912/8.0),
    REAL_CONST(63474.877613/8.0),
    REAL_CONST(63496.042079/8.0),
    REAL_CONST(63517.208308/8.0),
    REAL_CONST(63538.376301/8.0),
    REAL_CONST(63559.546056/8.0),
    REAL_CONST(63580.717575/8.0),
    REAL_CONST(63601.890857/8.0),
    REAL_CONST(63623.065900/8.0),
    REAL_CONST(63644.242706/8.0),
    REAL_CONST(63665.421273/8.0),
    REAL_CONST(63686.601602/8.0),
    REAL_CONST(63707.783692/8.0),
    REAL_CONST(63728.967543/8.0),
    REAL_CONST(63750.153155/8.0),
    REAL_CONST(63771.340526/8.0),
    REAL_CONST(63792.529658/8.0),
    REAL_CONST(63813.720549/8.0),
    REAL_CONST(63834.913200/8.0),
    REAL_CONST(63856.107610/8.0),
    REAL_CONST(63877.303778/8.0),
    REAL_CONST(63898.501705/8.0),
    REAL_CONST(63919.701391/8.0),
    REAL_CONST(63940.902834/8.0),
    REAL_CONST(63962.106035/8.0),
    REAL_CONST(63983.310993/8.0),
    REAL_CONST(64004.517708/8.0),
    REAL_CONST(64025.726180/8.0),
    REAL_CONST(64046.936409/8.0),
    REAL_CONST(64068.148393/8.0),
    REAL_CONST(64089.362134/8.0),
    REAL_CONST(64110.577630/8.0),
    REAL_CONST(64131.794881/8.0),
    REAL_CONST(64153.013888/8.0),
    REAL_CONST(64174.234649/8.0),
    REAL_CONST(64195.457165/8.0),
    REAL_CONST(64216.681434/8.0),
    REAL_CONST(64237.907458/8.0),
    REAL_CONST(64259.135235/8.0),
    REAL_CONST(64280.364766/8.0),
    REAL_CONST(64301.596049/8.0),
    REAL_CONST(64322.829085/8.0),
    REAL_CONST(64344.063874/8.0),
    REAL_CONST(64365.300414/8.0),
    REAL_CONST(64386.538707/8.0),
    REAL_CONST(64407.778751/8.0),
    REAL_CONST(64429.020546/8.0),
    REAL_CONST(64450.264092/8.0),
    REAL_CONST(64471.509389/8.0),
    REAL_CONST(64492.756437/8.0),
    REAL_CONST(64514.005234/8.0),
    REAL_CONST(64535.255781/8.0),
    REAL_CONST(64556.508078/8.0),
    REAL_CONST(64577.762124/8.0),
    REAL_CONST(64599.017919/8.0),
    REAL_CONST(64620.275462/8.0),
    REAL_CONST(64641.534754/8.0),
    REAL_CONST(64662.795794/8.0),
    REAL_CONST(64684.058582/8.0),
    REAL_CONST(64705.323117/8.0),
    REAL_CONST(64726.589400/8.0),
    REAL_CONST(64747.857429/8.0),
    REAL_CONST(64769.127205/8.0),
    REAL_CONST(64790.398728/8.0),
    REAL_CONST(64811.671996/8.0),
    REAL_CONST(64832.947011/8.0),
    REAL_CONST(64854.223770/8.0),
    REAL_CONST(64875.502276/8.0),
    REAL_CONST(64896.782525/8.0),
    REAL_CONST(64918.064520/8.0),
    REAL_CONST(64939.348259/8.0),
    REAL_CONST(64960.633742/8.0),
    REAL_CONST(64981.920969/8.0),
    REAL_CONST(65003.209939/8.0),
    REAL_CONST(65024.500653/8.0),
    REAL_CONST(65045.793109/8.0),
    REAL_CONST(65067.087308/8.0),
    REAL_CONST(65088.383250/8.0),
    REAL_CONST(65109.680933/8.0),
    REAL_CONST(65130.980358/8.0),
    REAL_CONST(65152.281525/8.0),
    REAL_CONST(65173.584433/8.0),
    REAL_CONST(65194.889082/8.0),
    REAL_CONST(65216.195472/8.0),
    REAL_CONST(65237.503602/8.0),
    REAL_CONST(65258.813472/8.0),
    REAL_CONST(65280.125081/8.0),
    REAL_CONST(65301.438431/8.0),
    REAL_CONST(65322.753519/8.0),
    REAL_CONST(65344.070347/8.0),
    REAL_CONST(65365.388913/8.0),
    REAL_CONST(65386.709218/8.0),
    REAL_CONST(65408.031260/8.0),
    REAL_CONST(65429.355041/8.0),
    REAL_CONST(65450.680559/8.0),
    REAL_CONST(65472.007814/8.0),
    REAL_CONST(65493.336806/8.0),
    REAL_CONST(65514.667535/8.0),
    REAL_CONST(65536.000000/8.0),
    REAL_CONST(65557.334201/8.0),
    REAL_CONST(65578.670139/8.0),
    REAL_CONST(65600.007811/8.0),
    REAL_CONST(65621.347219/8.0),
    REAL_CONST(65642.688362/8.0),
    REAL_CONST(65664.031240/8.0),
    REAL_CONST(65685.375852/8.0),
    REAL_CONST(65706.722198/8.0),
    REAL_CONST(65728.070278/8.0),
    REAL_CONST(65749.420092/8.0),
    REAL_CONST(65770.771639/8.0),
    REAL_CONST(65792.124919/8.0),
    REAL_CONST(65813.479931/8.0),
    REAL_CONST(65834.836677/8.0),
    REAL_CONST(65856.195154/8.0),
    REAL_CONST(65877.555363/8.0),
    REAL_CONST(65898.917304/8.0),
    REAL_CONST(65920.280976/8.0),
    REAL_CONST(65941.646379/8.0),
    REAL_CONST(65963.013513/8.0),
    REAL_CONST(65984.382377/8.0),
    REAL_CONST(66005.752972/8.0),
    REAL_CONST(66027.125296/8.0),
    REAL_CONST(66048.499351/8.0),
    REAL_CONST(66069.875134/8.0),
    REAL_CONST(66091.252647/8.0),
    REAL_CONST(66112.631888/8.0),
    REAL_CONST(66134.012858/8.0),
    REAL_CONST(66155.395556/8.0),
    REAL_CONST(66176.779982/8.0),
    REAL_CONST(66198.166136/8.0),
    REAL_CONST(66219.554017/8.0),
    REAL_CONST(66240.943626/8.0),
    REAL_CONST(66262.334961/8.0),
    REAL_CONST(66283.728023/8.0),
    REAL_CONST(66305.122811/8.0),
    REAL_CONST(66326.519325/8.0),
    REAL_CONST(66347.917565/8.0),
    REAL_CONST(66369.317530/8.0),
    REAL_CONST(66390.719220/8.0),
    REAL_CONST(66412.122636/8.0),
    REAL_CONST(66433.527776/8.0),
    REAL_CONST(66454.934640/8.0),
    REAL_CONST(66476.343228/8.0),
    REAL_CONST(66497.753540/8.0),
    REAL_CONST(66519.165576/8.0),
    REAL_CONST(66540.579335/8.0),
    REAL_CONST(66561.994817/8.0),
    REAL_CONST(66583.412021/8.0),
    REAL_CONST(66604.830948/8.0),
    REAL_CONST(66626.251597/8.0),
    REAL_CONST(66647.673968/8.0),
    REAL_CONST(66669.098061/8.0),
    REAL_CONST(66690.523875/8.0),
    REAL_CONST(66711.951409/8.0),
    REAL_CONST(66733.380665/8.0),
    REAL_CONST(66754.811641/8.0),
    REAL_CONST(66776.244337/8.0),
    REAL_CONST(66797.678753/8.0),
    REAL_CONST(66819.114889/8.0),
    REAL_CONST(66840.552744/8.0),
    REAL_CONST(66861.992318/8.0),
    REAL_CONST(66883.433611/8.0),
    REAL_CONST(66904.876623/8.0),
    REAL_CONST(66926.321353/8.0),
    REAL_CONST(66947.767800/8.0),
    REAL_CONST(66969.215966/8.0),
    REAL_CONST(66990.665849/8.0),
    REAL_CONST(67012.117449/8.0),
    REAL_CONST(67033.570766/8.0),
    REAL_CONST(67055.025800/8.0),
    REAL_CONST(67076.482549/8.0),
    REAL_CONST(67097.941015/8.0),
    REAL_CONST(67119.401197/8.0),
    REAL_CONST(67140.863094/8.0),
    REAL_CONST(67162.326707/8.0),
    REAL_CONST(67183.792034/8.0),
    REAL_CONST(67205.259077/8.0),
    REAL_CONST(67226.727833/8.0),
    REAL_CONST(67248.198304/8.0),
    REAL_CONST(67269.670488/8.0),
    REAL_CONST(67291.144387/8.0),
    REAL_CONST(67312.619998/8.0),
    REAL_CONST(67334.097323/8.0),
    REAL_CONST(67355.576360/8.0),
    REAL_CONST(67377.057110/8.0),
    REAL_CONST(67398.539572/8.0),
    REAL_CONST(67420.023746/8.0),
    REAL_CONST(67441.509631/8.0),
    REAL_CONST(67462.997228/8.0),
    REAL_CONST(67484.486537/8.0),
    REAL_CONST(67505.977556/8.0),
    REAL_CONST(67527.470285/8.0),
    REAL_CONST(67548.964725/8.0),
    REAL_CONST(67570.460875/8.0),
    REAL_CONST(67591.958735/8.0),
    REAL_CONST(67613.458305/8.0),
    REAL_CONST(67634.959583/8.0),
    REAL_CONST(67656.462571/8.0),
    REAL_CONST(67677.967267/8.0),
    REAL_CONST(67699.473671/8.0),
    REAL_CONST(67720.981784/8.0),
    REAL_CONST(67742.491605/8.0),
    REAL_CONST(67764.003133/8.0),
    REAL_CONST(67785.516369/8.0),
    REAL_CONST(67807.031311/8.0),
    REAL_CONST(67828.547961/8.0),
    REAL_CONST(67850.066317/8.0),
    REAL_CONST(67871.586379/8.0),
    REAL_CONST(67893.108147/8.0),
    REAL_CONST(67914.631621/8.0),
    REAL_CONST(67936.156800/8.0),
    REAL_CONST(67957.683685/8.0),
    REAL_CONST(67979.212274/8.0),
    REAL_CONST(68000.742568/8.0),
    REAL_CONST(68022.274566/8.0),
    REAL_CONST(68043.808269/8.0),
    REAL_CONST(68065.343675/8.0),
    REAL_CONST(68086.880785/8.0),
    REAL_CONST(68108.419598/8.0),
    REAL_CONST(68129.960114/8.0),
    REAL_CONST(68151.502333/8.0),
    REAL_CONST(68173.046254/8.0),
    REAL_CONST(68194.591878/8.0),
    REAL_CONST(68216.139203/8.0),
    REAL_CONST(68237.688230/8.0),
    REAL_CONST(68259.238959/8.0),
    REAL_CONST(68280.791388/8.0),
    REAL_CONST(68302.345519/8.0),
    REAL_CONST(68323.901350/8.0),
    REAL_CONST(68345.458881/8.0),
    REAL_CONST(68367.018113/8.0),
    REAL_CONST(68388.579044/8.0),
    REAL_CONST(68410.141675/8.0),
    REAL_CONST(68431.706005/8.0),
    REAL_CONST(68453.272034/8.0),
    REAL_CONST(68474.839762/8.0),
    REAL_CONST(68496.409188/8.0),
    REAL_CONST(68517.980312/8.0),
    REAL_CONST(68539.553134/8.0),
    REAL_CONST(68561.127654/8.0),
    REAL_CONST(68582.703872/8.0),
    REAL_CONST(68604.281786/8.0),
    REAL_CONST(68625.861397/8.0),
    REAL_CONST(68647.442705/8.0),
    REAL_CONST(68669.025709/8.0),
    REAL_CONST(68690.610409/8.0),
    REAL_CONST(68712.196805/8.0),
    REAL_CONST(68733.784897/8.0),
    REAL_CONST(68755.374683/8.0),
    REAL_CONST(68776.966165/8.0),
    REAL_CONST(68798.559341/8.0),
    REAL_CONST(68820.154212/8.0),
    REAL_CONST(68841.750777/8.0),
    REAL_CONST(68863.349036/8.0),
    REAL_CONST(68884.948989/8.0),
    REAL_CONST(68906.550635/8.0),
    REAL_CONST(68928.153974/8.0),
    REAL_CONST(68949.759006/8.0),
    REAL_CONST(68971.365730/8.0),
    REAL_CONST(68992.974147/8.0),
    REAL_CONST(69014.584256/8.0),
    REAL_CONST(69036.196057/8.0),
    REAL_CONST(69057.809549/8.0),
    REAL_CONST(69079.424732/8.0),
    REAL_CONST(69101.041607/8.0),
    REAL_CONST(69122.660172/8.0),
    REAL_CONST(69144.280428/8.0),
    REAL_CONST(69165.902373/8.0),
    REAL_CONST(69187.526009/8.0),
    REAL_CONST(69209.151335/8.0),
    REAL_CONST(69230.778350/8.0),
    REAL_CONST(69252.407054/8.0),
    REAL_CONST(69274.037447/8.0),
    REAL_CONST(69295.669528/8.0),
    REAL_CONST(69317.303298/8.0),
    REAL_CONST(69338.938756/8.0),
    REAL_CONST(69360.575902/8.0),
    REAL_CONST(69382.214735/8.0),
    REAL_CONST(69403.855256/8.0),
    REAL_CONST(69425.497464/8.0),
    REAL_CONST(69447.141358/8.0),
    REAL_CONST(69468.786939/8.0),
    REAL_CONST(69490.434207/8.0),
    REAL_CONST(69512.083160/8.0),
    REAL_CONST(69533.733799/8.0),
    REAL_CONST(69555.386124/8.0),
    REAL_CONST(69577.040133/8.0),
    REAL_CONST(69598.695828/8.0),
    REAL_CONST(69620.353207/8.0),
    REAL_CONST(69642.012271/8.0),
    REAL_CONST(69663.673019/8.0),
    REAL_CONST(69685.335451/8.0),
    REAL_CONST(69706.999566/8.0),
    REAL_CONST(69728.665365/8.0),
    REAL_CONST(69750.332847/8.0),
    REAL_CONST(69772.002011/8.0),
    REAL_CONST(69793.672859/8.0),
    REAL_CONST(69815.345388/8.0),
    REAL_CONST(69837.019600/8.0),
    REAL_CONST(69858.695494/8.0),
    REAL_CONST(69880.373069/8.0),
    REAL_CONST(69902.052325/8.0),
    REAL_CONST(69923.733262/8.0),
    REAL_CONST(69945.415880/8.0),
    REAL_CONST(69967.100179/8.0),
    REAL_CONST(69988.786158/8.0),
    REAL_CONST(70010.473817/8.0),
    REAL_CONST(70032.163155/8.0),
    REAL_CONST(70053.854173/8.0),
    REAL_CONST(70075.546870/8.0),
    REAL_CONST(70097.241246/8.0),
    REAL_CONST(70118.937301/8.0),
    REAL_CONST(70140.635034/8.0),
    REAL_CONST(70162.334446/8.0),
    REAL_CONST(70184.035535/8.0),
    REAL_CONST(70205.738302/8.0),
    REAL_CONST(70227.442746/8.0),
    REAL_CONST(70249.148867/8.0),
    REAL_CONST(70270.856666/8.0),
    REAL_CONST(70292.566141/8.0),
    REAL_CONST(70314.277292/8.0),
    REAL_CONST(70335.990119/8.0),
    REAL_CONST(70357.704622/8.0),
    REAL_CONST(70379.420801/8.0),
    REAL_CONST(70401.138655/8.0),
    REAL_CONST(70422.858184/8.0),
    REAL_CONST(70444.579388/8.0),
    REAL_CONST(70466.302266/8.0),
    REAL_CONST(70488.026819/8.0),
    REAL_CONST(70509.753045/8.0),
    REAL_CONST(70531.480946/8.0),
    REAL_CONST(70553.210520/8.0),
    REAL_CONST(70574.941767/8.0),
    REAL_CONST(70596.674687/8.0),
    REAL_CONST(70618.409280/8.0),
    REAL_CONST(70640.145545/8.0),
    REAL_CONST(70661.883483/8.0),
    REAL_CONST(70683.623092/8.0),
    REAL_CONST(70705.364373/8.0),
    REAL_CONST(70727.107326/8.0),
    REAL_CONST(70748.851950/8.0),
    REAL_CONST(70770.598245/8.0),
    REAL_CONST(70792.346210/8.0),
    REAL_CONST(70814.095846/8.0),
    REAL_CONST(70835.847152/8.0),
    REAL_CONST(70857.600128/8.0),
    REAL_CONST(70879.354773/8.0),
    REAL_CONST(70901.111088/8.0),
    REAL_CONST(70922.869072/8.0),
    REAL_CONST(70944.628725/8.0),
    REAL_CONST(70966.390047/8.0),
    REAL_CONST(70988.153037/8.0),
    REAL_CONST(71009.917695/8.0),
    REAL_CONST(71031.684021/8.0),
    REAL_CONST(71053.452014/8.0),
    REAL_CONST(71075.221675/8.0),
    REAL_CONST(71096.993003/8.0),
    REAL_CONST(71118.765998/8.0),
    REAL_CONST(71140.540659/8.0),
    REAL_CONST(71162.316987/8.0),
    REAL_CONST(71184.094980/8.0),
    REAL_CONST(71205.874640/8.0),
    REAL_CONST(71227.655965/8.0),
    REAL_CONST(71249.438955/8.0),
    REAL_CONST(71271.223611/8.0),
    REAL_CONST(71293.009931/8.0),
    REAL_CONST(71314.797916/8.0),
    REAL_CONST(71336.587565/8.0),
    REAL_CONST(71358.378878/8.0),
    REAL_CONST(71380.171855/8.0),
    REAL_CONST(71401.966495/8.0),
    REAL_CONST(71423.762799/8.0),
    REAL_CONST(71445.560766/8.0),
    REAL_CONST(71467.360395/8.0),
    REAL_CONST(71489.161687/8.0),
    REAL_CONST(71510.964641/8.0),
    REAL_CONST(71532.769257/8.0),
    REAL_CONST(71554.575535/8.0),
    REAL_CONST(71576.383475/8.0),
    REAL_CONST(71598.193075/8.0),
    REAL_CONST(71620.004337/8.0),
    REAL_CONST(71641.817260/8.0),
    REAL_CONST(71663.631842/8.0),
    REAL_CONST(71685.448086/8.0),
    REAL_CONST(71707.265989/8.0),
    REAL_CONST(71729.085551/8.0),
    REAL_CONST(71750.906774/8.0),
    REAL_CONST(71772.729655/8.0),
    REAL_CONST(71794.554196/8.0),
    REAL_CONST(71816.380395/8.0),
    REAL_CONST(71838.208253/8.0),
    REAL_CONST(71860.037768/8.0),
    REAL_CONST(71881.868942/8.0),
    REAL_CONST(71903.701774/8.0),
    REAL_CONST(71925.536263/8.0),
    REAL_CONST(71947.372409/8.0),
    REAL_CONST(71969.210212/8.0),
    REAL_CONST(71991.049672/8.0),
    REAL_CONST(72012.890788/8.0),
    REAL_CONST(72034.733561/8.0),
    REAL_CONST(72056.577989/8.0),
    REAL_CONST(72078.424073/8.0),
    REAL_CONST(72100.271813/8.0),
    REAL_CONST(72122.121208/8.0),
    REAL_CONST(72143.972257/8.0),
    REAL_CONST(72165.824962/8.0),
    REAL_CONST(72187.679321/8.0),
    REAL_CONST(72209.535334/8.0),
    REAL_CONST(72231.393001/8.0),
    REAL_CONST(72253.252321/8.0),
    REAL_CONST(72275.113295/8.0),
    REAL_CONST(72296.975923/8.0),
    REAL_CONST(72318.840203/8.0),
    REAL_CONST(72340.706136/8.0),
    REAL_CONST(72362.573721/8.0),
    REAL_CONST(72384.442959/8.0),
    REAL_CONST(72406.313848/8.0),
    REAL_CONST(72428.186390/8.0),
    REAL_CONST(72450.060582/8.0),
    REAL_CONST(72471.936426/8.0),
    REAL_CONST(72493.813921/8.0),
    REAL_CONST(72515.693066/8.0),
    REAL_CONST(72537.573862/8.0),
    REAL_CONST(72559.456308/8.0),
    REAL_CONST(72581.340405/8.0),
    REAL_CONST(72603.226150/8.0),
    REAL_CONST(72625.113546/8.0),
    REAL_CONST(72647.002590/8.0),
    REAL_CONST(72668.893283/8.0),
    REAL_CONST(72690.785625/8.0),
    REAL_CONST(72712.679616/8.0),
    REAL_CONST(72734.575255/8.0),
    REAL_CONST(72756.472542/8.0),
    REAL_CONST(72778.371476/8.0),
    REAL_CONST(72800.272058/8.0),
    REAL_CONST(72822.174287/8.0),
    REAL_CONST(72844.078163/8.0),
    REAL_CONST(72865.983686/8.0),
    REAL_CONST(72887.890855/8.0),
    REAL_CONST(72909.799671/8.0),
    REAL_CONST(72931.710132/8.0),
    REAL_CONST(72953.622239/8.0),
    REAL_CONST(72975.535992/8.0),
    REAL_CONST(72997.451390/8.0),
    REAL_CONST(73019.368433/8.0),
    REAL_CONST(73041.287121/8.0),
    REAL_CONST(73063.207453/8.0),
    REAL_CONST(73085.129429/8.0),
    REAL_CONST(73107.053050/8.0),
    REAL_CONST(73128.978314/8.0),
    REAL_CONST(73150.905222/8.0),
    REAL_CONST(73172.833773/8.0),
    REAL_CONST(73194.763967/8.0),
    REAL_CONST(73216.695803/8.0),
    REAL_CONST(73238.629283/8.0),
    REAL_CONST(73260.564404/8.0),
    REAL_CONST(73282.501168/8.0),
    REAL_CONST(73304.439573/8.0),
    REAL_CONST(73326.379620/8.0),
    REAL_CONST(73348.321308/8.0),
    REAL_CONST(73370.264638/8.0),
    REAL_CONST(73392.209608/8.0),
    REAL_CONST(73414.156218/8.0),
    REAL_CONST(73436.104469/8.0),
    REAL_CONST(73458.054361/8.0),
    REAL_CONST(73480.005891/8.0),
    REAL_CONST(73501.959062/8.0),
    REAL_CONST(73523.913872/8.0),
    REAL_CONST(73545.870321/8.0),
    REAL_CONST(73567.828408/8.0),
    REAL_CONST(73589.788135/8.0),
    REAL_CONST(73611.749499/8.0),
    REAL_CONST(73633.712502/8.0),
    REAL_CONST(73655.677143/8.0),
    REAL_CONST(73677.643421/8.0),
    REAL_CONST(73699.611337/8.0),
    REAL_CONST(73721.580889/8.0),
    REAL_CONST(73743.552079/8.0),
    REAL_CONST(73765.524906/8.0),
    REAL_CONST(73787.499368/8.0),
    REAL_CONST(73809.475467/8.0),
    REAL_CONST(73831.453202/8.0),
    REAL_CONST(73853.432573/8.0),
    REAL_CONST(73875.413579/8.0),
    REAL_CONST(73897.396220/8.0),
    REAL_CONST(73919.380496/8.0),
    REAL_CONST(73941.366406/8.0),
    REAL_CONST(73963.353952/8.0),
    REAL_CONST(73985.343131/8.0),
    REAL_CONST(74007.333945/8.0),
    REAL_CONST(74029.326392/8.0),
    REAL_CONST(74051.320472/8.0),
    REAL_CONST(74073.316186/8.0),
    REAL_CONST(74095.313533/8.0),
    REAL_CONST(74117.312513/8.0),
    REAL_CONST(74139.313125/8.0),
    REAL_CONST(74161.315369/8.0),
    REAL_CONST(74183.319246/8.0),
    REAL_CONST(74205.324754/8.0),
    REAL_CONST(74227.331894/8.0),
    REAL_CONST(74249.340665/8.0),
    REAL_CONST(74271.351067/8.0),
    REAL_CONST(74293.363100/8.0),
    REAL_CONST(74315.376764/8.0),
    REAL_CONST(74337.392058/8.0),
    REAL_CONST(74359.408982/8.0),
    REAL_CONST(74381.427536/8.0),
    REAL_CONST(74403.447719/8.0),
    REAL_CONST(74425.469532/8.0),
    REAL_CONST(74447.492974/8.0),
    REAL_CONST(74469.518045/8.0),
    REAL_CONST(74491.544744/8.0),
    REAL_CONST(74513.573072/8.0),
    REAL_CONST(74535.603028/8.0),
    REAL_CONST(74557.634612/8.0),
    REAL_CONST(74579.667824/8.0),
    REAL_CONST(74601.702663/8.0),
    REAL_CONST(74623.739130/8.0),
    REAL_CONST(74645.777223/8.0),
    REAL_CONST(74667.816943/8.0),
    REAL_CONST(74689.858290/8.0),
    REAL_CONST(74711.901263/8.0),
    REAL_CONST(74733.945861/8.0),
    REAL_CONST(74755.992086/8.0),
    REAL_CONST(74778.039936/8.0),
    REAL_CONST(74800.089412/8.0),
    REAL_CONST(74822.140512/8.0),
    REAL_CONST(74844.193237/8.0),
    REAL_CONST(74866.247587/8.0),
    REAL_CONST(74888.303561/8.0),
    REAL_CONST(74910.361160/8.0),
    REAL_CONST(74932.420382/8.0),
    REAL_CONST(74954.481227/8.0),
    REAL_CONST(74976.543697/8.0),
    REAL_CONST(74998.607789/8.0),
    REAL_CONST(75020.673504/8.0),
    REAL_CONST(75042.740842/8.0),
    REAL_CONST(75064.809802/8.0),
    REAL_CONST(75086.880384/8.0),
    REAL_CONST(75108.952589/8.0),
    REAL_CONST(75131.026415/8.0),
    REAL_CONST(75153.101862/8.0),
    REAL_CONST(75175.178931/8.0),
    REAL_CONST(75197.257621/8.0),
    REAL_CONST(75219.337931/8.0),
    REAL_CONST(75241.419862/8.0),
    REAL_CONST(75263.503414/8.0),
    REAL_CONST(75285.588585/8.0),
    REAL_CONST(75307.675376/8.0),
    REAL_CONST(75329.763787/8.0),
    REAL_CONST(75351.853817/8.0),
    REAL_CONST(75373.945466/8.0),
    REAL_CONST(75396.038734/8.0),
    REAL_CONST(75418.133620/8.0),
    REAL_CONST(75440.230125/8.0),
    REAL_CONST(75462.328248/8.0),
    REAL_CONST(75484.427989/8.0),
    REAL_CONST(75506.529348/8.0),
    REAL_CONST(75528.632324/8.0),
    REAL_CONST(75550.736917/8.0),
    REAL_CONST(75572.843127/8.0),
    REAL_CONST(75594.950954/8.0),
    REAL_CONST(75617.060398/8.0),
    REAL_CONST(75639.171457/8.0),
    REAL_CONST(75661.284133/8.0),
    REAL_CONST(75683.398424/8.0),
    REAL_CONST(75705.514331/8.0),
    REAL_CONST(75727.631854/8.0),
    REAL_CONST(75749.750991/8.0),
    REAL_CONST(75771.871743/8.0),
    REAL_CONST(75793.994110/8.0),
    REAL_CONST(75816.118091/8.0),
    REAL_CONST(75838.243686/8.0),
    REAL_CONST(75860.370896/8.0),
    REAL_CONST(75882.499718/8.0),
    REAL_CONST(75904.630155/8.0),
    REAL_CONST(75926.762204/8.0),
    REAL_CONST(75948.895866/8.0),
    REAL_CONST(75971.031141/8.0),
    REAL_CONST(75993.168029/8.0),
    REAL_CONST(76015.306529/8.0),
    REAL_CONST(76037.446640/8.0),
    REAL_CONST(76059.588364/8.0),
    REAL_CONST(76081.731699/8.0),
    REAL_CONST(76103.876646/8.0),
    REAL_CONST(76126.023203/8.0),
    REAL_CONST(76148.171371/8.0),
    REAL_CONST(76170.321150/8.0),
    REAL_CONST(76192.472539/8.0),
    REAL_CONST(76214.625539/8.0),
    REAL_CONST(76236.780148/8.0),
    REAL_CONST(76258.936367/8.0),
    REAL_CONST(76281.094196/8.0),
    REAL_CONST(76303.253633/8.0),
    REAL_CONST(76325.414680/8.0),
    REAL_CONST(76347.577335/8.0),
    REAL_CONST(76369.741599/8.0),
    REAL_CONST(76391.907471/8.0),
    REAL_CONST(76414.074951/8.0),
    REAL_CONST(76436.244039/8.0),
    REAL_CONST(76458.414734/8.0),
    REAL_CONST(76480.587037/8.0),
    REAL_CONST(76502.760947/8.0),
    REAL_CONST(76524.936463/8.0),
    REAL_CONST(76547.113587/8.0),
    REAL_CONST(76569.292316/8.0),
    REAL_CONST(76591.472652/8.0),
    REAL_CONST(76613.654594/8.0),
    REAL_CONST(76635.838142/8.0),
    REAL_CONST(76658.023295/8.0),
    REAL_CONST(76680.210053/8.0),
    REAL_CONST(76702.398416/8.0),
    REAL_CONST(76724.588384/8.0),
    REAL_CONST(76746.779957/8.0),
    REAL_CONST(76768.973134/8.0),
    REAL_CONST(76791.167915/8.0),
    REAL_CONST(76813.364299/8.0),
    REAL_CONST(76835.562288/8.0),
    REAL_CONST(76857.761880/8.0),
    REAL_CONST(76879.963074/8.0),
    REAL_CONST(76902.165872/8.0),
    REAL_CONST(76924.370273/8.0),
    REAL_CONST(76946.576276/8.0),
    REAL_CONST(76968.783881/8.0),
    REAL_CONST(76990.993088/8.0),
    REAL_CONST(77013.203897/8.0),
    REAL_CONST(77035.416308/8.0),
    REAL_CONST(77057.630319/8.0),
    REAL_CONST(77079.845932/8.0),
    REAL_CONST(77102.063146/8.0),
    REAL_CONST(77124.281960/8.0),
    REAL_CONST(77146.502375/8.0),
    REAL_CONST(77168.724390/8.0),
    REAL_CONST(77190.948004/8.0),
    REAL_CONST(77213.173219/8.0),
    REAL_CONST(77235.400033/8.0),
    REAL_CONST(77257.628446/8.0),
    REAL_CONST(77279.858458/8.0),
    REAL_CONST(77302.090069/8.0),
    REAL_CONST(77324.323278/8.0),
    REAL_CONST(77346.558086/8.0),
    REAL_CONST(77368.794491/8.0),
    REAL_CONST(77391.032495/8.0),
    REAL_CONST(77413.272096/8.0),
    REAL_CONST(77435.513295/8.0),
    REAL_CONST(77457.756090/8.0),
    REAL_CONST(77480.000483/8.0),
    REAL_CONST(77502.246473/8.0),
    REAL_CONST(77524.494058/8.0),
    REAL_CONST(77546.743240/8.0),
    REAL_CONST(77568.994019/8.0),
    REAL_CONST(77591.246392/8.0),
    REAL_CONST(77613.500362/8.0),
    REAL_CONST(77635.755927/8.0),
    REAL_CONST(77658.013086/8.0),
    REAL_CONST(77680.271841/8.0),
    REAL_CONST(77702.532191/8.0),
    REAL_CONST(77724.794134/8.0),
    REAL_CONST(77747.057672/8.0),
    REAL_CONST(77769.322804/8.0),
    REAL_CONST(77791.589530/8.0),
    REAL_CONST(77813.857849/8.0),
    REAL_CONST(77836.127761/8.0),
    REAL_CONST(77858.399267/8.0),
    REAL_CONST(77880.672365/8.0),
    REAL_CONST(77902.947056/8.0),
    REAL_CONST(77925.223339/8.0),
    REAL_CONST(77947.501214/8.0),
    REAL_CONST(77969.780681/8.0),
    REAL_CONST(77992.061740/8.0),
    REAL_CONST(78014.344391/8.0),
    REAL_CONST(78036.628632/8.0),
    REAL_CONST(78058.914465/8.0),
    REAL_CONST(78081.201888/8.0),
    REAL_CONST(78103.490902/8.0),
    REAL_CONST(78125.781506/8.0),
    REAL_CONST(78148.073700/8.0),
    REAL_CONST(78170.367484/8.0),
    REAL_CONST(78192.662858/8.0),
    REAL_CONST(78214.959821/8.0),
    REAL_CONST(78237.258374/8.0),
    REAL_CONST(78259.558515/8.0),
    REAL_CONST(78281.860245/8.0),
    REAL_CONST(78304.163563/8.0),
    REAL_CONST(78326.468470/8.0),
    REAL_CONST(78348.774965/8.0),
    REAL_CONST(78371.083048/8.0),
    REAL_CONST(78393.392718/8.0),
    REAL_CONST(78415.703976/8.0),
    REAL_CONST(78438.016820/8.0),
    REAL_CONST(78460.331252/8.0),
    REAL_CONST(78482.647270/8.0),
    REAL_CONST(78504.964875/8.0),
    REAL_CONST(78527.284066/8.0),
    REAL_CONST(78549.604843/8.0),
    REAL_CONST(78571.927206/8.0),
    REAL_CONST(78594.251155/8.0),
    REAL_CONST(78616.576688/8.0),
    REAL_CONST(78638.903807/8.0),
    REAL_CONST(78661.232511/8.0),
    REAL_CONST(78683.562799/8.0),
    REAL_CONST(78705.894672/8.0),
    REAL_CONST(78728.228129/8.0),
    REAL_CONST(78750.563170/8.0),
    REAL_CONST(78772.899795/8.0),
    REAL_CONST(78795.238004/8.0),
    REAL_CONST(78817.577795/8.0),
    REAL_CONST(78839.919170/8.0),
    REAL_CONST(78862.262128/8.0),
    REAL_CONST(78884.606668/8.0),
    REAL_CONST(78906.952791/8.0),
    REAL_CONST(78929.300496/8.0),
    REAL_CONST(78951.649783/8.0),
    REAL_CONST(78974.000651/8.0),
    REAL_CONST(78996.353101/8.0),
    REAL_CONST(79018.707133/8.0),
    REAL_CONST(79041.062745/8.0),
    REAL_CONST(79063.419939/8.0),
    REAL_CONST(79085.778713/8.0),
    REAL_CONST(79108.139067/8.0),
    REAL_CONST(79130.501002/8.0),
    REAL_CONST(79152.864516/8.0),
    REAL_CONST(79175.229610/8.0),
    REAL_CONST(79197.596284/8.0),
    REAL_CONST(79219.964537/8.0),
    REAL_CONST(79242.334369/8.0),
    REAL_CONST(79264.705780/8.0),
    REAL_CONST(79287.078770/8.0),
    REAL_CONST(79309.453338/8.0),
    REAL_CONST(79331.829484/8.0),
    REAL_CONST(79354.207208/8.0),
    REAL_CONST(79376.586510/8.0),
    REAL_CONST(79398.967390/8.0),
    REAL_CONST(79421.349846/8.0),
    REAL_CONST(79443.733880/8.0),
    REAL_CONST(79466.119490/8.0),
    REAL_CONST(79488.506678/8.0),
    REAL_CONST(79510.895441/8.0),
    REAL_CONST(79533.285781/8.0),
    REAL_CONST(79555.677697/8.0),
    REAL_CONST(79578.071188/8.0),
    REAL_CONST(79600.466255/8.0),
    REAL_CONST(79622.862897/8.0),
    REAL_CONST(79645.261114/8.0),
    REAL_CONST(79667.660907/8.0),
    REAL_CONST(79690.062273/8.0),
    REAL_CONST(79712.465215/8.0),
    REAL_CONST(79734.869730/8.0),
    REAL_CONST(79757.275819/8.0),
    REAL_CONST(79779.683482/8.0),
    REAL_CONST(79802.092719/8.0),
    REAL_CONST(79824.503529/8.0),
    REAL_CONST(79846.915911/8.0),
    REAL_CONST(79869.329867/8.0),
    REAL_CONST(79891.745396/8.0),
    REAL_CONST(79914.162496/8.0),
    REAL_CONST(79936.581169/8.0),
    REAL_CONST(79959.001414/8.0),
    REAL_CONST(79981.423231/8.0),
    REAL_CONST(80003.846619/8.0),
    REAL_CONST(80026.271579/8.0),
    REAL_CONST(80048.698110/8.0),
    REAL_CONST(80071.126211/8.0),
    REAL_CONST(80093.555883/8.0),
    REAL_CONST(80115.987126/8.0),
    REAL_CONST(80138.419939/8.0),
    REAL_CONST(80160.854322/8.0),
    REAL_CONST(80183.290274/8.0),
    REAL_CONST(80205.727796/8.0),
    REAL_CONST(80228.166888/8.0),
    REAL_CONST(80250.607548/8.0),
    REAL_CONST(80273.049778/8.0),
    REAL_CONST(80295.493576/8.0),
    REAL_CONST(80317.938943/8.0),
    REAL_CONST(80340.385877/8.0),
    REAL_CONST(80362.834380/8.0),
    REAL_CONST(80385.284451/8.0),
    REAL_CONST(80407.736089/8.0),
    REAL_CONST(80430.189295/8.0),
    REAL_CONST(80452.644068/8.0),
    REAL_CONST(80475.100407/8.0),
    REAL_CONST(80497.558314/8.0),
    REAL_CONST(80520.017786/8.0),
    REAL_CONST(80542.478825/8.0),
    REAL_CONST(80564.941431/8.0),
    REAL_CONST(80587.405602/8.0),
    REAL_CONST(80609.871338/8.0),
    REAL_CONST(80632.338640/8.0),
    REAL_CONST(80654.807507/8.0),
    REAL_CONST(80677.277939/8.0),
    REAL_CONST(80699.749936/8.0),
    REAL_CONST(80722.223498/8.0),
    REAL_CONST(80744.698623/8.0),
    REAL_CONST(80767.175313/8.0),
    REAL_CONST(80789.653567/8.0),
    REAL_CONST(80812.133384/8.0),
    REAL_CONST(80834.614765/8.0),
    REAL_CONST(80857.097709/8.0),
    REAL_CONST(80879.582216/8.0),
    REAL_CONST(80902.068285/8.0),
    REAL_CONST(80924.555918/8.0),
    REAL_CONST(80947.045112/8.0),
    REAL_CONST(80969.535869/8.0),
    REAL_CONST(80992.028188/8.0),
    REAL_CONST(81014.522068/8.0),
    REAL_CONST(81037.017510/8.0),
    REAL_CONST(81059.514513/8.0),
    REAL_CONST(81082.013077/8.0),
    REAL_CONST(81104.513202/8.0),
    REAL_CONST(81127.014888/8.0),
    REAL_CONST(81149.518134/8.0),
    REAL_CONST(81172.022940/8.0),
    REAL_CONST(81194.529306/8.0),
    REAL_CONST(81217.037232/8.0),
    REAL_CONST(81239.546717/8.0),
    REAL_CONST(81262.057762/8.0),
    REAL_CONST(81284.570366/8.0),
    REAL_CONST(81307.084528/8.0),
    REAL_CONST(81329.600250/8.0),
    REAL_CONST(81352.117530/8.0),
    REAL_CONST(81374.636368/8.0),
    REAL_CONST(81397.156764/8.0),
    REAL_CONST(81419.678718/8.0),
    REAL_CONST(81442.202229/8.0),
    REAL_CONST(81464.727298/8.0),
    REAL_CONST(81487.253924/8.0),
    REAL_CONST(81509.782107/8.0),
    REAL_CONST(81532.311846/8.0),
    REAL_CONST(81554.843143/8.0),
    REAL_CONST(81577.375995/8.0),
    REAL_CONST(81599.910404/8.0),
    REAL_CONST(81622.446368/8.0),
    REAL_CONST(81644.983888/8.0),
    REAL_CONST(81667.522964/8.0),
    REAL_CONST(81690.063594/8.0),
    REAL_CONST(81712.605780/8.0),
    REAL_CONST(81735.149521/8.0),
    REAL_CONST(81757.694816/8.0),
    REAL_CONST(81780.241665/8.0),
    REAL_CONST(81802.790069/8.0),
    REAL_CONST(81825.340026/8.0),
    REAL_CONST(81847.891538/8.0),
    REAL_CONST(81870.444603/8.0),
    REAL_CONST(81892.999221/8.0),
    REAL_CONST(81915.555392/8.0),
    REAL_CONST(81938.113116/8.0),
    REAL_CONST(81960.672393/8.0),
    REAL_CONST(81983.233222/8.0),
    REAL_CONST(82005.795603/8.0),
    REAL_CONST(82028.359536/8.0),
    REAL_CONST(82050.925022/8.0),
    REAL_CONST(82073.492058/8.0),
    REAL_CONST(82096.060647/8.0),
    REAL_CONST(82118.630786/8.0),
    REAL_CONST(82141.202476/8.0),
    REAL_CONST(82163.775717/8.0),
    REAL_CONST(82186.350509/8.0),
    REAL_CONST(82208.926850/8.0),
    REAL_CONST(82231.504742/8.0),
    REAL_CONST(82254.084184/8.0),
    REAL_CONST(82276.665175/8.0),
    REAL_CONST(82299.247716/8.0),
    REAL_CONST(82321.831807/8.0),
    REAL_CONST(82344.417446/8.0),
    REAL_CONST(82367.004634/8.0),
    REAL_CONST(82389.593370/8.0),
    REAL_CONST(82412.183655/8.0),
    REAL_CONST(82434.775488/8.0),
    REAL_CONST(82457.368870/8.0),
    REAL_CONST(82479.963798/8.0),
    REAL_CONST(82502.560275/8.0),
    REAL_CONST(82525.158299/8.0),
    REAL_CONST(82547.757870/8.0),
    REAL_CONST(82570.358987/8.0),
    REAL_CONST(82592.961652/8.0),
    REAL_CONST(82615.565863/8.0),
    REAL_CONST(82638.171620/8.0),
    REAL_CONST(82660.778923/8.0),
    REAL_CONST(82683.387773/8.0),
    REAL_CONST(82705.998167/8.0),
    REAL_CONST(82728.610108/8.0),
    REAL_CONST(82751.223593/8.0),
    REAL_CONST(82773.838624/8.0),
    REAL_CONST(82796.455199/8.0),
    REAL_CONST(82819.073319/8.0),
    REAL_CONST(82841.692983/8.0),
    REAL_CONST(82864.314191/8.0),
    REAL_CONST(82886.936944/8.0),
    REAL_CONST(82909.561240/8.0),
    REAL_CONST(82932.187079/8.0),
    REAL_CONST(82954.814462/8.0),
    REAL_CONST(82977.443388/8.0),
    REAL_CONST(83000.073857/8.0),
    REAL_CONST(83022.705869/8.0),
    REAL_CONST(83045.339423/8.0),
    REAL_CONST(83067.974519/8.0),
    REAL_CONST(83090.611158/8.0),
    REAL_CONST(83113.249338/8.0),
    REAL_CONST(83135.889060/8.0),
    REAL_CONST(83158.530323/8.0),
    REAL_CONST(83181.173128/8.0),
    REAL_CONST(83203.817473/8.0),
    REAL_CONST(83226.463360/8.0),
    REAL_CONST(83249.110787/8.0),
    REAL_CONST(83271.759754/8.0),
    REAL_CONST(83294.410262/8.0),
    REAL_CONST(83317.062309/8.0),
    REAL_CONST(83339.715896/8.0),
    REAL_CONST(83362.371023/8.0),
    REAL_CONST(83385.027689/8.0),
    REAL_CONST(83407.685894/8.0),
    REAL_CONST(83430.345639/8.0),
    REAL_CONST(83453.006921/8.0),
    REAL_CONST(83475.669743/8.0),
    REAL_CONST(83498.334102/8.0),
    REAL_CONST(83521.000000/8.0),
    REAL_CONST(83543.667436/8.0),
    REAL_CONST(83566.336409/8.0),
    REAL_CONST(83589.006919/8.0),
    REAL_CONST(83611.678967/8.0),
    REAL_CONST(83634.352552/8.0),
    REAL_CONST(83657.027674/8.0),
    REAL_CONST(83679.704333/8.0),
    REAL_CONST(83702.382527/8.0),
    REAL_CONST(83725.062258/8.0),
    REAL_CONST(83747.743525/8.0),
    REAL_CONST(83770.426328/8.0),
    REAL_CONST(83793.110667/8.0),
    REAL_CONST(83815.796540/8.0),
    REAL_CONST(83838.483949/8.0),
    REAL_CONST(83861.172893/8.0),
    REAL_CONST(83883.863372/8.0),
    REAL_CONST(83906.555385/8.0),
    REAL_CONST(83929.248932/8.0),
    REAL_CONST(83951.944014/8.0),
    REAL_CONST(83974.640630/8.0),
    REAL_CONST(83997.338779/8.0),
    REAL_CONST(84020.038462/8.0),
    REAL_CONST(84042.739678/8.0),
    REAL_CONST(84065.442427/8.0),
    REAL_CONST(84088.146709/8.0),
    REAL_CONST(84110.852523/8.0),
    REAL_CONST(84133.559871/8.0),
    REAL_CONST(84156.268750/8.0),
    REAL_CONST(84178.979162/8.0),
    REAL_CONST(84201.691105/8.0),
    REAL_CONST(84224.404580/8.0),
    REAL_CONST(84247.119586/8.0),
    REAL_CONST(84269.836124/8.0),
    REAL_CONST(84292.554192/8.0),
    REAL_CONST(84315.273792/8.0),
    REAL_CONST(84337.994922/8.0),
    REAL_CONST(84360.717583/8.0),
    REAL_CONST(84383.441773/8.0),
    REAL_CONST(84406.167494/8.0),
    REAL_CONST(84428.894744/8.0),
    REAL_CONST(84451.623524/8.0),
    REAL_CONST(84474.353834/8.0),
    REAL_CONST(84497.085672/8.0),
    REAL_CONST(84519.819040/8.0),
    REAL_CONST(84542.553936/8.0),
    REAL_CONST(84565.290361/8.0),
    REAL_CONST(84588.028314/8.0),
    REAL_CONST(84610.767795/8.0),
    REAL_CONST(84633.508805/8.0),
    REAL_CONST(84656.251342/8.0),
    REAL_CONST(84678.995406/8.0),
    REAL_CONST(84701.740998/8.0),
    REAL_CONST(84724.488117/8.0),
    REAL_CONST(84747.236763/8.0),
    REAL_CONST(84769.986935/8.0),
    REAL_CONST(84792.738634/8.0),
    REAL_CONST(84815.491860/8.0),
    REAL_CONST(84838.246611/8.0),
    REAL_CONST(84861.002889/8.0),
    REAL_CONST(84883.760692/8.0),
    REAL_CONST(84906.520020/8.0),
    REAL_CONST(84929.280874/8.0),
    REAL_CONST(84952.043253/8.0),
    REAL_CONST(84974.807156/8.0),
    REAL_CONST(84997.572585/8.0),
    REAL_CONST(85020.339537/8.0),
    REAL_CONST(85043.108014/8.0),
    REAL_CONST(85065.878016/8.0),
    REAL_CONST(85088.649540/8.0),
    REAL_CONST(85111.422589/8.0),
    REAL_CONST(85134.197161/8.0),
    REAL_CONST(85156.973256/8.0),
    REAL_CONST(85179.750874/8.0),
    REAL_CONST(85202.530016/8.0),
    REAL_CONST(85225.310679/8.0),
    REAL_CONST(85248.092865/8.0),
    REAL_CONST(85270.876574/8.0),
    REAL_CONST(85293.661804/8.0),
    REAL_CONST(85316.448556/8.0),
    REAL_CONST(85339.236830/8.0),
    REAL_CONST(85362.026625/8.0),
    REAL_CONST(85384.817941/8.0),
    REAL_CONST(85407.610779/8.0),
    REAL_CONST(85430.405137/8.0),
    REAL_CONST(85453.201015/8.0),
    REAL_CONST(85475.998415/8.0),
    REAL_CONST(85498.797334/8.0),
    REAL_CONST(85521.597773/8.0),
    REAL_CONST(85544.399732/8.0),
    REAL_CONST(85567.203211/8.0),
    REAL_CONST(85590.008209/8.0),
    REAL_CONST(85612.814726/8.0),
    REAL_CONST(85635.622762/8.0),
    REAL_CONST(85658.432317/8.0),
    REAL_CONST(85681.243390/8.0),
    REAL_CONST(85704.055982/8.0),
    REAL_CONST(85726.870092/8.0),
    REAL_CONST(85749.685720/8.0),
    REAL_CONST(85772.502865/8.0),
    REAL_CONST(85795.321529/8.0),
    REAL_CONST(85818.141709/8.0),
    REAL_CONST(85840.963407/8.0),
    REAL_CONST(85863.786622/8.0),
    REAL_CONST(85886.611353/8.0),
    REAL_CONST(85909.437601/8.0),
    REAL_CONST(85932.265365/8.0),
    REAL_CONST(85955.094646/8.0),
    REAL_CONST(85977.925442/8.0),
    REAL_CONST(86000.757754/8.0),
    REAL_CONST(86023.591582/8.0),
    REAL_CONST(86046.426925/8.0),
    REAL_CONST(86069.263783/8.0),
    REAL_CONST(86092.102156/8.0),
    REAL_CONST(86114.942043/8.0),
    REAL_CONST(86137.783446/8.0),
    REAL_CONST(86160.626362/8.0),
    REAL_CONST(86183.470793/8.0),
    REAL_CONST(86206.316738/8.0),
    REAL_CONST(86229.164196/8.0),
    REAL_CONST(86252.013168/8.0),
    REAL_CONST(86274.863653/8.0),
    REAL_CONST(86297.715652/8.0),
    REAL_CONST(86320.569163/8.0),
    REAL_CONST(86343.424187/8.0),
    REAL_CONST(86366.280724/8.0),
    REAL_CONST(86389.138773/8.0),
    REAL_CONST(86411.998334/8.0),
    REAL_CONST(86434.859407/8.0),
    REAL_CONST(86457.721991/8.0),
    REAL_CONST(86480.586088/8.0),
    REAL_CONST(86503.451695/8.0),
    REAL_CONST(86526.318814/8.0),
    REAL_CONST(86549.187443/8.0),
    REAL_CONST(86572.057584/8.0),
    REAL_CONST(86594.929234/8.0),
    REAL_CONST(86617.802396/8.0),
    REAL_CONST(86640.677067/8.0),
    REAL_CONST(86663.553248/8.0),
    REAL_CONST(86686.430939/8.0),
    REAL_CONST(86709.310140/8.0),
    REAL_CONST(86732.190849/8.0),
    REAL_CONST(86755.073068/8.0),
    REAL_CONST(86777.956796/8.0),
    REAL_CONST(86800.842033/8.0),
    REAL_CONST(86823.728778/8.0),
    REAL_CONST(86846.617031/8.0),
    REAL_CONST(86869.506793/8.0),
    REAL_CONST(86892.398063/8.0),
    REAL_CONST(86915.290840/8.0),
    REAL_CONST(86938.185125/8.0),
    REAL_CONST(86961.080917/8.0),
    REAL_CONST(86983.978216/8.0),
    REAL_CONST(87006.877023/8.0),
    REAL_CONST(87029.777336/8.0),
    REAL_CONST(87052.679155/8.0),
    REAL_CONST(87075.582481/8.0),
    REAL_CONST(87098.487313/8.0),
    REAL_CONST(87121.393651/8.0),
    REAL_CONST(87144.301495/8.0),
    REAL_CONST(87167.210844/8.0),
    REAL_CONST(87190.121699/8.0),
    REAL_CONST(87213.034059/8.0),
    REAL_CONST(87235.947924/8.0),
    REAL_CONST(87258.863293/8.0),
    REAL_CONST(87281.780168/8.0),
    REAL_CONST(87304.698546/8.0),
    REAL_CONST(87327.618429/8.0),
    REAL_CONST(87350.539816/8.0),
    REAL_CONST(87373.462706/8.0),
    REAL_CONST(87396.387100/8.0),
    REAL_CONST(87419.312998/8.0),
    REAL_CONST(87442.240398/8.0),
    REAL_CONST(87465.169302/8.0),
    REAL_CONST(87488.099708/8.0),
    REAL_CONST(87511.031617/8.0),
    REAL_CONST(87533.965029/8.0),
    REAL_CONST(87556.899943/8.0),
    REAL_CONST(87579.836358/8.0),
    REAL_CONST(87602.774276/8.0),
    REAL_CONST(87625.713695/8.0),
    REAL_CONST(87648.654615/8.0),
    REAL_CONST(87671.597037/8.0),
    REAL_CONST(87694.540960/8.0),
    REAL_CONST(87717.486383/8.0),
    REAL_CONST(87740.433308/8.0),
    REAL_CONST(87763.381732/8.0),
    REAL_CONST(87786.331657/8.0),
    REAL_CONST(87809.283082/8.0),
    REAL_CONST(87832.236007/8.0),
    REAL_CONST(87855.190431/8.0),
    REAL_CONST(87878.146355/8.0),
    REAL_CONST(87901.103778/8.0),
    REAL_CONST(87924.062700/8.0),
    REAL_CONST(87947.023122/8.0),
    REAL_CONST(87969.985041/8.0),
    REAL_CONST(87992.948460/8.0),
    REAL_CONST(88015.913376/8.0),
    REAL_CONST(88038.879791/8.0),
    REAL_CONST(88061.847703/8.0),
    REAL_CONST(88084.817113/8.0),
    REAL_CONST(88107.788021/8.0),
    REAL_CONST(88130.760426/8.0),
    REAL_CONST(88153.734328/8.0),
    REAL_CONST(88176.709727/8.0),
    REAL_CONST(88199.686623/8.0),
    REAL_CONST(88222.665015/8.0),
    REAL_CONST(88245.644904/8.0),
    REAL_CONST(88268.626288/8.0),
    REAL_CONST(88291.609169/8.0),
    REAL_CONST(88314.593546/8.0),
    REAL_CONST(88337.579417/8.0),
    REAL_CONST(88360.566785/8.0),
    REAL_CONST(88383.555647/8.0),
    REAL_CONST(88406.546005/8.0),
    REAL_CONST(88429.537857/8.0),
    REAL_CONST(88452.531204/8.0),
    REAL_CONST(88475.526045/8.0),
    REAL_CONST(88498.522380/8.0),
    REAL_CONST(88521.520210/8.0),
    REAL_CONST(88544.519533/8.0),
    REAL_CONST(88567.520350/8.0),
    REAL_CONST(88590.522660/8.0),
    REAL_CONST(88613.526463/8.0),
    REAL_CONST(88636.531760/8.0),
    REAL_CONST(88659.538549/8.0),
    REAL_CONST(88682.546831/8.0),
    REAL_CONST(88705.556605/8.0),
    REAL_CONST(88728.567872/8.0),
    REAL_CONST(88751.580631/8.0),
    REAL_CONST(88774.594881/8.0),
    REAL_CONST(88797.610623/8.0),
    REAL_CONST(88820.627857/8.0),
    REAL_CONST(88843.646582/8.0),
    REAL_CONST(88866.666798/8.0),
    REAL_CONST(88889.688505/8.0),
    REAL_CONST(88912.711703/8.0),
    REAL_CONST(88935.736391/8.0),
    REAL_CONST(88958.762569/8.0),
    REAL_CONST(88981.790238/8.0),
    REAL_CONST(89004.819397/8.0),
    REAL_CONST(89027.850045/8.0),
    REAL_CONST(89050.882183/8.0),
    REAL_CONST(89073.915810/8.0),
    REAL_CONST(89096.950926/8.0),
    REAL_CONST(89119.987532/8.0),
    REAL_CONST(89143.025626/8.0),
    REAL_CONST(89166.065208/8.0),
    REAL_CONST(89189.106279/8.0),
    REAL_CONST(89212.148839/8.0),
    REAL_CONST(89235.192886/8.0),
    REAL_CONST(89258.238421/8.0),
    REAL_CONST(89281.285444/8.0),
    REAL_CONST(89304.333954/8.0),
    REAL_CONST(89327.383952/8.0),
    REAL_CONST(89350.435436/8.0),
    REAL_CONST(89373.488407/8.0),
    REAL_CONST(89396.542865/8.0),
    REAL_CONST(89419.598810/8.0),
    REAL_CONST(89442.656240/8.0),
    REAL_CONST(89465.715157/8.0),
    REAL_CONST(89488.775560/8.0),
    REAL_CONST(89511.837448/8.0),
    REAL_CONST(89534.900822/8.0),
    REAL_CONST(89557.965682/8.0),
    REAL_CONST(89581.032026/8.0),
    REAL_CONST(89604.099855/8.0),
    REAL_CONST(89627.169170/8.0),
    REAL_CONST(89650.239968/8.0),
    REAL_CONST(89673.312251/8.0),
    REAL_CONST(89696.386018/8.0),
    REAL_CONST(89719.461270/8.0),
    REAL_CONST(89742.538005/8.0),
    REAL_CONST(89765.616223/8.0),
    REAL_CONST(89788.695925/8.0),
    REAL_CONST(89811.777111/8.0),
    REAL_CONST(89834.859779/8.0),
    REAL_CONST(89857.943930/8.0),
    REAL_CONST(89881.029564/8.0),
    REAL_CONST(89904.116680/8.0),
    REAL_CONST(89927.205278/8.0),
    REAL_CONST(89950.295359/8.0),
    REAL_CONST(89973.386921/8.0),
    REAL_CONST(89996.479966/8.0),
    REAL_CONST(90019.574491/8.0),
    REAL_CONST(90042.670498/8.0),
    REAL_CONST(90065.767986/8.0),
    REAL_CONST(90088.866955/8.0),
    REAL_CONST(90111.967405/8.0),
    REAL_CONST(90135.069336/8.0),
    REAL_CONST(90158.172746/8.0),
    REAL_CONST(90181.277637/8.0),
    REAL_CONST(90204.384008/8.0),
    REAL_CONST(90227.491859/8.0),
    REAL_CONST(90250.601189/8.0),
    REAL_CONST(90273.711999/8.0),
    REAL_CONST(90296.824288/8.0),
    REAL_CONST(90319.938056/8.0),
    REAL_CONST(90343.053303/8.0),
    REAL_CONST(90366.170029/8.0),
    REAL_CONST(90389.288233/8.0),
    REAL_CONST(90412.407915/8.0),
    REAL_CONST(90435.529075/8.0),
    REAL_CONST(90458.651714/8.0),
    REAL_CONST(90481.775830/8.0),
    REAL_CONST(90504.901423/8.0),
    REAL_CONST(90528.028494/8.0),
    REAL_CONST(90551.157042/8.0),
    REAL_CONST(90574.287067/8.0),
    REAL_CONST(90597.418569/8.0),
    REAL_CONST(90620.551548/8.0),
    REAL_CONST(90643.686002/8.0),
    REAL_CONST(90666.821934/8.0),
    REAL_CONST(90689.959341/8.0),
    REAL_CONST(90713.098223/8.0),
    REAL_CONST(90736.238582/8.0),
    REAL_CONST(90759.380416/8.0),
    REAL_CONST(90782.523725/8.0),
    REAL_CONST(90805.668510/8.0),
    REAL_CONST(90828.814769/8.0),
    REAL_CONST(90851.962503/8.0),
    REAL_CONST(90875.111711/8.0),
    REAL_CONST(90898.262394/8.0),
    REAL_CONST(90921.414551/8.0),
    REAL_CONST(90944.568182/8.0),
    REAL_CONST(90967.723287/8.0),
    REAL_CONST(90990.879865/8.0),
    REAL_CONST(91014.037916/8.0),
    REAL_CONST(91037.197441/8.0),
    REAL_CONST(91060.358439/8.0),
    REAL_CONST(91083.520910/8.0),
    REAL_CONST(91106.684853/8.0),
    REAL_CONST(91129.850269/8.0),
    REAL_CONST(91153.017157/8.0),
    REAL_CONST(91176.185517/8.0),
    REAL_CONST(91199.355349/8.0),
    REAL_CONST(91222.526653/8.0),
    REAL_CONST(91245.699428/8.0),
    REAL_CONST(91268.873675/8.0),
    REAL_CONST(91292.049393/8.0),
    REAL_CONST(91315.226581/8.0),
    REAL_CONST(91338.405241/8.0),
    REAL_CONST(91361.585371/8.0),
    REAL_CONST(91384.766971/8.0),
    REAL_CONST(91407.950042/8.0),
    REAL_CONST(91431.134583/8.0),
    REAL_CONST(91454.320593/8.0),
    REAL_CONST(91477.508074/8.0),
    REAL_CONST(91500.697023/8.0),
    REAL_CONST(91523.887442/8.0),
    REAL_CONST(91547.079330/8.0),
    REAL_CONST(91570.272687/8.0),
    REAL_CONST(91593.467513/8.0),
    REAL_CONST(91616.663807/8.0),
    REAL_CONST(91639.861570/8.0),
    REAL_CONST(91663.060800/8.0),
    REAL_CONST(91686.261499/8.0),
    REAL_CONST(91709.463666/8.0),
    REAL_CONST(91732.667300/8.0),
    REAL_CONST(91755.872401/8.0),
    REAL_CONST(91779.078970/8.0),
    REAL_CONST(91802.287006/8.0),
    REAL_CONST(91825.496509/8.0),
    REAL_CONST(91848.707478/8.0),
    REAL_CONST(91871.919914/8.0),
    REAL_CONST(91895.133816/8.0),
    REAL_CONST(91918.349185/8.0),
    REAL_CONST(91941.566019/8.0),
    REAL_CONST(91964.784319/8.0),
    REAL_CONST(91988.004084/8.0),
    REAL_CONST(92011.225315/8.0),
    REAL_CONST(92034.448012/8.0),
    REAL_CONST(92057.672173/8.0),
    REAL_CONST(92080.897799/8.0),
    REAL_CONST(92104.124889/8.0),
    REAL_CONST(92127.353445/8.0),
    REAL_CONST(92150.583464/8.0),
    REAL_CONST(92173.814948/8.0),
    REAL_CONST(92197.047895/8.0),
    REAL_CONST(92220.282306/8.0),
    REAL_CONST(92243.518181/8.0),
    REAL_CONST(92266.755519/8.0),
    REAL_CONST(92289.994320/8.0),
    REAL_CONST(92313.234584/8.0),
    REAL_CONST(92336.476311/8.0),
    REAL_CONST(92359.719501/8.0),
    REAL_CONST(92382.964153/8.0),
    REAL_CONST(92406.210267/8.0),
    REAL_CONST(92429.457843/8.0),
    REAL_CONST(92452.706882/8.0),
    REAL_CONST(92475.957382/8.0),
    REAL_CONST(92499.209343/8.0),
    REAL_CONST(92522.462766/8.0),
    REAL_CONST(92545.717650/8.0),
    REAL_CONST(92568.973995/8.0),
    REAL_CONST(92592.231800/8.0),
    REAL_CONST(92615.491067/8.0),
    REAL_CONST(92638.751793/8.0),
    REAL_CONST(92662.013980/8.0),
    REAL_CONST(92685.277627/8.0),
    REAL_CONST(92708.542734/8.0),
    REAL_CONST(92731.809300/8.0),
    REAL_CONST(92755.077326/8.0),
    REAL_CONST(92778.346812/8.0),
    REAL_CONST(92801.617756/8.0),
    REAL_CONST(92824.890160/8.0),
    REAL_CONST(92848.164022/8.0),
    REAL_CONST(92871.439342/8.0),
    REAL_CONST(92894.716122/8.0),
    REAL_CONST(92917.994359/8.0),
    REAL_CONST(92941.274054/8.0),
    REAL_CONST(92964.555207/8.0),
    REAL_CONST(92987.837818/8.0),
    REAL_CONST(93011.121887/8.0),
    REAL_CONST(93034.407412/8.0),
    REAL_CONST(93057.694395/8.0),
    REAL_CONST(93080.982835/8.0),
    REAL_CONST(93104.272732/8.0),
    REAL_CONST(93127.564085/8.0),
    REAL_CONST(93150.856894/8.0),
    REAL_CONST(93174.151160/8.0),
    REAL_CONST(93197.446881/8.0),
    REAL_CONST(93220.744059/8.0),
    REAL_CONST(93244.042692/8.0),
    REAL_CONST(93267.342781/8.0),
    REAL_CONST(93290.644325/8.0),
    REAL_CONST(93313.947324/8.0),
    REAL_CONST(93337.251778/8.0),
    REAL_CONST(93360.557687/8.0),
    REAL_CONST(93383.865050/8.0),
    REAL_CONST(93407.173868/8.0),
    REAL_CONST(93430.484140/8.0),
    REAL_CONST(93453.795866/8.0),
    REAL_CONST(93477.109046/8.0),
    REAL_CONST(93500.423680/8.0),
    REAL_CONST(93523.739767/8.0),
    REAL_CONST(93547.057307/8.0),
    REAL_CONST(93570.376300/8.0),
    REAL_CONST(93593.696747/8.0),
    REAL_CONST(93617.018646/8.0),
    REAL_CONST(93640.341998/8.0),
    REAL_CONST(93663.666802/8.0),
    REAL_CONST(93686.993058/8.0),
    REAL_CONST(93710.320766/8.0),
    REAL_CONST(93733.649927/8.0),
    REAL_CONST(93756.980539/8.0),
    REAL_CONST(93780.312602/8.0),
    REAL_CONST(93803.646117/8.0),
    REAL_CONST(93826.981083/8.0),
    REAL_CONST(93850.317499/8.0),
    REAL_CONST(93873.655367/8.0),
    REAL_CONST(93896.994685/8.0),
    REAL_CONST(93920.335454/8.0),
    REAL_CONST(93943.677673/8.0),
    REAL_CONST(93967.021342/8.0),
    REAL_CONST(93990.366460/8.0),
    REAL_CONST(94013.713029/8.0),
    REAL_CONST(94037.061047/8.0),
    REAL_CONST(94060.410514/8.0),
    REAL_CONST(94083.761430/8.0),
    REAL_CONST(94107.113796/8.0),
    REAL_CONST(94130.467610/8.0),
    REAL_CONST(94153.822873/8.0),
    REAL_CONST(94177.179584/8.0),
    REAL_CONST(94200.537744/8.0),
    REAL_CONST(94223.897351/8.0),
    REAL_CONST(94247.258407/8.0),
    REAL_CONST(94270.620910/8.0),
    REAL_CONST(94293.984861/8.0),
    REAL_CONST(94317.350259/8.0),
    REAL_CONST(94340.717104/8.0),
    REAL_CONST(94364.085396/8.0),
    REAL_CONST(94387.455135/8.0),
    REAL_CONST(94410.826321/8.0),
    REAL_CONST(94434.198953/8.0),
    REAL_CONST(94457.573032/8.0),
    REAL_CONST(94480.948556/8.0),
    REAL_CONST(94504.325527/8.0),
    REAL_CONST(94527.703943/8.0),
    REAL_CONST(94551.083805/8.0),
    REAL_CONST(94574.465112/8.0),
    REAL_CONST(94597.847864/8.0),
    REAL_CONST(94621.232062/8.0),
    REAL_CONST(94644.617704/8.0),
    REAL_CONST(94668.004791/8.0),
    REAL_CONST(94691.393322/8.0),
    REAL_CONST(94714.783298/8.0),
    REAL_CONST(94738.174718/8.0),
    REAL_CONST(94761.567582/8.0),
    REAL_CONST(94784.961890/8.0),
    REAL_CONST(94808.357641/8.0),
    REAL_CONST(94831.754835/8.0),
    REAL_CONST(94855.153473/8.0),
    REAL_CONST(94878.553554/8.0),
    REAL_CONST(94901.955078/8.0),
    REAL_CONST(94925.358045/8.0),
    REAL_CONST(94948.762454/8.0),
    REAL_CONST(94972.168305/8.0),
    REAL_CONST(94995.575599/8.0),
    REAL_CONST(95018.984335/8.0),
    REAL_CONST(95042.394512/8.0),
    REAL_CONST(95065.806131/8.0),
    REAL_CONST(95089.219192/8.0),
    REAL_CONST(95112.633694/8.0),
    REAL_CONST(95136.049637/8.0),
    REAL_CONST(95159.467021/8.0),
    REAL_CONST(95182.885845/8.0),
    REAL_CONST(95206.306111/8.0),
    REAL_CONST(95229.727816/8.0),
    REAL_CONST(95253.150962/8.0),
    REAL_CONST(95276.575548/8.0),
    REAL_CONST(95300.001574/8.0),
    REAL_CONST(95323.429040/8.0),
    REAL_CONST(95346.857945/8.0),
    REAL_CONST(95370.288289/8.0),
    REAL_CONST(95393.720073/8.0),
    REAL_CONST(95417.153295/8.0),
    REAL_CONST(95440.587957/8.0),
    REAL_CONST(95464.024057/8.0),
    REAL_CONST(95487.461595/8.0),
    REAL_CONST(95510.900572/8.0),
    REAL_CONST(95534.340987/8.0),
    REAL_CONST(95557.782839/8.0),
    REAL_CONST(95581.226130/8.0),
    REAL_CONST(95604.670858/8.0),
    REAL_CONST(95628.117024/8.0),
    REAL_CONST(95651.564626/8.0),
    REAL_CONST(95675.013666/8.0),
    REAL_CONST(95698.464143/8.0),
    REAL_CONST(95721.916056/8.0),
    REAL_CONST(95745.369406/8.0),
    REAL_CONST(95768.824192/8.0),
    REAL_CONST(95792.280415/8.0),
    REAL_CONST(95815.738073/8.0),
    REAL_CONST(95839.197167/8.0),
    REAL_CONST(95862.657697/8.0),
    REAL_CONST(95886.119662/8.0),
    REAL_CONST(95909.583063/8.0),
    REAL_CONST(95933.047899/8.0),
    REAL_CONST(95956.514169/8.0),
    REAL_CONST(95979.981875/8.0),
    REAL_CONST(96003.451015/8.0),
    REAL_CONST(96026.921589/8.0),
    REAL_CONST(96050.393598/8.0),
    REAL_CONST(96073.867041/8.0),
    REAL_CONST(96097.341917/8.0),
    REAL_CONST(96120.818227/8.0),
    REAL_CONST(96144.295971/8.0),
    REAL_CONST(96167.775148/8.0),
    REAL_CONST(96191.255759/8.0),
    REAL_CONST(96214.737802/8.0),
    REAL_CONST(96238.221279/8.0),
    REAL_CONST(96261.706187/8.0),
    REAL_CONST(96285.192529/8.0),
    REAL_CONST(96308.680302/8.0),
    REAL_CONST(96332.169508/8.0),
    REAL_CONST(96355.660146/8.0),
    REAL_CONST(96379.152216/8.0),
    REAL_CONST(96402.645717/8.0),
    REAL_CONST(96426.140650/8.0),
    REAL_CONST(96449.637013/8.0),
    REAL_CONST(96473.134808/8.0),
    REAL_CONST(96496.634034/8.0),
    REAL_CONST(96520.134691/8.0),
    REAL_CONST(96543.636778/8.0),
    REAL_CONST(96567.140296/8.0),
    REAL_CONST(96590.645244/8.0),
    REAL_CONST(96614.151622/8.0),
    REAL_CONST(96637.659429/8.0),
    REAL_CONST(96661.168667/8.0),
    REAL_CONST(96684.679334/8.0),
    REAL_CONST(96708.191430/8.0),
    REAL_CONST(96731.704956/8.0),
    REAL_CONST(96755.219910/8.0),
    REAL_CONST(96778.736294/8.0),
    REAL_CONST(96802.254106/8.0),
    REAL_CONST(96825.773346/8.0),
    REAL_CONST(96849.294015/8.0),
    REAL_CONST(96872.816112/8.0),
    REAL_CONST(96896.339637/8.0),
    REAL_CONST(96919.864589/8.0),
    REAL_CONST(96943.390970/8.0),
    REAL_CONST(96966.918777/8.0),
    REAL_CONST(96990.448012/8.0),
    REAL_CONST(97013.978674/8.0),
    REAL_CONST(97037.510763/8.0),
    REAL_CONST(97061.044279/8.0),
    REAL_CONST(97084.579221/8.0),
    REAL_CONST(97108.115590/8.0),
    REAL_CONST(97131.653385/8.0),
    REAL_CONST(97155.192606/8.0),
    REAL_CONST(97178.733253/8.0),
    REAL_CONST(97202.275326/8.0),
    REAL_CONST(97225.818824/8.0),
    REAL_CONST(97249.363747/8.0),
    REAL_CONST(97272.910096/8.0),
    REAL_CONST(97296.457870/8.0),
    REAL_CONST(97320.007069/8.0),
    REAL_CONST(97343.557692/8.0),
    REAL_CONST(97367.109740/8.0),
    REAL_CONST(97390.663212/8.0),
    REAL_CONST(97414.218108/8.0),
    REAL_CONST(97437.774428/8.0),
    REAL_CONST(97461.332172/8.0),
    REAL_CONST(97484.891340/8.0),
    REAL_CONST(97508.451931/8.0),
    REAL_CONST(97532.013946/8.0),
    REAL_CONST(97555.577383/8.0),
    REAL_CONST(97579.142244/8.0),
    REAL_CONST(97602.708527/8.0),
    REAL_CONST(97626.276233/8.0),
    REAL_CONST(97649.845362/8.0),
    REAL_CONST(97673.415912/8.0),
    REAL_CONST(97696.987885/8.0),
    REAL_CONST(97720.561280/8.0),
    REAL_CONST(97744.136096/8.0),
    REAL_CONST(97767.712334/8.0),
    REAL_CONST(97791.289994/8.0),
    REAL_CONST(97814.869074/8.0),
    REAL_CONST(97838.449576/8.0),
    REAL_CONST(97862.031499/8.0),
    REAL_CONST(97885.614842/8.0),
    REAL_CONST(97909.199606/8.0),
    REAL_CONST(97932.785791/8.0),
    REAL_CONST(97956.373395/8.0),
    REAL_CONST(97979.962420/8.0),
    REAL_CONST(98003.552864/8.0),
    REAL_CONST(98027.144728/8.0),
    REAL_CONST(98050.738012/8.0),
    REAL_CONST(98074.332715/8.0),
    REAL_CONST(98097.928837/8.0),
    REAL_CONST(98121.526378/8.0),
    REAL_CONST(98145.125339/8.0),
    REAL_CONST(98168.725717/8.0),
    REAL_CONST(98192.327515/8.0),
    REAL_CONST(98215.930730/8.0),
    REAL_CONST(98239.535364/8.0),
    REAL_CONST(98263.141416/8.0),
    REAL_CONST(98286.748885/8.0),
    REAL_CONST(98310.357772/8.0),
    REAL_CONST(98333.968077/8.0),
    REAL_CONST(98357.579799/8.0),
    REAL_CONST(98381.192938/8.0),
    REAL_CONST(98404.807495/8.0),
    REAL_CONST(98428.423468/8.0),
    REAL_CONST(98452.040857/8.0),
    REAL_CONST(98475.659663/8.0),
    REAL_CONST(98499.279885/8.0),
    REAL_CONST(98522.901524/8.0),
    REAL_CONST(98546.524578/8.0),
    REAL_CONST(98570.149049/8.0),
    REAL_CONST(98593.774934/8.0),
    REAL_CONST(98617.402236/8.0),
    REAL_CONST(98641.030952/8.0),
    REAL_CONST(98664.661084/8.0),
    REAL_CONST(98688.292630/8.0),
    REAL_CONST(98711.925592/8.0),
    REAL_CONST(98735.559968/8.0),
    REAL_CONST(98759.195758/8.0),
    REAL_CONST(98782.832963/8.0),
    REAL_CONST(98806.471581/8.0),
    REAL_CONST(98830.111614/8.0),
    REAL_CONST(98853.753060/8.0),
    REAL_CONST(98877.395920/8.0),
    REAL_CONST(98901.040194/8.0),
    REAL_CONST(98924.685880/8.0),
    REAL_CONST(98948.332980/8.0),
    REAL_CONST(98971.981493/8.0),
    REAL_CONST(98995.631418/8.0),
    REAL_CONST(99019.282756/8.0),
    REAL_CONST(99042.935506/8.0),
    REAL_CONST(99066.589669/8.0),
    REAL_CONST(99090.245243/8.0),
    REAL_CONST(99113.902230/8.0),
    REAL_CONST(99137.560628/8.0),
    REAL_CONST(99161.220438/8.0),
    REAL_CONST(99184.881659/8.0),
    REAL_CONST(99208.544291/8.0),
    REAL_CONST(99232.208335/8.0),
    REAL_CONST(99255.873789/8.0),
    REAL_CONST(99279.540654/8.0),
    REAL_CONST(99303.208930/8.0),
    REAL_CONST(99326.878616/8.0),
    REAL_CONST(99350.549712/8.0),
    REAL_CONST(99374.222218/8.0),
    REAL_CONST(99397.896134/8.0),
    REAL_CONST(99421.571460/8.0),
    REAL_CONST(99445.248195/8.0),
    REAL_CONST(99468.926340/8.0),
    REAL_CONST(99492.605894/8.0),
    REAL_CONST(99516.286857/8.0),
    REAL_CONST(99539.969229/8.0),
    REAL_CONST(99563.653009/8.0),
    REAL_CONST(99587.338198/8.0),
    REAL_CONST(99611.024796/8.0),
    REAL_CONST(99634.712801/8.0),
    REAL_CONST(99658.402215/8.0),
    REAL_CONST(99682.093036/8.0),
    REAL_CONST(99705.785265/8.0),
    REAL_CONST(99729.478902/8.0),
    REAL_CONST(99753.173946/8.0),
    REAL_CONST(99776.870398/8.0),
    REAL_CONST(99800.568256/8.0),
    REAL_CONST(99824.267521/8.0),
    REAL_CONST(99847.968193/8.0),
    REAL_CONST(99871.670271/8.0),
    REAL_CONST(99895.373756/8.0),
    REAL_CONST(99919.078647/8.0),
    REAL_CONST(99942.784944/8.0),
    REAL_CONST(99966.492647/8.0),
    REAL_CONST(99990.201755/8.0),
    REAL_CONST(100013.912269/8.0),
    REAL_CONST(100037.624189/8.0),
    REAL_CONST(100061.337513/8.0),
    REAL_CONST(100085.052243/8.0),
    REAL_CONST(100108.768377/8.0),
    REAL_CONST(100132.485917/8.0),
    REAL_CONST(100156.204860/8.0),
    REAL_CONST(100179.925208/8.0),
    REAL_CONST(100203.646961/8.0),
    REAL_CONST(100227.370117/8.0),
    REAL_CONST(100251.094677/8.0),
    REAL_CONST(100274.820641/8.0),
    REAL_CONST(100298.548008/8.0),
    REAL_CONST(100322.276779/8.0),
    REAL_CONST(100346.006953/8.0),
    REAL_CONST(100369.738530/8.0),
    REAL_CONST(100393.471510/8.0),
    REAL_CONST(100417.205892/8.0),
    REAL_CONST(100440.941677/8.0),
    REAL_CONST(100464.678865/8.0),
    REAL_CONST(100488.417454/8.0),
    REAL_CONST(100512.157446/8.0),
    REAL_CONST(100535.898840/8.0),
    REAL_CONST(100559.641635/8.0),
    REAL_CONST(100583.385832/8.0),
    REAL_CONST(100607.131430/8.0),
    REAL_CONST(100630.878429/8.0),
    REAL_CONST(100654.626830/8.0),
    REAL_CONST(100678.376631/8.0),
    REAL_CONST(100702.127833/8.0),
    REAL_CONST(100725.880436/8.0),
    REAL_CONST(100749.634438/8.0),
    REAL_CONST(100773.389842/8.0),
    REAL_CONST(100797.146645/8.0),
    REAL_CONST(100820.904848/8.0),
    REAL_CONST(100844.664451/8.0),
    REAL_CONST(100868.425453/8.0),
    REAL_CONST(100892.187855/8.0),
    REAL_CONST(100915.951656/8.0),
    REAL_CONST(100939.716856/8.0),
    REAL_CONST(100963.483455/8.0),
    REAL_CONST(100987.251453/8.0),
    REAL_CONST(101011.020849/8.0),
    REAL_CONST(101034.791644/8.0),
    REAL_CONST(101058.563837/8.0),
    REAL_CONST(101082.337428/8.0),
    REAL_CONST(101106.112417/8.0),
    REAL_CONST(101129.888803/8.0),
    REAL_CONST(101153.666587/8.0),
    REAL_CONST(101177.445769/8.0),
    REAL_CONST(101201.226348/8.0),
    REAL_CONST(101225.008324/8.0),
    REAL_CONST(101248.791697/8.0),
    REAL_CONST(101272.576467/8.0),
    REAL_CONST(101296.362633/8.0),
    REAL_CONST(101320.150196/8.0),
    REAL_CONST(101343.939155/8.0),
    REAL_CONST(101367.729510/8.0),
    REAL_CONST(101391.521261/8.0),
    REAL_CONST(101415.314408/8.0),
    REAL_CONST(101439.108950/8.0),
    REAL_CONST(101462.904888/8.0),
    REAL_CONST(101486.702221/8.0),
    REAL_CONST(101510.500949/8.0),
    REAL_CONST(101534.301073/8.0),
    REAL_CONST(101558.102591/8.0),
    REAL_CONST(101581.905503/8.0),
    REAL_CONST(101605.709811/8.0),
    REAL_CONST(101629.515512/8.0),
    REAL_CONST(101653.322608/8.0),
    REAL_CONST(101677.131097/8.0),
    REAL_CONST(101700.940981/8.0),
    REAL_CONST(101724.752258/8.0),
    REAL_CONST(101748.564928/8.0),
    REAL_CONST(101772.378992/8.0),
    REAL_CONST(101796.194449/8.0),
    REAL_CONST(101820.011299/8.0),
    REAL_CONST(101843.829542/8.0),
    REAL_CONST(101867.649178/8.0),
    REAL_CONST(101891.470206/8.0),
    REAL_CONST(101915.292626/8.0),
    REAL_CONST(101939.116439/8.0),
    REAL_CONST(101962.941644/8.0),
    REAL_CONST(101986.768240/8.0),
    REAL_CONST(102010.596228/8.0),
    REAL_CONST(102034.425608/8.0),
    REAL_CONST(102058.256379/8.0),
    REAL_CONST(102082.088542/8.0),
    REAL_CONST(102105.922095/8.0),
    REAL_CONST(102129.757039/8.0),
    REAL_CONST(102153.593374/8.0),
    REAL_CONST(102177.431100/8.0),
    REAL_CONST(102201.270216/8.0),
    REAL_CONST(102225.110722/8.0),
    REAL_CONST(102248.952618/8.0),
    REAL_CONST(102272.795904/8.0),
    REAL_CONST(102296.640580/8.0),
    REAL_CONST(102320.486646/8.0),
    REAL_CONST(102344.334101/8.0),
    REAL_CONST(102368.182945/8.0),
    REAL_CONST(102392.033178/8.0),
    REAL_CONST(102415.884801/8.0),
    REAL_CONST(102439.737812/8.0),
    REAL_CONST(102463.592211/8.0),
    REAL_CONST(102487.448000/8.0),
    REAL_CONST(102511.305176/8.0),
    REAL_CONST(102535.163741/8.0),
    REAL_CONST(102559.023693/8.0),
    REAL_CONST(102582.885033/8.0),
    REAL_CONST(102606.747761/8.0),
    REAL_CONST(102630.611877/8.0),
    REAL_CONST(102654.477380/8.0),
    REAL_CONST(102678.344270/8.0),
    REAL_CONST(102702.212547/8.0),
    REAL_CONST(102726.082211/8.0),
    REAL_CONST(102749.953261/8.0),
    REAL_CONST(102773.825698/8.0),
    REAL_CONST(102797.699521/8.0),
    REAL_CONST(102821.574731/8.0),
    REAL_CONST(102845.451327/8.0),
    REAL_CONST(102869.329308/8.0),
    REAL_CONST(102893.208675/8.0),
    REAL_CONST(102917.089428/8.0),
    REAL_CONST(102940.971566/8.0),
    REAL_CONST(102964.855090/8.0),
    REAL_CONST(102988.739998/8.0),
    REAL_CONST(103012.626292/8.0),
    REAL_CONST(103036.513970/8.0),
    REAL_CONST(103060.403033/8.0),
    REAL_CONST(103084.293480/8.0),
    REAL_CONST(103108.185311/8.0),
    REAL_CONST(103132.078527/8.0),
    REAL_CONST(103155.973126/8.0),
    REAL_CONST(103179.869110/8.0),
    REAL_CONST(103203.766477/8.0),
    REAL_CONST(103227.665227/8.0),
    REAL_CONST(103251.565361/8.0),
    REAL_CONST(103275.466878/8.0),
    REAL_CONST(103299.369777/8.0),
    REAL_CONST(103323.274060/8.0),
    REAL_CONST(103347.179725/8.0),
    REAL_CONST(103371.086773/8.0),
    REAL_CONST(103394.995203/8.0),
    REAL_CONST(103418.905016/8.0),
    REAL_CONST(103442.816210/8.0),
    REAL_CONST(103466.728787/8.0),
    REAL_CONST(103490.642745/8.0),
    REAL_CONST(103514.558084/8.0),
    REAL_CONST(103538.474805/8.0),
    REAL_CONST(103562.392907/8.0),
    REAL_CONST(103586.312391/8.0),
    REAL_CONST(103610.233255/8.0),
    REAL_CONST(103634.155500/8.0),
    REAL_CONST(103658.079125/8.0),
    REAL_CONST(103682.004131/8.0),
    REAL_CONST(103705.930517/8.0),
    REAL_CONST(103729.858284/8.0),
    REAL_CONST(103753.787430/8.0),
    REAL_CONST(103777.717956/8.0),
    REAL_CONST(103801.649862/8.0),
    REAL_CONST(103825.583147/8.0),
    REAL_CONST(103849.517812/8.0),
    REAL_CONST(103873.453855/8.0),
    REAL_CONST(103897.391278/8.0),
    REAL_CONST(103921.330080/8.0),
    REAL_CONST(103945.270260/8.0),
    REAL_CONST(103969.211819/8.0),
    REAL_CONST(103993.154756/8.0),
    REAL_CONST(104017.099071/8.0),
    REAL_CONST(104041.044764/8.0),
    REAL_CONST(104064.991836/8.0),
    REAL_CONST(104088.940285/8.0),
    REAL_CONST(104112.890111/8.0),
    REAL_CONST(104136.841315/8.0),
    REAL_CONST(104160.793897/8.0),
    REAL_CONST(104184.747855/8.0),
    REAL_CONST(104208.703190/8.0),
    REAL_CONST(104232.659902/8.0),
    REAL_CONST(104256.617991/8.0),
    REAL_CONST(104280.577456/8.0),
    REAL_CONST(104304.538298/8.0),
    REAL_CONST(104328.500515/8.0),
    REAL_CONST(104352.464109/8.0),
    REAL_CONST(104376.429078/8.0),
    REAL_CONST(104400.395424/8.0),
    REAL_CONST(104424.363144/8.0),
    REAL_CONST(104448.332240/8.0),
    REAL_CONST(104472.302712/8.0),
    REAL_CONST(104496.274558/8.0),
    REAL_CONST(104520.247779/8.0),
    REAL_CONST(104544.222375/8.0),
    REAL_CONST(104568.198345/8.0),
    REAL_CONST(104592.175690/8.0),
    REAL_CONST(104616.154409/8.0),
    REAL_CONST(104640.134503/8.0),
    REAL_CONST(104664.115970/8.0),
    REAL_CONST(104688.098811/8.0),
    REAL_CONST(104712.083025/8.0),
    REAL_CONST(104736.068613/8.0),
    REAL_CONST(104760.055575/8.0),
    REAL_CONST(104784.043909/8.0),
    REAL_CONST(104808.033617/8.0),
    REAL_CONST(104832.024697/8.0),
    REAL_CONST(104856.017150/8.0),
    REAL_CONST(104880.010976/8.0),
    REAL_CONST(104904.006174/8.0),
    REAL_CONST(104928.002744/8.0),
    REAL_CONST(104952.000686/8.0),
    REAL_CONST(104976.000000/8.0),
    REAL_CONST(105000.000686/8.0),
    REAL_CONST(105024.002743/8.0),
    REAL_CONST(105048.006172/8.0),
    REAL_CONST(105072.010972/8.0),
    REAL_CONST(105096.017144/8.0),
    REAL_CONST(105120.024686/8.0),
    REAL_CONST(105144.033599/8.0),
    REAL_CONST(105168.043882/8.0),
    REAL_CONST(105192.055537/8.0),
    REAL_CONST(105216.068561/8.0),
    REAL_CONST(105240.082956/8.0),
    REAL_CONST(105264.098720/8.0),
    REAL_CONST(105288.115855/8.0),
    REAL_CONST(105312.134359/8.0),
    REAL_CONST(105336.154233/8.0),
    REAL_CONST(105360.175476/8.0),
    REAL_CONST(105384.198088/8.0),
    REAL_CONST(105408.222070/8.0),
    REAL_CONST(105432.247420/8.0),
    REAL_CONST(105456.274140/8.0),
    REAL_CONST(105480.302227/8.0),
    REAL_CONST(105504.331684/8.0),
    REAL_CONST(105528.362508/8.0),
    REAL_CONST(105552.394701/8.0),
    REAL_CONST(105576.428262/8.0),
    REAL_CONST(105600.463190/8.0),
    REAL_CONST(105624.499487/8.0),
    REAL_CONST(105648.537150/8.0),
    REAL_CONST(105672.576181/8.0),
    REAL_CONST(105696.616580/8.0),
    REAL_CONST(105720.658345/8.0),
    REAL_CONST(105744.701478/8.0),
    REAL_CONST(105768.745977/8.0),
    REAL_CONST(105792.791842/8.0),
    REAL_CONST(105816.839074/8.0),
    REAL_CONST(105840.887673/8.0),
    REAL_CONST(105864.937637/8.0),
    REAL_CONST(105888.988968/8.0),
    REAL_CONST(105913.041664/8.0),
    REAL_CONST(105937.095726/8.0),
    REAL_CONST(105961.151153/8.0),
    REAL_CONST(105985.207946/8.0),
    REAL_CONST(106009.266104/8.0),
    REAL_CONST(106033.325627/8.0),
    REAL_CONST(106057.386515/8.0),
    REAL_CONST(106081.448768/8.0),
    REAL_CONST(106105.512385/8.0),
    REAL_CONST(106129.577367/8.0),
    REAL_CONST(106153.643712/8.0),
    REAL_CONST(106177.711422/8.0),
    REAL_CONST(106201.780496/8.0),
    REAL_CONST(106225.850934/8.0),
    REAL_CONST(106249.922736/8.0),
    REAL_CONST(106273.995901/8.0),
    REAL_CONST(106298.070429/8.0),
    REAL_CONST(106322.146320/8.0),
    REAL_CONST(106346.223575/8.0),
    REAL_CONST(106370.302192/8.0),
    REAL_CONST(106394.382172/8.0),
    REAL_CONST(106418.463515/8.0),
    REAL_CONST(106442.546220/8.0),
    REAL_CONST(106466.630287/8.0),
    REAL_CONST(106490.715717/8.0),
    REAL_CONST(106514.802508/8.0),
    REAL_CONST(106538.890661/8.0),
    REAL_CONST(106562.980176/8.0),
    REAL_CONST(106587.071052/8.0),
    REAL_CONST(106611.163290/8.0),
    REAL_CONST(106635.256889/8.0),
    REAL_CONST(106659.351849/8.0),
    REAL_CONST(106683.448169/8.0),
    REAL_CONST(106707.545851/8.0),
    REAL_CONST(106731.644893/8.0),
    REAL_CONST(106755.745295/8.0),
    REAL_CONST(106779.847058/8.0),
    REAL_CONST(106803.950181/8.0),
    REAL_CONST(106828.054663/8.0),
    REAL_CONST(106852.160506/8.0),
    REAL_CONST(106876.267708/8.0),
    REAL_CONST(106900.376270/8.0),
    REAL_CONST(106924.486191/8.0),
    REAL_CONST(106948.597471/8.0),
    REAL_CONST(106972.710110/8.0),
    REAL_CONST(106996.824108/8.0),
    REAL_CONST(107020.939465/8.0),
    REAL_CONST(107045.056181/8.0),
    REAL_CONST(107069.174255/8.0),
    REAL_CONST(107093.293687/8.0),
    REAL_CONST(107117.414477/8.0),
    REAL_CONST(107141.536625/8.0),
    REAL_CONST(107165.660131/8.0),
    REAL_CONST(107189.784995/8.0),
    REAL_CONST(107213.911216/8.0),
    REAL_CONST(107238.038794/8.0),
    REAL_CONST(107262.167730/8.0),
    REAL_CONST(107286.298023/8.0),
    REAL_CONST(107310.429672/8.0),
    REAL_CONST(107334.562679/8.0),
    REAL_CONST(107358.697042/8.0),
    REAL_CONST(107382.832761/8.0),
    REAL_CONST(107406.969837/8.0),
    REAL_CONST(107431.108269/8.0),
    REAL_CONST(107455.248056/8.0),
    REAL_CONST(107479.389200/8.0),
    REAL_CONST(107503.531699/8.0),
    REAL_CONST(107527.675554/8.0),
    REAL_CONST(107551.820764/8.0),
    REAL_CONST(107575.967330/8.0),
    REAL_CONST(107600.115250/8.0),
    REAL_CONST(107624.264526/8.0),
    REAL_CONST(107648.415156/8.0),
    REAL_CONST(107672.567140/8.0),
    REAL_CONST(107696.720480/8.0),
    REAL_CONST(107720.875173/8.0),
    REAL_CONST(107745.031221/8.0),
    REAL_CONST(107769.188622/8.0),
    REAL_CONST(107793.347378/8.0),
    REAL_CONST(107817.507487/8.0),
    REAL_CONST(107841.668950/8.0),
    REAL_CONST(107865.831766/8.0),
    REAL_CONST(107889.995935/8.0),
    REAL_CONST(107914.161458/8.0),
    REAL_CONST(107938.328333/8.0),
    REAL_CONST(107962.496561/8.0),
    REAL_CONST(107986.666142/8.0),
    REAL_CONST(108010.837076/8.0),
    REAL_CONST(108035.009361/8.0),
    REAL_CONST(108059.182999/8.0),
    REAL_CONST(108083.357989/8.0),
    REAL_CONST(108107.534331/8.0),
    REAL_CONST(108131.712024/8.0),
    REAL_CONST(108155.891069/8.0),
    REAL_CONST(108180.071466/8.0),
    REAL_CONST(108204.253213/8.0),
    REAL_CONST(108228.436312/8.0),
    REAL_CONST(108252.620762/8.0),
    REAL_CONST(108276.806563/8.0),
    REAL_CONST(108300.993714/8.0),
    REAL_CONST(108325.182216/8.0),
    REAL_CONST(108349.372068/8.0),
    REAL_CONST(108373.563271/8.0),
    REAL_CONST(108397.755823/8.0),
    REAL_CONST(108421.949726/8.0),
    REAL_CONST(108446.144978/8.0),
    REAL_CONST(108470.341580/8.0),
    REAL_CONST(108494.539531/8.0),
    REAL_CONST(108518.738831/8.0),
    REAL_CONST(108542.939481/8.0),
    REAL_CONST(108567.141480/8.0),
    REAL_CONST(108591.344828/8.0),
    REAL_CONST(108615.549524/8.0),
    REAL_CONST(108639.755569/8.0),
    REAL_CONST(108663.962962/8.0),
    REAL_CONST(108688.171704/8.0),
    REAL_CONST(108712.381794/8.0),
    REAL_CONST(108736.593231/8.0),
    REAL_CONST(108760.806017/8.0),
    REAL_CONST(108785.020150/8.0),
    REAL_CONST(108809.235631/8.0),
    REAL_CONST(108833.452459/8.0),
    REAL_CONST(108857.670634/8.0),
    REAL_CONST(108881.890156/8.0),
    REAL_CONST(108906.111025/8.0),
    REAL_CONST(108930.333241/8.0),
    REAL_CONST(108954.556804/8.0),
    REAL_CONST(108978.781713/8.0),
    REAL_CONST(109003.007968/8.0),
    REAL_CONST(109027.235570/8.0),
    REAL_CONST(109051.464517/8.0),
    REAL_CONST(109075.694811/8.0),
    REAL_CONST(109099.926450/8.0),
    REAL_CONST(109124.159435/8.0),
    REAL_CONST(109148.393765/8.0),
    REAL_CONST(109172.629440/8.0),
    REAL_CONST(109196.866461/8.0),
    REAL_CONST(109221.104826/8.0),
    REAL_CONST(109245.344537/8.0),
    REAL_CONST(109269.585591/8.0),
    REAL_CONST(109293.827991/8.0),
    REAL_CONST(109318.071735/8.0),
    REAL_CONST(109342.316823/8.0),
    REAL_CONST(109366.563255/8.0),
    REAL_CONST(109390.811031/8.0),
    REAL_CONST(109415.060151/8.0),
    REAL_CONST(109439.310615/8.0),
    REAL_CONST(109463.562421/8.0),
    REAL_CONST(109487.815572/8.0),
    REAL_CONST(109512.070065/8.0),
    REAL_CONST(109536.325902/8.0),
    REAL_CONST(109560.583081/8.0),
    REAL_CONST(109584.841603/8.0),
    REAL_CONST(109609.101468/8.0),
    REAL_CONST(109633.362675/8.0),
    REAL_CONST(109657.625225/8.0),
    REAL_CONST(109681.889116/8.0),
    REAL_CONST(109706.154350/8.0),
    REAL_CONST(109730.420925/8.0),
    REAL_CONST(109754.688842/8.0),
    REAL_CONST(109778.958101/8.0),
    REAL_CONST(109803.228701/8.0),
    REAL_CONST(109827.500642/8.0),
    REAL_CONST(109851.773925/8.0),
    REAL_CONST(109876.048548/8.0),
    REAL_CONST(109900.324512/8.0),
    REAL_CONST(109924.601817/8.0),
    REAL_CONST(109948.880462/8.0),
    REAL_CONST(109973.160448/8.0),
    REAL_CONST(109997.441774/8.0),
    REAL_CONST(110021.724440/8.0),
    REAL_CONST(110046.008446/8.0),
    REAL_CONST(110070.293792/8.0),
    REAL_CONST(110094.580477/8.0),
    REAL_CONST(110118.868502/8.0),
    REAL_CONST(110143.157866/8.0),
    REAL_CONST(110167.448569/8.0),
    REAL_CONST(110191.740611/8.0),
    REAL_CONST(110216.033993/8.0),
    REAL_CONST(110240.328713/8.0),
    REAL_CONST(110264.624771/8.0),
    REAL_CONST(110288.922168/8.0),
    REAL_CONST(110313.220903/8.0),
    REAL_CONST(110337.520977/8.0),
    REAL_CONST(110361.822388/8.0),
    REAL_CONST(110386.125137/8.0),
    REAL_CONST(110410.429224/8.0),
    REAL_CONST(110434.734649/8.0),
    REAL_CONST(110459.041411/8.0),
    REAL_CONST(110483.349510/8.0),
    REAL_CONST(110507.658946/8.0),
    REAL_CONST(110531.969719/8.0),
    REAL_CONST(110556.281830/8.0),
    REAL_CONST(110580.595276/8.0),
    REAL_CONST(110604.910060/8.0),
    REAL_CONST(110629.226179/8.0),
    REAL_CONST(110653.543635/8.0),
    REAL_CONST(110677.862427/8.0),
    REAL_CONST(110702.182555/8.0),
    REAL_CONST(110726.504019/8.0),
    REAL_CONST(110750.826818/8.0),
    REAL_CONST(110775.150953/8.0),
    REAL_CONST(110799.476423/8.0),
    REAL_CONST(110823.803229/8.0),
    REAL_CONST(110848.131369/8.0),
    REAL_CONST(110872.460845/8.0),
    REAL_CONST(110896.791655/8.0),
    REAL_CONST(110921.123800/8.0),
    REAL_CONST(110945.457279/8.0),
    REAL_CONST(110969.792093/8.0),
    REAL_CONST(110994.128240/8.0),
    REAL_CONST(111018.465722/8.0),
    REAL_CONST(111042.804538/8.0),
    REAL_CONST(111067.144687/8.0),
    REAL_CONST(111091.486170/8.0),
    REAL_CONST(111115.828987/8.0),
    REAL_CONST(111140.173137/8.0),
    REAL_CONST(111164.518620/8.0),
    REAL_CONST(111188.865436/8.0),
    REAL_CONST(111213.213585/8.0),
    REAL_CONST(111237.563066/8.0),
    REAL_CONST(111261.913880/8.0),
    REAL_CONST(111286.266027/8.0),
    REAL_CONST(111310.619506/8.0),
    REAL_CONST(111334.974317/8.0),
    REAL_CONST(111359.330460/8.0),
    REAL_CONST(111383.687935/8.0),
    REAL_CONST(111408.046741/8.0),
    REAL_CONST(111432.406879/8.0),
    REAL_CONST(111456.768349/8.0),
    REAL_CONST(111481.131149/8.0),
    REAL_CONST(111505.495281/8.0),
    REAL_CONST(111529.860744/8.0),
    REAL_CONST(111554.227538/8.0),
    REAL_CONST(111578.595662/8.0),
    REAL_CONST(111602.965117/8.0),
    REAL_CONST(111627.335902/8.0),
    REAL_CONST(111651.708018/8.0),
    REAL_CONST(111676.081464/8.0),
    REAL_CONST(111700.456239/8.0),
    REAL_CONST(111724.832345/8.0),
    REAL_CONST(111749.209780/8.0),
    REAL_CONST(111773.588544/8.0),
    REAL_CONST(111797.968638/8.0),
    REAL_CONST(111822.350062/8.0),
    REAL_CONST(111846.732814/8.0),
    REAL_CONST(111871.116895/8.0),
    REAL_CONST(111895.502305/8.0),
    REAL_CONST(111919.889044/8.0),
    REAL_CONST(111944.277111/8.0),
    REAL_CONST(111968.666507/8.0),
    REAL_CONST(111993.057230/8.0),
    REAL_CONST(112017.449282/8.0),
    REAL_CONST(112041.842662/8.0),
    REAL_CONST(112066.237369/8.0),
    REAL_CONST(112090.633405/8.0),
    REAL_CONST(112115.030767/8.0),
    REAL_CONST(112139.429457/8.0),
    REAL_CONST(112163.829475/8.0),
    REAL_CONST(112188.230819/8.0),
    REAL_CONST(112212.633490/8.0),
    REAL_CONST(112237.037488/8.0),
    REAL_CONST(112261.442813/8.0),
    REAL_CONST(112285.849464/8.0),
    REAL_CONST(112310.257441/8.0),
    REAL_CONST(112334.666745/8.0),
    REAL_CONST(112359.077375/8.0),
    REAL_CONST(112383.489330/8.0),
    REAL_CONST(112407.902612/8.0),
    REAL_CONST(112432.317219/8.0),
    REAL_CONST(112456.733151/8.0),
    REAL_CONST(112481.150409/8.0),
    REAL_CONST(112505.568992/8.0),
    REAL_CONST(112529.988900/8.0),
    REAL_CONST(112554.410133/8.0),
    REAL_CONST(112578.832691/8.0),
    REAL_CONST(112603.256573/8.0),
    REAL_CONST(112627.681780/8.0),
    REAL_CONST(112652.108311/8.0),
    REAL_CONST(112676.536166/8.0),
    REAL_CONST(112700.965345/8.0),
    REAL_CONST(112725.395849/8.0),
    REAL_CONST(112749.827676/8.0),
    REAL_CONST(112774.260826/8.0),
    REAL_CONST(112798.695300/8.0),
    REAL_CONST(112823.131098/8.0),
    REAL_CONST(112847.568218/8.0),
    REAL_CONST(112872.006662/8.0),
    REAL_CONST(112896.446428/8.0),
    REAL_CONST(112920.887517/8.0),
    REAL_CONST(112945.329929/8.0),
    REAL_CONST(112969.773663/8.0),
    REAL_CONST(112994.218720/8.0),
    REAL_CONST(113018.665099/8.0),
    REAL_CONST(113043.112800/8.0),
    REAL_CONST(113067.561822/8.0),
    REAL_CONST(113092.012167/8.0),
    REAL_CONST(113116.463833/8.0),
    REAL_CONST(113140.916820/8.0),
    REAL_CONST(113165.371129/8.0),
    REAL_CONST(113189.826759/8.0),
    REAL_CONST(113214.283710/8.0),
    REAL_CONST(113238.741982/8.0),
    REAL_CONST(113263.201575/8.0),
    REAL_CONST(113287.662488/8.0),
    REAL_CONST(113312.124722/8.0),
    REAL_CONST(113336.588276/8.0),
    REAL_CONST(113361.053150/8.0),
    REAL_CONST(113385.519345/8.0),
    REAL_CONST(113409.986859/8.0),
    REAL_CONST(113434.455693/8.0),
    REAL_CONST(113458.925846/8.0),
    REAL_CONST(113483.397319/8.0),
    REAL_CONST(113507.870112/8.0),
    REAL_CONST(113532.344223/8.0),
    REAL_CONST(113556.819654/8.0),
    REAL_CONST(113581.296403/8.0),
    REAL_CONST(113605.774471/8.0),
    REAL_CONST(113630.253858/8.0),
    REAL_CONST(113654.734563/8.0),
    REAL_CONST(113679.216587/8.0),
    REAL_CONST(113703.699929/8.0),
    REAL_CONST(113728.184589/8.0),
    REAL_CONST(113752.670566/8.0),
    REAL_CONST(113777.157862/8.0),
    REAL_CONST(113801.646475/8.0),
    REAL_CONST(113826.136406/8.0),
    REAL_CONST(113850.627654/8.0),
    REAL_CONST(113875.120219/8.0),
    REAL_CONST(113899.614101/8.0),
    REAL_CONST(113924.109300/8.0),
    REAL_CONST(113948.605816/8.0),
    REAL_CONST(113973.103648/8.0),
    REAL_CONST(113997.602797/8.0),
    REAL_CONST(114022.103263/8.0),
    REAL_CONST(114046.605044/8.0),
    REAL_CONST(114071.108142/8.0),
    REAL_CONST(114095.612555/8.0),
    REAL_CONST(114120.118285/8.0),
    REAL_CONST(114144.625330/8.0),
    REAL_CONST(114169.133690/8.0),
    REAL_CONST(114193.643366/8.0),
    REAL_CONST(114218.154357/8.0),
    REAL_CONST(114242.666663/8.0),
    REAL_CONST(114267.180284/8.0),
    REAL_CONST(114291.695220/8.0),
    REAL_CONST(114316.211470/8.0),
    REAL_CONST(114340.729035/8.0),
    REAL_CONST(114365.247914/8.0),
    REAL_CONST(114389.768108/8.0),
    REAL_CONST(114414.289615/8.0),
    REAL_CONST(114438.812437/8.0),
    REAL_CONST(114463.336572/8.0),
    REAL_CONST(114487.862021/8.0),
    REAL_CONST(114512.388784/8.0),
    REAL_CONST(114536.916860/8.0),
    REAL_CONST(114561.446249/8.0),
    REAL_CONST(114585.976951/8.0),
    REAL_CONST(114610.508967/8.0),
    REAL_CONST(114635.042295/8.0),
    REAL_CONST(114659.576936/8.0),
    REAL_CONST(114684.112889/8.0),
    REAL_CONST(114708.650155/8.0),
    REAL_CONST(114733.188733/8.0),
    REAL_CONST(114757.728623/8.0),
    REAL_CONST(114782.269825/8.0),
    REAL_CONST(114806.812339/8.0),
    REAL_CONST(114831.356164/8.0),
    REAL_CONST(114855.901301/8.0),
    REAL_CONST(114880.447750/8.0),
    REAL_CONST(114904.995510/8.0),
    REAL_CONST(114929.544581/8.0),
    REAL_CONST(114954.094963/8.0),
    REAL_CONST(114978.646655/8.0),
    REAL_CONST(115003.199659/8.0),
    REAL_CONST(115027.753973/8.0),
    REAL_CONST(115052.309598/8.0),
    REAL_CONST(115076.866532/8.0),
    REAL_CONST(115101.424777/8.0),
    REAL_CONST(115125.984333/8.0),
    REAL_CONST(115150.545197/8.0),
    REAL_CONST(115175.107372/8.0),
    REAL_CONST(115199.670856/8.0),
    REAL_CONST(115224.235650/8.0),
    REAL_CONST(115248.801753/8.0),
    REAL_CONST(115273.369165/8.0),
    REAL_CONST(115297.937886/8.0),
    REAL_CONST(115322.507917/8.0),
    REAL_CONST(115347.079256/8.0),
    REAL_CONST(115371.651903/8.0),
    REAL_CONST(115396.225859/8.0),
    REAL_CONST(115420.801123/8.0),
    REAL_CONST(115445.377696/8.0),
    REAL_CONST(115469.955577/8.0),
    REAL_CONST(115494.534765/8.0),
    REAL_CONST(115519.115261/8.0),
    REAL_CONST(115543.697065/8.0),
    REAL_CONST(115568.280177/8.0),
    REAL_CONST(115592.864596/8.0),
    REAL_CONST(115617.450322/8.0),
    REAL_CONST(115642.037355/8.0),
    REAL_CONST(115666.625695/8.0),
    REAL_CONST(115691.215342/8.0),
    REAL_CONST(115715.806296/8.0),
    REAL_CONST(115740.398556/8.0),
    REAL_CONST(115764.992122/8.0),
    REAL_CONST(115789.586995/8.0),
    REAL_CONST(115814.183174/8.0),
    REAL_CONST(115838.780659/8.0),
    REAL_CONST(115863.379450/8.0),
    REAL_CONST(115887.979546/8.0),
    REAL_CONST(115912.580948/8.0),
    REAL_CONST(115937.183656/8.0),
    REAL_CONST(115961.787668/8.0),
    REAL_CONST(115986.392986/8.0),
    REAL_CONST(116010.999609/8.0),
    REAL_CONST(116035.607537/8.0),
    REAL_CONST(116060.216769/8.0),
    REAL_CONST(116084.827307/8.0),
    REAL_CONST(116109.439148/8.0),
    REAL_CONST(116134.052294/8.0),
    REAL_CONST(116158.666744/8.0),
    REAL_CONST(116183.282498/8.0),
    REAL_CONST(116207.899556/8.0),
    REAL_CONST(116232.517918/8.0),
    REAL_CONST(116257.137583/8.0),
    REAL_CONST(116281.758552/8.0),
    REAL_CONST(116306.380824/8.0),
    REAL_CONST(116331.004400/8.0),
    REAL_CONST(116355.629278/8.0),
    REAL_CONST(116380.255460/8.0),
    REAL_CONST(116404.882944/8.0),
    REAL_CONST(116429.511731/8.0),
    REAL_CONST(116454.141820/8.0),
    REAL_CONST(116478.773212/8.0),
    REAL_CONST(116503.405906/8.0),
    REAL_CONST(116528.039902/8.0),
    REAL_CONST(116552.675201/8.0),
    REAL_CONST(116577.311801/8.0),
    REAL_CONST(116601.949702/8.0),
    REAL_CONST(116626.588905/8.0),
    REAL_CONST(116651.229410/8.0),
    REAL_CONST(116675.871216/8.0),
    REAL_CONST(116700.514323/8.0),
    REAL_CONST(116725.158731/8.0),
    REAL_CONST(116749.804440/8.0),
    REAL_CONST(116774.451450/8.0),
    REAL_CONST(116799.099760/8.0),
    REAL_CONST(116823.749371/8.0),
    REAL_CONST(116848.400282/8.0),
    REAL_CONST(116873.052494/8.0),
    REAL_CONST(116897.706005/8.0),
    REAL_CONST(116922.360816/8.0),
    REAL_CONST(116947.016927/8.0),
    REAL_CONST(116971.674338/8.0),
    REAL_CONST(116996.333048/8.0),
    REAL_CONST(117020.993058/8.0),
    REAL_CONST(117045.654367/8.0),
    REAL_CONST(117070.316974/8.0),
    REAL_CONST(117094.980881/8.0),
    REAL_CONST(117119.646087/8.0),
    REAL_CONST(117144.312591/8.0),
    REAL_CONST(117168.980394/8.0),
    REAL_CONST(117193.649495/8.0),
    REAL_CONST(117218.319895/8.0),
    REAL_CONST(117242.991593/8.0),
    REAL_CONST(117267.664588/8.0),
    REAL_CONST(117292.338882/8.0),
    REAL_CONST(117317.014473/8.0),
    REAL_CONST(117341.691362/8.0),
    REAL_CONST(117366.369548/8.0),
    REAL_CONST(117391.049032/8.0),
    REAL_CONST(117415.729813/8.0),
    REAL_CONST(117440.411891/8.0),
    REAL_CONST(117465.095266/8.0),
    REAL_CONST(117489.779937/8.0),
    REAL_CONST(117514.465905/8.0),
    REAL_CONST(117539.153170/8.0),
    REAL_CONST(117563.841731/8.0),
    REAL_CONST(117588.531588/8.0),
    REAL_CONST(117613.222741/8.0),
    REAL_CONST(117637.915191/8.0),
    REAL_CONST(117662.608936/8.0),
    REAL_CONST(117687.303977/8.0),
    REAL_CONST(117712.000313/8.0),
    REAL_CONST(117736.697945/8.0),
    REAL_CONST(117761.396872/8.0),
    REAL_CONST(117786.097094/8.0),
    REAL_CONST(117810.798611/8.0),
    REAL_CONST(117835.501423/8.0),
    REAL_CONST(117860.205530/8.0),
    REAL_CONST(117884.910931/8.0),
    REAL_CONST(117909.617627/8.0),
    REAL_CONST(117934.325617/8.0),
    REAL_CONST(117959.034902/8.0),
    REAL_CONST(117983.745480/8.0),
    REAL_CONST(118008.457352/8.0),
    REAL_CONST(118033.170518/8.0),
    REAL_CONST(118057.884978/8.0),
    REAL_CONST(118082.600731/8.0),
    REAL_CONST(118107.317778/8.0),
    REAL_CONST(118132.036118/8.0),
    REAL_CONST(118156.755751/8.0),
    REAL_CONST(118181.476677/8.0),
    REAL_CONST(118206.198895/8.0),
    REAL_CONST(118230.922407/8.0),
    REAL_CONST(118255.647211/8.0),
    REAL_CONST(118280.373307/8.0),
    REAL_CONST(118305.100696/8.0),
    REAL_CONST(118329.829377/8.0),
    REAL_CONST(118354.559350/8.0),
    REAL_CONST(118379.290615/8.0),
    REAL_CONST(118404.023171/8.0),
    REAL_CONST(118428.757019/8.0),
    REAL_CONST(118453.492159/8.0),
    REAL_CONST(118478.228590/8.0),
    REAL_CONST(118502.966312/8.0),
    REAL_CONST(118527.705326/8.0),
    REAL_CONST(118552.445630/8.0),
    REAL_CONST(118577.187225/8.0),
    REAL_CONST(118601.930111/8.0),
    REAL_CONST(118626.674287/8.0),
    REAL_CONST(118651.419754/8.0),
    REAL_CONST(118676.166511/8.0),
    REAL_CONST(118700.914558/8.0),
    REAL_CONST(118725.663895/8.0),
    REAL_CONST(118750.414522/8.0),
    REAL_CONST(118775.166438/8.0),
    REAL_CONST(118799.919645/8.0),
    REAL_CONST(118824.674140/8.0),
    REAL_CONST(118849.429926/8.0),
    REAL_CONST(118874.187000/8.0),
    REAL_CONST(118898.945363/8.0),
    REAL_CONST(118923.705015/8.0),
    REAL_CONST(118948.465957/8.0),
    REAL_CONST(118973.228186/8.0),
    REAL_CONST(118997.991705/8.0),
    REAL_CONST(119022.756511/8.0),
    REAL_CONST(119047.522606/8.0),
    REAL_CONST(119072.289989/8.0),
    REAL_CONST(119097.058660/8.0),
    REAL_CONST(119121.828619/8.0),
    REAL_CONST(119146.599866/8.0),
    REAL_CONST(119171.372400/8.0),
    REAL_CONST(119196.146221/8.0),
    REAL_CONST(119220.921330/8.0),
    REAL_CONST(119245.697726/8.0),
    REAL_CONST(119270.475410/8.0),
    REAL_CONST(119295.254380/8.0),
    REAL_CONST(119320.034637/8.0),
    REAL_CONST(119344.816180/8.0),
    REAL_CONST(119369.599010/8.0),
    REAL_CONST(119394.383127/8.0),
    REAL_CONST(119419.168529/8.0),
    REAL_CONST(119443.955218/8.0),
    REAL_CONST(119468.743193/8.0),
    REAL_CONST(119493.532454/8.0),
    REAL_CONST(119518.323000/8.0),
    REAL_CONST(119543.114832/8.0),
    REAL_CONST(119567.907949/8.0),
    REAL_CONST(119592.702352/8.0),
    REAL_CONST(119617.498040/8.0),
    REAL_CONST(119642.295013/8.0),
    REAL_CONST(119667.093271/8.0),
    REAL_CONST(119691.892813/8.0),
    REAL_CONST(119716.693641/8.0),
    REAL_CONST(119741.495752/8.0),
    REAL_CONST(119766.299149/8.0),
    REAL_CONST(119791.103829/8.0),
    REAL_CONST(119815.909794/8.0),
    REAL_CONST(119840.717042/8.0),
    REAL_CONST(119865.525575/8.0),
    REAL_CONST(119890.335391/8.0),
    REAL_CONST(119915.146490/8.0),
    REAL_CONST(119939.958874/8.0),
    REAL_CONST(119964.772540/8.0),
    REAL_CONST(119989.587490/8.0),
    REAL_CONST(120014.403723/8.0),
    REAL_CONST(120039.221238/8.0),
    REAL_CONST(120064.040037/8.0),
    REAL_CONST(120088.860118/8.0),
    REAL_CONST(120113.681481/8.0),
    REAL_CONST(120138.504127/8.0),
    REAL_CONST(120163.328056/8.0),
    REAL_CONST(120188.153266/8.0),
    REAL_CONST(120212.979759/8.0),
    REAL_CONST(120237.807533/8.0),
    REAL_CONST(120262.636589/8.0),
    REAL_CONST(120287.466926/8.0),
    REAL_CONST(120312.298545/8.0),
    REAL_CONST(120337.131446/8.0),
    REAL_CONST(120361.965627/8.0),
    REAL_CONST(120386.801090/8.0),
    REAL_CONST(120411.637834/8.0),
    REAL_CONST(120436.475858/8.0),
    REAL_CONST(120461.315163/8.0),
    REAL_CONST(120486.155749/8.0),
    REAL_CONST(120510.997615/8.0),
    REAL_CONST(120535.840761/8.0),
    REAL_CONST(120560.685188/8.0),
    REAL_CONST(120585.530894/8.0),
    REAL_CONST(120610.377881/8.0),
    REAL_CONST(120635.226147/8.0),
    REAL_CONST(120660.075692/8.0),
    REAL_CONST(120684.926518/8.0),
    REAL_CONST(120709.778622/8.0),
    REAL_CONST(120734.632006/8.0),
    REAL_CONST(120759.486669/8.0),
    REAL_CONST(120784.342611/8.0),
    REAL_CONST(120809.199831/8.0),
    REAL_CONST(120834.058331/8.0),
    REAL_CONST(120858.918109/8.0),
    REAL_CONST(120883.779165/8.0),
    REAL_CONST(120908.641500/8.0),
    REAL_CONST(120933.505113/8.0),
    REAL_CONST(120958.370004/8.0),
    REAL_CONST(120983.236172/8.0),
    REAL_CONST(121008.103619/8.0),
    REAL_CONST(121032.972343/8.0),
    REAL_CONST(121057.842345/8.0),
    REAL_CONST(121082.713624/8.0),
    REAL_CONST(121107.586180/8.0),
    REAL_CONST(121132.460014/8.0),
    REAL_CONST(121157.335124/8.0),
    REAL_CONST(121182.211512/8.0),
    REAL_CONST(121207.089176/8.0),
    REAL_CONST(121231.968116/8.0),
    REAL_CONST(121256.848333/8.0),
    REAL_CONST(121281.729827/8.0),
    REAL_CONST(121306.612597/8.0),
    REAL_CONST(121331.496642/8.0),
    REAL_CONST(121356.381964/8.0),
    REAL_CONST(121381.268561/8.0),
    REAL_CONST(121406.156435/8.0),
    REAL_CONST(121431.045583/8.0),
    REAL_CONST(121455.936007/8.0),
    REAL_CONST(121480.827707/8.0),
    REAL_CONST(121505.720681/8.0),
    REAL_CONST(121530.614931/8.0),
    REAL_CONST(121555.510455/8.0),
    REAL_CONST(121580.407255/8.0),
    REAL_CONST(121605.305329/8.0),
    REAL_CONST(121630.204677/8.0),
    REAL_CONST(121655.105300/8.0),
    REAL_CONST(121680.007197/8.0),
    REAL_CONST(121704.910368/8.0),
    REAL_CONST(121729.814813/8.0),
    REAL_CONST(121754.720532/8.0),
    REAL_CONST(121779.627525/8.0),
    REAL_CONST(121804.535791/8.0),
    REAL_CONST(121829.445331/8.0),
    REAL_CONST(121854.356144/8.0),
    REAL_CONST(121879.268230/8.0),
    REAL_CONST(121904.181589/8.0),
    REAL_CONST(121929.096222/8.0),
    REAL_CONST(121954.012127/8.0),
    REAL_CONST(121978.929304/8.0),
    REAL_CONST(122003.847755/8.0),
    REAL_CONST(122028.767478/8.0),
    REAL_CONST(122053.688473/8.0),
    REAL_CONST(122078.610740/8.0),
    REAL_CONST(122103.534279/8.0),
    REAL_CONST(122128.459090/8.0),
    REAL_CONST(122153.385173/8.0),
    REAL_CONST(122178.312528/8.0),
    REAL_CONST(122203.241154/8.0),
    REAL_CONST(122228.171051/8.0),
    REAL_CONST(122253.102220/8.0),
    REAL_CONST(122278.034660/8.0),
    REAL_CONST(122302.968370/8.0),
    REAL_CONST(122327.903352/8.0),
    REAL_CONST(122352.839604/8.0),
    REAL_CONST(122377.777127/8.0),
    REAL_CONST(122402.715921/8.0),
    REAL_CONST(122427.655985/8.0),
    REAL_CONST(122452.597319/8.0),
    REAL_CONST(122477.539923/8.0),
    REAL_CONST(122502.483797/8.0),
    REAL_CONST(122527.428941/8.0),
    REAL_CONST(122552.375354/8.0),
    REAL_CONST(122577.323038/8.0),
    REAL_CONST(122602.271990/8.0),
    REAL_CONST(122627.222212/8.0),
    REAL_CONST(122652.173703/8.0),
    REAL_CONST(122677.126463/8.0),
    REAL_CONST(122702.080493/8.0),
    REAL_CONST(122727.035790/8.0),
    REAL_CONST(122751.992357/8.0),
    REAL_CONST(122776.950192/8.0),
    REAL_CONST(122801.909296/8.0),
    REAL_CONST(122826.869667/8.0),
    REAL_CONST(122851.831307/8.0),
    REAL_CONST(122876.794215/8.0),
    REAL_CONST(122901.758391/8.0),
    REAL_CONST(122926.723835/8.0),
    REAL_CONST(122951.690546/8.0),
    REAL_CONST(122976.658525/8.0),
    REAL_CONST(123001.627771/8.0),
    REAL_CONST(123026.598284/8.0),
    REAL_CONST(123051.570065/8.0),
    REAL_CONST(123076.543112/8.0),
    REAL_CONST(123101.517427/8.0),
    REAL_CONST(123126.493008/8.0),
    REAL_CONST(123151.469855/8.0),
    REAL_CONST(123176.447970/8.0),
    REAL_CONST(123201.427350/8.0),
    REAL_CONST(123226.407997/8.0),
    REAL_CONST(123251.389910/8.0),
    REAL_CONST(123276.373088/8.0),
    REAL_CONST(123301.357533/8.0),
    REAL_CONST(123326.343243/8.0),
    REAL_CONST(123351.330219/8.0),
    REAL_CONST(123376.318461/8.0),
    REAL_CONST(123401.307967/8.0),
    REAL_CONST(123426.298739/8.0),
    REAL_CONST(123451.290776/8.0),
    REAL_CONST(123476.284078/8.0),
    REAL_CONST(123501.278645/8.0),
    REAL_CONST(123526.274476/8.0),
    REAL_CONST(123551.271572/8.0),
    REAL_CONST(123576.269933/8.0),
    REAL_CONST(123601.269557/8.0),
    REAL_CONST(123626.270446/8.0),
    REAL_CONST(123651.272599/8.0),
    REAL_CONST(123676.276016/8.0),
    REAL_CONST(123701.280696/8.0),
    REAL_CONST(123726.286641/8.0),
    REAL_CONST(123751.293849/8.0),
    REAL_CONST(123776.302320/8.0),
    REAL_CONST(123801.312054/8.0),
    REAL_CONST(123826.323052/8.0),
    REAL_CONST(123851.335312/8.0),
    REAL_CONST(123876.348836/8.0),
    REAL_CONST(123901.363622/8.0),
    REAL_CONST(123926.379671/8.0),
    REAL_CONST(123951.396983/8.0),
    REAL_CONST(123976.415557/8.0),
    REAL_CONST(124001.435393/8.0),
    REAL_CONST(124026.456491/8.0),
    REAL_CONST(124051.478851/8.0),
    REAL_CONST(124076.502473/8.0),
    REAL_CONST(124101.527357/8.0),
    REAL_CONST(124126.553503/8.0),
    REAL_CONST(124151.580910/8.0),
    REAL_CONST(124176.609578/8.0),
    REAL_CONST(124201.639508/8.0),
    REAL_CONST(124226.670698/8.0),
    REAL_CONST(124251.703150/8.0),
    REAL_CONST(124276.736862/8.0),
    REAL_CONST(124301.771836/8.0),
    REAL_CONST(124326.808070/8.0),
    REAL_CONST(124351.845564/8.0),
    REAL_CONST(124376.884319/8.0),
    REAL_CONST(124401.924334/8.0),
    REAL_CONST(124426.965609/8.0),
    REAL_CONST(124452.008144/8.0),
    REAL_CONST(124477.051938/8.0),
    REAL_CONST(124502.096993/8.0),
    REAL_CONST(124527.143307/8.0),
    REAL_CONST(124552.190881/8.0),
    REAL_CONST(124577.239714/8.0),
    REAL_CONST(124602.289806/8.0),
    REAL_CONST(124627.341157/8.0),
    REAL_CONST(124652.393767/8.0),
    REAL_CONST(124677.447636/8.0),
    REAL_CONST(124702.502764/8.0),
    REAL_CONST(124727.559150/8.0),
    REAL_CONST(124752.616795/8.0),
    REAL_CONST(124777.675698/8.0),
    REAL_CONST(124802.735859/8.0),
    REAL_CONST(124827.797279/8.0),
    REAL_CONST(124852.859956/8.0),
    REAL_CONST(124877.923891/8.0),
    REAL_CONST(124902.989084/8.0),
    REAL_CONST(124928.055534/8.0),
    REAL_CONST(124953.123242/8.0),
    REAL_CONST(124978.192207/8.0),
    REAL_CONST(125003.262430/8.0),
    REAL_CONST(125028.333909/8.0),
    REAL_CONST(125053.406645/8.0),
    REAL_CONST(125078.480638/8.0),
    REAL_CONST(125103.555888/8.0),
    REAL_CONST(125128.632395/8.0),
    REAL_CONST(125153.710157/8.0),
    REAL_CONST(125178.789176/8.0),
    REAL_CONST(125203.869452/8.0),
    REAL_CONST(125228.950983/8.0),
    REAL_CONST(125254.033770/8.0),
    REAL_CONST(125279.117813/8.0),
    REAL_CONST(125304.203112/8.0),
    REAL_CONST(125329.289666/8.0),
    REAL_CONST(125354.377476/8.0),
    REAL_CONST(125379.466541/8.0),
    REAL_CONST(125404.556861/8.0),
    REAL_CONST(125429.648437/8.0),
    REAL_CONST(125454.741267/8.0),
    REAL_CONST(125479.835352/8.0),
    REAL_CONST(125504.930692/8.0),
    REAL_CONST(125530.027286/8.0),
    REAL_CONST(125555.125134/8.0),
    REAL_CONST(125580.224237/8.0),
    REAL_CONST(125605.324594/8.0),
    REAL_CONST(125630.426205/8.0),
    REAL_CONST(125655.529071/8.0),
    REAL_CONST(125680.633189/8.0),
    REAL_CONST(125705.738562/8.0),
    REAL_CONST(125730.845188/8.0),
    REAL_CONST(125755.953067/8.0),
    REAL_CONST(125781.062200/8.0),
    REAL_CONST(125806.172586/8.0),
    REAL_CONST(125831.284225/8.0),
    REAL_CONST(125856.397117/8.0),
    REAL_CONST(125881.511262/8.0),
    REAL_CONST(125906.626659/8.0),
    REAL_CONST(125931.743309/8.0),
    REAL_CONST(125956.861211/8.0),
    REAL_CONST(125981.980366/8.0),
    REAL_CONST(126007.100773/8.0),
    REAL_CONST(126032.222432/8.0),
    REAL_CONST(126057.345343/8.0),
    REAL_CONST(126082.469505/8.0),
    REAL_CONST(126107.594919/8.0),
    REAL_CONST(126132.721585/8.0),
    REAL_CONST(126157.849502/8.0),
    REAL_CONST(126182.978671/8.0),
    REAL_CONST(126208.109090/8.0),
    REAL_CONST(126233.240761/8.0),
    REAL_CONST(126258.373683/8.0),
    REAL_CONST(126283.507855/8.0),
    REAL_CONST(126308.643278/8.0),
    REAL_CONST(126333.779952/8.0),
    REAL_CONST(126358.917876/8.0),
    REAL_CONST(126384.057051/8.0),
    REAL_CONST(126409.197475/8.0),
    REAL_CONST(126434.339150/8.0),
    REAL_CONST(126459.482074/8.0),
    REAL_CONST(126484.626249/8.0),
    REAL_CONST(126509.771673/8.0),
    REAL_CONST(126534.918346/8.0),
    REAL_CONST(126560.066269/8.0),
    REAL_CONST(126585.215442/8.0),
    REAL_CONST(126610.365863/8.0),
    REAL_CONST(126635.517534/8.0),
    REAL_CONST(126660.670453/8.0),
    REAL_CONST(126685.824622/8.0),
    REAL_CONST(126710.980039/8.0),
    REAL_CONST(126736.136704/8.0),
    REAL_CONST(126761.294618/8.0),
    REAL_CONST(126786.453780/8.0),
    REAL_CONST(126811.614191/8.0),
    REAL_CONST(126836.775849/8.0),
    REAL_CONST(126861.938756/8.0),
    REAL_CONST(126887.102910/8.0),
    REAL_CONST(126912.268312/8.0),
    REAL_CONST(126937.434962/8.0),
    REAL_CONST(126962.602859/8.0),
    REAL_CONST(126987.772003/8.0),
    REAL_CONST(127012.942395/8.0),
    REAL_CONST(127038.114034/8.0),
    REAL_CONST(127063.286919/8.0),
    REAL_CONST(127088.461052/8.0),
    REAL_CONST(127113.636431/8.0),
    REAL_CONST(127138.813057/8.0),
    REAL_CONST(127163.990929/8.0),
    REAL_CONST(127189.170047/8.0),
    REAL_CONST(127214.350412/8.0),
    REAL_CONST(127239.532023/8.0),
    REAL_CONST(127264.714880/8.0),
    REAL_CONST(127289.898982/8.0),
    REAL_CONST(127315.084331/8.0),
    REAL_CONST(127340.270925/8.0),
    REAL_CONST(127365.458764/8.0),
    REAL_CONST(127390.647849/8.0),
    REAL_CONST(127415.838179/8.0),
    REAL_CONST(127441.029754/8.0),
    REAL_CONST(127466.222574/8.0),
    REAL_CONST(127491.416639/8.0),
    REAL_CONST(127516.611949/8.0),
    REAL_CONST(127541.808503/8.0),
    REAL_CONST(127567.006302/8.0),
    REAL_CONST(127592.205345/8.0),
    REAL_CONST(127617.405632/8.0),
    REAL_CONST(127642.607164/8.0),
    REAL_CONST(127667.809939/8.0),
    REAL_CONST(127693.013959/8.0),
    REAL_CONST(127718.219222/8.0),
    REAL_CONST(127743.425729/8.0),
    REAL_CONST(127768.633479/8.0),
    REAL_CONST(127793.842473/8.0),
    REAL_CONST(127819.052710/8.0),
    REAL_CONST(127844.264190/8.0),
    REAL_CONST(127869.476913/8.0),
    REAL_CONST(127894.690879/8.0),
    REAL_CONST(127919.906088/8.0),
    REAL_CONST(127945.122539/8.0),
    REAL_CONST(127970.340233/8.0),
    REAL_CONST(127995.559169/8.0),
    REAL_CONST(128020.779348/8.0),
    REAL_CONST(128046.000769/8.0),
    REAL_CONST(128071.223431/8.0),
    REAL_CONST(128096.447336/8.0),
    REAL_CONST(128121.672483/8.0),
    REAL_CONST(128146.898871/8.0),
    REAL_CONST(128172.126501/8.0),
    REAL_CONST(128197.355372/8.0),
    REAL_CONST(128222.585484/8.0),
    REAL_CONST(128247.816838/8.0),
    REAL_CONST(128273.049433/8.0),
    REAL_CONST(128298.283268/8.0),
    REAL_CONST(128323.518345/8.0),
    REAL_CONST(128348.754662/8.0),
    REAL_CONST(128373.992220/8.0),
    REAL_CONST(128399.231018/8.0),
    REAL_CONST(128424.471056/8.0),
    REAL_CONST(128449.712335/8.0),
    REAL_CONST(128474.954854/8.0),
    REAL_CONST(128500.198612/8.0),
    REAL_CONST(128525.443611/8.0),
    REAL_CONST(128550.689849/8.0),
    REAL_CONST(128575.937327/8.0),
    REAL_CONST(128601.186045/8.0),
    REAL_CONST(128626.436001/8.0),
    REAL_CONST(128651.687197/8.0),
    REAL_CONST(128676.939632/8.0),
    REAL_CONST(128702.193306/8.0),
    REAL_CONST(128727.448219/8.0),
    REAL_CONST(128752.704371/8.0),
    REAL_CONST(128777.961761/8.0),
    REAL_CONST(128803.220390/8.0),
    REAL_CONST(128828.480257/8.0),
    REAL_CONST(128853.741363/8.0),
    REAL_CONST(128879.003706/8.0),
    REAL_CONST(128904.267288/8.0),
    REAL_CONST(128929.532107/8.0),
    REAL_CONST(128954.798165/8.0),
    REAL_CONST(128980.065460/8.0),
    REAL_CONST(129005.333992/8.0),
    REAL_CONST(129030.603762/8.0),
    REAL_CONST(129055.874769/8.0),
    REAL_CONST(129081.147013/8.0),
    REAL_CONST(129106.420495/8.0),
    REAL_CONST(129131.695213/8.0),
    REAL_CONST(129156.971168/8.0),
    REAL_CONST(129182.248360/8.0),
    REAL_CONST(129207.526788/8.0),
    REAL_CONST(129232.806453/8.0),
    REAL_CONST(129258.087354/8.0),
    REAL_CONST(129283.369491/8.0),
    REAL_CONST(129308.652865/8.0),
    REAL_CONST(129333.937474/8.0),
    REAL_CONST(129359.223319/8.0),
    REAL_CONST(129384.510400/8.0),
    REAL_CONST(129409.798716/8.0),
    REAL_CONST(129435.088268/8.0),
    REAL_CONST(129460.379056/8.0),
    REAL_CONST(129485.671078/8.0),
    REAL_CONST(129510.964336/8.0),
    REAL_CONST(129536.258829/8.0),
    REAL_CONST(129561.554556/8.0),
    REAL_CONST(129586.851518/8.0),
    REAL_CONST(129612.149715/8.0),
    REAL_CONST(129637.449147/8.0),
    REAL_CONST(129662.749812/8.0),
    REAL_CONST(129688.051713/8.0),
    REAL_CONST(129713.354847/8.0),
    REAL_CONST(129738.659215/8.0),
    REAL_CONST(129763.964817/8.0),
    REAL_CONST(129789.271653/8.0),
    REAL_CONST(129814.579723/8.0),
    REAL_CONST(129839.889026/8.0),
    REAL_CONST(129865.199562/8.0),
    REAL_CONST(129890.511332/8.0),
    REAL_CONST(129915.824335/8.0),
    REAL_CONST(129941.138572/8.0),
    REAL_CONST(129966.454041/8.0),
    REAL_CONST(129991.770743/8.0),
    REAL_CONST(130017.088677/8.0),
    REAL_CONST(130042.407844/8.0),
    REAL_CONST(130067.728244/8.0),
    REAL_CONST(130093.049876/8.0),
    REAL_CONST(130118.372740/8.0),
    REAL_CONST(130143.696837/8.0),
    REAL_CONST(130169.022165/8.0),
    REAL_CONST(130194.348725/8.0),
    REAL_CONST(130219.676517/8.0),
    REAL_CONST(130245.005541/8.0),
    REAL_CONST(130270.335796/8.0),
    REAL_CONST(130295.667282/8.0),
    REAL_CONST(130321.000000/8.0),
    REAL_CONST(130346.333949/8.0),
    REAL_CONST(130371.669129/8.0),
    REAL_CONST(130397.005540/8.0),
    REAL_CONST(130422.343181/8.0),
    REAL_CONST(130447.682054/8.0),
    REAL_CONST(130473.022156/8.0),
    REAL_CONST(130498.363490/8.0),
    REAL_CONST(130523.706053/8.0),
    REAL_CONST(130549.049847/8.0),
    REAL_CONST(130574.394871/8.0),
    REAL_CONST(130599.741125/8.0),
    REAL_CONST(130625.088608/8.0),
    REAL_CONST(130650.437322/8.0),
    REAL_CONST(130675.787264/8.0),
    REAL_CONST(130701.138437/8.0),
    REAL_CONST(130726.490839/8.0),
    REAL_CONST(130751.844470/8.0),
    REAL_CONST(130777.199330/8.0),
    REAL_CONST(130802.555419/8.0),
    REAL_CONST(130827.912737/8.0),
    REAL_CONST(130853.271284/8.0),
    REAL_CONST(130878.631059/8.0),
    REAL_CONST(130903.992063/8.0),
    REAL_CONST(130929.354295/8.0),
    REAL_CONST(130954.717756/8.0),
    REAL_CONST(130980.082445/8.0),
    REAL_CONST(131005.448362/8.0),
    REAL_CONST(131030.815506/8.0),
    REAL_CONST(131056.183879/8.0),
    REAL_CONST(131081.553479/8.0),
    REAL_CONST(131106.924307/8.0),
    REAL_CONST(131132.296362/8.0),
    REAL_CONST(131157.669645/8.0),
    REAL_CONST(131183.044155/8.0),
    REAL_CONST(131208.419892/8.0),
    REAL_CONST(131233.796855/8.0),
    REAL_CONST(131259.175046/8.0),
    REAL_CONST(131284.554464/8.0),
    REAL_CONST(131309.935108/8.0),
    REAL_CONST(131335.316978/8.0),
    REAL_CONST(131360.700075/8.0),
    REAL_CONST(131386.084399/8.0),
    REAL_CONST(131411.469948/8.0),
    REAL_CONST(131436.856724/8.0),
    REAL_CONST(131462.244725/8.0),
    REAL_CONST(131487.633952/8.0),
    REAL_CONST(131513.024405/8.0),
    REAL_CONST(131538.416083/8.0),
    REAL_CONST(131563.808987/8.0),
    REAL_CONST(131589.203116/8.0),
    REAL_CONST(131614.598471/8.0),
    REAL_CONST(131639.995050/8.0),
    REAL_CONST(131665.392854/8.0),
    REAL_CONST(131690.791884/8.0),
    REAL_CONST(131716.192138/8.0),
    REAL_CONST(131741.593616/8.0),
    REAL_CONST(131766.996319/8.0),
    REAL_CONST(131792.400247/8.0),
    REAL_CONST(131817.805398/8.0),
    REAL_CONST(131843.211774/8.0),
    REAL_CONST(131868.619374/8.0),
    REAL_CONST(131894.028198/8.0),
    REAL_CONST(131919.438245/8.0),
    REAL_CONST(131944.849517/8.0),
    REAL_CONST(131970.262011/8.0),
    REAL_CONST(131995.675730/8.0),
    REAL_CONST(132021.090671/8.0),
    REAL_CONST(132046.506836/8.0),
    REAL_CONST(132071.924224/8.0),
    REAL_CONST(132097.342834/8.0),
    REAL_CONST(132122.762668/8.0),
    REAL_CONST(132148.183724/8.0),
    REAL_CONST(132173.606003/8.0),
    REAL_CONST(132199.029504/8.0),
    REAL_CONST(132224.454228/8.0),
    REAL_CONST(132249.880174/8.0),
    REAL_CONST(132275.307342/8.0),
    REAL_CONST(132300.735733/8.0),
    REAL_CONST(132326.165345/8.0),
    REAL_CONST(132351.596179/8.0),
    REAL_CONST(132377.028234/8.0),
    REAL_CONST(132402.461511/8.0),
    REAL_CONST(132427.896010/8.0),
    REAL_CONST(132453.331729/8.0),
    REAL_CONST(132478.768671/8.0),
    REAL_CONST(132504.206833/8.0),
    REAL_CONST(132529.646216/8.0),
    REAL_CONST(132555.086820/8.0),
    REAL_CONST(132580.528644/8.0),
    REAL_CONST(132605.971690/8.0),
    REAL_CONST(132631.415955/8.0),
    REAL_CONST(132656.861441/8.0),
    REAL_CONST(132682.308148/8.0),
    REAL_CONST(132707.756074/8.0),
    REAL_CONST(132733.205221/8.0),
    REAL_CONST(132758.655587/8.0),
    REAL_CONST(132784.107174/8.0),
    REAL_CONST(132809.559980/8.0),
    REAL_CONST(132835.014005/8.0),
    REAL_CONST(132860.469250/8.0),
    REAL_CONST(132885.925714/8.0),
    REAL_CONST(132911.383398/8.0),
    REAL_CONST(132936.842300/8.0),
    REAL_CONST(132962.302422/8.0),
    REAL_CONST(132987.763762/8.0),
    REAL_CONST(133013.226321/8.0),
    REAL_CONST(133038.690099/8.0),
    REAL_CONST(133064.155095/8.0),
    REAL_CONST(133089.621310/8.0),
    REAL_CONST(133115.088743/8.0),
    REAL_CONST(133140.557394/8.0),
    REAL_CONST(133166.027263/8.0),
    REAL_CONST(133191.498350/8.0),
    REAL_CONST(133216.970655/8.0),
    REAL_CONST(133242.444178/8.0),
    REAL_CONST(133267.918918/8.0),
    REAL_CONST(133293.394876/8.0),
    REAL_CONST(133318.872051/8.0),
    REAL_CONST(133344.350443/8.0),
    REAL_CONST(133369.830052/8.0),
    REAL_CONST(133395.310878/8.0),
    REAL_CONST(133420.792921/8.0),
    REAL_CONST(133446.276181/8.0),
    REAL_CONST(133471.760658/8.0),
    REAL_CONST(133497.246351/8.0),
    REAL_CONST(133522.733261/8.0),
    REAL_CONST(133548.221386/8.0),
    REAL_CONST(133573.710728/8.0),
    REAL_CONST(133599.201286/8.0),
    REAL_CONST(133624.693060/8.0),
    REAL_CONST(133650.186050/8.0),
    REAL_CONST(133675.680256/8.0),
    REAL_CONST(133701.175677/8.0),
    REAL_CONST(133726.672314/8.0),
    REAL_CONST(133752.170166/8.0),
    REAL_CONST(133777.669233/8.0),
    REAL_CONST(133803.169515/8.0),
    REAL_CONST(133828.671013/8.0),
    REAL_CONST(133854.173725/8.0),
    REAL_CONST(133879.677652/8.0),
    REAL_CONST(133905.182794/8.0),
    REAL_CONST(133930.689150/8.0),
    REAL_CONST(133956.196721/8.0),
    REAL_CONST(133981.705506/8.0),
    REAL_CONST(134007.215506/8.0),
    REAL_CONST(134032.726719/8.0),
    REAL_CONST(134058.239147/8.0),
    REAL_CONST(134083.752788/8.0),
    REAL_CONST(134109.267643/8.0),
    REAL_CONST(134134.783712/8.0),
    REAL_CONST(134160.300994/8.0),
    REAL_CONST(134185.819489/8.0),
    REAL_CONST(134211.339198/8.0),
    REAL_CONST(134236.860120/8.0),
    REAL_CONST(134262.382255/8.0),
    REAL_CONST(134287.905604/8.0),
    REAL_CONST(134313.430164/8.0),
    REAL_CONST(134338.955938/8.0),
    REAL_CONST(134364.482924/8.0),
    REAL_CONST(134390.011123/8.0),
    REAL_CONST(134415.540534/8.0),
    REAL_CONST(134441.071157/8.0),
    REAL_CONST(134466.602993/8.0),
    REAL_CONST(134492.136040/8.0),
    REAL_CONST(134517.670300/8.0),
    REAL_CONST(134543.205771/8.0),
    REAL_CONST(134568.742454/8.0),
    REAL_CONST(134594.280348/8.0),
    REAL_CONST(134619.819454/8.0),
    REAL_CONST(134645.359771/8.0),
    REAL_CONST(134670.901299/8.0),
    REAL_CONST(134696.444039/8.0),
    REAL_CONST(134721.987989/8.0),
    REAL_CONST(134747.533151/8.0),
    REAL_CONST(134773.079523/8.0),
    REAL_CONST(134798.627106/8.0),
    REAL_CONST(134824.175899/8.0),
    REAL_CONST(134849.725902/8.0),
    REAL_CONST(134875.277116/8.0),
    REAL_CONST(134900.829541/8.0),
    REAL_CONST(134926.383175/8.0),
    REAL_CONST(134951.938019/8.0),
    REAL_CONST(134977.494073/8.0),
    REAL_CONST(135003.051337/8.0),
    REAL_CONST(135028.609810/8.0),
    REAL_CONST(135054.169493/8.0),
    REAL_CONST(135079.730385/8.0),
    REAL_CONST(135105.292487/8.0),
    REAL_CONST(135130.855798/8.0),
    REAL_CONST(135156.420317/8.0),
    REAL_CONST(135181.986046/8.0),
    REAL_CONST(135207.552983/8.0),
    REAL_CONST(135233.121129/8.0),
    REAL_CONST(135258.690484/8.0),
    REAL_CONST(135284.261047/8.0),
    REAL_CONST(135309.832819/8.0),
    REAL_CONST(135335.405799/8.0),
    REAL_CONST(135360.979987/8.0),
    REAL_CONST(135386.555383/8.0),
    REAL_CONST(135412.131986/8.0),
    REAL_CONST(135437.709798/8.0),
    REAL_CONST(135463.288817/8.0),
    REAL_CONST(135488.869044/8.0),
    REAL_CONST(135514.450478/8.0),
    REAL_CONST(135540.033120/8.0),
    REAL_CONST(135565.616969/8.0),
    REAL_CONST(135591.202025/8.0),
    REAL_CONST(135616.788287/8.0),
    REAL_CONST(135642.375757/8.0),
    REAL_CONST(135667.964434/8.0),
    REAL_CONST(135693.554317/8.0),
    REAL_CONST(135719.145407/8.0),
    REAL_CONST(135744.737703/8.0),
    REAL_CONST(135770.331205/8.0),
    REAL_CONST(135795.925914/8.0),
    REAL_CONST(135821.521828/8.0),
    REAL_CONST(135847.118949/8.0),
    REAL_CONST(135872.717275/8.0),
    REAL_CONST(135898.316808/8.0),
    REAL_CONST(135923.917545/8.0),
    REAL_CONST(135949.519489/8.0),
    REAL_CONST(135975.122637/8.0),
    REAL_CONST(136000.726991/8.0),
    REAL_CONST(136026.332551/8.0),
    REAL_CONST(136051.939315/8.0),
    REAL_CONST(136077.547284/8.0),
    REAL_CONST(136103.156458/8.0),
    REAL_CONST(136128.766837/8.0),
    REAL_CONST(136154.378420/8.0),
    REAL_CONST(136179.991208/8.0),
    REAL_CONST(136205.605200/8.0),
    REAL_CONST(136231.220396/8.0),
    REAL_CONST(136256.836797/8.0),
    REAL_CONST(136282.454401/8.0),
    REAL_CONST(136308.073210/8.0),
    REAL_CONST(136333.693222/8.0),
    REAL_CONST(136359.314438/8.0),
    REAL_CONST(136384.936858/8.0),
    REAL_CONST(136410.560481/8.0),
    REAL_CONST(136436.185307/8.0),
    REAL_CONST(136461.811337/8.0),
    REAL_CONST(136487.438570/8.0),
    REAL_CONST(136513.067006/8.0),
    REAL_CONST(136538.696644/8.0),
    REAL_CONST(136564.327486/8.0),
    REAL_CONST(136589.959530/8.0),
    REAL_CONST(136615.592777/8.0),
    REAL_CONST(136641.227226/8.0),
    REAL_CONST(136666.862877/8.0),
    REAL_CONST(136692.499731/8.0),
    REAL_CONST(136718.137787/8.0),
    REAL_CONST(136743.777045/8.0),
    REAL_CONST(136769.417505/8.0),
    REAL_CONST(136795.059166/8.0),
    REAL_CONST(136820.702029/8.0),
    REAL_CONST(136846.346094/8.0),
    REAL_CONST(136871.991360/8.0),
    REAL_CONST(136897.637828/8.0),
    REAL_CONST(136923.285496/8.0),
    REAL_CONST(136948.934366/8.0),
    REAL_CONST(136974.584437/8.0),
    REAL_CONST(137000.235709/8.0),
    REAL_CONST(137025.888181/8.0),
    REAL_CONST(137051.541854/8.0),
    REAL_CONST(137077.196728/8.0),
    REAL_CONST(137102.852802/8.0),
    REAL_CONST(137128.510076/8.0),
    REAL_CONST(137154.168551/8.0),
    REAL_CONST(137179.828225/8.0),
    REAL_CONST(137205.489100/8.0),
    REAL_CONST(137231.151174/8.0),
    REAL_CONST(137256.814449/8.0),
    REAL_CONST(137282.478922/8.0),
    REAL_CONST(137308.144596/8.0),
    REAL_CONST(137333.811469/8.0),
    REAL_CONST(137359.479541/8.0),
    REAL_CONST(137385.148812/8.0),
    REAL_CONST(137410.819282/8.0),
    REAL_CONST(137436.490952/8.0),
    REAL_CONST(137462.163820/8.0),
    REAL_CONST(137487.837887/8.0),
    REAL_CONST(137513.513152/8.0),
    REAL_CONST(137539.189617/8.0),
    REAL_CONST(137564.867279/8.0),
    REAL_CONST(137590.546140/8.0),
    REAL_CONST(137616.226199/8.0),
    REAL_CONST(137641.907456/8.0),
    REAL_CONST(137667.589911/8.0),
    REAL_CONST(137693.273564/8.0),
    REAL_CONST(137718.958414/8.0),
    REAL_CONST(137744.644462/8.0),
    REAL_CONST(137770.331708/8.0),
    REAL_CONST(137796.020151/8.0),
    REAL_CONST(137821.709792/8.0),
    REAL_CONST(137847.400629/8.0),
    REAL_CONST(137873.092664/8.0),
    REAL_CONST(137898.785896/8.0),
    REAL_CONST(137924.480324/8.0),
    REAL_CONST(137950.175949/8.0),
    REAL_CONST(137975.872771/8.0),
    REAL_CONST(138001.570789/8.0),
    REAL_CONST(138027.270004/8.0),
    REAL_CONST(138052.970415/8.0),
    REAL_CONST(138078.672022/8.0),
    REAL_CONST(138104.374826/8.0),
    REAL_CONST(138130.078825/8.0),
    REAL_CONST(138155.784020/8.0),
    REAL_CONST(138181.490410/8.0),
    REAL_CONST(138207.197997/8.0),
    REAL_CONST(138232.906779/8.0),
    REAL_CONST(138258.616756/8.0),
    REAL_CONST(138284.327929/8.0),
    REAL_CONST(138310.040296/8.0),
    REAL_CONST(138335.753859/8.0),
    REAL_CONST(138361.468617/8.0),
    REAL_CONST(138387.184569/8.0),
    REAL_CONST(138412.901717/8.0),
    REAL_CONST(138438.620059/8.0),
    REAL_CONST(138464.339595/8.0),
    REAL_CONST(138490.060326/8.0),
    REAL_CONST(138515.782251/8.0),
    REAL_CONST(138541.505370/8.0),
    REAL_CONST(138567.229684/8.0),
    REAL_CONST(138592.955191/8.0),
    REAL_CONST(138618.681892/8.0),
    REAL_CONST(138644.409787/8.0),
    REAL_CONST(138670.138876/8.0),
    REAL_CONST(138695.869158/8.0),
    REAL_CONST(138721.600633/8.0),
    REAL_CONST(138747.333302/8.0),
    REAL_CONST(138773.067164/8.0),
    REAL_CONST(138798.802219/8.0),
    REAL_CONST(138824.538467/8.0),
    REAL_CONST(138850.275907/8.0),
    REAL_CONST(138876.014541/8.0),
    REAL_CONST(138901.754367/8.0),
    REAL_CONST(138927.495386/8.0),
    REAL_CONST(138953.237597/8.0),
    REAL_CONST(138978.981000/8.0),
    REAL_CONST(139004.725596/8.0),
    REAL_CONST(139030.471383/8.0),
    REAL_CONST(139056.218363/8.0),
    REAL_CONST(139081.966534/8.0),
    REAL_CONST(139107.715897/8.0),
    REAL_CONST(139133.466452/8.0),
    REAL_CONST(139159.218198/8.0),
    REAL_CONST(139184.971136/8.0),
    REAL_CONST(139210.725265/8.0),
    REAL_CONST(139236.480585/8.0),
    REAL_CONST(139262.237097/8.0),
    REAL_CONST(139287.994799/8.0),
    REAL_CONST(139313.753692/8.0),
    REAL_CONST(139339.513776/8.0),
    REAL_CONST(139365.275050/8.0),
    REAL_CONST(139391.037515/8.0),
    REAL_CONST(139416.801171/8.0),
    REAL_CONST(139442.566017/8.0),
    REAL_CONST(139468.332052/8.0),
    REAL_CONST(139494.099279/8.0),
    REAL_CONST(139519.867695/8.0),
    REAL_CONST(139545.637300/8.0),
    REAL_CONST(139571.408096/8.0),
    REAL_CONST(139597.180081/8.0),
    REAL_CONST(139622.953256/8.0),
    REAL_CONST(139648.727621/8.0),
    REAL_CONST(139674.503174/8.0),
    REAL_CONST(139700.279917/8.0),
    REAL_CONST(139726.057849/8.0),
    REAL_CONST(139751.836970/8.0),
    REAL_CONST(139777.617280/8.0),
    REAL_CONST(139803.398778/8.0),
    REAL_CONST(139829.181465/8.0),
    REAL_CONST(139854.965341/8.0),
    REAL_CONST(139880.750405/8.0),
    REAL_CONST(139906.536658/8.0),
    REAL_CONST(139932.324099/8.0),
    REAL_CONST(139958.112728/8.0),
    REAL_CONST(139983.902544/8.0),
    REAL_CONST(140009.693549/8.0),
    REAL_CONST(140035.485742/8.0),
    REAL_CONST(140061.279122/8.0),
    REAL_CONST(140087.073690/8.0),
    REAL_CONST(140112.869445/8.0),
    REAL_CONST(140138.666388/8.0),
    REAL_CONST(140164.464518/8.0),
    REAL_CONST(140190.263835/8.0),
    REAL_CONST(140216.064339/8.0),
    REAL_CONST(140241.866030/8.0),
    REAL_CONST(140267.668907/8.0),
    REAL_CONST(140293.472972/8.0),
    REAL_CONST(140319.278223/8.0),
    REAL_CONST(140345.084660/8.0),
    REAL_CONST(140370.892284/8.0),
    REAL_CONST(140396.701094/8.0),
    REAL_CONST(140422.511090/8.0),
    REAL_CONST(140448.322273/8.0),
    REAL_CONST(140474.134641/8.0),
    REAL_CONST(140499.948195/8.0),
    REAL_CONST(140525.762935/8.0),
    REAL_CONST(140551.578860/8.0),
    REAL_CONST(140577.395971/8.0),
    REAL_CONST(140603.214267/8.0),
    REAL_CONST(140629.033749/8.0),
    REAL_CONST(140654.854416/8.0),
    REAL_CONST(140680.676267/8.0),
    REAL_CONST(140706.499304/8.0),
    REAL_CONST(140732.323526/8.0),
    REAL_CONST(140758.148932/8.0),
    REAL_CONST(140783.975523/8.0),
    REAL_CONST(140809.803298/8.0),
    REAL_CONST(140835.632258/8.0),
    REAL_CONST(140861.462402/8.0),
    REAL_CONST(140887.293730/8.0),
    REAL_CONST(140913.126243/8.0),
    REAL_CONST(140938.959939/8.0),
    REAL_CONST(140964.794819/8.0),
    REAL_CONST(140990.630883/8.0),
    REAL_CONST(141016.468131/8.0),
    REAL_CONST(141042.306562/8.0),
    REAL_CONST(141068.146177/8.0),
    REAL_CONST(141093.986975/8.0),
    REAL_CONST(141119.828956/8.0),
    REAL_CONST(141145.672120/8.0),
    REAL_CONST(141171.516467/8.0),
    REAL_CONST(141197.361998/8.0),
    REAL_CONST(141223.208710/8.0),
    REAL_CONST(141249.056606/8.0),
    REAL_CONST(141274.905684/8.0),
    REAL_CONST(141300.755945/8.0),
    REAL_CONST(141326.607388/8.0),
    REAL_CONST(141352.460013/8.0),
    REAL_CONST(141378.313820/8.0),
    REAL_CONST(141404.168810/8.0),
    REAL_CONST(141430.024981/8.0),
    REAL_CONST(141455.882334/8.0),
    REAL_CONST(141481.740869/8.0),
    REAL_CONST(141507.600585/8.0),
    REAL_CONST(141533.461483/8.0),
    REAL_CONST(141559.323562/8.0),
    REAL_CONST(141585.186823/8.0),
    REAL_CONST(141611.051264/8.0),
    REAL_CONST(141636.916887/8.0),
    REAL_CONST(141662.783691/8.0),
    REAL_CONST(141688.651675/8.0),
    REAL_CONST(141714.520840/8.0),
    REAL_CONST(141740.391186/8.0),
    REAL_CONST(141766.262713/8.0),
    REAL_CONST(141792.135419/8.0),
    REAL_CONST(141818.009306/8.0),
    REAL_CONST(141843.884374/8.0),
    REAL_CONST(141869.760621/8.0),
    REAL_CONST(141895.638048/8.0),
    REAL_CONST(141921.516655/8.0),
    REAL_CONST(141947.396442/8.0),
    REAL_CONST(141973.277409/8.0),
    REAL_CONST(141999.159555/8.0),
    REAL_CONST(142025.042881/8.0),
    REAL_CONST(142050.927385/8.0),
    REAL_CONST(142076.813070/8.0),
    REAL_CONST(142102.699933/8.0),
    REAL_CONST(142128.587975/8.0),
    REAL_CONST(142154.477196/8.0),
    REAL_CONST(142180.367596/8.0),
    REAL_CONST(142206.259175/8.0),
    REAL_CONST(142232.151932/8.0),
    REAL_CONST(142258.045867/8.0),
    REAL_CONST(142283.940981/8.0),
    REAL_CONST(142309.837274/8.0),
    REAL_CONST(142335.734744/8.0),
    REAL_CONST(142361.633393/8.0),
    REAL_CONST(142387.533219/8.0),
    REAL_CONST(142413.434223/8.0),
    REAL_CONST(142439.336405/8.0),
    REAL_CONST(142465.239765/8.0),
    REAL_CONST(142491.144302/8.0),
    REAL_CONST(142517.050016/8.0),
    REAL_CONST(142542.956908/8.0),
    REAL_CONST(142568.864977/8.0),
    REAL_CONST(142594.774223/8.0),
    REAL_CONST(142620.684646/8.0),
    REAL_CONST(142646.596246/8.0),
    REAL_CONST(142672.509022/8.0),
    REAL_CONST(142698.422975/8.0),
    REAL_CONST(142724.338105/8.0),
    REAL_CONST(142750.254411/8.0),
    REAL_CONST(142776.171894/8.0),
    REAL_CONST(142802.090553/8.0),
    REAL_CONST(142828.010388/8.0),
    REAL_CONST(142853.931399/8.0),
    REAL_CONST(142879.853585/8.0),
    REAL_CONST(142905.776948/8.0),
    REAL_CONST(142931.701486/8.0),
    REAL_CONST(142957.627200/8.0),
    REAL_CONST(142983.554090/8.0),
    REAL_CONST(143009.482154/8.0),
    REAL_CONST(143035.411394/8.0),
    REAL_CONST(143061.341809/8.0),
    REAL_CONST(143087.273400/8.0),
    REAL_CONST(143113.206165/8.0),
    REAL_CONST(143139.140105/8.0),
    REAL_CONST(143165.075219/8.0),
    REAL_CONST(143191.011509/8.0),
    REAL_CONST(143216.948973/8.0),
    REAL_CONST(143242.887611/8.0),
    REAL_CONST(143268.827423/8.0),
    REAL_CONST(143294.768410/8.0),
    REAL_CONST(143320.710571/8.0),
    REAL_CONST(143346.653906/8.0),
    REAL_CONST(143372.598415/8.0),
    REAL_CONST(143398.544097/8.0),
    REAL_CONST(143424.490953/8.0),
    REAL_CONST(143450.438983/8.0),
    REAL_CONST(143476.388186/8.0),
    REAL_CONST(143502.338563/8.0),
    REAL_CONST(143528.290112/8.0),
    REAL_CONST(143554.242835/8.0),
    REAL_CONST(143580.196731/8.0),
    REAL_CONST(143606.151800/8.0),
    REAL_CONST(143632.108042/8.0),
    REAL_CONST(143658.065456/8.0),
    REAL_CONST(143684.024043/8.0),
    REAL_CONST(143709.983803/8.0),
    REAL_CONST(143735.944735/8.0),
    REAL_CONST(143761.906839/8.0),
    REAL_CONST(143787.870115/8.0),
    REAL_CONST(143813.834564/8.0),
    REAL_CONST(143839.800184/8.0),
    REAL_CONST(143865.766976/8.0),
    REAL_CONST(143891.734940/8.0),
    REAL_CONST(143917.704076/8.0),
    REAL_CONST(143943.674383/8.0),
    REAL_CONST(143969.645862/8.0),
    REAL_CONST(143995.618512/8.0),
    REAL_CONST(144021.592333/8.0),
    REAL_CONST(144047.567326/8.0),
    REAL_CONST(144073.543489/8.0),
    REAL_CONST(144099.520823/8.0),
    REAL_CONST(144125.499329/8.0),
    REAL_CONST(144151.479004/8.0),
    REAL_CONST(144177.459851/8.0),
    REAL_CONST(144203.441868/8.0),
    REAL_CONST(144229.425055/8.0),
    REAL_CONST(144255.409413/8.0),
    REAL_CONST(144281.394940/8.0),
    REAL_CONST(144307.381638/8.0),
    REAL_CONST(144333.369506/8.0),
    REAL_CONST(144359.358544/8.0),
    REAL_CONST(144385.348751/8.0),
    REAL_CONST(144411.340128/8.0),
    REAL_CONST(144437.332675/8.0),
    REAL_CONST(144463.326391/8.0),
    REAL_CONST(144489.321276/8.0),
    REAL_CONST(144515.317331/8.0),
    REAL_CONST(144541.314555/8.0),
    REAL_CONST(144567.312947/8.0),
    REAL_CONST(144593.312509/8.0),
    REAL_CONST(144619.313240/8.0),
    REAL_CONST(144645.315139/8.0),
    REAL_CONST(144671.318207/8.0),
    REAL_CONST(144697.322443/8.0),
    REAL_CONST(144723.327848/8.0),
    REAL_CONST(144749.334421/8.0),
    REAL_CONST(144775.342162/8.0),
    REAL_CONST(144801.351071/8.0),
    REAL_CONST(144827.361148/8.0),
    REAL_CONST(144853.372393/8.0),
    REAL_CONST(144879.384806/8.0),
    REAL_CONST(144905.398386/8.0),
    REAL_CONST(144931.413134/8.0),
    REAL_CONST(144957.429050/8.0),
    REAL_CONST(144983.446133/8.0),
    REAL_CONST(145009.464383/8.0),
    REAL_CONST(145035.483800/8.0),
    REAL_CONST(145061.504384/8.0),
    REAL_CONST(145087.526135/8.0),
    REAL_CONST(145113.549053/8.0),
    REAL_CONST(145139.573138/8.0),
    REAL_CONST(145165.598389/8.0),
    REAL_CONST(145191.624807/8.0),
    REAL_CONST(145217.652391/8.0),
    REAL_CONST(145243.681141/8.0),
    REAL_CONST(145269.711058/8.0),
    REAL_CONST(145295.742140/8.0),
    REAL_CONST(145321.774389/8.0),
    REAL_CONST(145347.807804/8.0),
    REAL_CONST(145373.842384/8.0),
    REAL_CONST(145399.878130/8.0),
    REAL_CONST(145425.915041/8.0),
    REAL_CONST(145451.953119/8.0),
    REAL_CONST(145477.992361/8.0),
    REAL_CONST(145504.032768/8.0),
    REAL_CONST(145530.074341/8.0),
    REAL_CONST(145556.117079/8.0),
    REAL_CONST(145582.160982/8.0),
    REAL_CONST(145608.206049/8.0),
    REAL_CONST(145634.252282/8.0),
    REAL_CONST(145660.299679/8.0),
    REAL_CONST(145686.348240/8.0),
    REAL_CONST(145712.397966/8.0),
    REAL_CONST(145738.448856/8.0),
    REAL_CONST(145764.500910/8.0),
    REAL_CONST(145790.554129/8.0),
    REAL_CONST(145816.608511/8.0),
    REAL_CONST(145842.664058/8.0),
    REAL_CONST(145868.720768/8.0),
    REAL_CONST(145894.778642/8.0),
    REAL_CONST(145920.837679/8.0),
    REAL_CONST(145946.897880/8.0),
    REAL_CONST(145972.959244/8.0),
    REAL_CONST(145999.021772/8.0),
    REAL_CONST(146025.085463/8.0),
    REAL_CONST(146051.150317/8.0),
    REAL_CONST(146077.216333/8.0),
    REAL_CONST(146103.283513/8.0),
    REAL_CONST(146129.351855/8.0),
    REAL_CONST(146155.421360/8.0),
    REAL_CONST(146181.492028/8.0),
    REAL_CONST(146207.563858/8.0),
    REAL_CONST(146233.636850/8.0),
    REAL_CONST(146259.711005/8.0),
    REAL_CONST(146285.786321/8.0),
    REAL_CONST(146311.862800/8.0),
    REAL_CONST(146337.940441/8.0),
    REAL_CONST(146364.019243/8.0),
    REAL_CONST(146390.099208/8.0),
    REAL_CONST(146416.180333/8.0),
    REAL_CONST(146442.262621/8.0),
    REAL_CONST(146468.346069/8.0),
    REAL_CONST(146494.430679/8.0),
    REAL_CONST(146520.516451/8.0),
    REAL_CONST(146546.603383/8.0),
    REAL_CONST(146572.691476/8.0),
    REAL_CONST(146598.780731/8.0),
    REAL_CONST(146624.871146/8.0),
    REAL_CONST(146650.962721/8.0),
    REAL_CONST(146677.055457/8.0),
    REAL_CONST(146703.149354/8.0),
    REAL_CONST(146729.244411/8.0),
    REAL_CONST(146755.340629/8.0),
    REAL_CONST(146781.438006/8.0),
    REAL_CONST(146807.536544/8.0),
    REAL_CONST(146833.636241/8.0),
    REAL_CONST(146859.737099/8.0),
    REAL_CONST(146885.839116/8.0),
    REAL_CONST(146911.942293/8.0),
    REAL_CONST(146938.046629/8.0),
    REAL_CONST(146964.152125/8.0),
    REAL_CONST(146990.258780/8.0),
    REAL_CONST(147016.366595/8.0),
    REAL_CONST(147042.475568/8.0),
    REAL_CONST(147068.585701/8.0),
    REAL_CONST(147094.696992/8.0),
    REAL_CONST(147120.809443/8.0),
    REAL_CONST(147146.923052/8.0),
    REAL_CONST(147173.037819/8.0),
    REAL_CONST(147199.153746/8.0),
    REAL_CONST(147225.270830/8.0),
    REAL_CONST(147251.389073/8.0),
    REAL_CONST(147277.508474/8.0),
    REAL_CONST(147303.629034/8.0),
    REAL_CONST(147329.750751/8.0),
    REAL_CONST(147355.873626/8.0),
    REAL_CONST(147381.997659/8.0),
    REAL_CONST(147408.122850/8.0),
    REAL_CONST(147434.249198/8.0),
    REAL_CONST(147460.376704/8.0),
    REAL_CONST(147486.505367/8.0),
    REAL_CONST(147512.635187/8.0),
    REAL_CONST(147538.766165/8.0),
    REAL_CONST(147564.898300/8.0),
    REAL_CONST(147591.031591/8.0),
    REAL_CONST(147617.166040/8.0),
    REAL_CONST(147643.301645/8.0),
    REAL_CONST(147669.438407/8.0),
    REAL_CONST(147695.576326/8.0),
    REAL_CONST(147721.715401/8.0),
    REAL_CONST(147747.855632/8.0),
    REAL_CONST(147773.997020/8.0),
    REAL_CONST(147800.139564/8.0),
    REAL_CONST(147826.283264/8.0),
    REAL_CONST(147852.428119/8.0),
    REAL_CONST(147878.574131/8.0),
    REAL_CONST(147904.721299/8.0),
    REAL_CONST(147930.869622/8.0),
    REAL_CONST(147957.019100/8.0),
    REAL_CONST(147983.169734/8.0),
    REAL_CONST(148009.321524/8.0),
    REAL_CONST(148035.474469/8.0),
    REAL_CONST(148061.628568/8.0),
    REAL_CONST(148087.783823/8.0),
    REAL_CONST(148113.940233/8.0),
    REAL_CONST(148140.097798/8.0),
    REAL_CONST(148166.256517/8.0),
    REAL_CONST(148192.416391/8.0),
    REAL_CONST(148218.577420/8.0),
    REAL_CONST(148244.739603/8.0),
    REAL_CONST(148270.902940/8.0),
    REAL_CONST(148297.067431/8.0),
    REAL_CONST(148323.233077/8.0),
    REAL_CONST(148349.399877/8.0),
    REAL_CONST(148375.567830/8.0),
    REAL_CONST(148401.736938/8.0),
    REAL_CONST(148427.907199/8.0),
    REAL_CONST(148454.078613/8.0),
    REAL_CONST(148480.251182/8.0),
    REAL_CONST(148506.424903/8.0),
    REAL_CONST(148532.599778/8.0),
    REAL_CONST(148558.775806/8.0),
    REAL_CONST(148584.952987/8.0),
    REAL_CONST(148611.131322/8.0),
    REAL_CONST(148637.310809/8.0),
    REAL_CONST(148663.491449/8.0),
    REAL_CONST(148689.673241/8.0),
    REAL_CONST(148715.856187/8.0),
    REAL_CONST(148742.040284/8.0),
    REAL_CONST(148768.225534/8.0),
    REAL_CONST(148794.411937/8.0),
    REAL_CONST(148820.599491/8.0),
    REAL_CONST(148846.788198/8.0),
    REAL_CONST(148872.978057/8.0),
    REAL_CONST(148899.169067/8.0),
    REAL_CONST(148925.361230/8.0),
    REAL_CONST(148951.554544/8.0),
    REAL_CONST(148977.749009/8.0),
    REAL_CONST(149003.944626/8.0),
    REAL_CONST(149030.141395/8.0),
    REAL_CONST(149056.339315/8.0),
    REAL_CONST(149082.538386/8.0),
    REAL_CONST(149108.738608/8.0),
    REAL_CONST(149134.939981/8.0),
    REAL_CONST(149161.142504/8.0),
    REAL_CONST(149187.346179/8.0),
    REAL_CONST(149213.551004/8.0),
    REAL_CONST(149239.756980/8.0),
    REAL_CONST(149265.964106/8.0),
    REAL_CONST(149292.172383/8.0),
    REAL_CONST(149318.381810/8.0),
    REAL_CONST(149344.592387/8.0),
    REAL_CONST(149370.804115/8.0),
    REAL_CONST(149397.016992/8.0),
    REAL_CONST(149423.231019/8.0),
    REAL_CONST(149449.446196/8.0),
    REAL_CONST(149475.662522/8.0),
    REAL_CONST(149501.879998/8.0),
    REAL_CONST(149528.098623/8.0),
    REAL_CONST(149554.318398/8.0),
    REAL_CONST(149580.539322/8.0),
    REAL_CONST(149606.761396/8.0),
    REAL_CONST(149632.984618/8.0),
    REAL_CONST(149659.208989/8.0),
    REAL_CONST(149685.434509/8.0),
    REAL_CONST(149711.661178/8.0),
    REAL_CONST(149737.888996/8.0),
    REAL_CONST(149764.117962/8.0),
    REAL_CONST(149790.348076/8.0),
    REAL_CONST(149816.579339/8.0),
    REAL_CONST(149842.811751/8.0),
    REAL_CONST(149869.045310/8.0),
    REAL_CONST(149895.280017/8.0),
    REAL_CONST(149921.515873/8.0),
    REAL_CONST(149947.752876/8.0),
    REAL_CONST(149973.991027/8.0),
    REAL_CONST(150000.230325/8.0),
    REAL_CONST(150026.470771/8.0),
    REAL_CONST(150052.712365/8.0),
    REAL_CONST(150078.955106/8.0),
    REAL_CONST(150105.198994/8.0),
    REAL_CONST(150131.444029/8.0),
    REAL_CONST(150157.690212/8.0),
    REAL_CONST(150183.937541/8.0),
    REAL_CONST(150210.186017/8.0),
    REAL_CONST(150236.435640/8.0),
    REAL_CONST(150262.686410/8.0),
    REAL_CONST(150288.938326/8.0),
    REAL_CONST(150315.191388/8.0),
    REAL_CONST(150341.445597/8.0),
    REAL_CONST(150367.700952/8.0),
    REAL_CONST(150393.957453/8.0),
    REAL_CONST(150420.215101/8.0),
    REAL_CONST(150446.473894/8.0),
    REAL_CONST(150472.733833/8.0),
    REAL_CONST(150498.994918/8.0),
    REAL_CONST(150525.257149/8.0),
    REAL_CONST(150551.520525/8.0),
    REAL_CONST(150577.785046/8.0),
    REAL_CONST(150604.050713/8.0),
    REAL_CONST(150630.317525/8.0),
    REAL_CONST(150656.585482/8.0),
    REAL_CONST(150682.854585/8.0),
    REAL_CONST(150709.124832/8.0),
    REAL_CONST(150735.396224/8.0),
    REAL_CONST(150761.668761/8.0),
    REAL_CONST(150787.942442/8.0),
    REAL_CONST(150814.217268/8.0),
    REAL_CONST(150840.493239/8.0),
    REAL_CONST(150866.770354/8.0),
    REAL_CONST(150893.048613/8.0),
    REAL_CONST(150919.328016/8.0),
    REAL_CONST(150945.608563/8.0),
    REAL_CONST(150971.890255/8.0),
    REAL_CONST(150998.173090/8.0),
    REAL_CONST(151024.457068/8.0),
    REAL_CONST(151050.742191/8.0),
    REAL_CONST(151077.028457/8.0),
    REAL_CONST(151103.315866/8.0),
    REAL_CONST(151129.604419/8.0),
    REAL_CONST(151155.894115/8.0),
    REAL_CONST(151182.184955/8.0),
    REAL_CONST(151208.476937/8.0),
    REAL_CONST(151234.770062/8.0),
    REAL_CONST(151261.064330/8.0),
    REAL_CONST(151287.359741/8.0),
    REAL_CONST(151313.656295/8.0),
    REAL_CONST(151339.953991/8.0),
    REAL_CONST(151366.252829/8.0),
    REAL_CONST(151392.552810/8.0),
    REAL_CONST(151418.853934/8.0),
    REAL_CONST(151445.156199/8.0),
    REAL_CONST(151471.459606/8.0),
    REAL_CONST(151497.764156/8.0),
    REAL_CONST(151524.069847/8.0),
    REAL_CONST(151550.376680/8.0),
    REAL_CONST(151576.684655/8.0),
    REAL_CONST(151602.993771/8.0),
    REAL_CONST(151629.304028/8.0),
    REAL_CONST(151655.615427/8.0),
    REAL_CONST(151681.927968/8.0),
    REAL_CONST(151708.241649/8.0),
    REAL_CONST(151734.556472/8.0),
    REAL_CONST(151760.872435/8.0),
    REAL_CONST(151787.189540/8.0),
    REAL_CONST(151813.507785/8.0),
    REAL_CONST(151839.827171/8.0),
    REAL_CONST(151866.147697/8.0),
    REAL_CONST(151892.469364/8.0),
    REAL_CONST(151918.792172/8.0),
    REAL_CONST(151945.116119/8.0),
    REAL_CONST(151971.441207/8.0),
    REAL_CONST(151997.767435/8.0),
    REAL_CONST(152024.094803/8.0),
    REAL_CONST(152050.423310/8.0),
    REAL_CONST(152076.752958/8.0),
    REAL_CONST(152103.083745/8.0),
    REAL_CONST(152129.415672/8.0),
    REAL_CONST(152155.748738/8.0),
    REAL_CONST(152182.082944/8.0),
    REAL_CONST(152208.418289/8.0),
    REAL_CONST(152234.754773/8.0),
    REAL_CONST(152261.092396/8.0),
    REAL_CONST(152287.431158/8.0),
    REAL_CONST(152313.771060/8.0),
    REAL_CONST(152340.112100/8.0),
    REAL_CONST(152366.454278/8.0),
    REAL_CONST(152392.797595/8.0),
    REAL_CONST(152419.142051/8.0),
    REAL_CONST(152445.487645/8.0),
    REAL_CONST(152471.834378/8.0),
    REAL_CONST(152498.182249/8.0),
    REAL_CONST(152524.531257/8.0),
    REAL_CONST(152550.881404/8.0),
    REAL_CONST(152577.232689/8.0),
    REAL_CONST(152603.585111/8.0),
    REAL_CONST(152629.938672/8.0),
    REAL_CONST(152656.293370/8.0),
    REAL_CONST(152682.649205/8.0),
    REAL_CONST(152709.006178/8.0),
    REAL_CONST(152735.364288/8.0),
    REAL_CONST(152761.723535/8.0),
    REAL_CONST(152788.083920/8.0),
    REAL_CONST(152814.445442/8.0),
    REAL_CONST(152840.808100/8.0),
    REAL_CONST(152867.171895/8.0),
    REAL_CONST(152893.536827/8.0),
    REAL_CONST(152919.902896/8.0),
    REAL_CONST(152946.270101/8.0),
    REAL_CONST(152972.638443/8.0),
    REAL_CONST(152999.007921/8.0),
    REAL_CONST(153025.378535/8.0),
    REAL_CONST(153051.750286/8.0),
    REAL_CONST(153078.123172/8.0),
    REAL_CONST(153104.497195/8.0),
    REAL_CONST(153130.872353/8.0),
    REAL_CONST(153157.248647/8.0),
    REAL_CONST(153183.626077/8.0),
    REAL_CONST(153210.004642/8.0),
    REAL_CONST(153236.384343/8.0),
    REAL_CONST(153262.765179/8.0),
    REAL_CONST(153289.147150/8.0),
    REAL_CONST(153315.530257/8.0),
    REAL_CONST(153341.914499/8.0),
    REAL_CONST(153368.299875/8.0),
    REAL_CONST(153394.686387/8.0),
    REAL_CONST(153421.074033/8.0),
    REAL_CONST(153447.462814/8.0),
    REAL_CONST(153473.852729/8.0),
    REAL_CONST(153500.243779/8.0),
    REAL_CONST(153526.635964/8.0),
    REAL_CONST(153553.029283/8.0),
    REAL_CONST(153579.423735/8.0),
    REAL_CONST(153605.819322/8.0),
    REAL_CONST(153632.216043/8.0),
    REAL_CONST(153658.613898/8.0),
    REAL_CONST(153685.012887/8.0),
    REAL_CONST(153711.413010/8.0),
    REAL_CONST(153737.814266/8.0),
    REAL_CONST(153764.216655/8.0),
    REAL_CONST(153790.620178/8.0),
    REAL_CONST(153817.024834/8.0),
    REAL_CONST(153843.430624/8.0),
    REAL_CONST(153869.837547/8.0),
    REAL_CONST(153896.245602/8.0),
    REAL_CONST(153922.654791/8.0),
    REAL_CONST(153949.065112/8.0),
    REAL_CONST(153975.476566/8.0),
    REAL_CONST(154001.889153/8.0),
    REAL_CONST(154028.302873/8.0),
    REAL_CONST(154054.717724/8.0),
    REAL_CONST(154081.133709/8.0),
    REAL_CONST(154107.550825/8.0),
    REAL_CONST(154133.969074/8.0),
    REAL_CONST(154160.388454/8.0),
    REAL_CONST(154186.808967/8.0),
    REAL_CONST(154213.230611/8.0),
    REAL_CONST(154239.653387/8.0),
    REAL_CONST(154266.077295/8.0),
    REAL_CONST(154292.502335/8.0),
    REAL_CONST(154318.928506/8.0),
    REAL_CONST(154345.355808/8.0),
    REAL_CONST(154371.784241/8.0),
    REAL_CONST(154398.213806/8.0),
    REAL_CONST(154424.644502/8.0),
    REAL_CONST(154451.076329/8.0),
    REAL_CONST(154477.509287/8.0),
    REAL_CONST(154503.943375/8.0),
    REAL_CONST(154530.378594/8.0),
    REAL_CONST(154556.814944/8.0),
    REAL_CONST(154583.252425/8.0),
    REAL_CONST(154609.691035/8.0),
    REAL_CONST(154636.130776/8.0),
    REAL_CONST(154662.571648/8.0),
    REAL_CONST(154689.013649/8.0),
    REAL_CONST(154715.456781/8.0),
    REAL_CONST(154741.901042/8.0),
    REAL_CONST(154768.346433/8.0),
    REAL_CONST(154794.792954/8.0),
    REAL_CONST(154821.240605/8.0),
    REAL_CONST(154847.689385/8.0),
    REAL_CONST(154874.139294/8.0),
    REAL_CONST(154900.590333/8.0),
    REAL_CONST(154927.042501/8.0),
    REAL_CONST(154953.495799/8.0),
    REAL_CONST(154979.950225/8.0),
    REAL_CONST(155006.405780/8.0),
    REAL_CONST(155032.862464/8.0),
    REAL_CONST(155059.320277/8.0),
    REAL_CONST(155085.779219/8.0),
    REAL_CONST(155112.239289/8.0),
    REAL_CONST(155138.700488/8.0),
    REAL_CONST(155165.162815/8.0),
    REAL_CONST(155191.626270/8.0),
    REAL_CONST(155218.090854/8.0),
    REAL_CONST(155244.556566/8.0),
    REAL_CONST(155271.023405/8.0),
    REAL_CONST(155297.491373/8.0),
    REAL_CONST(155323.960468/8.0),
    REAL_CONST(155350.430691/8.0),
    REAL_CONST(155376.902042/8.0),
    REAL_CONST(155403.374520/8.0),
    REAL_CONST(155429.848126/8.0),
    REAL_CONST(155456.322859/8.0),
    REAL_CONST(155482.798719/8.0),
    REAL_CONST(155509.275706/8.0),
    REAL_CONST(155535.753821/8.0),
    REAL_CONST(155562.233062/8.0),
    REAL_CONST(155588.713430/8.0),
    REAL_CONST(155615.194925/8.0),
    REAL_CONST(155641.677547/8.0),
    REAL_CONST(155668.161295/8.0),
    REAL_CONST(155694.646170/8.0),
    REAL_CONST(155721.132171/8.0),
    REAL_CONST(155747.619298/8.0),
    REAL_CONST(155774.107551/8.0),
    REAL_CONST(155800.596931/8.0),
    REAL_CONST(155827.087436/8.0),
    REAL_CONST(155853.579068/8.0),
    REAL_CONST(155880.071825/8.0),
    REAL_CONST(155906.565708/8.0),
    REAL_CONST(155933.060716/8.0),
    REAL_CONST(155959.556850/8.0),
    REAL_CONST(155986.054110/8.0),
    REAL_CONST(156012.552494/8.0),
    REAL_CONST(156039.052004/8.0),
    REAL_CONST(156065.552639/8.0),
    REAL_CONST(156092.054399/8.0),
    REAL_CONST(156118.557284/8.0),
    REAL_CONST(156145.061294/8.0),
    REAL_CONST(156171.566429/8.0),
    REAL_CONST(156198.072688/8.0),
    REAL_CONST(156224.580072/8.0),
    REAL_CONST(156251.088580/8.0),
    REAL_CONST(156277.598213/8.0),
    REAL_CONST(156304.108970/8.0),
    REAL_CONST(156330.620851/8.0),
    REAL_CONST(156357.133856/8.0),
    REAL_CONST(156383.647985/8.0),
    REAL_CONST(156410.163238/8.0),
    REAL_CONST(156436.679615/8.0),
    REAL_CONST(156463.197115/8.0),
    REAL_CONST(156489.715740/8.0),
    REAL_CONST(156516.235487/8.0),
    REAL_CONST(156542.756358/8.0),
    REAL_CONST(156569.278352/8.0),
    REAL_CONST(156595.801470/8.0),
    REAL_CONST(156622.325711/8.0),
    REAL_CONST(156648.851074/8.0),
    REAL_CONST(156675.377561/8.0),
    REAL_CONST(156701.905170/8.0),
    REAL_CONST(156728.433903/8.0),
    REAL_CONST(156754.963757/8.0),
    REAL_CONST(156781.494735/8.0),
    REAL_CONST(156808.026835/8.0),
    REAL_CONST(156834.560057/8.0),
    REAL_CONST(156861.094401/8.0),
    REAL_CONST(156887.629868/8.0),
    REAL_CONST(156914.166457/8.0),
    REAL_CONST(156940.704168/8.0),
    REAL_CONST(156967.243000/8.0),
    REAL_CONST(156993.782955/8.0),
    REAL_CONST(157020.324031/8.0),
    REAL_CONST(157046.866228/8.0),
    REAL_CONST(157073.409548/8.0),
    REAL_CONST(157099.953988/8.0),
    REAL_CONST(157126.499550/8.0),
    REAL_CONST(157153.046233/8.0),
    REAL_CONST(157179.594038/8.0),
    REAL_CONST(157206.142963/8.0),
    REAL_CONST(157232.693009/8.0),
    REAL_CONST(157259.244176/8.0),
    REAL_CONST(157285.796464/8.0),
    REAL_CONST(157312.349873/8.0),
    REAL_CONST(157338.904402/8.0),
    REAL_CONST(157365.460051/8.0),
    REAL_CONST(157392.016821/8.0),
    REAL_CONST(157418.574712/8.0),
    REAL_CONST(157445.133722/8.0),
    REAL_CONST(157471.693853/8.0),
    REAL_CONST(157498.255103/8.0),
    REAL_CONST(157524.817473/8.0),
    REAL_CONST(157551.380964/8.0),
    REAL_CONST(157577.945574/8.0),
    REAL_CONST(157604.511303/8.0),
    REAL_CONST(157631.078152/8.0),
    REAL_CONST(157657.646121/8.0),
    REAL_CONST(157684.215208/8.0),
    REAL_CONST(157710.785415/8.0),
    REAL_CONST(157737.356742/8.0),
    REAL_CONST(157763.929187/8.0),
    REAL_CONST(157790.502751/8.0),
    REAL_CONST(157817.077434/8.0),
    REAL_CONST(157843.653236/8.0),
    REAL_CONST(157870.230157/8.0),
    REAL_CONST(157896.808196/8.0),
    REAL_CONST(157923.387353/8.0),
    REAL_CONST(157949.967629/8.0),
    REAL_CONST(157976.549023/8.0),
    REAL_CONST(158003.131536/8.0),
    REAL_CONST(158029.715167/8.0),
    REAL_CONST(158056.299915/8.0),
    REAL_CONST(158082.885782/8.0),
    REAL_CONST(158109.472766/8.0),
    REAL_CONST(158136.060868/8.0),
    REAL_CONST(158162.650088/8.0),
    REAL_CONST(158189.240425/8.0),
    REAL_CONST(158215.831880/8.0),
    REAL_CONST(158242.424452/8.0),
    REAL_CONST(158269.018141/8.0),
    REAL_CONST(158295.612948/8.0),
    REAL_CONST(158322.208871/8.0),
    REAL_CONST(158348.805912/8.0),
    REAL_CONST(158375.404070/8.0),
    REAL_CONST(158402.003344/8.0),
    REAL_CONST(158428.603735/8.0),
    REAL_CONST(158455.205242/8.0),
    REAL_CONST(158481.807866/8.0),
    REAL_CONST(158508.411607/8.0),
    REAL_CONST(158535.016464/8.0),
    REAL_CONST(158561.622437/8.0),
    REAL_CONST(158588.229526/8.0),
    REAL_CONST(158614.837731/8.0),
    REAL_CONST(158641.447053/8.0),
    REAL_CONST(158668.057490/8.0),
    REAL_CONST(158694.669042/8.0),
    REAL_CONST(158721.281711/8.0),
    REAL_CONST(158747.895495/8.0),
    REAL_CONST(158774.510395/8.0),
    REAL_CONST(158801.126410/8.0),
    REAL_CONST(158827.743540/8.0),
    REAL_CONST(158854.361785/8.0),
    REAL_CONST(158880.981146/8.0),
    REAL_CONST(158907.601621/8.0),
    REAL_CONST(158934.223212/8.0),
    REAL_CONST(158960.845917/8.0),
    REAL_CONST(158987.469737/8.0),
    REAL_CONST(159014.094672/8.0),
    REAL_CONST(159040.720721/8.0),
    REAL_CONST(159067.347885/8.0),
    REAL_CONST(159093.976163/8.0),
    REAL_CONST(159120.605556/8.0),
    REAL_CONST(159147.236062/8.0),
    REAL_CONST(159173.867683/8.0),
    REAL_CONST(159200.500417/8.0),
    REAL_CONST(159227.134266/8.0),
    REAL_CONST(159253.769228/8.0),
    REAL_CONST(159280.405304/8.0),
    REAL_CONST(159307.042494/8.0),
    REAL_CONST(159333.680797/8.0),
    REAL_CONST(159360.320214/8.0),
    REAL_CONST(159386.960744/8.0),
    REAL_CONST(159413.602387/8.0),
    REAL_CONST(159440.245143/8.0),
    REAL_CONST(159466.889012/8.0),
    REAL_CONST(159493.533995/8.0),
    REAL_CONST(159520.180090/8.0),
    REAL_CONST(159546.827298/8.0),
    REAL_CONST(159573.475619/8.0),
    REAL_CONST(159600.125052/8.0),
    REAL_CONST(159626.775598/8.0),
    REAL_CONST(159653.427256/8.0),
    REAL_CONST(159680.080027/8.0),
    REAL_CONST(159706.733909/8.0),
    REAL_CONST(159733.388904/8.0),
    REAL_CONST(159760.045011/8.0),
    REAL_CONST(159786.702230/8.0),
    REAL_CONST(159813.360561/8.0),
    REAL_CONST(159840.020003/8.0),
    REAL_CONST(159866.680557/8.0),
    REAL_CONST(159893.342223/8.0),
    REAL_CONST(159920.005000/8.0),
    REAL_CONST(159946.668889/8.0),
    REAL_CONST(159973.333889/8.0),
    REAL_CONST(160000.000000/8.0),
    REAL_CONST(160026.667222/8.0),
    REAL_CONST(160053.335555/8.0),
    REAL_CONST(160080.005000/8.0),
    REAL_CONST(160106.675555/8.0),
    REAL_CONST(160133.347220/8.0),
    REAL_CONST(160160.019997/8.0),
    REAL_CONST(160186.693884/8.0),
    REAL_CONST(160213.368881/8.0),
    REAL_CONST(160240.044989/8.0),
    REAL_CONST(160266.722207/8.0),
    REAL_CONST(160293.400535/8.0),
    REAL_CONST(160320.079973/8.0),
    REAL_CONST(160346.760522/8.0),
    REAL_CONST(160373.442180/8.0),
    REAL_CONST(160400.124948/8.0),
    REAL_CONST(160426.808826/8.0),
    REAL_CONST(160453.493813/8.0),
    REAL_CONST(160480.179910/8.0),
    REAL_CONST(160506.867116/8.0),
    REAL_CONST(160533.555432/8.0),
    REAL_CONST(160560.244857/8.0),
    REAL_CONST(160586.935391/8.0),
    REAL_CONST(160613.627035/8.0),
    REAL_CONST(160640.319787/8.0),
    REAL_CONST(160667.013648/8.0),
    REAL_CONST(160693.708618/8.0),
    REAL_CONST(160720.404697/8.0),
    REAL_CONST(160747.101884/8.0),
    REAL_CONST(160773.800180/8.0),
    REAL_CONST(160800.499584/8.0),
    REAL_CONST(160827.200097/8.0),
    REAL_CONST(160853.901717/8.0),
    REAL_CONST(160880.604446/8.0),
    REAL_CONST(160907.308283/8.0),
    REAL_CONST(160934.013228/8.0),
    REAL_CONST(160960.719281/8.0),
    REAL_CONST(160987.426442/8.0),
    REAL_CONST(161014.134710/8.0),
    REAL_CONST(161040.844086/8.0),
    REAL_CONST(161067.554570/8.0),
    REAL_CONST(161094.266161/8.0),
    REAL_CONST(161120.978859/8.0),
    REAL_CONST(161147.692665/8.0),
    REAL_CONST(161174.407577/8.0),
    REAL_CONST(161201.123597/8.0),
    REAL_CONST(161227.840724/8.0),
    REAL_CONST(161254.558957/8.0),
    REAL_CONST(161281.278298/8.0),
    REAL_CONST(161307.998745/8.0),
    REAL_CONST(161334.720298/8.0),
    REAL_CONST(161361.442958/8.0),
    REAL_CONST(161388.166725/8.0),
    REAL_CONST(161414.891598/8.0),
    REAL_CONST(161441.617577/8.0),
    REAL_CONST(161468.344662/8.0),
    REAL_CONST(161495.072853/8.0),
    REAL_CONST(161521.802151/8.0),
    REAL_CONST(161548.532554/8.0),
    REAL_CONST(161575.264062/8.0),
    REAL_CONST(161601.996677/8.0),
    REAL_CONST(161628.730397/8.0),
    REAL_CONST(161655.465223/8.0),
    REAL_CONST(161682.201154/8.0),
    REAL_CONST(161708.938190/8.0),
    REAL_CONST(161735.676332/8.0),
    REAL_CONST(161762.415579/8.0),
    REAL_CONST(161789.155930/8.0),
    REAL_CONST(161815.897387/8.0),
    REAL_CONST(161842.639949/8.0),
    REAL_CONST(161869.383615/8.0),
    REAL_CONST(161896.128386/8.0),
    REAL_CONST(161922.874261/8.0),
    REAL_CONST(161949.621242/8.0),
    REAL_CONST(161976.369326/8.0),
    REAL_CONST(162003.118515/8.0),
    REAL_CONST(162029.868808/8.0),
    REAL_CONST(162056.620205/8.0),
    REAL_CONST(162083.372706/8.0),
    REAL_CONST(162110.126311/8.0),
    REAL_CONST(162136.881020/8.0),
    REAL_CONST(162163.636833/8.0),
    REAL_CONST(162190.393750/8.0),
    REAL_CONST(162217.151770/8.0),
    REAL_CONST(162243.910893/8.0),
    REAL_CONST(162270.671120/8.0),
    REAL_CONST(162297.432450/8.0),
    REAL_CONST(162324.194884/8.0),
    REAL_CONST(162350.958420/8.0),
    REAL_CONST(162377.723060/8.0),
    REAL_CONST(162404.488802/8.0),
    REAL_CONST(162431.255648/8.0),
    REAL_CONST(162458.023596/8.0),
    REAL_CONST(162484.792647/8.0),
    REAL_CONST(162511.562800/8.0),
    REAL_CONST(162538.334056/8.0),
    REAL_CONST(162565.106414/8.0),
    REAL_CONST(162591.879875/8.0),
    REAL_CONST(162618.654438/8.0),
    REAL_CONST(162645.430103/8.0),
    REAL_CONST(162672.206870/8.0),
    REAL_CONST(162698.984739/8.0),
    REAL_CONST(162725.763710/8.0),
    REAL_CONST(162752.543782/8.0),
    REAL_CONST(162779.324957/8.0),
    REAL_CONST(162806.107232/8.0),
    REAL_CONST(162832.890610/8.0),
    REAL_CONST(162859.675089/8.0),
    REAL_CONST(162886.460669/8.0),
    REAL_CONST(162913.247350/8.0),
    REAL_CONST(162940.035132/8.0),
    REAL_CONST(162966.824016/8.0),
    REAL_CONST(162993.614000/8.0),
    REAL_CONST(163020.405085/8.0),
    REAL_CONST(163047.197271/8.0),
    REAL_CONST(163073.990558/8.0),
    REAL_CONST(163100.784945/8.0),
    REAL_CONST(163127.580433/8.0),
    REAL_CONST(163154.377021/8.0),
    REAL_CONST(163181.174710/8.0),
    REAL_CONST(163207.973499/8.0),
    REAL_CONST(163234.773388/8.0),
    REAL_CONST(163261.574377/8.0),
    REAL_CONST(163288.376465/8.0),
    REAL_CONST(163315.179654/8.0),
    REAL_CONST(163341.983943/8.0),
    REAL_CONST(163368.789331/8.0),
    REAL_CONST(163395.595819/8.0),
    REAL_CONST(163422.403406/8.0),
    REAL_CONST(163449.212093/8.0),
    REAL_CONST(163476.021879/8.0),
    REAL_CONST(163502.832764/8.0),
    REAL_CONST(163529.644749/8.0),
    REAL_CONST(163556.457832/8.0),
    REAL_CONST(163583.272015/8.0),
    REAL_CONST(163610.087296/8.0),
    REAL_CONST(163636.903676/8.0),
    REAL_CONST(163663.721155/8.0),
    REAL_CONST(163690.539732/8.0),
    REAL_CONST(163717.359408/8.0),
    REAL_CONST(163744.180182/8.0),
    REAL_CONST(163771.002055/8.0),
    REAL_CONST(163797.825026/8.0),
    REAL_CONST(163824.649095/8.0),
    REAL_CONST(163851.474262/8.0),
    REAL_CONST(163878.300527/8.0),
    REAL_CONST(163905.127890/8.0),
    REAL_CONST(163931.956351/8.0),
    REAL_CONST(163958.785910/8.0),
    REAL_CONST(163985.616566/8.0),
    REAL_CONST(164012.448320/8.0),
    REAL_CONST(164039.281171/8.0),
    REAL_CONST(164066.115119/8.0),
    REAL_CONST(164092.950165/8.0),
    REAL_CONST(164119.786308/8.0),
    REAL_CONST(164146.623548/8.0),
    REAL_CONST(164173.461884/8.0),
    REAL_CONST(164200.301318/8.0),
    REAL_CONST(164227.141849/8.0),
    REAL_CONST(164253.983476/8.0),
    REAL_CONST(164280.826200/8.0),
    REAL_CONST(164307.670021/8.0),
    REAL_CONST(164334.514938/8.0),
    REAL_CONST(164361.360951/8.0),
    REAL_CONST(164388.208061/8.0),
    REAL_CONST(164415.056266/8.0),
    REAL_CONST(164441.905568/8.0),
    REAL_CONST(164468.755966/8.0),
    REAL_CONST(164495.607460/8.0),
    REAL_CONST(164522.460049/8.0),
    REAL_CONST(164549.313735/8.0),
    REAL_CONST(164576.168516/8.0),
    REAL_CONST(164603.024392/8.0),
    REAL_CONST(164629.881364/8.0),
    REAL_CONST(164656.739432/8.0),
    REAL_CONST(164683.598594/8.0),
    REAL_CONST(164710.458852/8.0),
    REAL_CONST(164737.320205/8.0),
    REAL_CONST(164764.182653/8.0),
    REAL_CONST(164791.046196/8.0),
    REAL_CONST(164817.910834/8.0),
    REAL_CONST(164844.776566/8.0),
    REAL_CONST(164871.643393/8.0),
    REAL_CONST(164898.511315/8.0),
    REAL_CONST(164925.380331/8.0),
    REAL_CONST(164952.250442/8.0),
    REAL_CONST(164979.121647/8.0),
    REAL_CONST(165005.993946/8.0),
    REAL_CONST(165032.867339/8.0),
    REAL_CONST(165059.741827/8.0),
    REAL_CONST(165086.617408/8.0),
    REAL_CONST(165113.494083/8.0)
};

#endif

#ifdef __cplusplus
}
#endif
#endif
